// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-none-eabi -target-feature +mve.fp -mfloat-abi hard -disable-O0-optnone -emit-llvm -o - %s | opt -S -passes=mem2reg | FileCheck %s --check-prefixes=CHECK,CHECK-NOSTRICT
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-none-eabi -target-feature +mve.fp -mfloat-abi hard -disable-O0-optnone -DPOLYMORPHIC -emit-llvm -o - %s | opt -S -passes=mem2reg | FileCheck %s --check-prefixes=CHECK,CHECK-NOSTRICT
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-none-eabi -target-feature +mve.fp -mfloat-abi hard -disable-O0-optnone -frounding-math -fexperimental-strict-floating-point -emit-llvm -o - %s | opt -S -passes=mem2reg | FileCheck %s --check-prefixes=CHECK,CHECK-STRICT
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-none-eabi -target-feature +mve.fp -mfloat-abi hard -disable-O0-optnone -frounding-math -fexperimental-strict-floating-point -DPOLYMORPHIC -emit-llvm -o - %s | opt -S -passes=mem2reg | FileCheck %s --check-prefixes=CHECK,CHECK-STRICT

// REQUIRES: aarch64-registered-target || arm-registered-target

#include <arm_mve.h>

// CHECK-NOSTRICT-LABEL: @test_vminnmq_f16(
// CHECK-NOSTRICT-NEXT:  entry:
// CHECK-NOSTRICT-NEXT:    [[TMP0:%.*]] = call <8 x half> @llvm.minnum.v8f16(<8 x half> [[A:%.*]], <8 x half> [[B:%.*]])
// CHECK-NOSTRICT-NEXT:    ret <8 x half> [[TMP0]]
//
// CHECK-STRICT-LABEL: @test_vminnmq_f16(
// CHECK-STRICT-NEXT:  entry:
// CHECK-STRICT-NEXT:    [[TMP0:%.*]] = call <8 x half> @llvm.arm.mve.vminnm.v8f16(<8 x half> [[A:%.*]], <8 x half> [[B:%.*]]) #[[ATTR2:[0-9]+]]
// CHECK-STRICT-NEXT:    ret <8 x half> [[TMP0]]
//
float16x8_t test_vminnmq_f16(float16x8_t a, float16x8_t b)
{
#ifdef POLYMORPHIC
    return vminnmq(a, b);
#else /* POLYMORPHIC */
    return vminnmq_f16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-NOSTRICT-LABEL: @test_vminnmq_f32(
// CHECK-NOSTRICT-NEXT:  entry:
// CHECK-NOSTRICT-NEXT:    [[TMP0:%.*]] = call <4 x float> @llvm.minnum.v4f32(<4 x float> [[A:%.*]], <4 x float> [[B:%.*]])
// CHECK-NOSTRICT-NEXT:    ret <4 x float> [[TMP0]]
//
// CHECK-STRICT-LABEL: @test_vminnmq_f32(
// CHECK-STRICT-NEXT:  entry:
// CHECK-STRICT-NEXT:    [[TMP0:%.*]] = call <4 x float> @llvm.arm.mve.vminnm.v4f32(<4 x float> [[A:%.*]], <4 x float> [[B:%.*]]) #[[ATTR2]]
// CHECK-STRICT-NEXT:    ret <4 x float> [[TMP0]]
//
float32x4_t test_vminnmq_f32(float32x4_t a, float32x4_t b)
{
#ifdef POLYMORPHIC
    return vminnmq(a, b);
#else /* POLYMORPHIC */
    return vminnmq_f32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-NOSTRICT-LABEL: @test_vminnmq_m_f16(
// CHECK-NOSTRICT-NEXT:  entry:
// CHECK-NOSTRICT-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NOSTRICT-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NOSTRICT-NEXT:    [[TMP2:%.*]] = call <8 x half> @llvm.arm.mve.min.predicated.v8f16.v8i1(<8 x half> [[A:%.*]], <8 x half> [[B:%.*]], i32 0, <8 x i1> [[TMP1]], <8 x half> [[INACTIVE:%.*]])
// CHECK-NOSTRICT-NEXT:    ret <8 x half> [[TMP2]]
//
// CHECK-STRICT-LABEL: @test_vminnmq_m_f16(
// CHECK-STRICT-NEXT:  entry:
// CHECK-STRICT-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-STRICT-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]]) #[[ATTR2]]
// CHECK-STRICT-NEXT:    [[TMP2:%.*]] = call <8 x half> @llvm.arm.mve.min.predicated.v8f16.v8i1(<8 x half> [[A:%.*]], <8 x half> [[B:%.*]], i32 0, <8 x i1> [[TMP1]], <8 x half> [[INACTIVE:%.*]]) #[[ATTR2]]
// CHECK-STRICT-NEXT:    ret <8 x half> [[TMP2]]
//
float16x8_t test_vminnmq_m_f16(float16x8_t inactive, float16x8_t a, float16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vminnmq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vminnmq_m_f16(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-NOSTRICT-LABEL: @test_vminnmq_m_f32(
// CHECK-NOSTRICT-NEXT:  entry:
// CHECK-NOSTRICT-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NOSTRICT-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NOSTRICT-NEXT:    [[TMP2:%.*]] = call <4 x float> @llvm.arm.mve.min.predicated.v4f32.v4i1(<4 x float> [[A:%.*]], <4 x float> [[B:%.*]], i32 0, <4 x i1> [[TMP1]], <4 x float> [[INACTIVE:%.*]])
// CHECK-NOSTRICT-NEXT:    ret <4 x float> [[TMP2]]
//
// CHECK-STRICT-LABEL: @test_vminnmq_m_f32(
// CHECK-STRICT-NEXT:  entry:
// CHECK-STRICT-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-STRICT-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]]) #[[ATTR2]]
// CHECK-STRICT-NEXT:    [[TMP2:%.*]] = call <4 x float> @llvm.arm.mve.min.predicated.v4f32.v4i1(<4 x float> [[A:%.*]], <4 x float> [[B:%.*]], i32 0, <4 x i1> [[TMP1]], <4 x float> [[INACTIVE:%.*]]) #[[ATTR2]]
// CHECK-STRICT-NEXT:    ret <4 x float> [[TMP2]]
//
float32x4_t test_vminnmq_m_f32(float32x4_t inactive, float32x4_t a, float32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vminnmq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vminnmq_m_f32(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-NOSTRICT-LABEL: @test_vminnmq_x_f16(
// CHECK-NOSTRICT-NEXT:  entry:
// CHECK-NOSTRICT-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NOSTRICT-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NOSTRICT-NEXT:    [[TMP2:%.*]] = call <8 x half> @llvm.arm.mve.min.predicated.v8f16.v8i1(<8 x half> [[A:%.*]], <8 x half> [[B:%.*]], i32 0, <8 x i1> [[TMP1]], <8 x half> undef)
// CHECK-NOSTRICT-NEXT:    ret <8 x half> [[TMP2]]
//
// CHECK-STRICT-LABEL: @test_vminnmq_x_f16(
// CHECK-STRICT-NEXT:  entry:
// CHECK-STRICT-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-STRICT-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]]) #[[ATTR2]]
// CHECK-STRICT-NEXT:    [[TMP2:%.*]] = call <8 x half> @llvm.arm.mve.min.predicated.v8f16.v8i1(<8 x half> [[A:%.*]], <8 x half> [[B:%.*]], i32 0, <8 x i1> [[TMP1]], <8 x half> undef) #[[ATTR2]]
// CHECK-STRICT-NEXT:    ret <8 x half> [[TMP2]]
//
float16x8_t test_vminnmq_x_f16(float16x8_t a, float16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vminnmq_x(a, b, p);
#else /* POLYMORPHIC */
    return vminnmq_x_f16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-NOSTRICT-LABEL: @test_vminnmq_x_f32(
// CHECK-NOSTRICT-NEXT:  entry:
// CHECK-NOSTRICT-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NOSTRICT-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NOSTRICT-NEXT:    [[TMP2:%.*]] = call <4 x float> @llvm.arm.mve.min.predicated.v4f32.v4i1(<4 x float> [[A:%.*]], <4 x float> [[B:%.*]], i32 0, <4 x i1> [[TMP1]], <4 x float> undef)
// CHECK-NOSTRICT-NEXT:    ret <4 x float> [[TMP2]]
//
// CHECK-STRICT-LABEL: @test_vminnmq_x_f32(
// CHECK-STRICT-NEXT:  entry:
// CHECK-STRICT-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-STRICT-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]]) #[[ATTR2]]
// CHECK-STRICT-NEXT:    [[TMP2:%.*]] = call <4 x float> @llvm.arm.mve.min.predicated.v4f32.v4i1(<4 x float> [[A:%.*]], <4 x float> [[B:%.*]], i32 0, <4 x i1> [[TMP1]], <4 x float> undef) #[[ATTR2]]
// CHECK-STRICT-NEXT:    ret <4 x float> [[TMP2]]
//
float32x4_t test_vminnmq_x_f32(float32x4_t a, float32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vminnmq_x(a, b, p);
#else /* POLYMORPHIC */
    return vminnmq_x_f32(a, b, p);
#endif /* POLYMORPHIC */
}
//// NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
// CHECK: {{.*}}
