/* $Id$ */
/* File: tables.c */

/* Purpose: Angband Tables */

/*
 * Copyright (c) 1989 James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

/* added this for consistency in some (unrelated) header-inclusion,
   it IS a server file, isn't it? */
#define SERVER

#include "angband.h"


/*
 * XXX XXX Important notice:
 *
 * adj_*_* arrays are frequently used beyond the original purpose
 * (yeah, truly bad hack), so changing them may cause various
 * unexpected side-effects.
 * grep the array name first and do it deliberately!
 */


/*
 * Global array for looping through the "keypad directions"
 */
s16b ddd[9] =
{ 2, 8, 6, 4, 3, 1, 9, 7, 5 };

/*
 * Global arrays for converting "keypad direction" into offsets
 */
s16b ddx[10] =
{ 0, -1, 0, 1, -1, 0, 1, -1, 0, 1 };

s16b ddy[10] =
{ 0, 1, 1, 1, 0, 0, 0, -1, -1, -1 };

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
s16b ddx_ddd[9] =
{ 0, 0, 1, -1, 1, -1, 1, -1, 0 };

s16b ddy_ddd[9] =
{ 1, -1, 0, 0, 1, 1, -1, -1, 0 };


/* extra stuff for place_rubble() -  C. Blue */
/* Global arrays for cycling through directions, starting at bottom left, clockwise */
s16b ddx_cyc[8] =
{ -1, 0, 1, 1, 1, 0, -1, -1};
s16b ddy_cyc[8] =
{ -1, -1, -1, 0, 1, 1, 1, 0};
/* and for inverting directions of above array ((x+4)%8) */
s16b ddi_cyc[8] =
{ 4, 5, 6, 7, 0, 1, 2, 3};

/* extra stuff for placing feats around wild dungeon/tower entrances -  C. Blue */
s16b ddx_wide_cyc[16] =
{ -2, -1, 0, 1, 2, 2, 2, 2, 2, 1, 0, -1, -2, -2, -2, -2 };
s16b ddy_wide_cyc[16] =
{ -2, -2, -2, -2, -2, -1, 0, 1, 2, 2, 2, 2, 2, 1, 0, -1 };


/*
 * Global array for converting numbers to uppercase hecidecimal digit
 * This array can also be used to convert a number to an octal digit
 */
char hexsym[16] = {
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/* The following tables are also used by the client and hence in src/common/tables.c:
    adj_mag_fail[]
    adj_mag_stat[]
    adj_int_pow[]
*/


/*
 * Stat Table (INT/WIS) -- Number of half-spells per level
 */
byte adj_mag_study[] = {
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	3	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	4	/* 18/120-18/129 */,
	4	/* 18/130-18/139 */,
	4	/* 18/140-18/149 */,
	4	/* 18/150-18/159 */,
	5	/* 18/160-18/169 */,
	5	/* 18/170-18/179 */,
	5	/* 18/180-18/189 */,
	5	/* 18/190-18/199 */,
	5	/* 18/200-18/209 */,
	5	/* 18/210-18/219 */,
	5	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- extra half-mana-points per level
 */
byte adj_mag_mana[] = {
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	2	/* 9 */,
	2	/* 10 */,
	2	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	3	/* 18/30-18/39 */,
	3	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	5	/* 18/70-18/79 */,
	6	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	9	/* 18/110-18/119 */,
	10	/* 18/120-18/129 */,
	11	/* 18/130-18/139 */,
	12	/* 18/140-18/149 */,
	13	/* 18/150-18/159 */,
	13	/* 18/160-18/169 */,
	14	/* 18/170-18/179 */,
	14	/* 18/180-18/189 */,
	15	/* 18/190-18/199 */,
	15	/* 18/200-18/209 */,
	15	/* 18/210-18/219 */,
	16	/* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentages
 */
byte adj_chr_gold[] = {
	130	/* 3 */,
	125	/* 4 */,
	122	/* 5 */,
	120	/* 6 */,
	118	/* 7 */,
	116	/* 8 */,
	114	/* 9 */,
	112	/* 10 */,
	110	/* 11 */,
	108	/* 12 */,
	106	/* 13 */,
	104	/* 14 */,
	103	/* 15 */,
	102	/* 16 */,
	101	/* 17 */,
	100	/* 18/00-18/09 */,
	99	/* 18/10-18/19 */,
	98	/* 18/20-18/29 */,
	97	/* 18/30-18/39 */,
	96	/* 18/40-18/49 */,
	95	/* 18/50-18/59 */,
	94	/* 18/60-18/69 */,
	93	/* 18/70-18/79 */,
	92	/* 18/80-18/89 */,
	91	/* 18/90-18/99 */,
	90	/* 18/100-18/109 */,
	89	/* 18/110-18/119 */,
	88	/* 18/120-18/129 */,
	87	/* 18/130-18/139 */,
	86	/* 18/140-18/149 */,
	85	/* 18/150-18/159 */,
	84	/* 18/160-18/169 */,
	84	/* 18/170-18/179 */,
	83	/* 18/180-18/189 */,
	83	/* 18/190-18/199 */,
	82	/* 18/200-18/209 */,
	81	/* 18/210-18/219 */,
	80	/* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
byte adj_int_dev[] = {
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	4	/* 18/20-18/29 */,
	4	/* 18/30-18/39 */,
	5	/* 18/40-18/49 */,
	5	/* 18/50-18/59 */,
	6	/* 18/60-18/69 */,
	6	/* 18/70-18/79 */,
	7	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	9	/* 18/110-18/119 */,
	10	/* 18/120-18/129 */,
	11	/* 18/130-18/139 */,
	12	/* 18/140-18/149 */,
	13	/* 18/150-18/159 */,
	14	/* 18/160-18/169 */,
	15	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	17	/* 18/190-18/199 */,
	18	/* 18/200-18/209 */,
	19	/* 18/210-18/219 */,
	20	/* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
byte adj_wis_sav[] = {
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	3	/* 18/30-18/39 */,
	3	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	5	/* 18/70-18/79 */,
	5	/* 18/80-18/89 */,
	6	/* 18/90-18/99 */,
	7	/* 18/100-18/109 */,
	8	/* 18/110-18/119 */,
	9	/* 18/120-18/129 */,
	10	/* 18/130-18/139 */,
	11	/* 18/140-18/149 */,
	12	/* 18/150-18/159 */,
	13	/* 18/160-18/169 */,
	14	/* 18/170-18/179 */,
	15	/* 18/180-18/189 */,
	16	/* 18/190-18/199 */,
	17	/* 18/200-18/209 */,
	18	/* 18/210-18/219 */,
	19	/* 18/220+ */
};

/*
 * Stat Table (WIS) -- Max sanity points
 */
byte adj_wis_msane[] = {
	128 + -5	/* 3 */,
	128 + -4	/* 4 */,
	128 + -3	/* 5 */,
	128 + -2	/* 6 */,
	128 + -2	/* 7 */,
	128 + -1	/* 8 */,
	128 + -1	/* 9 */,
	128 + 0		/* 10 */,
	128 + 0		/* 11 */,
	128 + 0		/* 12 */,
	128 + 0		/* 13 */,
	128 + 1		/* 14 */,
	128 + 1		/* 15 */,
	128 + 1		/* 16 */,
	128 + 2		/* 17 */,
	128 + 2		/* 18/00-18/09 */,
	128 + 2		/* 18/10-18/19 */,
	128 + 3		/* 18/20-18/29 */,
	128 + 3		/* 18/30-18/39 */,
	128 + 4		/* 18/40-18/49 */,
	128 + 4		/* 18/50-18/59 */,
	128 + 5		/* 18/60-18/69 */,
	128 + 5		/* 18/70-18/79 */,
	128 + 6		/* 18/80-18/89 */,
	128 + 6		/* 18/90-18/99 */,
	128 + 7		/* 18/100-18/109 */,
	128 + 8		/* 18/110-18/119 */,
	128 + 8		/* 18/120-18/129 */,
	128 + 9		/* 18/130-18/139 */,
	128 + 10	/* 18/140-18/149 */,
	128 + 10	/* 18/150-18/159 */,
	128 + 11	/* 18/160-18/169 */,
	128 + 12	/* 18/170-18/179 */,
	128 + 12	/* 18/180-18/189 */,
	128 + 13	/* 18/190-18/199 */,
	128 + 14	/* 18/200-18/209 */,
	128 + 14	/* 18/210-18/219 */,
	128 + 15	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- disarming
 */
byte adj_dex_dis[] = {
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	0	/* 10 */,
	0	/* 11 */,
	0	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	4	/* 18/30-18/39 */,
	4	/* 18/40-18/49 */,
	5	/* 18/50-18/59 */,
	5	/* 18/60-18/69 */,
	6	/* 18/70-18/79 */,
	6	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	8	/* 18/110-18/119 */,
	8	/* 18/120-18/129 */,
	8	/* 18/130-18/139 */,
	8	/* 18/140-18/149 */,
	9	/* 18/150-18/159 */,
	9	/* 18/160-18/169 */,
	9	/* 18/170-18/179 */,
	9	/* 18/180-18/189 */,
	9	/* 18/190-18/199 */,
	10	/* 18/200-18/209 */,
	10	/* 18/210-18/219 */,
	11	/* 18/220+ */
};


/*
 * Stat Table (INT) -- disarming
 */
byte adj_int_dis[] = {
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	4	/* 18/30-18/39 */,
	4	/* 18/40-18/49 */,
	5	/* 18/50-18/59 */,
	6	/* 18/60-18/69 */,
	7	/* 18/70-18/79 */,
	8	/* 18/80-18/89 */,
	9	/* 18/90-18/99 */,
	10	/* 18/100-18/109 */,
	10	/* 18/110-18/119 */,
	11	/* 18/120-18/129 */,
	12	/* 18/130-18/139 */,
	13	/* 18/140-18/149 */,
	14	/* 18/150-18/159 */,
	15	/* 18/160-18/169 */,
	16	/* 18/170-18/179 */,
	17	/* 18/180-18/189 */,
	18	/* 18/190-18/199 */,
	19	/* 18/200-18/209 */,
	19	/* 18/210-18/219 */,
	19	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
byte adj_dex_ta[] = {
	128 + -4	/* 3 */,
	128 + -3	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0		/* 7 */,
	128 + 0		/* 8 */,
	128 + 0		/* 9 */,
	128 + 0		/* 10 */,
	128 + 0		/* 11 */,
	128 + 0		/* 12 */,
	128 + 0		/* 13 */,
	128 + 0		/* 14 */,
	128 + 1		/* 15 */,
	128 + 1		/* 16 */,
	128 + 1		/* 17 */,
	128 + 2		/* 18/00-18/09 */,
	128 + 2		/* 18/10-18/19 */,
	128 + 2		/* 18/20-18/29 */,
	128 + 2		/* 18/30-18/39 */,
	128 + 2		/* 18/40-18/49 */,
	128 + 3		/* 18/50-18/59 */,
	128 + 3		/* 18/60-18/69 */,
	128 + 3		/* 18/70-18/79 */,
	128 + 4		/* 18/80-18/89 */,
	128 + 5		/* 18/90-18/99 */,
	128 + 6		/* 18/100-18/109 */,
	128 + 7		/* 18/110-18/119 */,
	128 + 8		/* 18/120-18/129 */,
	128 + 9		/* 18/130-18/139 */,
	128 + 9		/* 18/140-18/149 */,
	128 + 10	/* 18/150-18/159 */,
	128 + 10	/* 18/160-18/169 */,
	128 + 11	/* 18/170-18/179 */,
	128 + 11	/* 18/180-18/189 */,
	128 + 12	/* 18/190-18/199 */,
	128 + 13	/* 18/200-18/209 */,
	128 + 13	/* 18/210-18/219 */,
	128 + 14	/* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to dam (plus 128)
 */
byte adj_str_td[] = {
	128 + -2	/* 3 */,
	128 + -2	/* 4 */,
	128 + -1	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0		/* 7 */,
	128 + 0		/* 8 */,
	128 + 0		/* 9 */,
	128 + 0		/* 10 */,
	128 + 0		/* 11 */,
	128 + 0		/* 12 */,
	128 + 0		/* 13 */,
	128 + 1		/* 14 */,
	128 + 1		/* 15 */,
	128 + 1		/* 16 */,
	128 + 1		/* 17 */,
	128 + 2		/* 18/00-18/09 */,
	128 + 2		/* 18/10-18/19 */,
	128 + 2		/* 18/20-18/29 */,
	128 + 3		/* 18/30-18/39 */,
	128 + 3		/* 18/40-18/49 */,
	128 + 3		/* 18/50-18/59 */,
	128 + 4		/* 18/60-18/69 */,
	128 + 4		/* 18/70-18/79 */,
	128 + 4		/* 18/80-18/89 */,
	128 + 5		/* 18/90-18/99 */,
	128 + 5		/* 18/100-18/109 */,
	128 + 6		/* 18/110-18/119 */,
	128 + 6		/* 18/120-18/129 */,
	128 + 7		/* 18/130-18/139 */,
	128 + 7		/* 18/140-18/149 */,
	128 + 8		/* 18/150-18/159 */,
	128 + 9		/* 18/160-18/169 */,
	128 + 10	/* 18/170-18/179 */,
	128 + 11	/* 18/180-18/189 */,
	128 + 12	/* 18/190-18/199 */,
	128 + 13	/* 18/200-18/209 */,
	128 + 14	/* 18/210-18/219 */,
	128 + 15	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to hit (plus 128)
 */
#if 0 /* this was used when adj_dex_th and adj_str_th both affect to_hit (vanilla) */
byte adj_dex_th[] = {
	128 + -3	/* 3 */,
	128 + -2	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + -1	/* 7 */,
	128 + 0		/* 8 */,
	128 + 0		/* 9 */,
	128 + 0		/* 10 */,
	128 + 0		/* 11 */,
	128 + 0		/* 12 */,
	128 + 0		/* 13 */,
	128 + 0		/* 14 */,
	128 + 0		/* 15 */,
	128 + 1		/* 16 */,
	128 + 2		/* 17 */,
	128 + 3		/* 18/00-18/09 */,
	128 + 3		/* 18/10-18/19 */,
	128 + 3		/* 18/20-18/29 */,
	128 + 3		/* 18/30-18/39 */,
	128 + 3		/* 18/40-18/49 */,
	128 + 4		/* 18/50-18/59 */,
	128 + 4		/* 18/60-18/69 */,
	128 + 4		/* 18/70-18/79 */,
	128 + 4		/* 18/80-18/89 */,
	128 + 5		/* 18/90-18/99 */,
	128 + 6		/* 18/100-18/109 */,
	128 + 7		/* 18/110-18/119 */,
	128 + 8		/* 18/120-18/129 */,
	128 + 9		/* 18/130-18/139 */,
	128 + 9		/* 18/140-18/149 */,
	128 + 10	/* 18/150-18/159 */,
	128 + 11	/* 18/160-18/169 */,
	128 + 12	/* 18/170-18/179 */,
	128 + 13	/* 18/180-18/189 */,
	128 + 14	/* 18/190-18/199 */,
	128 + 15	/* 18/200-18/209 */,
	128 + 16	/* 18/210-18/219 */,
	128 + 17	/* 18/220+ */
};
#else /* this is used for when only adj_dex_th affects to-hit, to make DEX more important */
byte adj_dex_th[] = {
	128 + -7	/* 3 */,
	128 + -6	/* 4 */,
	128 + -5	/* 5 */,
	128 + -4	/* 6 */,
	128 + -3	/* 7 */,
	128 + -2	/* 8 */,
	128 + -1	/* 9 */,
	128 + 0		/* 10 */,
	128 + 0		/* 11 */,
	128 + 1		/* 12 */,
	128 + 2		/* 13 */,
	128 + 3		/* 14 */,
	128 + 4		/* 15 */,
	128 + 5		/* 16 */,
	128 + 6		/* 17 */,
	128 + 7		/* 18/00-18/09 */,
	128 + 8		/* 18/10-18/19 */,
	128 + 9		/* 18/20-18/29 */,
	128 + 10	/* 18/30-18/39 */,
	128 + 11	/* 18/40-18/49 */,
	128 + 11	/* 18/50-18/59 */,
	128 + 12	/* 18/60-18/69 */,
	128 + 12	/* 18/70-18/79 */,
	128 + 13	/* 18/80-18/89 */,
	128 + 13	/* 18/90-18/99 */,
	128 + 14	/* 18/100-18/109 */,
	128 + 14	/* 18/110-18/119 */,
	128 + 15	/* 18/120-18/129 */,
	128 + 15	/* 18/130-18/139 */,
	128 + 16	/* 18/140-18/149 */,
	128 + 16	/* 18/150-18/159 */,
	128 + 17	/* 18/160-18/169 */,
	128 + 17	/* 18/170-18/179 */,
	128 + 18	/* 18/180-18/189 */,
	128 + 18	/* 18/190-18/199 */,
	128 + 19	/* 18/200-18/209 */,
	128 + 19	/* 18/210-18/219 */,
	128 + 20	/* 18/220+ */
};
#endif

/*
 * Stat Table (DEX) -- multiplicative bonus to hit (in percent)
 */
byte adj_dex_th_mul[] = {
	20	/* 3 */,
	30	/* 4 */,
	40	/* 5 */,
	50	/* 6 */,
	60	/* 7 */,
	70	/* 8 */,
	75	/* 9 */,
	80	/* 10 */,
	85	/* 11 */,
	89	/* 12 */,
	93	/* 13 */,
	97	/* 14 */,
	100	/* 15 */,
	103	/* 16 */,
	106	/* 17 */,
	109	/* 18/00-18/09 */,
	111	/* 18/10-18/19 */,
	113	/* 18/20-18/29 */,
	115	/* 18/30-18/39 */,
	116	/* 18/40-18/49 */,
	117	/* 18/50-18/59 */,
	118	/* 18/60-18/69 */,
	119	/* 18/70-18/79 */,
	120	/* 18/80-18/89 */,
	121	/* 18/90-18/99 */,
	122	/* 18/100-18/109 */,
	123	/* 18/110-18/119 */,
	124	/* 18/120-18/129 */,
	125	/* 18/130-18/139 */,
	126	/* 18/140-18/149 */,
	126	/* 18/150-18/159 */,
	127	/* 18/160-18/169 */,
	127	/* 18/170-18/179 */,
	128	/* 18/180-18/189 */,
	128	/* 18/190-18/199 */,
	129	/* 18/200-18/209 */,
	129	/* 18/210-18/219 */,
	130	/* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to hit (plus 128)
 */
byte adj_str_th[] = {
	128 + -3	/* 3 */,
	128 + -2	/* 4 */,
	128 + -1	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0		/* 7 */,
	128 + 0		/* 8 */,
	128 + 0		/* 9 */,
	128 + 0		/* 10 */,
	128 + 0		/* 11 */,
	128 + 0		/* 12 */,
	128 + 0		/* 13 */,
	128 + 0		/* 14 */,
	128 + 0		/* 15 */,
	128 + 0		/* 16 */,
	128 + 0		/* 17 */,
	128 + 1		/* 18/00-18/09 */,
	128 + 1		/* 18/10-18/19 */,
	128 + 1		/* 18/20-18/29 */,
	128 + 1		/* 18/30-18/39 */,
	128 + 1		/* 18/40-18/49 */,
	128 + 1		/* 18/50-18/59 */,
	128 + 1		/* 18/60-18/69 */,
	128 + 2		/* 18/70-18/79 */,
	128 + 3		/* 18/80-18/89 */,
	128 + 4		/* 18/90-18/99 */,
	128 + 5		/* 18/100-18/109 */,
	128 + 6		/* 18/110-18/119 */,
	128 + 7		/* 18/120-18/129 */,
	128 + 8		/* 18/130-18/139 */,
	128 + 9		/* 18/140-18/149 */,
	128 + 10	/* 18/150-18/159 */,
	128 + 11	/* 18/160-18/169 */,
	128 + 12	/* 18/170-18/179 */,
	128 + 13	/* 18/180-18/189 */,
	128 + 14	/* 18/190-18/199 */,
	128 + 15	/* 18/200-18/209 */,
	128 + 15	/* 18/210-18/219 */,
	128 + 15	/* 18/220+ */
};


/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
byte adj_str_wgt[] = {
	5	/* 3 */,
	6	/* 4 */,
	7	/* 5 */,
	8	/* 6 */,
	9	/* 7 */,
	10	/* 8 */,
	11	/* 9 */,
	12	/* 10 */,
	13	/* 11 */,
	14	/* 12 */,
	15	/* 13 */,
	16	/* 14 */,
	17	/* 15 */,
	18	/* 16 */,
	19	/* 17 */,
	20	/* 18/00-18/09 */,
	22	/* 18/10-18/19 */,
	24	/* 18/20-18/29 */,
	26	/* 18/30-18/39 */,
	28	/* 18/40-18/49 */,
	30	/* 18/50-18/59 */,
	30	/* 18/60-18/69 */,
	30	/* 18/70-18/79 */,
	30	/* 18/80-18/89 */,
	30	/* 18/90-18/99 */,
	30	/* 18/100-18/109 */,
	30	/* 18/110-18/119 */,
	30	/* 18/120-18/129 */,
	30	/* 18/130-18/139 */,
	30	/* 18/140-18/149 */,
	30	/* 18/150-18/159 */,
	30	/* 18/160-18/169 */,
	30	/* 18/170-18/179 */,
	30	/* 18/180-18/189 */,
	30	/* 18/190-18/199 */,
	30	/* 18/200-18/209 */,
	30	/* 18/210-18/219 */,
	30	/* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 */
byte adj_str_hold[] = {
	4	/* 3 */,
	5	/* 4 */,
	6	/* 5 */,
	7	/* 6 */,
	8	/* 7 */,
	10	/* 8 */,
	12	/* 9 */,
	14	/* 10 */,
	16	/* 11 */,
	18	/* 12 */,
	20	/* 13 */,
	22	/* 14 */,
	24	/* 15 */,
	26	/* 16 */,
	28	/* 17 */,
	30	/* 18/00-18/09 */,
	30	/* 18/10-18/19 */,
	35	/* 18/20-18/29 */,
	40	/* 18/30-18/39 */,
	45	/* 18/40-18/49 */,
	50	/* 18/50-18/59 */,
	55	/* 18/60-18/69 */,
	60	/* 18/70-18/79 */,
	65	/* 18/80-18/89 */,
	70	/* 18/90-18/99 */,
	80	/* 18/100-18/109 */,
	80	/* 18/110-18/119 */,
	80	/* 18/120-18/129 */,
	80	/* 18/130-18/139 */,
	80	/* 18/140-18/149 */,
	90	/* 18/150-18/159 */,
	90	/* 18/160-18/169 */,
	90	/* 18/170-18/179 */,
	90	/* 18/180-18/189 */,
	90	/* 18/190-18/199 */,
	100	/* 18/200-18/209 */,
	100	/* 18/210-18/219 */,
	100	/* 18/220+ */
};


/*
 * Stat Table (STR) -- digging value
 */
byte adj_str_dig[] = {
	0	/* 3 */,
	0	/* 4 */,
	1	/* 5 */,
	2	/* 6 */,
	3	/* 7 */,
	4	/* 8 */,
	4	/* 9 */,
	5	/* 10 */,
	5	/* 11 */,
	6	/* 12 */,
	6	/* 13 */,
	7	/* 14 */,
	7	/* 15 */,
	8	/* 16 */,
	8	/* 17 */,
	9	/* 18/00-18/09 */,
	10	/* 18/10-18/19 */,
	12	/* 18/20-18/29 */,
	15	/* 18/30-18/39 */,
	18	/* 18/40-18/49 */,
	21	/* 18/50-18/59 */,
	25	/* 18/60-18/69 */,
	30	/* 18/70-18/79 */,
	35	/* 18/80-18/89 */,
	40	/* 18/90-18/99 */,
	45	/* 18/100-18/109 */,
	50	/* 18/110-18/119 */,
	55	/* 18/120-18/129 */,
	60	/* 18/130-18/139 */,
	65	/* 18/140-18/149 */,
	70	/* 18/150-18/159 */,
	75	/* 18/160-18/169 */,
	80	/* 18/170-18/179 */,
	85	/* 18/180-18/189 */,
	90	/* 18/190-18/199 */,
	95	/* 18/200-18/209 */,
	95	/* 18/210-18/219 */,
	100	/* 18/220+ */
};


/*
 * Stat Table (STR) -- help index into the "blow" table
 */
byte adj_str_blow[] = {
	3	/* 3 */,
	4	/* 4 */,
	5	/* 5 */,
	6	/* 6 */,
	7	/* 7 */,
	8	/* 8 */,
	9	/* 9 */,
	10	/* 10 */,
	11	/* 11 */,
	12	/* 12 */,
	13	/* 13 */,
	14	/* 14 */,
	15	/* 15 */,
	16	/* 16 */,
	17	/* 17 */,
	20	/* 18/00-18/09 */,
	30	/* 18/10-18/19 */,
	40	/* 18/20-18/29 */,
	50	/* 18/30-18/39 */,
	60	/* 18/40-18/49 */,
	70	/* 18/50-18/59 */,
	80	/* 18/60-18/69 */,
	90	/* 18/70-18/79 */,
	100	/* 18/80-18/89 */,
	110	/* 18/90-18/99 */,
	120	/* 18/100-18/109 */,
	130	/* 18/110-18/119 */,
	140	/* 18/120-18/129 */,
	150	/* 18/130-18/139 */,
	160	/* 18/140-18/149 */,
	170	/* 18/150-18/159 */,
	180	/* 18/160-18/169 */,
	190	/* 18/170-18/179 */,
	200	/* 18/180-18/189 */,
	210	/* 18/190-18/199 */,
	220	/* 18/200-18/209 */,
	230	/* 18/210-18/219 */,
	240	/* 18/220+ */
/*	266 (to get 6 bpr at 400 lb weapon weight) not possible since type is byte. Work-around via hack in calc_blows. - C. Blue */
};


/*
 * Stat Table (STR) -- orientation for create_reward, concerning armor weight
 */
byte adj_str_armor[] = {
	2	/* 3 */,
	2	/* 4 */,
	2	/* 5 */,
	2	/* 6 */,
	3	/* 7 */,
	3	/* 8 */,
	4	/* 9 */,
	4	/* 10 */,
	5	/* 11 */,
	5	/* 12 */,
	7	/* 13 */,
	9	/* 14 */,
	11	/* 15 */,
	13	/* 16 */,
	14	/* 17 */,
	15	/* 18/00-18/09 */,
	16	/* 18/10-18/19 */,
	18	/* 18/20-18/29 - 200 is max. weight for TV_SOFT_ARMOR */,
	20	/* 18/30-18/39 - 200 is min. weight for TV_HARD_ARMOR */,
	22	/* 18/40-18/49 */,
	24	/* 18/50-18/59 */,
	26	/* 18/60-18/69 */,
	28	/* 18/70-18/79 */,
	30	/* 18/80-18/89 */,
	32	/* 18/90-18/99 */,
	35	/* 18/100-18/109 */,
	38	/* 18/110-18/119 */,
	41	/* 18/120-18/129 */,
	44	/* 18/130-18/139 */,
	47	/* 18/140-18/149 */,
	50	/* 18/150-18/159 */,
	50	/* 18/160-18/169 */,
	50	/* 18/170-18/179 */,
	50	/* 18/180-18/189 */,
	50	/* 18/190-18/199 */,
	50	/* 18/200-18/209 */,
	50	/* 18/210-18/219 */,
	50	/* 18/220+ - 500 is just a limit value in create_reward() */
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
byte adj_dex_blow[] = {
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	1	/* 16 */,
	1	/* 17 */,
	1	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	4	/* 18/70-18/79 */,
	4	/* 18/80-18/89 */,
	5	/* 18/90-18/99 */,
	6	/* 18/100-18/109 */,
	7	/* 18/110-18/119 */,
	8	/* 18/120-18/129 */,
	9	/* 18/130-18/139 */,
	10	/* 18/140-18/149 */,
	11	/* 18/150-18/159 */,
	12	/* 18/160-18/169 */,
	14	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	18	/* 18/190-18/199 */,
	20	/* 18/200-18/209 */,
	20	/* 18/210-18/219 */,
	20	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling"
 */
byte adj_dex_safe[] = {
	0	/* 3 */,
	1	/* 4 */,
	2	/* 5 */,
	3	/* 6 */,
	4	/* 7 */,
	5	/* 8 */,
	5	/* 9 */,
	6	/* 10 */,
	6	/* 11 */,
	7	/* 12 */,
	7	/* 13 */,
	8	/* 14 */,
	8	/* 15 */,
	9	/* 16 */,
	9	/* 17 */,
	10	/* 18/00-18/09 */,
	10	/* 18/10-18/19 */,
	15	/* 18/20-18/29 */,
	15	/* 18/30-18/39 */,
	20	/* 18/40-18/49 */,
	25	/* 18/50-18/59 */,
	30	/* 18/60-18/69 */,
	35	/* 18/70-18/79 */,
	40	/* 18/80-18/89 */,
	45	/* 18/90-18/99 */,
	50	/* 18/100-18/109 */,
	55	/* 18/110-18/119 */,
	60	/* 18/120-18/129 */,
	65	/* 18/130-18/139 */,
	70	/* 18/140-18/149 */,
	75	/* 18/150-18/159 */,
	80	/* 18/160-18/169 */,
	85	/* 18/170-18/179 */,
	90	/* 18/180-18/189 */,
	90	/* 18/190-18/199 */,
	95	/* 18/200-18/209 */,
	95	/* 18/210-18/219 */,
	100	/* 18/220+ */
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
byte adj_con_fix[] = {
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	0	/* 10 */,
	0	/* 11 */,
	0	/* 12 */,
	0	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	1	/* 16 */,
	1	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	3	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	4	/* 18/120-18/129 */,
	5	/* 18/130-18/139 */,
	5	/* 18/140-18/149 */,
	6	/* 18/150-18/159 */,
	6	/* 18/160-18/169 */,
	7	/* 18/170-18/179 */,
	7	/* 18/180-18/189 */,
	8	/* 18/190-18/199 */,
	8	/* 18/200-18/209 */,
	9	/* 18/210-18/219 */,
	9	/* 18/220+ */
};


/*
 * Stat Table (CON) -- extra half-hitpoints per level (plus 128)
 */
byte adj_con_mhp[] = {
	128 + -5	/* 3 */,
	128 + -4	/* 4 */,
	128 + -3	/* 5 */,
	128 + -2	/* 6 */,
	128 + -1	/* 7 */,
	128 + -1	/* 8 */,
	128 + 0		/* 9 */,
	128 + 0		/* 10 */,
	128 + 0		/* 11 */,
	128 + 0		/* 12 */,
	128 + 1		/* 13 */,
	128 + 1		/* 14 */,
	128 + 1		/* 15 */,
	128 + 2		/* 16 */,
	128 + 2		/* 17 */,
	128 + 3		/* 18/00-18/09 */,
	128 + 4		/* 18/10-18/19 */,
	128 + 5		/* 18/20-18/29 */,
	128 + 6		/* 18/30-18/39 */,
	128 + 7		/* 18/40-18/49 */,
	128 + 8		/* 18/50-18/59 */,
	128 + 9		/* 18/60-18/69 */,
	128 + 10	/* 18/70-18/79 */,
	128 + 11	/* 18/80-18/89 */,
	128 + 12	/* 18/90-18/99 */,
	128 + 13	/* 18/100-18/109 */,
	128 + 14	/* 18/110-18/119 */,
	128 + 15	/* 18/120-18/129 */,
	128 + 16	/* 18/130-18/139 */,
	128 + 17	/* 18/140-18/149 */,
	128 + 18	/* 18/150-18/159 */,
	128 + 19	/* 18/160-18/169 */,
	128 + 20	/* 18/170-18/179 */,
	128 + 21	/* 18/180-18/189 */,
	128 + 22	/* 18/190-18/199 */,
	128 + 23	/* 18/200-18/209 */,
	128 + 24	/* 18/210-18/219 */,
	128 + 25	/* 18/220+ */
};


/*
 * This table is used to help calculate the number of blows the player can
 * make in a single round of attacks (one player turn) with a normal weapon.
 *
 * This number ranges from a single blow/round for weak players to up to six
 * blows/round for powerful warriors.
 *
 * Note that certain artifacts and ego-items give "bonus" blows/round.
 *
 * First, from the player class, we extract some values:
 *
 *    Warrior --> num = 6; mul = 5; div = MAX(30, weapon_weight);
 *    Mage    --> num = 4; mul = 2; div = MAX(40, weapon_weight);
 *    Priest  --> num = 5; mul = 3; div = MAX(35, weapon_weight);
 *    Rogue   --> num = 5; mul = 3; div = MAX(30, weapon_weight);
 *    Ranger  --> num = 5; mul = 4; div = MAX(35, weapon_weight);
 *    Paladin --> num = 5; mul = 4; div = MAX(30, weapon_weight);
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by "mul", and then divide it by "div", rounding down.
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above),
 * note especially column 6 (DEX 18/101) and 11 (DEX 18/150).
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below,
 * up to a maximum of "num" blows/round, plus any "bonus" blows/round.
 */
byte blows_table[12][12] = {
	/* P/D */
	/* 0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11+ */

	/* 0  */
	{  1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   3 },

	/* 1  */
	{  1,   1,   1,   1,   2,   2,   3,   3,   3,   4,   4,   4 },

	/* 2  */
	{  1,   1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5 },

	/* 3  */
	{  1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5 },

	/* 4  */
	{  1,   2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5 },

	/* 5  */
	{  2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6 },

	/* 6  */
	{  2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6 },

	/* 7  */
	{  2,   3,   3,   4,   4,   4,   5,   5,   5,   5,   5,   6 },

	/* 8  */
	{  3,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6 },

	/* 9  */
	{  3,   3,   4,   4,   4,   4,   5,   5,   5,   5,   6,   6 },

	/* 10 */
	{  3,   3,   4,   4,   4,   4,   5,   5,   5,   6,   6,   6 },

	/* 11+ */
	{  3,   3,   4,   4,   4,   4,   5,   5,   6,   6,   6,   7 },
};


/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest monster is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
s16b extract_energy[256] = {
	/* Slow */     10,  10,  10,  10,  10,  10,  10,  10,  10,  10,	/* 0-9 */
	/* Slow */     10,  10,  10,  10,  10,  10,  10,  10,  10,  10,
	/* Slow */     10,  10,  10,  10,  10,  10,  10,  10,  10,  10,
	/* Slow */     10,  10,  10,  10,  10,  10,  10,  10,  10,  10,
	/* Slow */     10,  10,  10,  10,  10,  10,  10,  10,  10,  10,
	/* Slow */     10,  10,  10,  10,  10,  10,  10,  10,  10,  10,
	/* S-50 */     10,  10,  10,  10,  10,  10,  10,  10,  10,  10,
	/* S-40 */     20,  20,  20,  20,  20,  20,  20,  20,  20,  20,
	/* S-30 */     20,  20,  20,  20,  20,  20,  20,  30,  30,  30,
	/* S-20 */     30,  30,  30,  30,  30,  40,  40,  40,  40,  40,
	/* S-10 */     50,  50,  50,  50,  60,  60,  70,  70,  80,  90,
	/* Norm */    100, 110, 120, 130, 140, 150, 160, 170, 180, 190,	/* 110-119 */
	/* F+10 */    200, 210, 220, 230, 240, 250, 260, 270, 280, 290,
	/* F+20 */    300, 310, 320, 330, 340, 350, 360, 370, 380, 390,
	/* F+30 */    400, 410, 420, 430, 440, 450, 460, 470, 480, 490,
	/* F+40 */    500, 510, 520, 530, 540, 540, 550, 550, 560, 570,
	/* F+50 */    580, 580, 590, 600, 610, 620, 630, 630, 640, 640,
	/* F+60 */    650, 650, 660, 660, 670, 670, 680, 680, 690, 690,
	/* F+70 */    700, 700, 710, 710, 720, 720, 730, 730, 740, 740,
	/* F+80 */    750, 750, 760, 760, 770, 770, 780, 780, 790, 790,
	/* F+90 */    800, 800, 800, 800, 800, 800, 800, 800, 800, 800,	/* 200-209 */
	/* Fast */    800, 800, 800, 800, 800, 800, 800, 800, 800, 800,
	/* Fast */    800, 800, 800, 800, 800, 800, 800, 800, 800, 800,
	/* Fast */    800, 800, 800, 800, 800, 800, 800, 800, 800, 800,
	/* Fast */    800, 800, 800, 800, 800, 800, 800, 800, 800, 800,
	/* Fast */    800, 800, 800, 800, 800, 800			/* 250-255 */
};


/*
 * This table provides for different game speeds at different
 * dungeon depths.  Shallower depths are faster, allowing for
 * easier town navigation.  Deeper depths are slow, hopefully
 * make deep combat less of a test of reflexs.
 */
s16b level_speeds[256] = {
	 750,  900,  910,  920,  930,  940,  950,  960,  970,  980, /* Town - 450' */
	 990, 1000, 1000, 1000, 1000, 1000, 1010, 1020, 1030, 1040, /* 500' - 950' */
	1050, 1060, 1070, 1080, 1090, 1100, 1110, 1120, 1130, 1140, /* 1000' - 1450' */
	1150, 1160, 1170, 1180, 1190, 1200, 1210, 1220, 1230, 1240, /* 1500' - 1950' */
	1250, 1260, 1270, 1280, 1290, 1300, 1310, 1320, 1330, 1340, /* 2000' - 2450' */
	1350, 1370, 1380, 1390, 1400, 1420, 1430, 1440, 1460, 1480, /* 2500' - 2950' */
	1500, 1520, 1540, 1560, 1580, 1600, 1620, 1640, 1660, 1680, /* 3000' - 3450' */
	1700, 1720, 1740, 1760, 1780, 1800, 1820, 1840, 1860, 1880, /* 3500' - 3950' */
	1900, 1920, 1940, 1960, 1980, 2000, 2000, 2000, 2000, 2000, /* 4000' - 4450' */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* 4500' - 4950' */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* 5000' - 5450' */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* 5500' - 5950' */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* 120 - 129 */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* 130 - 139 */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* 140 - 149 */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* 150 - 159 */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* 160 - 169 */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* 170 - 179 */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* 180 - 189 */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* 190 - 199 */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* 200 (- 209) */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* (210 - 219) */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* (220 - 229) */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* (230 - 239) */
	2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, /* (240 - 249) */
	2000, 2000, 2000, 2000, 2000, 2000			    /* (250 - 255) */
};



/*
 * Base experience levels, may be adjusted up for race and/or class
 */
s32b player_exp[PY_MAX_LEVEL + 1] = {
	10,
	25,
	45,
	70,//5
	100,
	140,
	200,
	280,
	380,//10
	500,
	650,
	850,
	1100,
	1400,//15
	1800,
	2300,
	2900,
	3600,
	4400,//20
	5400,
	6800,
	8400,
	10200,
	12500,//25
	17500,
	25000,
	35000L,
	50000L,
	75000L,//30
	100000L,
	150000L,
	200000L,
	275000L,
	350000L,//35
	450000L,
	550000L,
	700000L,
	850000L,
	1050000L,//	1000000L,//40
	1300000L,//	1250000L,
	1550000L,//	1500000L,
	1850000L,//	1800000L,
	2150000L,//	2100000L,
	2500000L,//	2400000L,//45
	2900000L,//	2700000L,
	3400000L,//	3000000L,
	4000000L,//	3500000L,
	4800000L,//	4000000L,
	5800000L,//	4500000L,//50
	7000000L,//	5000000L,

	8200000L,//	6000000L,
	9400000L,//	7000000L,
	10800000L,//	8000000L,
	12600000L,//	9000000L,//55
	14600000L,//	10000000L,

	16800000L,//	12000000L,
	19200000L,//	14000000L,
	21800000L,//	16000000L,
	24600000L,//	18000000L,//60
	28000000L,//	20000000L,

	31500000L,//       24000000L,
	35500000L,//       28000000L,
	40000000L,//       32000000L,
	45000000L,//       36000000L,//65
	50500000L,//       40000000L,

	56500000L,//       46000000L,
	63000000L,//       52000000L,
	70000000L,//       58000000L,
	78000000L,//       64000000L,//70
	87000000L,//       70000000L,

	97000000L,//	    78000000L,
	108000000L,//	    86000000L,
	120000000L,//       94000000L,
	133000000L,//      102000000L,//75
	147000000L,//      110000000L,

	162000000L,//      120000000L,
	178000000L,//      130000000L,
	195000000L,//      140000000L,
	213000000L,//      150000000L,//80
	233000000L,//      160000000L,

	255000000L,//      172000000L,
	279000000L,//      184000000L,
	305000000L,//      196000000L,
	333000000L,//      208000000L,//85
	363000000L,//      220000000L,

	395000000L,//      234000000L,
	429000000L,//      248000000L,
	465000000L,//      262000000L,
	503000000L,//      276000000L,//90
	544000000L,//      290000000L,

	588000000L,//      304000000L,
	635000000L,//      318000000L,
	685000000L,//      332000000L,
	738000000L,//      346000000L,//95
	796000000L,//      360000000L,

	859000000L,//      380000000L,
	927000000L,//      400000000L,
	999000000L,//      420000000L,//99, PY_MAX_PLAYER_LEVEL (just 1M off, mathematically ideally it'd be 1G exp^^)
	999999000L,//      440000000L,//100 PY_MAX_LEVEL
	999999998L,//      460000000L,//<-not sure why 101 and the 'dummy' one for 102 are needed tho

	999999999L // dummy, == PY_MAX_EXP in defines.h
};


/*
 * Player Race Information:
 *    Title,
 *    {STR,INT,WIS,DEX,CON,CHR},
 *    r_dis, r_dev, r_sav, r_stl, r_srh, r_fos, r_thn, r_thb,
 *    hitdie, exp base,
 *    Age (Base, Mod),
 *    Male (Hgt, Wgt),
 *    Female (Hgt, Wgt)
 *    infra,
 *    class-choices
 *    mana %  (<- obsolete)
 */

/* Note about skill boni/mali wording in the guide:
   'slight':  +/- 0.05       (5%)
   -:         +/- 0.1        (10%)
   'large':   +/- 0.15..0.2  (15-20%)
   'huge':     anything differing even more
*/

player_race race_info[MAX_RACE] = {
	{ "Human",
		{  0,  0,  0,  0,  0,  0 },
		0,  0,  0,  0,  0,  10,  0,  0,
		10,  100,
		14,  6,
		72,  6, 180, 25,
		66,  4, 150, 20,
		0,
		CF_ALL,
		100,

		//skills: vmod, value; mmod, mod

		/* HUMAN POWER!! */
		{{ SKILL_INTERCEPT, //SKILL_TRAINING,
			'+', 1000,
			'%', 115, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 115, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 100, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "Half-Elf",
		{ -1,  1,  0,  1, -1,  1 },
		2,  5,  3,  1, 6,  11, -1,  5,
		10,  110,
		24, 16,
		66,  6, 130, 15,
		62,  6, 100, 10,
		2,
		CF_ALL,
		110,

		{{ SKILL_BOW,
			'+', 0,
			'%', 110, },
		{ SKILL_INTERCEPT, //SKILL_TRAINING,
			'+', 500,
			'%', 110, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 100, },
		{ SKILL_NATURE,
			'+', 0,
			'%', 105, },
#ifdef ENABLE_OCCULT
		{ SKILL_OSPIRIT,
			'+', 0,
			'%', 105, },
		{ SKILL_OSHADOW,
			'+', 0,
			'%', 95, },
#endif
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "Elf",
		{ -1,  2,  1,  1, -2,  2 },
		5,  9,  6,  2, 8,  12, -5, 15,
		9,  120,
		75, 75,
		60,  4, 100,  6,
		54,  4, 80,  6,
		3,
		CF_ALL,
		120,

		{{ SKILL_BOW,
			'+', 1000,
			'%', 110, },
		{ SKILL_MAGIC,
			'+', 0,
			'%', 110, },
		{ SKILL_NATURE,
			'+', 0,
			'%', 115, },
		{ SKILL_WATER,
			'+', 0,
			'%', 110, },
#ifdef ENABLE_OCCULT
		{ SKILL_OSPIRIT,
			'+', 0,
			'%', 110, },
		{ SKILL_OSHADOW,
			'+', 0,
			'%', 90, },
#endif
		{ SKILL_STEALTH,
			'+', 0,
			'%', 110, },
		{ SKILL_DODGE,
			'+', 0,/*1000*/
			'%', 110, },
		{ SKILL_AGILITY,
			'+', 1000,
			'%', 110, },
		{ SKILL_CALMNESS,
			'+', 1000,
			'%', 110, },
		{ SKILL_SNEAKINESS,
			'+', 1000,
			'%', 110, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 100, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "Hobbit",
		{ -2,  2,  1,  3,  0,  1 },
		15, 12, 18, 4, 12,  15, -10, 20,
		//7,  110,
		8,  115,
		21, 12,
		36,  3, 60,  3,
		33,  3, 50,  3,
		3,
		CF_ALL,
		90,

		{{ SKILL_SLING,
			'+', 1000,
			'%', 110, },
		{ SKILL_STEALTH,
			'+', 1000,
			'%', 115, },
		{ SKILL_SNEAKINESS,
			'+', 2000,
			'%', 110, },
		{ SKILL_DODGE,
			'+', 0,/*1000*/
			'%', 110, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 100, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "Gnome",
		{ -1,  2,  0,  2,  1, -2 },
		10, 18, 12,  3, 6,  13, -8, 12,
		9,  125,
		50, 40,
		42,  3, 90,  6,
		39,  3, 75,  3,
		4,
		CF_ALL,
		120,

		{{ SKILL_XBOW,
			'+', 1000,
			'%', 110, },
		{ SKILL_MAGIC,
			'+', 0,
			'%', 110, },
		{ SKILL_DIG,
			'+', 1000,
			'%', 115, },
		{ SKILL_DODGE,
			'+', 0,/*1000*/
			'%', 115, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 100, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "Dwarf",
		{  2, -2,  2, -2,  2, -3 },
		2,  9,  9,  -1,  7,  10, 15,  0,
		11,  130,
		35, 15,
		48,  3, 150, 10,
		46,  3, 120, 10,
		5,
		CF_ALL,
		95,

		{{ SKILL_AXE,
			'+', 0,
			'%', 110, },
		{ SKILL_DIG,
			'+', 4000,
			'%', 130, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 145, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 85, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "Half-Orc",
		{  2, -1,  0,  0,  1, -4 },
		-3, -3, -3,  -1,  0, 7, 12, -5,
		11,  115, // lowered from 110 to 100
		11,  4,
		66,  1, 150,  5,
		62,  1, 120,  5,
		3,
		CF_ALL,
		50,

		{{ SKILL_BACKSTAB,
			'+', 1000,
			'%', 105, },
		{ SKILL_MASTERY,
			'+', 0,
			'%', 115, },
#ifdef ENABLE_OCCULT
		{ SKILL_OSHADOW,
			'+', 0,
			'%', 110, },
		{ SKILL_OSPIRIT,
			'+', 0,
			'%', 90, },
#endif
		{ SKILL_NECROMANCY,
			'+', 0,
			'%', 110, },
		{ SKILL_MAGIC, /* Not banned, but hard */
			'+', 0,
			'%', 80, },
		{ SKILL_SORCERY,
			'+', 0,
			'%', 80, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 85, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "Half-Troll",
		{ 4, -4, -2, -4,  3, -6 },
		-5, -8, -8, -2,  -1, 5, 20, -10,
		12,  135,
		20, 10,
		96, 10, 250, 50,
		84,  8, 225, 40,
		3,
		CF_ALL,
		20,

		{{ SKILL_BLUNT,
			'+', 0,
			'%', 110, },
		{ SKILL_HEALTH,
			'+', 3000,
			'%', 110, },
		/* Silly Half-Troll archers/rogues */
		{ SKILL_ARCHERY,
			'+', 0,
			'%', 50, },
		{ SKILL_CRITS,
			'+', 0,
			'%', 70, },
		{ SKILL_MAGIC, /* Not banned, but *hard* */
			'+', 0,
			'%', 50, },
		{ SKILL_SORCERY,
			'+', 0,
			'%', 50, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 85, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 60, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "Dunadan",
		{  1,  2,  2,  2,  3,  2 },
		4,  3,  5,  0, 3, 13, 15, 10,
		10,  160,//170
		50, 20,
		82, 5, 190, 20,
		78,  6, 180, 15,
		0,
		CF_ALL,
		105,

		{{ SKILL_COMBAT, /* Dunadan makes good generalist */
			'+', 0,
			'%', 110, },
		{ SKILL_MAGIC,
			'+', 0,
			'%', 105, },
		{ SKILL_ARCHERY,
			'+', 0,
			'%', 110, },
		{ SKILL_INTERCEPT, //SKILL_TRAINING,
			'+', 1000,
			'%', 110, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 115, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "High-Elf",
		{  1,  3, -1,  3,  1,  3 },
		4,  20, 20,  3,  3, 14, 10, 25,
		10,  200,//230
		100, 30,
		90, 10, 190, 20,
		82, 10, 180, 15,
		4,
		CF_ALL,
		125,

		{{ SKILL_BOW,
			'+', 1000,
			'%', 110, },
		{ SKILL_MAGIC,
			'+', 0,
			'%', 110, },
		{ SKILL_NATURE,
			'+', 0,
			'%', 110, },
#ifdef ENABLE_OCCULT
		{ SKILL_OSPIRIT,
			'+', 0,
			'%', 105, },
		{ SKILL_OSHADOW,
			'+', 0,
			'%', 90, },
#endif
    /* Runeskill for the Eldar, who practiced their crafts in Aman. - Kurzel */
		{ SKILL_R_LITE,
			'+', 500,
			'%', 110, },
		{ SKILL_R_MANA,
			'+', 500,
			'%', 110, },
		{ SKILL_STEALTH,
			'+', 0,
			'%', 110, },
		{ SKILL_DODGE,
			'+', 0,/*1000*/
			'%', 110, },
		{ SKILL_AGILITY,
			'+', 2000,
			'%', 115, },
		{ SKILL_CALMNESS,
			'+', 2000,
			'%', 115, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 115, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "Yeek",
		{  -5, -5, -5, -5, -5, -3 },
		0,  0,  0,  0,  0,  10,  0,  0,
		8,  80, /* 8, 35 */ /* 80% for the new RPG_SERVER originally */
		14,  6,
		57,  5, 130,  8,
		53,  4, 115,  6,
		0,
		CF_ALL,
		50,

		{{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 115, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "Goblin",
		{  0, -1, -4,  4,  2, -5 },
		2, -3, -3,  0,  2, 8, 12, -5,
		10,  120,//increased from 115 to 125 due to great starting abilities for fighters
		11,  4,
		66,  1, 150,  5,
		62,  1, 120,  5,
		3,
		CF_ALL,
		70,

		/* Never ask me the reason why, I love boomerang :) */
		/* DG - Why ? ;) */
		{{ SKILL_BOOMERANG,
			'+', 1000,
			'%', 110, },
		{ SKILL_STEALING,
			'+', 0,
			'%', 110, },
#ifdef ENABLE_OCCULT
		{ SKILL_OSHADOW,
			'+', 0,
			'%', 110, },
		{ SKILL_OSPIRIT,
			'+', 0,
			'%', 90, },
#endif
		{ SKILL_HOFFENSE,
			'+', 0,
			'%', 90, },
		{ SKILL_HDEFENSE,
			'+', 0,
			'%', 90, },
		{ SKILL_HCURING,
			'+', 0,
			'%', 90, },
		{ SKILL_HSUPPORT,
			'+', 0,
			'%', 90, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 100,},
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "Ent",
		{ 8, -4, +2, -4,  8, -4 },
		-4, 0, 20, -6, 5, 4, 5, -20,
		14, 280,//320
		255, 70,
		240,  6, 255, 25, //dnd Treant: 30ft, 4500 lbs, luls. But can also be 15-25 ft. Wgt still silyl, even 5-digits.
		180,  4, 255, 20,
		0,
		//No archer, rogue
		CF_ALL & ~CFR & ~CFA,
		90,

		{{ SKILL_AXE,
			'+', 0,
			'%', 80, },
		{ SKILL_SWORD,
			'+', 0,
			'%', 90, },
		{ SKILL_HEALTH,
			'+', 1000,
			'%', 110, },
		{ SKILL_CALMNESS,
			'+', 1000,
			'%', 115, },
		/* Ent loves water and the Earth */
		{ SKILL_EARTH,
			'+', 0,
			'%', 120, },
		{ SKILL_WATER,
			'+', 0,
			'%', 120, },
		{ SKILL_NATURE,
			'+', 0,
			'%', 120, },
#ifdef ENABLE_OCCULT
		{ SKILL_OSPIRIT,
			'+', 0,
			'%', 105, },
#endif
		{ SKILL_NECROMANCY,
			'+', 0,
			'%', 0, },
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'%', 0, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'%', 0, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'%', 0, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'%', 0, },

		{ SKILL_FIRE, /* But hates fire */
			'+', 0,
			'%', 60, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 0, },
		{ SKILL_SWIM, /* has intrinsic pass_water ability instead, cannot propel the way swimmers do anyway :p */
			'+', 0,
			'%', 0, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "Draconian",	// "Dragonrider", "Thunderlord" --actually, while Dragonriders would be GOOD, Draconians would be EVIL? :/
		//{  6,  3,  -10,  0,  5,  5 },
		//{  6,  2,  -2,  1,  3,  5 },
		//{  6,  2,  1,  1,  3,  5 },
		{  4,  2,  2,  1,  3,  2 },
		0,  7,  10,  -5,  10,  10,  15,  5,
		12,  300,//350
		14,  6,
		108,  6, 255, 25, //Dnd 4e: Average Height: 6´ 2˝–6´ 8˝. BUT..also: 5 1/2..up to 9"+ oO.
		66,  4, 220, 20, //Dnd: Average Weight: 220–320 lb
		5,
		CF_ALL,
		95,

		{{ SKILL_POLEARM,
			'+', 0,
			'%', 110, },
		/* Runeskill for Dragonriders, who may "go between" (teleport). - Kurzel */
		{ SKILL_R_NEXU,
			'+', 500,
			'%', 110, },
		{ SKILL_DEVICE,
			'+', 0,
			'%', 110, },
		{ SKILL_ATTUNEMENT,
			'+', 0,
			'%', 110, },
		/* Dragons are especially fearsome, if not very stealthy. - Kurzel*/
		{ SKILL_AURA_FEAR,
			'+', 0,
			'%', 120, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 115, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
#ifdef ENABLE_DRACONIAN_TRAITS
		{ SKILL_BREATH,
			'+', 1000,
			'+', 0, },
		{ SKILL_PICK_BREATH,
			'+', 1000,
			'+', 0, },
#endif
		},},

#ifdef ENABLE_KOBOLD
	{ "Kobold",
		{ -1, -1,  0,  2,  2, -2 },
		10,  5,  0,  4, 15,  15, -5, 10,
		8,  115,
		11,  4,
		66,  1, 150,  5,
		62,  1, 120,  5,
		5,
		CF_ALL,
		120,

		{{ SKILL_TRAPPING,
			'+', 0,
			'%', 115, },
		{ SKILL_DIG,
			'+', 3000,
			'%', 120, },
		{ SKILL_SNEAKINESS,
			'+', 0,
			'%', 105, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM,
			'+', 150,
			'+', 145, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},
#endif

	{ "Dark-Elf",
		{  0,  2, 1,  3,  1,  -6 },
		7,  3, 6,  4, 10, 6, 15, 15,
		10,  140,//150
		100, 30,
		90, 10, 180, 20,
		82, 10, 180, 15,
		8,
		// no Paladins
		CF_ALL & ~CFL,
		115,

		{
#if 0
		{ SKILL_ARCHERY,
			'+', 1000,
			'%', 110, },
#endif
		{ SKILL_BACKSTAB,
			'+', 1000,
			'%', 110, },
		{ SKILL_STEALTH,
			'+', 0,
			'%', 110, },
#ifdef ENABLE_OCCULT
		{ SKILL_OSHADOW,
			'+', 0,
			'%', 115, },
		{ SKILL_OSPIRIT,
			'+', 0,
			'%', 90, },
#endif
		{ SKILL_HOFFENSE,
			'+', 0,
			'%', 90, },
		{ SKILL_HDEFENSE,
			'+', 0,
			'%', 90, },
		{ SKILL_HCURING,
			'+', 0,
			'%', 90, },
		{ SKILL_HSUPPORT,
			'+', 0,
			'%', 90, },
		{ SKILL_DODGE,
			'+', 0,/*1000,*/
			'%', 110, },
		{ SKILL_AGILITY,
			'+', 2000,
			'%', 110, },
		{ SKILL_SNEAKINESS,
			'+', 2000,
			'%', 110, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 100, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		},},

	{ "Vampire",
		{  2,  2,  -1,  2,  0,  3 },
		-2,  3, 20,  2,  -4, 13, 10, -10,
		11,  240,//270
		100, 30,
		82, 5, 190, 20,	//copy-paste from Dunadain for now
		78,  6, 180, 15,
		15,
		//No paladin,druid,priest,shaman/mimic
#ifdef ENABLE_DEATHKNIGHT
		(CF_ALL & ~CFD & ~CFP & ~CFM & ~CFS & ~CFN) | CFK,
#else
		CF_ALL & ~CFD & ~CFP & ~CFM & ~CFS & ~CFN & ~CFL,
#endif
		125,

		{{ SKILL_BLUNT,
			'+', 0,
			'%', 0, },
		{ SKILL_DIVINATION,
			'+', 0,
			'%', 75, },
		{ SKILL_WATER,
			'+', 0,
			'%', 0, },
		{ SKILL_NATURE,
			'+', 0,
			'%', 0, },
#if 0
		{ SKILL_MIND,
			'+', 0,
			'%', 110, },
#endif
		{ SKILL_HOFFENSE,
			'+', 0,
			'%', 0, },
		{ SKILL_HDEFENSE,
			'+', 0,
			'%', 0, },
		{ SKILL_HCURING,
			'+', 0,
			'%', 0, },
		{ SKILL_HSUPPORT,
			'+', 0,
			'%', 0, },
#ifdef ENABLE_OCCULT
		{ SKILL_OSHADOW,
			'+', 0,
			'%', 115, },
		{ SKILL_OSPIRIT,
			'+', 0,
			'%', 0, },
 #ifdef ENABLE_OUNLIFE
		{ SKILL_OUNLIFE,
			'+', 0,
			'%', 115, },
 #endif
#endif
		{ SKILL_R_LITE, /* cannot train Light runecraft well */
			'+', 0,
			'%', 50, },
		{ SKILL_R_NETH, /* Moderate bonus to Nether, being the undead... */
			'+', 0,
			'%', 120, },
		{ SKILL_MIMIC, /* polymorph to vampire bat and maybe vampiric mist */
			'+', 1000,
			'%', 0, },
		{ SKILL_ANTIMAGIC, /* keep mimicry usable for bat form. vampires believe! for now at least... */
			'%', 0,
			'%', 0, },
		{ SKILL_MINTRUSION,
			'+', 0,
			'%', 110, },
		{ SKILL_NECROMANCY,
			'+', 0,
			'%', 115, },
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'%', 105, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'%', 115, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'%', 115, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'%', 115, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM, /* magically cannot cope with flowing water */
			'+', 0,
			'+', 60, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		}, },
#ifdef ENABLE_MAIA
/*
 * Player Race Information:
 *    Title,
 *    {STR,INT,WIS,DEX,CON,CHR},
 *    r_dis, r_dev, r_sav, r_stl, r_srh, r_fos, r_thn, r_thb,
 *    hitdie, exp base,
 *    Age (Base, Mod),
 *    Male (Hgt, Wgt),
 *    Female (Hgt, Wgt)
 *    infra,
 *    class-choices
 *    mana %  (<- obsolete)
 */
	{ "Maia",
		{ 1,  3, 3,  1,  0, 2 }, //boosted int/wisdom/dex
		3, 20, 3, 0,  5, 1, 15, 5,
		11, 400,//too low == bad since you need the quest mobs
		255, 250,
		72,  16, 150, 55,
		66,  8, 130, 40,
		10,
		/* Warrior and archer are disabled since they do not have MP */
		/* ENABLE_HELLKNIGHT/ENABLE_CPRIEST note: These shouldn't have flags to be allowed, since they cannot be 'created' on birth: */
		CF_ALL & ~CFW & ~CFA,
		125,

		{
/* The plan is to have a skill tree that is updated as the player level.
Only 70%-ify the skills that could potentially be updated when the player mutates!!
 */
		{ SKILL_ANTIMAGIC,
			'%', 0,
			'%', 0, },
		{ SKILL_ASTRAL,
			'+', 1250,
			'+', 1250, },
		{ SKILL_HOFFENSE,
			'+', 0,
			'%', 70, },
		{ SKILL_HDEFENSE,
			'+', 0,
			'%', 70, },
		{ SKILL_HCURING,
			'+', 0,
			'%', 70, },
		{ SKILL_HSUPPORT,
			'+', 0,
			'%', 70, },
#ifdef ENABLE_OCCULT
		{ SKILL_OSHADOW,
			'+', 0,
			'%', 70, },
		{ SKILL_OSPIRIT,
			'+', 0,
			'%', 70, },
 #ifdef ENABLE_OHERETICISM /* unused actually, can't get this skill at birth */
		{ SKILL_OHERETICISM,
			'+', 0,
			'%', 70, },
 #endif
 #ifdef ENABLE_OUNLIFE
		{ SKILL_OUNLIFE,
			'+', 0,
			'%', 70, },
 #endif
#endif
		{ SKILL_SNEAKINESS,
			'+', 0,
			'%', 110, },
		{ SKILL_STEALTH,
			'+', 0,
			'%', 110, },
		{ SKILL_NECROMANCY,
			'+', 0,
			'%', 70, },
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'%', 70, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'%', 70, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'%', 70, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'%', 70, },
		{ SKILL_CLIMB,
			'+', 0,
			'+', 100, },
		{ SKILL_SWIM,
			'+', 0,
			'+', 100, },
		{ SKILL_SHOOT_TILL_KILL,
			'+', 1000,
			'+', 0, },
		}, },
#endif

#if 0 // do not activate until I find a way to have a race in the server and not in the client
	{
		"Exp 626",
		{  1,  2,  -3,  1,  2,  -3 },
		4,  20, 20,  3,  3, 14, 10, 25,
		11,  150,
		14,  6,
		180,  6, 255, 25,
		150,  4, 230, 20,
		0,
		0xFFFFFFFF,
		105,

		{ 0 },
	},
#endif
};

 /* Lookup for the race name */
char *special_prace_lookup[MAX_RACE] = {
/* RACE_HUMAN */	"Human",
/* RACE_HALF_ELF */	"Half-Elven",
/* RACE_ELF */		"Elven",
/* RACE_HOBBIT */	"Hobbitonian",
/* RACE_GNOME */	"Gnome",
/* RACE_DWARF */	"Dwarven",
/* RACE_HALF_ORC */	"Half-Orc",
/* RACE_HALF_TROLL */	"Half-Troll",

/* RACE_DUNADAN */	"Western",
/* According to Vir:
 *  Dunedain: men of the West,
 *  Dunadan:  man of the West.
 * "You can't bend in English since it's not"...
 * "dun" == west, "edain" is men of the three great houses who travelled
 *  towards the light in the west in the first age befriending the elves.
 * Yes, I got the whole history off him =)
 * Sticking with "Western" for now, then. */

/* RACE_HIGH_ELF */	"High-Elven",
/* RACE_YEEK */		"Yeek",
/* RACE_GOBLIN */	"Goblin",
/* RACE_ENT */		"Ent",
/* RACE_DRACONIAN */	"Draconian",
#ifdef ENABLE_KOBOLD
 /* RACE_KOBOLD*/	"Kobold",
#endif
/* RACE_DARK_ELF */	"Dark-Elven",
/* RACE_VAMPIRE */	"Vampire",
#ifdef ENABLE_MAIA
/* RACE_MAIA */		"Maia",
#endif
};

/* Extra trailing space.. */
char *special_prace_lookup2[MAX_RACE] = {
/* RACE_HUMAN */	"Human ",
/* RACE_HALF_ELF */	"Half-Elven ",
/* RACE_ELF */		"Elven ",
/* RACE_HOBBIT */	"Hobbitonian ",
/* RACE_GNOME */	"Gnome ",
/* RACE_DWARF */	"Dwarven ",
/* RACE_HALF_ORC */	"Half-Orc ",
/* RACE_HALF_TROLL */	"Half-Troll ",

/* RACE_DUNADAN */	"Western ",
/* According to Vir:
 *  Dunedain: men of the West,
 *  Dunadan:  man of the West.
 * "You can't bend in English since it's not"...
 * "dun" == west, "edain" is men of the three great houses who travelled
 *  towards the light in the west in the first age befriending the elves.
 * Yes, I got the whole history off him =)
 * Sticking with "Western" for now, then. */

/* RACE_HIGH_ELF */	"High-Elven ",
/* RACE_YEEK */		"Yeek ",
/* RACE_GOBLIN */	"Goblin ",
/* RACE_ENT */		"Ent ",
/* RACE_DRACONIAN */	"Draconian ",
#ifdef ENABLE_KOBOLD
 /* RACE_KOBOLD*/	"Kobold ",
#endif
/* RACE_DARK_ELF */	"Dark-Elven ",
/* RACE_VAMPIRE */	"Vampire ",
#ifdef ENABLE_MAIA
/* RACE_MAIA */		"Maia ",
#endif
};

/*
 * Player Race Information:
 *    Title,
 *    {STR,INT,WIS,DEX,CON,CHR},
 *    r_dis, r_dev, r_sav, r_stl, r_srh, r_fos, r_thn, r_thb,
 *    hitdie, exp base,
 *    Age (Base, Mod),
 *    Male (Hgt, Wgt),
 *    Female (Hgt, Wgt)
 *    infra,
 *    class-choices
 *    mana%
 */


/*
 * Player Classes.
 *
 *   Title,
 *   Color,
 *   {STR,INT,WIS,DEX,CON,CHR},
 *   {STR,INT,WIS,DEX,CON,CHR} recommended minimum values,
 *   c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *   x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *   HD, Exp
 */
/* TODO: let's move them to p_info.txt */

/* Experimental: Unlock Necromancy (and for Mimics Traumaturgy) for some unusual classes?
   Disabled this with the addition of Death Knight. Understanding is: Only classes very
   proficient in magic or specifically aligned to nether should be able to learn it. */
#define EXP_NECRO

player_class class_info[MAX_CLASS] = {
	{ "Warrior",
		TERM_UMBER, FALSE, 0,
		{ 5, -2, -2, 2, 2, -1},
		{ 22 + 100, 0, 0, 10 + 100, 0, 0},
		20, 18, 18, 1,  14, 2, 70, 55,
		10, 8,  10, 0,  0,  0,  45, 40,
		10, 0,//6,  10,//9, 10,
		//11, 0,

		//skills: vmod, value; mmod, mod

		{{ SKILL_COMBAT,
			'+', 3000,
			'+', 2000, },
		{ SKILL_MASTERY,
			'+', 1000,
			'+', 1000, },
		{ SKILL_TECHNIQUE,
			'+', 1000,
			'+', 0, },
#ifdef DUAL_WIELD /* warriors may too :) */
		{ SKILL_DUAL, /* dual-wield */
			'+', 1000,
			'+', 0, },
#endif
#ifdef ENABLE_STANCES /* was warrior-only, now also mimics/paladins/rangers */
		{ SKILL_STANCE,
			'+', 1000,
			'+', 0, },
#endif
		{ SKILL_SWORD,
			'+', 0,
			'+', 800, },
		{ SKILL_AXE,
			'+', 0,
			'+', 800, },
		{ SKILL_BLUNT,
			'+', 0,
			'+', 800, },
		{ SKILL_POLEARM,
			'+', 0,
			'+', 800, },
		{ SKILL_BOW,
			'+', 0,
			'+', 350, },
		{ SKILL_XBOW,
			'+', 0,
			'+', 350, },
		{ SKILL_BOOMERANG,
			'+', 0,
			'+', 500, },
		{ SKILL_SLING,
			'+', 0,
			'+', 300, },
		{ SKILL_MARTIAL_ARTS, /* let's keep it low for now - offbalancing */
			'+', 0,
			'+', 700, },
		{ SKILL_DEVICE,
			'+', 0,
			'+', 700, },
		{ SKILL_SNEAKINESS,
			'+', 0,
			'+', 700, },
		{ SKILL_STEALTH,
			'+', 0,
			'+', 600, },
		{ SKILL_DISARM,
			'+', 0,
			'+', 900, },
		{ SKILL_TRAPPING,
			'+', 0,
			'+', 600, },
		{ SKILL_DODGE,
			'+', 0,/*1000*/
			'+', 800, },
#ifdef EXP_NECRO
		{ SKILL_NECROMANCY, /* Necromancy for this class - experimental */
			'+', 0,
			'+', 1000, },
#endif
		{ SKILL_TRAUMATURGY,
			'%', 0,
			'%', 0, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'+', 1000, },
		{ SKILL_ANTIMAGIC,
			'+', 0,
			'+', 500, },//700
			/* Health tree */
		{ SKILL_HEALTH,
			'+', 2000,
			'+', 1000, },
		{ SKILL_SWIM,
			'+', 0,
			'%', 120, },
		{ SKILL_DIG,
			'+', 0,
			'+', 1200, },
		{ SKILL_INTERCEPT,
			'+', 1000,
			'+', 800, },
		}, },

	{ "Istar",
		TERM_RED, FALSE, 0,
		{-5, 3, 0, 1, -2, 1},
		{0, 0 + 100, 0, 0, 0, 0},
		30, 36, 30, 2,  16, 20, 34, 20,
		7,  10, 9,  0,  0,  0,  15, 15,
		0, 35,//0,30
		//3, 35,

		{{ SKILL_COMBAT,
			'+', 0,
			'+', 300, },
		{ SKILL_MASTERY,
			'+', 0,
			'+', 150, },
		{ SKILL_MAGIC,
			'+', 4000,	/* 6000 */
			'+', 1000, },
		{ SKILL_DEVICE,
			'+', 1000,
			'+', 1100, },
		{ SKILL_SNEAKINESS,
			'+', 1000,
			'+', 500, },//700,
		{ SKILL_STEALTH,
			'+', 0,
			'+', 600, },
		{ SKILL_DODGE,
			'+', 0,
			'+', 450, },
			/* Health tree */
		{ SKILL_HEALTH,
			'+', 0,
			'+', 800, },
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 800, },
		{ SKILL_DIG,
			'+', 0,
			'+', 700, },
		{ SKILL_SORCERY,
			'+', 0,
				/* '+', 500,//was 700 */
				/* '+', 170,  1..9schools->schools,10..12->sorc */
				/* '+', 185,  49*5.5 skill points -> sorcery ~maxed. */
			'+', 205,  /* 49*5 -> maxed at 50 */ },
		{ SKILL_SPELL,
			'+', 0,
			'+', 600, },
		{ SKILL_MANA,
			'+', 1000,	/* Allow to cast Manathrust */
			'+', 1500, },
		{ SKILL_FIRE,
			'+', 0,
			'+', 1500, },
		{ SKILL_AIR,
			'+', 0,
			'+', 1500, },
		{ SKILL_EARTH,
			'+', 0,
			'+', 1500, },
		{ SKILL_WATER,
			'+', 0,
			'+', 1500, },
		{ SKILL_NATURE,
			'+', 0,
			'+', 1500, },
		{ SKILL_DIVINATION,
			'+', 0,
			'+', 1400, },
		{ SKILL_CONVEYANCE,
			'+', 0,
			'+', 1500, },
#if 0
		{ SKILL_META,
			'+', 0,
			'+', 1500, },
		{ SKILL_MIND,
			'+', 0,
			'+', 1500, },
#endif
		{ SKILL_TEMPORAL,
			'+', 0,
			'+', 1500, },
		{ SKILL_UDUN,
			'+', 0,
			'+', 1400, },
		{ SKILL_NECROMANCY, /* Necromancy for this class - experimental */
			'+', 0,
			'+', 1100, },
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'+', 1100, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'+', 1200, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'+', 1200, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'+', 1200, },
		}, },

	{ "Priest",
		TERM_GREEN, FALSE, 0,
		{-1, -3, 3, -1, 0, 2},
#if 0 /* disabled recommendations for STR/DEX because STR cannot even be reached by dwarven priests.. */
		{19, 0, 0 + 100, 10, 0, 0},
#else
		{0, 0, 0 + 100, 0, 0, 0},
#endif
		25, 25, 32, 2,  16, 8, 48, 35,
		7,   9, 12, 0,  0,  0, 20, 15,
		5, 20, //2, 20,//4,20
		//7, 20,

		{{ SKILL_COMBAT,
			'+', 0,
			'+', 750,}, //x1.5
		{ SKILL_MASTERY,
			'+', 0,
			'+', 400, },//800
#if 0 /* unusable: depends on BLESSED too much - just confuses newbies anyway */
		{ SKILL_SWORD,
			'+', 0,
			'+', 500, },
#endif
		{ SKILL_BLUNT,
			'+', 0,
			'+', 600, },
		{ SKILL_MARTIAL_ARTS,
			'+', 0,
			'+', 500, }, //450
		{ SKILL_MAGIC,
			'+', 2000,
			'+', 900, },
#if 0
		{ SKILL_SPELL,
			'+', 0,
			'+', 500, },
#endif
		/*{ SKILL_DIVINATION,
			'+', 1000,
			'+', 500, },
		{ SKILL_CONVEYANCE,
			'+', 0,
			'+', 900,
			},,*/
		{ SKILL_HOFFENSE,
			'+', 0,
			'+', 1400, },
		{ SKILL_HDEFENSE,
			'+', 0,
			'+', 1400, },
		{ SKILL_HCURING,
			'+', 1000,
			'+', 1600, },
		{ SKILL_HSUPPORT,
			'+', 0,
			'+', 1400, },
#ifdef ENABLE_OCCULT
		{ SKILL_OSHADOW,
			'+', 0,
			'+', 800, },
#endif
		{ SKILL_DEVICE,
			'+', 1000,
			'+', 900, },
		{ SKILL_SNEAKINESS,
			'+', 1000,
			'+', 600, },//770,
		{ SKILL_STEALTH,
			'+', 0,
			'+', 500, },
		{ SKILL_DODGE,
			'+', 0,
			'+', 550, },
			/* Health tree */
		{ SKILL_HEALTH,
			'+', 1000,
			'+', 1000, },
		{ SKILL_DIG,
			'+', 0,
			'+', 700, },
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 900, },
		{ SKILL_INTERCEPT,
			'+', 0,
			'+', 600, }, //400
		}, },

	{ "Rogue",
		TERM_BLUE, FALSE, 0,
		{ 2, 1, -2, 3, 1, -1},
		{15, 0, 0, 19 + 100, 0, 0},
		45, 28, 28, 5, 32, 24, 60, 66,
		15, 9, 10, 0, 10, 10, 40, 40,// ..0,0,40,30
		5, 15, //3, 25,//5, 25
		//8, 25,

		{{ SKILL_COMBAT,
			'+', 1000,
			'+', 1200, },
		{ SKILL_MASTERY,
			'+', 1000,
			'+', 700, }, //650
		{ SKILL_TECHNIQUE,
			'+', 1000,
			'+', 0, },
#ifdef DUAL_WIELD
		{ /* dual-wield */ SKILL_DUAL,
			'+', 1000,
			'+', 0, },
#endif
		{ SKILL_SWORD,
			'+', 1000,
			'+', 600, },
		{ SKILL_CRITS,
			'+', 0,
			'+', 900, },
		{ SKILL_BOW,
			'+', 0,
			'+', 350, },
		{ SKILL_XBOW,
			'+', 0,
			'+', 350, },
		{ SKILL_BOOMERANG,
			'+', 0,
			'+', 600, },
		{ SKILL_SLING,
			'+', 0,
			'+', 450, },
		{ SKILL_MARTIAL_ARTS,
			'+', 0,
			'+', 500, },
		{ SKILL_MAGIC,
			'+', 0,
			'+', 600, },
		/* They can be changed */
		{ SKILL_CONVEYANCE,
			'+', 0,
			'+', 750, },
#if 0
		{ SKILL_DIVINATION,
			'+', 0,
			'+', 750, },
#endif
#ifndef ENABLE_OCCULT
		{ SKILL_AIR,
			'+', 0,
			'+', 750, },
#else
		{ SKILL_OSHADOW,
			'+', 0,
			'+', 600, },
#endif
		{ SKILL_DEVICE,
			'+', 1000,
			'+', 950, },
#ifdef EXP_NECRO /* Necromancy for this class - experimental */
		{ SKILL_NECROMANCY,
			'+', 0,
			'+', 1000, },
#endif
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'+', 1000, },
		{ SKILL_SNEAKINESS,
			'+', 1000,
			'+', 900, },//1200,
		{ SKILL_STEALTH,
			'+', 1000,
			'+', 700, },
		{ SKILL_DISARM,
			'+', 1000,
			'+', 1200, },
		{ SKILL_TRAPPING,
			'+', 1000,
			'+', 1000, },
		{ SKILL_STEALING,
			'+', 1000,
			'+', 1000, },
		{ SKILL_BACKSTAB,
			'+', 1000,
			'+', 1000, },
		{ SKILL_DODGE,
			'+', 1000,
			'+', 900, },
			/* Health tree */
		{ SKILL_HEALTH,
			'+', 1000,
			'+', 1000, },
		{ SKILL_AGILITY,
			'+', 1000,
			'+', 500, },
		{ SKILL_CALMNESS,
			'+', 0,
			//'+', 600,
			'+', 800, },
		{ SKILL_SWIM,
			'+', 0,
			'%', 120, },
		{ SKILL_CLIMB,
			'+', 0,
			'%', 110, },
		{ SKILL_DIG,
			'+', 0,
			'+', 1100, },
		{ SKILL_INTERCEPT,
			'+', 1000,
			'+', 900, },
		}, },

	{ "Mimic",
		 TERM_L_WHITE, FALSE, 0, //confusing colour
		// TERM_ORANGE, <- more confusing since they're supposed to use a monster form
		{ 1, 0, 0, 1, 1, -4},
		{19 + 100, 0, 0, 10 + 100, 0, 0},//21,19
		25, 30, 28, 1, 18, 18, 60, 46,
		 9, 9, 10, 0,  0,  0, 40, 25,
		6, 30,//3, 40,//4, 25
		//8, 40,

		{{ SKILL_COMBAT,
			'+', 3000,
			'+', 1600, },
		{ SKILL_MASTERY,
			'+', 1000,
			'+', 800, }, //750
		{ SKILL_TECHNIQUE,
			'+', 1000,
			'+', 0, },
#ifdef ENABLE_STANCES
		{ SKILL_STANCE,
			'+', 1000,
			'+', 0, },
#endif
		{ SKILL_SWORD,
			'+', 0,
			'+', 630, },
		{ SKILL_AXE,
			'+', 0,
			'+', 630, },
		{ SKILL_BLUNT,
			'+', 0,
			'+', 630, },
		{ SKILL_POLEARM,
			'+', 0,
			'+', 630, },
		{ SKILL_BOW,
			'+', 0,
			'+', 250, },
		{ SKILL_XBOW,
			'+', 0,
			'+', 250, },
		{ SKILL_SLING,
			'+', 0,
			'+', 350, },
		{ SKILL_BOOMERANG,
			'+', 0,
			'+', 500, },
		{ SKILL_MARTIAL_ARTS,
			'+', 0,
			'+', 550, },
		{ SKILL_MAGIC,
			'+', 1000,
			'+', 700, },
		{ SKILL_MIMIC,
			'+', 1000,
			'+', 900, },
		{ SKILL_DEVICE,
			'+', 1000,
			'+', 850, },
#ifdef EXP_NECRO /* Necromancy for this class - experimental */
		{ SKILL_NECROMANCY,
			'+', 0,
			'+', 1000, },
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'+', 1000, },
#endif
		{ SKILL_AURA_FEAR,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'+', 1000, },
		{ SKILL_SNEAKINESS,
			'+', 0,
			'+', 650, },//800,
		{ SKILL_STEALTH,
			'+', 1000,
			'+', 500, },
		{ SKILL_DISARM,
			'+', 0,
			'+', 500, },
		{ SKILL_DODGE,
			'+', 0,
			'+', 600, },
		{ SKILL_INTERCEPT,
			'+', 0,
			'+', 700, },
			/* Health tree */
		{ SKILL_HEALTH,
			'+', 1000,
			'+', 900, },
		{ SKILL_DIG,
			'+', 0,
			'+', 1100, },
			/* Misc tree */
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 600, },
		}, },

	{ "Archer",
		TERM_ORANGE, FALSE, 0,
		{ 1, 0, 2, 3, 1, -1},
		{0, 0, 0, 18 + 100, 0, 0},
		30, 22, 28, 2,  24, 20, 56, 72,
		8,  8, 10, 0,  0,  0,  30, 50,
		5, 10,//3, 15,//5, 15
		//8, 15,

		{{ SKILL_COMBAT,
			'+', 1000,
			'+', 1700, },//buffed from 1300
		{ SKILL_MASTERY,
			'+', 1000,
			'+', 600, },
		{ SKILL_SWORD,
			'+', 0,
			'+', 400, },
		{ SKILL_AXE,
			'+', 0,
			'+', 400, },
		{ SKILL_BLUNT,
			'+', 0,
			'+', 400, },
		{ SKILL_POLEARM,
			'+', 0,
			'+', 400, },
		{ SKILL_ARCHERY,
			'+', 2000,
			'+', 1000, },
		{ SKILL_SLING,
			'+', 0,
			'+', 800, },
		{ SKILL_BOW,
			'+', 1000,
			'+', 850, },
		{ SKILL_XBOW,
			'+', 0,
			'+', 800, },
		{ SKILL_BOOMERANG,
			'+', 0,
			'+', 600, },
		{ SKILL_DEVICE,
			'+', 1000,
			'+', 700, },
#ifdef EXP_NECRO /* Necromancy for this class - experimental */
		{ SKILL_NECROMANCY,
			'+', 0,
			'+', 1000, },
#endif
		{ SKILL_TRAUMATURGY,
			'%', 0,
			'%', 0, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'+', 1000, },
		{ SKILL_SNEAKINESS,
			'+', 1000,
			'+', 600, },//600,
		{ SKILL_STEALTH,
			'+', 1000,
			'+', 600, },
		{ SKILL_DISARM,
			'+', 500,
			'+', 500, },
		{ SKILL_TRAPPING,
			'+', 0,
			'+', 600, },
		{ SKILL_DODGE,
			'+', 0,/*1000*/
			'+', 700, /*500, but motivating light armour hereby*/ },
		{ SKILL_ANTIMAGIC,
			'+', 0,
			'+', 500, },//350
		{ SKILL_HEALTH,
			'+', 1000,
			'+', 1000, },
		{ SKILL_DIG,
			'+', 0,
			'+', 900, },
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 900, },
		}, },

	{ "Paladin",
		TERM_YELLOW, FALSE, 0,
		{ 3, -3, 1, 0, 2, 2},
		{20 + 100, 0, 0 + 100, 10, 0, 0},
/*   c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *   x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *   HD, Exp*/
		10, 21, 54, 1,  13, 16, 60, 40, //was c_thb 29
		2, 8,  10, 0,  0,  2,  35, 10,
		8, 30,//5, 30,//7,30
		//10, 30,

		{{  SKILL_COMBAT,
			'+', 2700,
			'+', 1400, },//nerfed from 1700
		{ SKILL_MASTERY,
			'+', 1800,
			'+', 900, },
		{ SKILL_TECHNIQUE,
			'+', 1000,
			'+', 0, },
#ifdef ENABLE_STANCES
		{ SKILL_STANCE,
			'+', 1000,
			'+', 0, },
#endif
		{ SKILL_SWORD,
			'+', 0,
			'+', 750, },
#if 1 /* offer it at all? */
		{ SKILL_AXE,
			'+', 0,
			'+', 600, },//savage^^
#endif
		{ SKILL_BLUNT,
			'+', 0,
			'+', 750, },
		{ SKILL_POLEARM,
			'+', 0,
			'+', 750, },
		{ SKILL_BOW,
			'+', 0,
			'+', 300, },
		{ SKILL_XBOW,
			'+', 0,
			'+', 300, },
#if 0 /* for 'monk' class, pick priest instead */
		{  SKILL_MARTIAL_ARTS, /* let's keep it low for now - offbalancing */
			'+', 0,
			'+', 500, },
#endif
		{ SKILL_MAGIC,
			'+', 1000,
			'+', 600, },
#if 0
		{ SKILL_SPELL,
			'+', 0,
			'+', 350, },
#endif
		/*{ SKILL_DIVINATION,
			'+', 1000,
			'+', 900, },
		{ SKILL_CONVEYANCE,
			'+', 0,
			'+', 700, },*/
		{ SKILL_HOFFENSE,
			'+', 0,
			'+', 700, },
		{ SKILL_HDEFENSE,
			'+', 0, /* be able to use the startup eq spellbook of blessing */
			'+', 800, },
		{ SKILL_HCURING,
			'+', 0,
			'+', 700, },
		{ SKILL_HSUPPORT,
			'+', 1000,
			'+', 800, },
		{ SKILL_DEVICE,
			'+', 1000,
			'+', 800, },
		{ SKILL_SNEAKINESS,
			'+', 1000,
			'+', 500, }, //650,
		{ SKILL_DISARM,
			'+', 1000,
			'+', 600, },
		{ SKILL_DODGE,
			'+', 0,/*1000*/
			'+', 600, },
		{ SKILL_STEALTH,
			'+', 0,
			'+', 500, },
		{ SKILL_HEALTH,
			'+', 2000,
			'+', 1000, },
		{ SKILL_DIG,
			'+', 0,
			'+', 700, },
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 600, },
		{ SKILL_INTERCEPT,
			'+', 1000,
			'+', 800, },
		}, },

	{ "Ranger",
		TERM_L_UMBER, FALSE, 0,
		{ 2, 2, -1, 1, 2, 0},
		{19 + 100, 0 + 100, 0, 10 + 100, 0, 0},//21,19
/*   c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *   x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *   HD, Exp*/
		34, 32, 30, 5, 30, 30, 50, 60,
		10, 9, 10, 0, 15,  5, 30, 45,
		7, 35,//4, 35,//6, 35
		//9, 35,

		{{ SKILL_COMBAT,
			'+', 1500,
			'+', 1000, },//nerfed from 1300
		{ SKILL_MASTERY,
			'+', 1000,
			'+', 800, },//700
		{ SKILL_TECHNIQUE,
			'+', 1000,
			'+', 0, },
#ifdef DUAL_WIELD /* rangers get an exception for now. hoping it'll balance out with giving them stances as well! */
		{ /* dual-wield */ SKILL_DUAL,
			'+', 1000,
			'+', 0, },
#endif
#ifdef ENABLE_STANCES
		{ SKILL_STANCE,
			'+', 1000,
			'+', 0, },
#endif
		{ SKILL_SWORD,
			'+', 0,
			'+', 700, },
		{ SKILL_AXE,
			'+', 0,
			'+', 700, },
		{ SKILL_BLUNT,
			'+', 0,
			'+', 700, },
		{ SKILL_POLEARM,
			'+', 0,
			'+', 700, },
#if 1 /* allowed in combination with SKF1_MAX_10 restriction */
		{ SKILL_ARCHERY,
			'+', 1000,
			'+', 700, },//500
#endif
		{ SKILL_SLING,
			'+', 0,
			'+', 450, },//350
		{ SKILL_BOW,
			'+', 1000,
			'+', 450, },//350
		{ SKILL_XBOW,
			'+', 0,
			'+', 450, },//350
		{ SKILL_BOOMERANG,
			'+', 0,
			'+', 650, },
		{ SKILL_MARTIAL_ARTS, /* let's keep it low for now - offbalancing */
			'+', 0,
			'+', 500, },
		{ SKILL_MAGIC,
			'+', 1000,
			'+', 800, },
		{ SKILL_SPELL,
			'+', 0,
			'+', 450, },
		{ SKILL_MANA,
			'+', 0,
			'+', 700, },//was 600 hmm
		{ SKILL_FIRE,
			'+', 0,
			'+', 900, },
		{ SKILL_AIR,
			'+', 0,
			'+', 900, },
		{ SKILL_EARTH,
			'+', 0,
			'+', 900, },
		{ SKILL_WATER,
			'+', 0,
			'+', 900, },
		{ SKILL_NATURE,
			'+', 1000,
			'+', 900, },
		{ SKILL_DIVINATION,
			'+', 0,
			'+', 800, },
		{ SKILL_CONVEYANCE,
			'+', 0,
			'+', 900, },
#if 0
		{ SKILL_META,
			'+', 0,
			'+', 800, },
		{ SKILL_MIND,
			'+', 0,
			'+', 800, },
#endif
#if 1
		{ SKILL_TEMPORAL,
			'+', 0,
			'+', 700, },//600,//800
#endif
		{ SKILL_DEVICE,
			'+', 1000,
			'+', 1000, },
		{ SKILL_SNEAKINESS,
			'+', 1000,
			'+', 750, },//900,
		{ SKILL_DISARM,
			'+', 1000,
			'+', 900, },
		{ SKILL_DODGE,
			'+', 0,/*1000*/
			'+', 700, },
		{ SKILL_STEALTH,
			'+', 0,
			'+', 600, },
		{ SKILL_TRAPPING,
			'+', 1000,
			'+', 1100, },
		{ SKILL_HEALTH,
			'+', 2000,
			'+', 1000, },
		{ SKILL_SWIM,
			'+', 0,
			'%', 120, },
		{ SKILL_CLIMB,
			'+', 0,
			'%', 110, },
		{ SKILL_DIG,
			'+', 0,
			'+', 1200, },
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 700, },
		{ SKILL_INTERCEPT,
			'+', 1000,
			'+', 800, },
		}, },

	{ "Adventurer",
		TERM_VIOLET, FALSE, 0,
		{ 0, 0, 0, 0, 0, 0},
		{19, 0, 0, 10, 0, 0},//20,10
		30, 22, 20, 3,  15, 15, 50, 50,
		10, 8,  10, 0,  5,  5,  25, 25,//..,0,0,25,25
		6, 25, //3,  0,//5,0,
		//8, 10,

		{{ SKILL_COMBAT,/* Combat tree */
			'+', 1000,
			'+', 900, },
		{ SKILL_MASTERY,
			'+', 0,//1000,
			'+', 600, },
		{ SKILL_TECHNIQUE,
			'+', 1000,
			'+', 0, },
		{ SKILL_SWORD,
			'+', 0,
			'+', 550, },
		{ SKILL_AXE,
			'+', 0,
			'+', 600, },
		{ SKILL_BLUNT,
			'+', 0,
			'+', 600, },
		{ SKILL_POLEARM,
			'+', 0,
			'+', 500, },
		{ SKILL_SLING,
			'+', 1000,
			'+', 350, },
		{ SKILL_BOW,
			'+', 0,
			'+', 350, },
		{ SKILL_XBOW,
			'+', 0,
			'+', 350, },
		{ SKILL_BOOMERANG,
			'+', 1000,
			'+', 700, },
		{ SKILL_MARTIAL_ARTS, /* let's keep it low for now - offbalancing */
			'+', 0,
			//'+', 450,
			'+', 500, },
		{ SKILL_MAGIC,
			'+', 0,//2000,
			'+', 600, },
		{ SKILL_CONVEYANCE,
			'+', 0,//1000,
			'+', 650, },
		{ SKILL_DEVICE,
			'+', 1000,
			'+', 900, },
		{ SKILL_SPELL,
			'+', 0,
			'+', 350,	/* reduced from 500, after
						sorcery & mimicry got raised,
						to avoid adv becoming best sorc */ },
		{ SKILL_MANA,
			'+', 0, //1000,
			'+', 500, },//600, //500
		{ SKILL_FIRE,
			'+', 0,
			'+', 600, },//700, //600..
		{ SKILL_AIR,
			'+', 0,
			'+', 700, },
		{ SKILL_EARTH,
			'+', 0,
			'+', 700, },
		{ SKILL_WATER,
			'+', 0,
			'+', 700, },
		{ SKILL_NATURE,
			'+', 0, //1000,
			'+', 700, },
		{ SKILL_DIVINATION,
			'+', 0,
			'+', 500, },//600, //500
#if 0
		{ SKILL_META,
			'+', 0,
			'+', 300, },
		{ SKILL_MIND,
			'+', 0,
			'+', 500, },//600, //500
#endif
#if 1
		{ SKILL_TEMPORAL,
			'+', 0,
			'+', 400, },//500, //400
#endif
		{ SKILL_HOFFENSE,
			'+', 0,
			'+', 500, },//600, //500
		{ SKILL_HDEFENSE,
			'+', 0,
			'+', 600, },
		{ SKILL_HCURING,
			'+', 0,
			'+', 600, },
		{ SKILL_HSUPPORT,
			'+', 0,
			'+', 600, },
#if 1
		{ SKILL_DRUID_ARCANE,
			'+', 0,
			'+', 500, }, //was formerly 300 for SKILL_DRUID (combined skill)
		{ SKILL_DRUID_PHYSICAL,
			'+', 0,
			'+', 500, },
#else
		{ SKILL_DRUID,
			'+', 0,
			'+', 300, },
#endif
		{ SKILL_PPOWER,
			'+', 0,
			'+', 500, },
		{ SKILL_ATTUNEMENT,
			'+', 0,
			'+', 500, },
		{ SKILL_MINTRUSION,
			'+', 0,
			'+', 500, },
#ifdef ENABLE_OCCULT /* Occult */
		{ SKILL_OSHADOW,
			'+', 0,
			'+', 450, },
		{ SKILL_OSPIRIT,
			'+', 0,
			'+', 450, },
 #ifdef ENABLE_OHERETICISM
		{ SKILL_OHERETICISM,
			'+', 0,
			'+', 450, },
 #endif
 #ifdef ENABLE_OUNLIFE
		{ SKILL_OUNLIFE,
			'+', 0,
			'+', 450, },
 #endif
#endif
		{ SKILL_R_LITE,
			'+', 0,
			'+', 500, },
		{ SKILL_R_DARK,
			'+', 0,
			'+', 500, },
		{ SKILL_R_NEXU,
			'+', 0,
			'+', 500, },
		{ SKILL_R_NETH,
			'+', 0,
			'+', 500, },
		{ SKILL_R_CHAO,
			'+', 0,
			'+', 500, },
		{ SKILL_R_MANA,
			'+', 0,
			'+', 500, },
		{ SKILL_MIMIC,
			'+', 0,
			'+', 400,	/* 300 was 'safer' */ },
		{ SKILL_SNEAKINESS, /* Sneakiness tree */
			'+', 1000,
			'+', 800, },//700
		{ SKILL_DISARM,
			'+', 1000,
			'+', 800, },//700,
		{ SKILL_TRAPPING,
			'+', 1000,//0,
			'+', 900, },//600,
		{ SKILL_STEALTH,
			'+', 1000,
			'+', 600, },
		{ SKILL_STEALING,
			'+', 0,
			'+', 600, },
		{ SKILL_BACKSTAB,
			'+', 0,
			'+', 600, },
		{ SKILL_DODGE,
			'+', 0,
			'+', 600, },
		{ SKILL_NECROMANCY,
			'+', 0,
			'+', 1000, },
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'+', 1000, },
		{ SKILL_ANTIMAGIC,
			'+', 0,
			'+', 500, },
		{  SKILL_HEALTH, /* Health tree */
			'+', 1000,
			'+', 1100, },
		{ SKILL_SWIM,
			'+', 0,
			'%', 140, },
		{ SKILL_CLIMB,
			'+', 0,
			'%', 140, },
		{ SKILL_DIG,
			'+', 1000,
			'+', 1400, },
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 700, },
		{ SKILL_INTERCEPT,
			'+', 0,
			'+', 700, },
		}, },

	{ "Druid",	/* by the_sandman -- w00t w00t -- a shapechanger+magical class */
		TERM_L_GREEN, FALSE, 0,
		{ 1, 0, 2, -2, -2, 1},
		{0, 0, 0 + 100, 0, 0, 0},
/*   c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *   x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *   HD, Exp*/
		30, 35, 30, 4, 25, 25, 50, 44,
		8, 10, 10, 0, 10,  5, 20, 25,
		5, 35,//5, 40

		{{ SKILL_COMBAT,
			'+', 1000,
			'+', 1000, },//nerfed from 1300
		{ SKILL_TECHNIQUE,
			'+', 1000,
			'+', 0, },
#if 1 /* druids are martial artists, so no need for these */
		{ SKILL_SLING,
			'+', 0,
			'+', 300, },
		{ SKILL_BOW,
			'+', 0,
			'+', 250, },
		{ SKILL_XBOW,
			'+', 0,
			'+', 250, },
#endif
		{ SKILL_BOOMERANG,
			'+', 0,
			'+', 500, },
		{ SKILL_MARTIAL_ARTS,
			'+', 1000, /* make newbies' lives easier */
			'+', 650, },
			/* Added nullifying of interception here, since some newbie
			   trained it as a human druid (mad waste of points) */
		{ SKILL_INTERCEPT,
			'%', 0,
			'%', 0, },
		{ SKILL_MAGIC,
			'+', 1000,
			'+', 1000, },
		{ SKILL_AIR,
			'+', 0,
			'+', 1000, },//900,
		{ SKILL_EARTH,
			'+', 0,
			'+', 1000, }, //900,
		{ SKILL_WATER,
			'+', 0,
			'+', 1000, }, //900,
		{ SKILL_NATURE,
			'+', 0,
			'+', 1100, }, //900,
		{ SKILL_DRUID_ARCANE,
			'+', 0,
			'+', 1200, }, //1500,
		{ SKILL_DRUID_PHYSICAL,
			'+', 1000,
			'+', 1200, }, //1500,
		{ SKILL_MIMIC,
			'+', 1000,
			'+', 0, },
		{ SKILL_DEVICE,
			'+', 0,
			'+', 1000, },
		{ SKILL_SNEAKINESS,
			'+', 0,
			'+', 600, },//750,
		{ SKILL_DISARM,
			'+', 0,/*1000*/
			'+', 600, },
		{ SKILL_DODGE,
			'+', 0,/*1000*/
			'+', 600, },
		{ SKILL_STEALTH,
			'+', 0,
			'+', 600, },
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 800, },
			/* Health tree */
		{ SKILL_HEALTH,
			'+', 2000,
			'+', 1100, },
		{ SKILL_SWIM,
			'+', 0,
			'%', 120, },
		{ SKILL_DIG,
			'+', 0,
			'+', 1200, },
		}, },

	{ "Shaman", /* by C. Blue -- Minor shapechange (restrictions), Necromancy/Praying/Magic */
		TERM_L_RED, FALSE, 0,
		{ 0, 1, 2, -2, 0, 0},
		{0, 0, 0, 0, 0, 0},
/*   c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *   x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *   HD, Exp*/
		10, 30, 30,  4, 20, 30, 45, 23,
		 0, 10, 10,  0,  3,  5, 20, 12,
		3, 40, //3, 45

		{
#if 0 /* mimicmage/mimicpriest/mimicmagepriest pure caster shaman as actually intended */
		{ SKILL_COMBAT,
			'+', 0,
			'+', 300, },//priests=750,istari=300
		{ SKILL_MAGIC,
			'+', 2000,
			'+', 1000, },
		{ SKILL_CONVEYANCE,
			'+', 1000,
			'+', 1000, },
		{ SKILL_DEVICE,
			'+', 0,
			'+', 1000, },
		{ SKILL_SPELL,
			'+', 0,
			'+', 500, },
 #ifndef ENABLE_OCCULT /* Occult */
		{ SKILL_MANA,
			'+', 1000,
			'+', 700, },//600
 #endif /* else: was +0,+700 */
		{ SKILL_FIRE,
			'+', 0,
			'+', 1000, },
		{ SKILL_AIR,
			'+', 0,
			'+', 1000, },
		{ SKILL_EARTH,
			'+', 0,
			'+', 1000, },
		{ SKILL_WATER,
			'+', 0,
			'+', 1000, },
		{ SKILL_NATURE,
			'+', 0,
			'+', 1000, },
		{ SKILL_DIVINATION,
			'+', 0,
			'+', 1100, },
		{ SKILL_TEMPORAL,
			'+', 0,
			'+', 900, },
		{ SKILL_UDUN,
			'+', 0,
			'+', 800, },
 #if 0
		{ SKILL_META,
			'+', 0,
			'+', 500, },
		{ SKILL_MIND,
			'+', 0,
			'+', 1000, },
 #endif
		{ SKILL_HOFFENSE,
 #ifdef ENABLE_OCCULT /* Occult */
			'+', 0,
 #else
			'+', 1000,
 #endif
			'+', 800, },
		{ SKILL_HDEFENSE,
			'+', 0,
			'+', 900, },
		{ SKILL_HCURING,
			'+', 0,
			'+', 900, },
		{ SKILL_HSUPPORT,
			'+', 0,
			'+', 700, },
 #ifdef ENABLE_OCCULT /* Occult */
		{ SKILL_OSHADOW,
			'+', 0,
			'+', 800, },
		{ SKILL_OSPIRIT,
			'+', 1000,
			'+', 900, },
 #endif
 #if 1 // Non-mana runes, the primal elements of Shaman wizardry. - Kurzel
 		{ SKILL_R_LITE,
			'+', 0,
			'+', 800, }, // Lesser of the ratio of prayer schools.
		{ SKILL_R_DARK,
			'+', 0,
			'+', 800, },
		{ SKILL_R_NEXU,
			'+', 0,
			'+', 700, }, // Worse at temporal, balancing inertia/gravity/time/sound.
		{ SKILL_R_NETH,
			'+', 0,
			'+', 800, },
		{ SKILL_R_CHAO,
			'+', 0,
			'+', 800, },
 #endif
		{ SKILL_MIMIC,
			'+', 1000,
			'+', 800,
				/* only: giant, dragon, animal, ghost, elemental, DR */ },
		{ SKILL_SNEAKINESS,
			'+', 0,
			'+', 400, },
		{ SKILL_STEALTH,
			'+', 1000,
			'+', 600, },
		{ SKILL_NECROMANCY,
			'+', 0,
			'+', 1300, },
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'+', 1300, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'+', 1400, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'+', 1300, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'+', 1200, },
		{ SKILL_HEALTH,
			'+', 1000,
			'+', 1000, },
		{ SKILL_DIG,
			'+', 0,
			'+', 1000, },
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 900, },
#else /* fighting shamans, rivalling priests/paladins/rangers - currently enabled \
	 since offensive spells are lacking, until spell system gets reworked */
		{ SKILL_AXE,
			'+', 0,
			'+', 450, },
		{ SKILL_BLUNT,
			'+', 0,
			'+', 450, },
		{ SKILL_POLEARM,
			'+', 0,
			'+', 450, },
		{ SKILL_MARTIAL_ARTS,
			'+', 0,
			'+', 400, },
		{ SKILL_COMBAT,
			'+', 0,
			'+', 300,},//priests=750,istari=300
		{ SKILL_MASTERY,
			'+', 0,
			'+', 150, },
			/* Magic tree */
		{ SKILL_MAGIC,
			'+', 2000,
			'+', 600, },//500
		{ SKILL_CONVEYANCE,
			'+', 1000,
			'+', 1000, },
		{ SKILL_DEVICE,
			'+', 0,
			'+', 1000, },
		{ SKILL_SPELL,
			'+', 0,
			'+', 500, },
 #ifndef ENABLE_OCCULT /* Occult */
		{ SKILL_MANA,
			'+', 1000,
			'+', 800, },
 #endif /* else: was +0,+800 */
		{ SKILL_FIRE,
			'+', 0,
			'+', 1000, },
		{ SKILL_AIR,
			'+', 0,
			'+', 1000, },
		{ SKILL_EARTH,
			'+', 0,
			'+', 1000, },
		{ SKILL_WATER,
			'+', 0,
			'+', 1000, },
		{ SKILL_NATURE,
			'+', 0,
			'+', 1000, },
		{ SKILL_DIVINATION,
			'+', 0,
			'+', 1100, },
		{ SKILL_TEMPORAL,
			'+', 0,
			'+', 900, },
		{ SKILL_UDUN,
			'+', 0,
			'+', 800, },
 #if 0
		{ SKILL_META,
			'+', 0,
			'+', 500, },
		{ SKILL_MIND,
			'+', 0,
			'+', 1000, },
 #endif
		{ SKILL_HOFFENSE,
 #ifdef ENABLE_OCCULT /* Occult */
			'+', 0,
 #else
			'+', 1000,
 #endif
			'+', 800, },//'+', 1000,
		{ SKILL_HDEFENSE,
			'+', 0,
			'+', 900, },//'+', 1000,
		{ SKILL_HCURING,
			'+', 0,
			//'+', 1100,
			'+', 900, },//'+', 1000,
		{ SKILL_HSUPPORT,
			'+', 0,
			'+', 800, },//'+', 1000,
 #ifdef ENABLE_OCCULT /* Occult */
		{ SKILL_OSHADOW,
			'+', 0,
			'+', 800, },
		{ SKILL_OSPIRIT,
			'+', 1000,
			'+', 900, },
 #endif
 #if 1 // Non-mana runes, the primal elements of Shaman wizardry. - Kurzel
 		{ SKILL_R_LITE,
			'+', 0,
			'+', 800, }, // Lesser of the ratio of prayer schools.
		{ SKILL_R_DARK,
			'+', 0,
			'+', 800, },
		{ SKILL_R_NEXU,
			'+', 0,
			'+', 700, }, // Worse at temporal, balancing inertia/gravity/time/sound.
		{ SKILL_R_NETH,
			'+', 0,
			'+', 800, },
		{ SKILL_R_CHAO,
			'+', 0,
			'+', 800, },
 #endif
		{ SKILL_MIMIC,
			'+', 1000,
			'+', 800,
				/* only: giant, dragon, animal, ghost, elemental, DR */ },
		{ SKILL_SNEAKINESS,
			'+', 0,
			'+', 400, },
		{ SKILL_STEALTH,
			'+', 1000,
			'+', 600, },
		{ SKILL_NECROMANCY,
			'+', 0,
			'+', 1300, },
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'+', 1300, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'+', 1400, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'+', 1300, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'+', 1200, },
		{ SKILL_HEALTH,
			'+', 1000,
			'+', 1000, },
		{ SKILL_DIG,
			'+', 0,
			'+', 1000, },
			/* Misc tree - let's keep it actually! */
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 900, },
		{ SKILL_INTERCEPT,
			'+', 0,
			'+', 500, },
#endif
		}, },

	{ "Runemaster",	/* A mage/rogue class, more caster than fighter, but with high spell damage / low durability.
			 * Intended to be the 'warrior' of the magic classes, but with allowed hybridization.
			 * Initial design by Relsiet, modified by Adam, redesign by Kurzel.
			 */
		TERM_L_BLUE, FALSE, 0,
		{ 0, 2, -2, 2, -2, 0}, //More towards rogue for STR/WIS, but more like an istar for CON. - Kurzel
		{15, 0 + 100, 0, 19 + 100, 0, 0},
/*   c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *   x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *   HD, Exp*/
		30, 32, 20,  3, 30, 26, 45, 40,
		10, 12, 10,  0,  5,  5, 25, 30,
		 4, 40, //4 is the minimum without form/shield? XP penalty similar to shaman. - Kurzel

		{{ SKILL_COMBAT,
			'+', 0,
			'+', 1000, },
		{ SKILL_TECHNIQUE,
			'+', 1000,
			'+', 0, },
			/* "I am able to learn sword, but not weapon mastery in general, nor combat" */
			/* combat is ok, but i guess they aren't disciplined enough for w-mastery ;) */
		{ SKILL_SWORD,
			'+', 0,
			'+', 900, },
		{ SKILL_CRITS,
			'+', 0,
			'+', 600, },
		{ SKILL_AXE,
			'+', 0,
			'+', 800, },
		{ SKILL_BLUNT,
			'+', 0,
			'+', 800, },
		{ SKILL_POLEARM,
			'+', 0,
			'+', 800, },
			/* MA ratio is so low, let's remove it and increase boomerangs, for class variety? */
			/* For flavour, make them boomerang specialists (enchantable), removing ammo-fueled types.  */
			/* This should further distance them from rangers as a class. */
			/*
		{ SKILL_MARTIAL_ARTS,
			'+', 0,
			'+', 200, },
			*/
		{ SKILL_BOOMERANG,
			'+', 0,
			'+', 800, },
			/*
		{ SKILL_SLING,
			'+', 0,
			'+', 700, },
			*/
		{ SKILL_MAGIC,
			'+', 1000,
			'+', 800, },
		/* Re-added devices with all the changes (especially stacking), even archers/warriors can skill it!
		   Ratio as with ranger (between rogue/istar); expecting to see this on mana runies. - Kurzel */
		{ SKILL_DEVICE,
			'+', 1000,
			'+', 1000, },
			/* Sneakiness tree */
		{ SKILL_SNEAKINESS,
			'+', 1000,
			'+', 600, },
		{ SKILL_STEALTH,
			'+', 1000,
			'+', 600, },
			/* Disabling trapping too, runies would use glyphs, and don't want additional inventory clutter. */
			/*
		{ SKILL_TRAPPING,
			'+', 0,
			'+', 900, },
			*/
		{ SKILL_STEALING,
			'+', 0,
			'+', 700, },
		{ SKILL_BACKSTAB,
			'+', 0,
			'+', 700, },
		{ SKILL_DODGE,
			'+', 0,
			'+', 700, },
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 1000, },
		{ SKILL_INTERCEPT,
			'+', 0,
			'+', 800, },
		{ SKILL_R_LITE,
			'+', 0,
			'+', 1000, },
		{ SKILL_R_DARK,
			'+', 0,
			'+', 1000, },
		{ SKILL_R_NEXU,
			'+', 0,
			'+', 1000, },
		{ SKILL_R_NETH,
			'+', 0,
			'+', 1000, },
		{ SKILL_R_CHAO,
			'+', 0,
			'+', 1000, },
		{ SKILL_R_MANA,
			'+', 0,
			'+', 1000, },
		{ SKILL_NECROMANCY,
			'+', 0,
			'+', 1000, },
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'+', 1000, },
		{ SKILL_HEALTH,
			'+', 1000,
			'+', 1000, },
		{ SKILL_SWIM,
			'+', 0,
			'%', 110, },
		{ SKILL_CLIMB,
			'+', 0,
			'%', 120, },
		{ SKILL_DIG,
			'+', 1000,
			'+', 1600, },
		}, },

#ifdef ENABLE_MCRAFT
	{ "Mindcrafter", /* old mindcrafter idea reincarnated in slightly different design - C. Blue:
			  At first made them a 'caster with melee ability', but now changed mind ;) to
			  actually view them as 'fighters with psi abilities' instead, improving vitality. */
		TERM_SLATE, FALSE, 0,
		//{ -1, 3, 0, -1, -1, 1},
		{ 2, 2, 0, 0, 0, 1},
		//{21 + 100, 0 + 100, 0, 19 + 100, 0, 0}, 18/30;10 pretty unreachable with {0,2,0,0,0,1}
		{19 + 100, 0 + 100, 0, 10 + 100, 0, 0},
/*   c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *   x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *   HD, Exp*/
		30, 28, 36,  3, 35, 14, 55, 45,
		 0, 9,  5,  0,  3,  3, 26, 25,
		//5, 25,
		6, 25,

		{{ SKILL_COMBAT, /* Combat tree */
			'+', 1000,
			//'+', 800,
			'+', 1000, },
		{ SKILL_MASTERY,
			'+', 1000,
			//'+', 400,
			//'+', 600,
			'+', 800, },
#ifdef ENABLE_STANCES
		{ SKILL_STANCE,
			'+', 1000,
			'+', 0, },
#endif
		{ SKILL_TECHNIQUE,
			'+', 1000,
			'+', 0, },
		{ SKILL_SWORD,
			'+', 0,
			//'+', 650,
			'+', 750, },
 #if 1 /* savage axes distract their mind..well, or maybe not? */
		{ SKILL_AXE,
			'+', 0,
			//'+', 600,
			'+', 700, },
 #endif
		{ SKILL_BLUNT,
			'+', 0,
			//'+', 650,
			'+', 750, },
		{ SKILL_POLEARM,
			'+', 0,
			//'+', 650,
			'+', 750, },
		{ SKILL_MARTIAL_ARTS,
			'+', 0,
			//'+', 600,
			'+', 700, },
		/*ranged weapon skills shouldnt be better than "Mimic" class. more like "Istar" which has none at all.*/
		{ SKILL_SLING,
			'+', 1000,
			'+', 250, },
		{ SKILL_XBOW,
			'+', 0,
			'+', 300, },
		{ SKILL_BOOMERANG,
			'+', 1000,
			'+', 500, },
		{ SKILL_MAGIC,
			'+', 1000,
			'+', 800, },
		{ SKILL_DEVICE,
			'+', 0,
			'+', 850, },
		{ SKILL_PPOWER,
			'+', 0,
			'+', 1500, },
		{ SKILL_ATTUNEMENT,
			'+', 0,
			'+', 1500, },
		{ SKILL_MINTRUSION,
			'+', 1000,
			'+', 1500, },
		{ SKILL_SNEAKINESS,
			'+', 1000,
			'+', 750, },
		{ SKILL_STEALTH,
			'+', 1000,
			'+', 700, /* high stealth- jedi hand wave? */ },
		{ SKILL_DISARM,
			'+', 0,
			'+', 700, },
		{ SKILL_DODGE,
			'+', 0,
			'+', 600, },
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 1500, },
		{ SKILL_INTERCEPT,
			'+', 0,
			'+', 700, },
 #ifdef EXP_NECRO
		{ SKILL_NECROMANCY,
			'+', 0,
			'+', 700, },
 #endif
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'+', 800, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'+', 1200, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'+', 1000, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'+', 900, },
			/* Health tree */
		{ SKILL_HEALTH,
			'+', 1000,
			'+', 1000, },
		{ SKILL_DIG,
			'+', 0,
			'+', 900, },
		}, },
#endif

#ifdef ENABLE_DEATHKNIGHT
	{ "Death Knight",
		TERM_L_DARK, TRUE, 6,
		{ 3, -3, 1, 0, 2, 2},
		{20 + 100, 0, 0 + 100, 10, 0, 0},
/*   c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *   x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *   HD, Exp*/
		10, 28, 54, 1,  13, 16, 60, 40,
		2, 8,  10, 0,  0,  2,  35, 10,
		8, 30,

		{{  SKILL_COMBAT,
			'+', 2700,
			'+', 1400, },
		{ SKILL_MASTERY,
			'+', 1800,
			'+', 900, },
		{ SKILL_TECHNIQUE,
			'+', 1000,
			'+', 0, },
 #ifdef ENABLE_STANCES
		{ SKILL_STANCE,
			'+', 1000,
			'+', 0, },
 #endif
		{ SKILL_SWORD,
			'+', 0,
			'+', 750, },
 #if 1 /* offer it at all? */
		{ SKILL_AXE,
			'+', 0,
			'+', 600, },//savage^^
 #endif
		{ SKILL_POLEARM,
			'+', 0,
			'+', 700, },
		{ SKILL_BOW,
			'+', 0,
			'+', 300, },
		{ SKILL_XBOW,
			'+', 0,
			'+', 300, },
 #if 0 /* same as paladin */
		{  SKILL_MARTIAL_ARTS, /* let's keep it low for now - offbalancing */
			'+', 0,
			'+', 500, },
 #endif
		{ SKILL_MAGIC,
			'+', 1000,
			'+', 600, },
 #ifdef ENABLE_OCCULT /* Occult */
		{ SKILL_OSHADOW,
  #ifndef ENABLE_OUNLIFE
			'+', 1000,
  #else
			'+', 1000, // <- actually start with 1.000 here too, since 'Cause Fear I' is level 1, while 'Fatigue I' is level 5 -_-
  #endif
			'+', 700, },
 #endif
 #ifdef ENABLE_OUNLIFE
		{ SKILL_OUNLIFE,
			'+', 0, // <- should have 1.000, but it's too much to start with that in two schools at once. Shadow is picked instead for now because of Cause Fear I.
			'+', 700, },
 #endif
 #if 0
		{ SKILL_SPELL,
			'+', 0,
			'+', 350, },
 #endif
		{ SKILL_NECROMANCY,
			'+', 0,
			'+', 1500, },
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'+', 1500, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'+', 1500, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'+', 1500, },
		{ SKILL_AURA_DEATH,
			'+', 0,
			'+', 1500, },
		{ SKILL_DEVICE,
			'+', 1500,
			'+', 800, },
		{ SKILL_SNEAKINESS,
			'+', 1000,
			'+', 500, }, //650,
		{ SKILL_DISARM,
			'+', 1000,
			'+', 600, },
		{ SKILL_DODGE,
			'+', 0,/*1000*/
			'+', 600, },
		{ SKILL_STEALTH,
			'+', 0,
			'+', 500, },
		{ SKILL_HEALTH,
			'+', 2000,
			'+', 1000, },
		{ SKILL_DIG,
			'+', 0,
			'+', 700, },
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 600, },
		{ SKILL_INTERCEPT,
			'+', 1000,
			'+', 800, },
		}, },
#endif
#ifdef ENABLE_HELLKNIGHT
	{ "Hell Knight",
		TERM_L_DARK, TRUE, 6,
		{ 3, -3, 1, 0, 2, 2},
		{20 + 100, 0, 0 + 100, 10, 0, 0},
/*   c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *   x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *   HD, Exp*/
		10, 25, 54, 1,  13, 16, 60, 40,
		2, 8,  10, 0,  0,  2,  35, 10,
		8, 30,

		// --- Lots of skills that differ from Paladin template are HARDCODED in shape_Maia_skills()! :( ---
		// This skill chart is basically just for reference, it has no actual effect in-game. All skills are derived from "Paladin" and then possibly modified in a hard-coded way on initiation.
		{{  SKILL_COMBAT,
			'+', 2700,
			'+', 1400, },
		{ SKILL_MASTERY,
			'+', 1800,
			'+', 900, },
		{ SKILL_TECHNIQUE,
			'+', 1000,
			'+', 0, },
#ifdef ENABLE_STANCES
		{ SKILL_STANCE,
			'+', 1000,
			'+', 0, },
#endif
#ifdef DUAL_WIELD /* experimental - khorne berzerkers ^^ */
		{ /* dual-wield */ SKILL_DUAL,
			'+', 1000,
			'+', 0, },
#endif
		{ SKILL_SWORD,
			'+', 0,
			'+', 750, }, //will get x1.1'd (replacement for MA x1.3 bonus we're missing out on)
#if 1 /* re-allow */
		{ SKILL_BLUNT,
			'+', 0,
			'+', 660, }, //swapped with former axe ratio, x1.1 (replacement for MA x1.3 bonus we're missing out on)
#endif
		{ SKILL_AXE,
			'+', 0,
			'+', 750, }, //swapped with former blunt ratio, will get x1.3'ed to 975
		{ SKILL_POLEARM,
			'+', 0,
			'+', 750, }, //falls through
		{ SKILL_BOW,
			'+', 0,
			'+', 300, },
		{ SKILL_XBOW,
			'+', 0,
			'+', 300, },
#if 0 /* same as paladin */
		{  SKILL_MARTIAL_ARTS, /* let's keep it low for now - offbalancing */
			'+', 0,
			'+', 500, },
#endif
		{ SKILL_MAGIC,
			'+', 1000,
			'+', 600, },
#ifdef ENABLE_OCCULT /* Occult */
 #ifdef ENABLE_OHERETICISM
		{ SKILL_OHERETICISM,
			'+', 1000,
			'+', 700, },
 #else
		{ SKILL_OSHADOW, /* emergency replacement skill if Hereticism isn't available for some reason */
			'+', 1000,
			'+', 700, },
 #endif
#endif
#if 1 /* EXPERIMENTAL: Allow Udun access for HK/CP? */
		{ SKILL_UDUN,
			'+', 0,
			//'+', 441, }, //pseudo '600' (this skill doesn't receive the initial Maia x0.7 modifier, hence..)
			'+', 368, }, //pseudo '500' (this skill doesn't receive the initial Maia x0.7 modifier, hence..)
#endif
#if 0
		{ SKILL_SPELL,
			'+', 0,
			'+', 350, },
#endif
#if 1
		{ SKILL_NECROMANCY,
			'+', 0,
			'+', 1300, },
#endif
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'+', 1500, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'+', 1400, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'+', 1400, },
#if 1
		{ SKILL_AURA_DEATH,
			'+', 0,
			'+', 1300, },
#endif
		{ SKILL_DEVICE,
			'+', 1000,
			'+', 800, },
		{ SKILL_SNEAKINESS,
			'+', 1000,
			'+', 500, }, //650,
		{ SKILL_DISARM,
			'+', 1000,
			'+', 600, },
		{ SKILL_DODGE,
			'+', 0,/*1000*/
			'+', 600, },
		{ SKILL_STEALTH,
			'+', 0,
			'+', 500, },
		{ SKILL_HEALTH,
			'+', 2000,
			'+', 1000, },
		{ SKILL_DIG,
			'+', 0,
			'+', 700, },
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 600, },
		{ SKILL_INTERCEPT,
			'+', 1000,
			'+', 800, },
		}, },
#endif
#ifdef ENABLE_CPRIEST
	{ "Priest", /* Corrupted Priest (Maia) */
		TERM_GREEN, TRUE, 2,
		{-1, -3, 3, -1, 0, 2},
#if 0 /* disabled recommendations for STR/DEX because STR cannot even be reached by dwarven priests.. */
		{19, 0, 0 + 100, 10, 0, 0},
#else
		{0, 0, 0 + 100, 0, 0, 0},
#endif
		25, 25, 32, 2,  16, 8, 48, 35,
		7,   9, 12, 0,  0,  0, 20, 15,
		5, 20, //2, 20,//4,20
		//7, 20,

		// This skill chart is basically just for reference, it has no actual effect in-game. All skills are derived from normal "Priest" and then possibly modified in a hard-coded way on initiation.
		{{ SKILL_COMBAT,
			'+', 0,
			'+', 750,}, //x1.5
		{ SKILL_MASTERY,
			'+', 0,
			'+', 400, },//800
		{ SKILL_SWORD, //additionally to blunt! (or instead of it, under 1st CPRIEST version, before blunt was re-allowed), gets x1.3 to 650
			'+', 0,
			'+', 500, },
#if 1 /* re-allow */
		{ SKILL_BLUNT,
			'+', 0,
			'+', 600, },
#endif
		{ SKILL_MARTIAL_ARTS,
			'+', 0,
//			'+', 650, }, //450
			'+', 500, }, //450 --normal priests have 500. gets boosted by Corrupted trait x1.3 -> 0.65
		{ SKILL_MAGIC,
			'+', 2000,
			'+', 900, },
#if 0
		{ SKILL_SPELL,
			'+', 0,
			'+', 500, },
#endif
		/*{ SKILL_DIVINATION,
			'+', 1000,
			'+', 500, },
		{ SKILL_CONVEYANCE,
			'+', 0,
			'+', 900,
			},,*/
#ifdef ENABLE_OCCULT
 #ifdef ENABLE_OHERETICISM
		{ SKILL_OSHADOW,
			'+', 0,
			'+', 800, },
		{ SKILL_OHERETICISM,
			'+', 1000,
			'+', 1050, },
 #else
		{ SKILL_OSHADOW,
			'+', 1000,
			'+', 800, },
 #endif
#endif
#if 1 /* EXPERIMENTAL: Allow Udun access for HK/CP? */
		{ SKILL_UDUN,
			'+', 0,
			'+', 515, }, //pseudo '700' (this skill doesn't receive the initial Maia x0.7 modifier, hence..)
#endif
		{ SKILL_DEVICE,
			'+', 1000,
			'+', 900, },
		{ SKILL_SNEAKINESS,
			'+', 1000,
			'+', 600, },//770,
		{ SKILL_STEALTH,
			'+', 0,
			'+', 500, },
		{ SKILL_DODGE,
			'+', 0,
			'+', 550, },
			/* Health tree */
		{ SKILL_HEALTH,
			'+', 1000,
			'+', 1000, },
		{ SKILL_DIG,
			'+', 0,
			'+', 700, },
		{ SKILL_CALMNESS,
			'+', 0,
			'+', 900, },
		{ SKILL_INTERCEPT,
			'+', 1000,
			'+', 600, }, //400
#if 1
		{ SKILL_NECROMANCY,
			'+', 0,
			'+', 1400, },
#endif
		{ SKILL_TRAUMATURGY,
			'+', 0,
			'+', 1400, },
		{ SKILL_AURA_FEAR,
			'+', 0,
			'+', 1500, },
		{ SKILL_AURA_SHIVER,
			'+', 0,
			'+', 1300, },
#if 1
		{ SKILL_AURA_DEATH,
			'+', 0,
			'+', 1300, },
#endif
		}, },
#endif
};


/* Racial traits, introduced for Draconians - C. Blue */
player_trait trait_info[MAX_TRAIT] = {
	{ /* Note: This trait #0 must be allowed for EXACTLY the races that DON'T have any trait.
	     This can be used to 'disable' all traits for a specific race: Just add it here. */
		"N/A",
#ifdef ENABLE_DRACONIAN_TRAITS
		0xFFFFFF & ~RFC,
#else
		0xFFFFFF, /* disable for all */
#endif
	},{	"Blue lineage",	RFC,//ELEC			res->imm	+brand+aura
	},{	"White lineage", RFC,//COLD			res->imm	+aura
	},{	"Red lineage", RFC,//FIRE			res->imm
	},{	"Black lineage", RFC,//ACID			res->imm
	},{	"Green lineage", RFC,//POIS			res->imm
	},{	"Multi-hued lineage", RFC,//base(+pois?)	base/pois
	},{	"Bronze lineage", RFC,//conf+fa(+fire?)+refl	conf/fa/refl
	},{	"Silver lineage", RFC,//cold+fa,refl (pois)	cold/pois/refl
	},{	"Golden lineage", RFC,//sound+acid,refl(+fear?)	acid/sound/refl
	},{	"Law lineage", RFC,//shards+sound		shards/sound
	},{	"Chaos lineage", RFC,//chaos			chaos/disen
	},{	"Balance lineage", RFC,//disen			disen/sound
#if 0
	},{	"Power lineage", RFC,//mana/res_tele?NOPE/rare!	reflect/blind/fear
#else
	},{	"", 0,
#endif
	},{	"Enlightened", 0, /* note: directly assigned live; must be N/A on char creation time */
	},{	"Corrupted", 0, /* note: directly assigned live; must be N/A on char creation time */
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},{	"", 0,
	},
};


/*
 * Player Classes.
 *
 *   Title,
 *   color,
 *   {STR,INT,WIS,DEX,CON,CHR},
 *   {STR,INT,WIS,DEX,CON,CHR} recommended minimum values,
 *   c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *   x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *   HD, Exp
 */

/*
 * Note that this is the same for all classes (for now).
 *
 * Such a hack....
 */
magic_type ghost_spells[64] = {
	{  1,   1, 0, 0, 0},
	{ 10,   2, 0, 0, 0},
	{ 15,   3, 0, 0, 0},
	{ 20,   5, 0, 0, 0},
	{ 25,  10, 0, 0, 1},
	{ 35,  60, 0, 0, 2},
	{ 45, 100, 0, 0, 2},

	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0},
	{ 99,   0, 0, 0, 0}
};


/*
 * Class titles for the player.
 *
 * The player gets a new title every five levels, so each class
 * needs only ten titles total.
 *
 * New: Fields x,2 and x,3 are for short titles sent to the client
 *      which must be 12 characters max in length  - C. Blue
 */
cptr player_title[MAX_CLASS][11][4] = {
	/* Warrior */
	{
		{"Rookie", "Rookie", "Rookie", "Rookie", },
		{"Mercenary", "Mercenary", "Mercenary", "Mercenary", },
		{"Soldier", "Soldier", "Soldier", "Soldier", },
		{"Veteran", "Veteran", "Veteran", "Veteran", },
		{"Captain", "Captain", "Captain", "Captain", },
		{"Champion", "Champion", "Champion", "Champion", },
		{"Hero", "Heroine", "Hero", "Heroine", },//heh they are back :)
		{"General", "General", "General", "General", },
		{"Baron", "Baroness", "Baron", "Baroness", },
		{"Duke", "Duchess", "Duke", "Duchess", },
		{"Lord", "Lady", "Lord", "Lady", },
	},

	/* Istar */
	{
		{"Novice", "Novice", "Novice", "Novice", },
		{"Apprentice", "Apprentice", "Apprentice", "Apprentice", },
		{"Trickster", "Trickster", "Trickster", "Trickster", },
		{"Illusionist", "Illusionist", "Illusionist", "Illusionist", },
		{"Spellbinder", "Spellbinder", "Spellbinder", "Spellbinder", },//Arcanist
		{"Spellweaver", "Spellweaver", "Spellweaver", "Spellweaver", },
		{"Evoker", "Evoker", "Evoker", "Evoker", },
		{"Conjurer", "Conjurer", "Conjurer", "Conjurer", },
		{"Sorcerer", "Sorceress", "Sorcerer", "Sorceress", },
		{"Warlock", "Warlock", "Warlock", "Warlock", },
		//{"Mage", "Mage", "Mage", "Mage", },
		{"Archmage", "Archmage", "Archmage", "Archmage", },
	},

	/* Priest */
	{
		//{"Believer", "Believer", "Believer", "Believer", },
		{"Acolyte", "Acolyte", "Acolyte", "Acolyte", },
		{"Adept", "Adept", "Adept", "Adept", },
		{"Curate", "Curate", "Curate", "Curate", },
		{"Canon", "Canon", "Canon", "Canon", },
		{"Priest", "Priestess", "Priest", "Priestess", },
		{"Exorcist", "Exorcist", "Exorcist", "Exorcist", },
		{"Bishop", "Bishop", "Bishop", "Bishop", },
		{"Arch-Bishop", "Arch-Bishop", "Arch-Bishop", "Arch-Bishop", },
		{"Cardinal", "Cardinal", "Cardinal", "Cardinal", },
		{"High Priest", "High Priestess", "High Priest", "H.Priestess", },
		{"Patriarch", "Matriarch", "Patriarch", "Matriarch", },
	},

	/* Rogues */
	{
		{"Vagabond", "Vagabond", "Vagabond", "Vagabond", },
		{"Cutpurse", "Cutpurse", "Cutpurse", "Cutpurse", },
		{"Robber", "Robber", "Robber", "Robber", },
		{"Burglar", "Burglar", "Burglar", "Burglar", },
		{"Filcher", "Filcher", "Filcher", "Filcher", },
		{"Sharper", "Sharper", "Sharper", "Sharper", },
		{"Thief", "Thief", "Thief", "Thief", },
		{"Master Thief", "Master Thief", "Master Thief", "Master Thief", },
		{"Infiltrator", "Infiltrator", "Infiltrator", "Infiltrator", },
		{"Grandmaster Thief", "Grandmaster Thief", "GM-Thief", "GM-Thief", },
		{"Assassin", "Assassin", "Assassin", "Assassin", },
	},

	/* Mimic */
	{
		{"Pretender", "Pretender", "Pretender", "Pretender", },
		{"Modifier", "Modifier", "Modifier", "Modifier", },
		{"Elastic", "Elastic", "Elastic", "Elastic", },
		{"Copier", "Copier", "Copier", "Copier", },
		{"Multiple (1st)", "Multiple (1st)", "Multiple I", "Multiple I", },
		{"Multiple (2nd)", "Multiple (2nd)", "Multiple II", "Multiple II", },
		{"Metamorph", "Metamorph", "Metamorph", "Metamorph", },
		{"Many-Faced", "Many-Faced", "Many-Faced", "Many-Faced", },
		{"Changer", "Changer", "Changer", "Changer", },
		{"Master Changer", "Master Changer", "M-Changer", "M-Changer", },
		{"Grandmaster Changer", "Grandmaster Changer", "GM-Changer", "GM-Changer", },
	},

	/* Archer */
	{
		{"Rock Thrower", "Rock Thrower", "Rock Thrower", "Rock Thrower", },
		{"Slinger", "Slinger", "Slinger", "Slinger", },
		{"Great Slinger", "Great Slinger", "Gr.Slinger", "Gr.Slinger", },
		{"Bowman", "Bowmaiden", "Bowman", "Bowmaiden", },
		{"Marksman", "Marksman", "Marksman", "Marksman", },
		{"Archer", "Archer", "Archer", "Archer", },
		{"Sharpshooter", "Sharpshooter", "Sharpshooter", "Sharpshooter", },
		{"Veteran Archer", "Veteran Archer", "Vet. Archer", "Vet. Archer", },
		{"Master Archer", "Master Archer", "M-Archer", "M-Archer", },
		{"Grandmaster Archer", "Grandmaster Archer", "GM-Archer", "GM-Archer", },
		{"Deadeye", "Deadeye", "Deadeye", "Deadeye", },
	},

	/* Paladin */
	{
		{"Page", "Page", "Page", "Page", },
		{"Squire", "Squire", "Squire", "Squire", },
		{"Faithful", "Faithful", "Faithful", "Faithful", },
		{"Zealot", "Zealot", "Zealot", "Zealot", },
		{"Chaplain", "Chaplain", "Chaplain", "Chaplain", },
		{"Defender", "Defender", "Defender", "Defender", },
		{"Crusader", "Crusader", "Crusader", "Crusader", },
		//Knight Seargent
		{"Knight", "Knight", "Knight", "Knight", },
		{"Banneret", "Banneret", "Banneret", "Banneret", },//Knight Banneret
		//{"Venerable Knight", "Venerable Knight", "V.Knight", "V.Knight", },
		{"Paladin", "Paladin", "Paladin", "Paladin", },
		{"Knight Commander", "Knight Commander", "Knight Cmdr.", "Knight Cmdr.", },
	},

	/* Ranger */
	{
		{"Path Finder", "Path Finder", "Path Finder", "Path Finder", },
		{"Scout", "Scout", "Scout", "Scout", },
		{"Guard", "Guard", "Guard", "Guard", },
		{"Sentry", "Sentry", "Sentry", "Sentry", },
		{"Ranger", "Ranger", "Ranger", "Ranger", },
		{"Deputy", "Deputy", "Deputy", "Deputy", },
		{"Sheriff", "Sheriff", "Sheriff", "Sheriff", },
		{"Marshall", "Marshall", "Marshall", "Marshall", },
		{"Supervisor", "Supervisor", "Supervisor", "Supervisor", },
		{"High Ranger", "High Ranger", "High Ranger", "High Ranger", },
		//{"Ranger Champion", "Ranger Champion", },
		{"Ranger Chieftain", "Ranger Chieftain", "Ranger Chief", "Ranger Chief", }, /* to check: Isn't it Chief Ranger rather? */
	},

	/* Adventurer */
	{
		{"Rambler", "Rambler", "Rambler", "Rambler", },
		{"Walker", "Walker", "Walker", "Walker", },
		{"Tripper", "Tripper", "Tripper", "Tripper", },
		{"Tourist", "Tourist", "Tourist", "Tourist", },
		{"Strider", "Strider", "Strider", "Strider", },
		{"Traveller", "Traveller", "Traveller", "Traveller", },
		{"Discoverer", "Discoverer", "Discoverer", "Discoverer", },
		{"Spelunker", "Spelunker", "Spelunker", "Spelunker"},
		{"Voyager", "Voyager", "Voyager", "Voyager", },
		{"Navigator", "Navigator", "Navigator", "Navigator", },
		{"Explorer", "Explorer", "Explorer", "Explorer", },
		//Adventurer", "Adventurer", "Adventurer", "Adventurer", },
	},

	/* Druid */
	{
		{"Green", "Green", "Green", "Green", },
		{"Tree Hugger", "Tree Hugger", "Tree Hugger", "Tree Hugger", },
		{"Flower Boy", "Flower Girl", "Flower Boy", "Flower Girl", },
		{"Herbalist", "Herbalist", "Herbalist", "Herbalist", },
		{"Spiritualist", "Spiritualist", "Spiritualist", "Spiritualist", },
		{"Elder", "Elder", "Elder", "Elder", },
		{"Druid", "Druid", "Druid", "Druid", },
		{"High Druid", "High Druid", "High Druid", "High Druid", },
		{"Master Druid", "Master Druid", "Master Druid", "Master Druid", },
		{"Wildlife Preserver", "Wildlife Preserver", "Wl.Preserver", "Wl.Preserver", },
		{"Arch-Druid", "Arch-Druid", "Arch-Druid", "Arch-Druid", }, //was Arch Druid
	},

	/* Shaman */
	{
		{"Smoker", "Smoker", "Smoker", "Smoker", },
		{"Novice Walker", "Novice Walker", "Nov. Walker", "Nov. Walker", },
		{"Walker", "Walker", "Walker", "Walker", },
		{"Spiritwalker", "Spiritwalker", "Spiritwalker", "Spiritwalker", },
		{"Bonecaster", "Bonecaster", "Bonecaster", "Bonecaster", },
		{"Bonefletcher", "Bonefletcher", "Bonefletchr", "Bonefletchr", },
		{"Cursed", "Cursed", "Cursed", "Cursed", },
		{"Chanter", "Chantress", "Chanter", "Chantress", },
		{"Elder Chanter", "Elder Chantress", "Eld.Chanter", "El.Chantress", },
		//{"Spiritwatcher", "Spiritwatcher", },
		{"Shaman", "Shaman", "Shaman", "Shaman", },
		{"Elder Shaman", "Elder Shaman", "Elder Shaman", "Elder Shaman", },
	},

	/* Runemaster */
	{
		{"Digger", "Digger", "Digger", "Digger", },
		{"Rune Tracer", "Rune Tracer", "Rune Tracer", "Rune Tracer", },
		{"Rock Collector", "Rock Collector", "R.Collector", "R.Collector", },
		//{"Rock Painter", "Rock Painter", "Rock Painter", "Rock Painter", },
		{"Fire Starter", "Fire Starter", "Fire Starter", "Fire Starter", },
		{"Treasure Hunter", "Treasure Hunter", "Tr.Hunter", "Tr.Hunter", },
		//{"Archaeologist", "Archaeologist", "Professor", "Professor", }, //too cool for 12 letters? ^^
		{"Archaeologist", "Archaeologist", "Archaelgst.", "Archaelgst.", },
		{"Earth Guard", "Earth Guard", "Earth Guard", "Earth Guard", },
		{"Rune Knight", "Rune Knight", "Rune Knight", "Rune Knight", },
		{"Rune Keeper", "Rune Keeper", "Rune Keeper", "Rune Keeper", },
		{"Runemaster", "Runemistress", "Runemaster", "Runemistress", },
		{"Grand Runemaster", "Grand Runemistress", "GrRunemaster", "GrRunemstrss", },
	},

	/* Mindcrafter */
	{
		//{"Simple-minded", "Simple-minded", "Simple-mind", "Simple-mind", },
		//{"Reflector", "Reflectress", "Reflector", "Reflectress", },
		//{"Paranoid", "Paranoid", "Paranoid", "Paranoid", },
		//{"Aware", "Aware", "Aware", "Aware", },
		{"Wary", "Wary", "Wary", "Wary", },
		{"Fathomer", "Fathomer", "Fathomer", "Fathomer", },
		{"Thinker", "Thinker", "Thinker", "Thinker", },
		{"Biaser", "Biaser", "Biaser", "Biaser", },
		{"Convincer", "Convincer", "Convincer", "Convincer", },
		{"Warper", "Warper", "Warper", "Warper", },
		{"Psychic", "Psychic", "Psychic", "Psychic", },
		{"Telepath", "Telepath", "Telepath", "Telepath", },
		{"Manipulator", "Manipulator", "Manipulator", "Manipulator", },
		{"Controller", "Controller", "Controller", "Controller", },
		{"Master Mindcrafter", "Master Mindcrafter", "Master Mdcr.", "Master Mdcr.", },
	},

#ifdef ENABLE_DEATHKNIGHT
	/* Death Knight (Vampire Paladin) */
	{
		{"Faithless", "Faithless", "Faithless", "Faithless", }, //neutral
		{"Forfeit", "Forfeit", "Forfeit", "Forfeit", }, //maybe hellish
		{"Unresting", "Unresting", "Unresting", "Unresting", },
		{"Hungering", "Hungering", "Hungering", "Hungering", },
		{"Tainted", "Tainted", "Tainted", "Tainted", }, //maybe hellish
		{"Unhallowed", "Unhallowed", "Unhallowed", "Unhallowed", },
		{"Dark Adept", "Dark Adept", "Dark Adept", "Dark Adept", },
		{"Crypt Keeper", "Crypt Keeper", "Crypt Keeper", "Crypt Keeper", },
		{"Fallen Champion", "Fallen Champion", "Fal.Champion", "Fal.Champion", },
		{"Antipaladin", "Antipaladin", "Antipaladin", "Antipaladin", },
		{"Death Knight", "Death Knight", "Death Knight", "Death Knight", },
	},
#endif
#ifdef ENABLE_HELLKNIGHT
	/* Hell Knight (Corrupted Paladin) */
	{
		{"Faithless", "Faithless", "Faithless", "Faithless", },
		{"Traitor", "Traitor", "Traitor", "Traitor", },
		{"Fanatic", "Fanatic", "Fanatic", "Fanatic", },
		{"Cultist", "Cultist", "Cultist", "Cultist", },
	//note that the first four titles will never be used since 'Hell Knight' career starts at level 20 on initiation
 #if 0
		{"Tainted", "Tainted", "Tainted", "Tainted", },
		{"Heretic", "Heretic", "Heretic", "Heretic", },
		//Apostate
		{"Dark Adept", "Dark Adept", "Dark Adept", "Dark Adept", },
		//{"Sacrificer", "Sacrificer", "Sacricifer", "Sacrificer", },
		{"Chosen", "Chosen", "Chosen", "Chosen", },
		//{"Corruptor", "Corruptor", "Corruptor", "Corruptor", },
		{"Unholy Zealot", "Unholy Zealot", "Unh.Zealot", "Unh.Zealot", },
		{"Antipaladin", "Antipaladin", "Antipaladin", "Antipaladin", },
		{"Hell Knight", "Hell Knight", "Hell Knight", "Hell Knight", },
 #else /* re-use up to the first four titles */
		{"Traitor", "Traitor", "Traitor", "Traitor", },
		{"Fanatic", "Fanatic", "Fanatic", "Fanatic", },
		{"Cultist", "Cultist", "Cultist", "Cultist", },
		{"Heretic", "Heretic", "Heretic", "Heretic", },
		{"Chosen", "Chosen", "Chosen", "Chosen", },
		{"Unholy Zealot", "Unholy Zealot", "Unh.Zealot", "Unh.Zealot", },
		{"Hell Knight", "Hell Knight", "Hell Knight", "Hell Knight", },
 #endif
	},
#endif
#ifdef ENABLE_CPRIEST
	/* Corrupted Priest */
	{
		//{"Sinner", "Sinner", "Sinner", "Sinner", },
		{"Acolyte", "Acolyte", "Acolyte", "Acolyte", },
		{"Adept", "Adept", "Adept", "Adept", },
		{"Curate", "Curate", "Curate", "Curate", },
		{"Canon", "Canon", "Canon", "Canon", },
		//{"Fiend", "Fiend", "Fiend", "Fiend", },
		{"Priest", "Priestess", "Priest", "Priestess", },
		//{"Heretic", "Heretic", "Heretic", "Heretic", },
		{"Execrator", "Execrator", "Execrator", "Execrator", },
		{"Bishop", "Bishop", "Bishop", "Bishop", },
		{"Arch-Bishop", "Arch-Bishop", "Arch-Bishop", "Arch-Bishop", },
		{"Cardinal", "Cardinal", "Cardinal", "Cardinal", },
		{"High Priest", "High Priestess", "High Priest", "H.Priestess", },
		{"Patriarch", "Matriarch", "Patriarch", "Matriarch", },
	},
#endif
};

/*
 * Special Class titles for the player who is way > 50. (C. Blue)
 * 60 (usually no change I'd say =) wait, or maybe), 70, 80, 90, 99
 * It was time to add female titles too!
 */
cptr player_title_special[MAX_CLASS][5][4] = {
	/* Warrior */
	{
#if 1
		{"Highlord", "Highlord", "Highlord", "Highlord", },
		{"Overlord", "Overlord", "Overlord", "Overlord", },
		//{"Hero", "Hero", }, hero is back in the normal warrior ranks!
		{"Destroyer", "Destroyer", "Destroyer", "Destroyer", },
		{"Annihilator", "Annihilator", "Annihilator", "Annihilator", },
		{"Titan", "Titan", "Titan", "Titan", },
#else
		{"Admiral", "Admiral", },
		{"Bombardier", "Bombardier", },
		{"Chief Marshal", "Chief Marshal", },
		{"Field Strategist", "Field Strategist", },
		{"Chief Admiral", "Chief Admiral", },//Fleet Admiral is probably the correct term
#endif
	},

	/* Istar */
	{
		{"Savant", "Savant", "Savant", "Savant", },
		{"Grand Wizard", "Grand Wizard", "Gr.Wizard", "Gr.Wizard", },
		{"Dragon Lord", "Dragon Lady", "Dragon Lord", "Dragon Lady", },//Earthsea
		//{"Plane Master", "Plane Master", "Plane Master", "Plane Master", },//I like planes
		{"Dimensionalist", "Dimensionalist", "Dimension.", "Dimension.", },
		{"Omniscient", "Omniscient", "Omniscient", "Omniscient", },
	},

	/* Priest */
	{
		{"Protonotary", "Protonotary", "Protonotary", "Protonotary", },
		{"Saint", "Saint", "Saint", "Saint", },
		{"Ascended", "Ascended", "Ascended", "Ascended", },
		{"Demi", "Demi", "Demi", "Demi", }, //Pope? :)
		{"Divine", "Divine", "Divine", "Divine", },
		//^^{"Holy Diver", "Holy Diver", "Holy Diver", "Holy Diver", }, //w00t!
	},

	/* Rogues */
	{
		//{"Grand Assassin", "Grand Assassin", },
		//{"Master Assassin", "Master Assassin", },
		//commented out: first master, then hand = wrong order ^^	{"Death's Master", "Death's Mistress", "Dth.Master", "Dth.Mistress", },
		{"Phantom", "Phantom", "Phantom", "Phantom" },
		//{"Legendary Assassin", "Legendary Assassin", "Lgd.Assassin", "Lgd.Assassin", },
		{"Myth", "Myth", "Myth", "Myth", },
		{"Nightmare", "Nightmare", "Nightmare", "Nightmare", },
		{"Terror", "Terror", "Terror", "Terror" },
		//{"Mythical Assassin", "Mythical Assassin", "Myt.Assassin", "Myt.Assassin", },
		//{"Death Fate", "Death Fate", "Death Fate", "Death Fate", },
		{"Death's Hand", "Death's Hand", "Death's Hand", "Death's Hand", },
		/* it's fitting, but let's not make the game too JOKEANGBANDish anyway^^ */
		//{"RNG", "RNG", }, //LOL! Perfect, do you not think so? :) -adam
	},

	/* Mimic */
	{
		{"Faker", "Faker", "Faker", "Faker", },
		{"Doppelganger", "Doppelganger", "Doppelganger", "Doppelganger", },
		{"Transformer", "Transformer", "Transformer", "Transformer", },
		{"Replicator", "Replicator", "Replicator", "Replicator", },
		{"Limitless", "Limitless", "Limitless", "Limitless", },
	},

	/* Archer */
	{
		{"Elite Archer", "Elite Archer", "Elite Archer", "Elite Archer", },
		{"Grand Elite Archer", "Grand Elite Archer", "GE-Archer", "GE-Archer", },
		{"Legendary Archer", "Legendary Archer", "Legd.Archer", "Legd.Archer", },
		{"Sirring Death", "Sirring Death", "Sirrg.Death", "Sirrg.Death", },
		{"Golden Eye", "Golden Eye", "Golden Eye", "Golden Eye", },
	},

	/* Paladin */
	{
		{"Sacred Defender", "Sacred Defender", "S.Defender", "S.Defender", },
		{"Venerable Templar", "Venerable Templar", "V.Templar", "V.Templar", },
		//{"Avenger", "Avenger", "Avenger", "Avenger", },
		{"Holy Avenger", "Holy Avenger", "Holy Avenger", "Holy Avenger", },
		//{"Holy Defender", "Holy Defender", }, defender comes before avenger if at all;
		//DF and HA are old 'good' ego mods from predecessors.
		{"Holy King", "Holy Queen", "Holy King", "Holy Queen", },
		{"God's Hand", "God's Hand", "God's Hand", "God's Hand", },
	},

	/* Ranger */
	{
		{"Elite Ranger", "Elite Ranger", "Elite Ranger", "Elite Ranger", },
		//{"Ranger Supervisor", "Ranger Supervisor", "Ranger Svis.", "Ranger Svis.", },
		{"Champion of Law", "Champion of Law", "Champ of Law", "Champ of Law", },
		{"Lord of Law", "Lady of Law", "Lord of Law", "Lady of Law", },
		//{"Ranger Commander", "Ranger Commander", "Ranger Cmdr.", "Ranger Cmdr.", },
		{"Legend", "Legend", "Legend", "Legend", },
		{"Justice", "Justice", "Justice", "Justice", },
	},

	/* Adventurer */
	{
		{"Seasoned Adventurer", "Seasoned Adventurer", "Seasoned Adv", "Seasoned Adv", },
		{"Famous Adventurer", "Famous Adventurer", "Famous Adv.", "Famous Adv.", },
		{"Grand Adventurer", "Grand Adventurer", "Grand Advntr", "Grand Advntr", },
		{"Legendary Adventurer", "Legendary Adventurer", "Legend. Adv.", "Legend. Adv.", },
		{"Mythical Adventurer", "Mythical Adventurer", "Mythic Adv.", "Mythic Adv.", },
	},

	/* Druid */
	{
		{"Forest Guardian", "Forest Guardian", "Forest Guard", "Forest Guard", },
		{"Wind Evoker", "Wind Evoker", "Wind Evoker", "Wind Evoker", },
		{"Forest Keeper", "Forest Keeper", "Forest Kpr.", "Forest Kpr.", },
		{"Autumn", "Autumn", "Autumn", "Autumn", },
		{"Evergreen", "Evergreen", "Evergreen", "Evergreen", },
	},

	/* Shaman */
	{
		{"Spirit Keeper", "Spirit Keeper", "Sprt.Keeper", "Sprt.Keeper", },
		{"Spirit Master", "Spirit Mistress", "Sprt.Master", "Spt.Mistress", },
		{"Grand Sage", "Grand Sage", "Grand Sage", "Grand Sage", },
		{"Realm Keeper", "Realm Keeper", "Realm Keeper", "Realm Keeper", },
		//{"Transient", "Transient", "Transient", "Transient", },
		{"Presence", "Presence", "Presence", "Presence", },
	},

	/* Runemaster */
	{
		{"Runescribe", "Runescribe", "Runescribe", "Runescribe", },
		//{"Grand Runemaster", "Grand Runemistress", "G.Runemaster", "G.Runemstrss", },
		{"Elemental Master", "Elemental Mistress", "Elemental-M", "Elemental-M", },
		{"Force Master", "Force Mistress", "Force Master", "Force Mstrss", },
		//{"Elemental Overlord", "Elemental Overlady", "E-Overlord", "E-Overlady", },
		{"Grand Channelist", "Grand Channelist", "G-Channelist", "G-Channelist", },
		{"Vortex", "Vortex", "Vortex", "Vortex", },
	},

	/* Mindcrafter */
	{
		{"Master Manipulator", "Master Manipulator", "M.Manipultr.", "M.Manipultr.", },
		{"Master Controller", "Master Controller", "M.Controllr.", "M.Controllr.", },
		{"Reality Shifter", "Reality Shifter", "Real.Shifter", "Real.Shifter", },
		{"Alterator", "Alterator", "Alterator", "Alterator", },
		{"Truth", "Truth", "Truth", "Truth", },
	},

#ifdef ENABLE_DEATHKNIGHT
	/* Death Knight (Vampire Paladin) */
	{
		{"Crypt Lord", "Crypt Lady", "Crypt Lord", "Crypt Lady", },
		{"Herald of Ruin", "Herald of Ruin", "Herald o.R.", "Herald o.R.", },
		{"Dark Legate", "Dark Legate", "Dark Legate", "Dark Legate", },
		{"Unholy King", "Unholy Queen", "Unholy King", "Unholy Queen", },
		{"Nemesis", "Nemesis", "Nemesis", "Nemesis", },
	},
#endif
#ifdef ENABLE_HELLKNIGHT
	/* Hell Knight (Corrupted Paladin) */
	{
		{"Plaguebringer", "Plaguebringer", "Pl.bringer", "Pl.bringer", },
		{"Grand Tormentor", "Grand Tormentor", "Gr.Tormentor", "Gr.Tormentor", },
		{"Vizier of Chaos", "Vizier of Chaos", "Vizier o.C.", "Vizier o.C.", },
		{"Demon Prince", "Demon Princess", "Demon Prince", "Dmn.Princess", },
		{"Demon King", "Demon Queen", "Demon King", "Demon Queen", },
	},
#endif
#ifdef ENABLE_CPRIEST
	/* Corrupted Priest */
	{
		{"Protonotary", "Protonotary", "Protonotary", "Protonotary", },
		{"Great Deceiver", "Great Deceiver", "Gr.Deceiver", "Gr.Deceiver", },
		{"Ascended", "Ascended", "Ascended", "Ascended", },
		{"Demi", "Demi", "Demi", "Demi", },
		{"Chaos God", "Chaos God", "Chaos God", "Chaos God", },
	},
#endif
};

/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 *
 * The "ctrl-i" (tab) command flips the "Display inven/equip" and "Display
 * equip/inven" flags for all windows.
 *
 * The "ctrl-g" command (or pseudo-command) should perhaps grab a snapshot
 * of the main screen into any interested windows.
 */


/* desc, min_lv, rchance, dd, ds, effect */
martial_arts ma_blows[MAX_MA] = {
#if 0
	{ "You punch %s",			 1, 0, 1, 4, 0 },
	{ "You kick %s",			 2, 0, 1, 6, 0 },
	{ "You strike %s",			 3, 0, 1, 7, 0 },
	{ "You ram %s with your knee",		 5, 5, 2, 3, MA_KNEE },
	{ "You strike %s with your elbow",	 7, 5, 1, 8, 0 },
	{ "You butt %s",			 9, 10, 2, 5, 0 },
	{ "You kick %s",			11, 10, 2, 5, MA_SLOW },
	{ "You uppercut %s",			13, 12, 4, 3, 4 },
	{ "You double-kick %s",			16, 15, 4, 4, 0 },
	{ "You strike %s with a Cat's Claw",	20, 20, 6, 3, 0 },
	{ "You hit %s with a jump kick",	25, 25, 3, 9, 6 },
	{ "You strike %s with an Eagle's Claw",	29, 25, 7, 4, 0 },
	{ "You hit %s with a circle kick",	33, 30, 4, 9, 0 },
	{ "You punch %s with an Iron Fist",	37, 35, 6, 6, 8 },
	{ "You hit %s with a flying kick",	41, 35, 5, 8, 0 },
	{ "You punch %s with a Dragon Fist",	45, 35, 6, 8, 10 },
	{ "You hit %s with a Crushing Blow",	48, 35, 8, 7, 12 },
	/* Kings only (for NR:) */
	{ "You bash %s with a Titan's Fist",	48, 45, 8, 5, 20 },
	{ "You strike %s with a Phoenix Claw",	48, 45, 5, 9, MA_ROYAL_SLOW },
#else //let's align the text so monster names are readable even when the messages are passing by
	{ "You damage %s with a punch",	  1, 0, 1, 4, 0 },
	{ "You damage %s with a kick",		 2, 0, 1, 6, 0 },
	{ "You damage %s with a strike",	 3, 0, 1, 7, 0 },
	{ "You damage %s with your knee",	 5, 5, 2, 3, MA_KNEE },
	{ "You strike %s with your elbow",	 7, 5, 1, 8, 0 },
	{ "You damage %s with a thrust",	 9, 10, 2, 5, 0 },
	{ "You damage %s with a kick",		11, 10, 2, 5, MA_SLOW },
	{ "You strike %s with an uppercut",	13, 12, 4, 3, 4 },
	{ "You damage %s with a double-kick",	16, 15, 4, 4, 0 },
	{ "You strike %s with a Cat's Claw",	20, 20, 6, 3, 0 },
	{ "You damage %s with a jump kick",	25, 25, 3, 9, 6 },
	{ "You strike %s with an Eagle's Claw",	29, 25, 7, 4, 0 },
	{ "You damage %s with a circle kick",	33, 30, 4, 9, 0 },
	{ "You pummel %s with an Iron Fist",	37, 35, 6, 6, 8 },
	{ "You damage %s with a flying kick",	41, 35, 5, 8, 0 },
	{ "You pummel %s with a Dragon Fist",	45, 35, 6, 8, 10 },
	{ "You damage %s with a Crushing Blow",	48, 35, 8, 7, 12 },
	/* Kings only (for NR:) */
	{ "You pummel %s with a Titan's Fist",	48, 45, 8, 5, 20 },
	{ "You strike %s with a Phoenix Claw",	48, 45, 5, 9, MA_ROYAL_SLOW },
#endif
};

/*
 * Months
 */
int month_day[9] = {
	0,      /* 1 day */

	1,      /* 54 days */
	55,     /* 72 days */
	127,    /* 54 days */

	181,    /* 3 days */

	184,    /* 54 days */
	238,    /* 72 days */
	310,    /* 54 days */

	364,    /* 1 day */
};
cptr month_name[9] = {
	"Yestare",

	"Tuile",
	"Laire",
	"Yavie",

	"Enderi",

	"Quelle",
	"Hrive",
	"Coire",

	"Mettare",
};


/*
 * Quick hack for towns -- this should die	- Jir -
 */
/* FIXME: Dungeons don't match the Tolkien themes;
 * they're simply used to match the necessity
 */
town_extra town_profile[6]= {
	/* Vanilla */
	{
		"Town",
		FEAT_GRASS,
		FEAT_GRASS,
		90,
		WILD_GRASSLAND,
		{
			0,	/* No dungeon unless admin creates one */
			0,
		},

		1,
		127,
		FALSE,
		0L,
		0L,
	},

	/* Bree */
	{
		"Bree",
		FEAT_TREE,
		FEAT_GRASS,
		98,
		WILD_FOREST,
		{
			4,	/* Barrow-Downs */
			30,	/* Training Tower */
		},

		1,
		60,
		FALSE,
		0L,
		0L,
	},

	/* Gondolin */
	{
		"Gondolin",
		FEAT_GRASS,
		FEAT_DIRT,
		70,
		WILD_GRASSLAND,
		{
			2,	/* Mordor */
			0,
		},

		20,
		80,
		FALSE,
		0L,
		0L,
	},

	/* Minas Anor */
	{
		"Minas Anor",
		FEAT_MOUNTAIN,
		FEAT_SAND,
		90,
		WILD_MOUNTAIN,
		{
			16,	/* Paths of the Dead */
			0,
		},

		40,
		80,
		TRUE,
		0L,
		0L,
	},

	/* Lothlorien */
	{
		"Lothlorien",
		FEAT_DEEP_WATER,
		FEAT_SHAL_WATER,
		80,
		WILD_RIVER,
		{
			3,	/* Angband */
			0,
		},

		60,
		80,
		FALSE,
		0L,
		0L,
	},

	/* Khazad-dum */
	{
		"Khazad-dum",
		FEAT_MOUNTAIN,
		FEAT_ASH,
		70,
		WILD_MOUNTAIN,
		{
			3,	/* Angband (lazy :) */
			0,
		},

		80,
		120,
		TRUE,
		0L,
		0L,
	}
};


/* for C_BLUE_AI - meaning is: minimum AC of a player to make him appear pretty tough to monsters */
int p_tough_ac[51] = {
	5,6,7,8,9,		10,11,12,13,14,
	15,15,16,16,17,		17,18,18,19,19,
	20,22,24,26,28,		31,34,37,40,45,
	50,55,60,65,75,		85,95,105,115,
	120,123,126,128,130,	132,134,136,138,140,
	160	/* 51+, ie 'post king' */
};


/* For fighting techniques */
byte mtech_lev[MAX_CLASS][16] = {
    //	sprint,	taunt,	dirt,	bash,	distr,	poison,	trackan,detnoi, flashb,	steamb,	spin,	assass,	berser,	jump,	s-jump,	s-run
	{2,	4,	0,	5,	0,	0,	0,	0,	0,	0,	6,	0,	20,	0,	0,	0},	//warrior
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},	//istar
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},	//priest
#ifdef ENABLE_ASSASSINATE
	{2,	3,	3,	0,	4,	5,	0,	8,	11,	0,	0,	35,	0,	0,	0,	50},	//rogue
#else
	{2,	3,	3,	0,	4,	5,	0,	8,	11,	0,	0,	0,	0,	0,	0,	50},	//rogue
#endif
	{4,	7,	0,	13,	0,	0,	0,	0,	0,	0,	20,	0,	0,	0,	0,	0},	//mimic
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},	//archer
	{5,	7,	0,	9,	0,	0,	0,	0,	0,	0,	20,	0,	0,	0,	0,	0},	//paladin
	{3,	8,	0,	13,	0,	0,	7,	0,	0,	0,	17,	0,	0,	0,	0,	0},	//ranger
	{3,	5,	9,	13,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},	//adventurer
	{5,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},	//druid
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},	//shaman
	{4,	6,	8,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},	//runemaster
	{0,	8,	0,	13,	12,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},	//mindcrafter
#ifdef ENABLE_DEATHKNIGHT
	{5,	9,	0,	10,	0,	0,	0,	0,	0,	0,	20,	0,	0,	0,	0,	0},	//death knight
#endif
#ifdef ENABLE_HELLKNIGHT
	{5,	9,	0,	11,	0,	0,	0,	0,	0,	0,	20,	0,	35,	0,	0,	0},	//hell knight
#endif
#ifdef ENABLE_CPRIEST
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},	//corrupted priest
#endif
};
