// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

#include "google/cloud/speech/v1/internal/adaptation_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace speech_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AdaptationTracingStub::AdaptationTracingStub(
    std::shared_ptr<AdaptationStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationTracingStub::CreatePhraseSet(
    grpc::ClientContext& context,
    google::cloud::speech::v1::CreatePhraseSetRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v1.Adaptation",
                                     "CreatePhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreatePhraseSet(context, request));
}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationTracingStub::GetPhraseSet(
    grpc::ClientContext& context,
    google::cloud::speech::v1::GetPhraseSetRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v1.Adaptation",
                                     "GetPhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetPhraseSet(context, request));
}

StatusOr<google::cloud::speech::v1::ListPhraseSetResponse>
AdaptationTracingStub::ListPhraseSet(
    grpc::ClientContext& context,
    google::cloud::speech::v1::ListPhraseSetRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v1.Adaptation",
                                     "ListPhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListPhraseSet(context, request));
}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationTracingStub::UpdatePhraseSet(
    grpc::ClientContext& context,
    google::cloud::speech::v1::UpdatePhraseSetRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v1.Adaptation",
                                     "UpdatePhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdatePhraseSet(context, request));
}

Status AdaptationTracingStub::DeletePhraseSet(
    grpc::ClientContext& context,
    google::cloud::speech::v1::DeletePhraseSetRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v1.Adaptation",
                                     "DeletePhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeletePhraseSet(context, request));
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationTracingStub::CreateCustomClass(
    grpc::ClientContext& context,
    google::cloud::speech::v1::CreateCustomClassRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v1.Adaptation",
                                     "CreateCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateCustomClass(context, request));
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationTracingStub::GetCustomClass(
    grpc::ClientContext& context,
    google::cloud::speech::v1::GetCustomClassRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v1.Adaptation",
                                     "GetCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetCustomClass(context, request));
}

StatusOr<google::cloud::speech::v1::ListCustomClassesResponse>
AdaptationTracingStub::ListCustomClasses(
    grpc::ClientContext& context,
    google::cloud::speech::v1::ListCustomClassesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v1.Adaptation",
                                     "ListCustomClasses");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListCustomClasses(context, request));
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationTracingStub::UpdateCustomClass(
    grpc::ClientContext& context,
    google::cloud::speech::v1::UpdateCustomClassRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v1.Adaptation",
                                     "UpdateCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateCustomClass(context, request));
}

Status AdaptationTracingStub::DeleteCustomClass(
    grpc::ClientContext& context,
    google::cloud::speech::v1::DeleteCustomClassRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v1.Adaptation",
                                     "DeleteCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteCustomClass(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<AdaptationStub> MakeAdaptationTracingStub(
    std::shared_ptr<AdaptationStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<AdaptationTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1_internal
}  // namespace cloud
}  // namespace google
