// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/domains/v1/domains.proto

#include "google/cloud/domains/v1/internal/domains_connection_impl.h"
#include "google/cloud/domains/v1/internal/domains_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace domains_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<domains_v1::DomainsRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<domains_v1::DomainsRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<domains_v1::DomainsBackoffPolicyOption>()->clone();
}

std::unique_ptr<domains_v1::DomainsConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<domains_v1::DomainsConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<domains_v1::DomainsPollingPolicyOption>()->clone();
}

}  // namespace

DomainsConnectionImpl::DomainsConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<domains_v1_internal::DomainsStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      DomainsConnection::options())) {}

StatusOr<google::cloud::domains::v1::SearchDomainsResponse>
DomainsConnectionImpl::SearchDomains(
    google::cloud::domains::v1::SearchDomainsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SearchDomains(request),
      [this](grpc::ClientContext& context,
             google::cloud::domains::v1::SearchDomainsRequest const& request) {
        return stub_->SearchDomains(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::domains::v1::RetrieveRegisterParametersResponse>
DomainsConnectionImpl::RetrieveRegisterParameters(
    google::cloud::domains::v1::RetrieveRegisterParametersRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RetrieveRegisterParameters(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::domains::v1::RetrieveRegisterParametersRequest const&
              request) {
        return stub_->RetrieveRegisterParameters(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsConnectionImpl::RegisterDomain(
    google::cloud::domains::v1::RegisterDomainRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::domains::v1::Registration>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::domains::v1::RegisterDomainRequest const& request) {
        return stub->AsyncRegisterDomain(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::domains::v1::Registration>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RegisterDomain(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::domains::v1::RetrieveTransferParametersResponse>
DomainsConnectionImpl::RetrieveTransferParameters(
    google::cloud::domains::v1::RetrieveTransferParametersRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RetrieveTransferParameters(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::domains::v1::RetrieveTransferParametersRequest const&
              request) {
        return stub_->RetrieveTransferParameters(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsConnectionImpl::TransferDomain(
    google::cloud::domains::v1::TransferDomainRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::domains::v1::Registration>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::domains::v1::TransferDomainRequest const& request) {
        return stub->AsyncTransferDomain(cq, std::move(context), options,
                                         request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::domains::v1::Registration>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TransferDomain(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::domains::v1::Registration>
DomainsConnectionImpl::ListRegistrations(
    google::cloud::domains::v1::ListRegistrationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListRegistrations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::domains::v1::Registration>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<domains_v1::DomainsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::domains::v1::ListRegistrationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::domains::v1::ListRegistrationsRequest const&
                       request) {
              return stub->ListRegistrations(context, request);
            },
            r, function_name);
      },
      [](google::cloud::domains::v1::ListRegistrationsResponse r) {
        std::vector<google::cloud::domains::v1::Registration> result(
            r.registrations().size());
        auto& messages = *r.mutable_registrations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::domains::v1::Registration>
DomainsConnectionImpl::GetRegistration(
    google::cloud::domains::v1::GetRegistrationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetRegistration(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::domains::v1::GetRegistrationRequest const& request) {
        return stub_->GetRegistration(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsConnectionImpl::UpdateRegistration(
    google::cloud::domains::v1::UpdateRegistrationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::domains::v1::Registration>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::domains::v1::UpdateRegistrationRequest const&
              request) {
        return stub->AsyncUpdateRegistration(cq, std::move(context), options,
                                             request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::domains::v1::Registration>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateRegistration(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsConnectionImpl::ConfigureManagementSettings(
    google::cloud::domains::v1::ConfigureManagementSettingsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::domains::v1::Registration>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::domains::v1::ConfigureManagementSettingsRequest const&
              request) {
        return stub->AsyncConfigureManagementSettings(cq, std::move(context),
                                                      options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::domains::v1::Registration>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ConfigureManagementSettings(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsConnectionImpl::ConfigureDnsSettings(
    google::cloud::domains::v1::ConfigureDnsSettingsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::domains::v1::Registration>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::domains::v1::ConfigureDnsSettingsRequest const&
              request) {
        return stub->AsyncConfigureDnsSettings(cq, std::move(context), options,
                                               request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::domains::v1::Registration>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ConfigureDnsSettings(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsConnectionImpl::ConfigureContactSettings(
    google::cloud::domains::v1::ConfigureContactSettingsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::domains::v1::Registration>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::domains::v1::ConfigureContactSettingsRequest const&
              request) {
        return stub->AsyncConfigureContactSettings(cq, std::move(context),
                                                   options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::domains::v1::Registration>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ConfigureContactSettings(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::domains::v1::Registration>>
DomainsConnectionImpl::ExportRegistration(
    google::cloud::domains::v1::ExportRegistrationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::domains::v1::Registration>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::domains::v1::ExportRegistrationRequest const&
              request) {
        return stub->AsyncExportRegistration(cq, std::move(context), options,
                                             request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::domains::v1::Registration>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ExportRegistration(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::domains::v1::OperationMetadata>>
DomainsConnectionImpl::DeleteRegistration(
    google::cloud::domains::v1::DeleteRegistrationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::domains::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::domains::v1::DeleteRegistrationRequest const&
              request) {
        return stub->AsyncDeleteRegistration(cq, std::move(context), options,
                                             request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::domains::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteRegistration(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::domains::v1::AuthorizationCode>
DomainsConnectionImpl::RetrieveAuthorizationCode(
    google::cloud::domains::v1::RetrieveAuthorizationCodeRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RetrieveAuthorizationCode(request),
      [this](grpc::ClientContext& context,
             google::cloud::domains::v1::RetrieveAuthorizationCodeRequest const&
                 request) {
        return stub_->RetrieveAuthorizationCode(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::domains::v1::AuthorizationCode>
DomainsConnectionImpl::ResetAuthorizationCode(
    google::cloud::domains::v1::ResetAuthorizationCodeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ResetAuthorizationCode(request),
      [this](grpc::ClientContext& context,
             google::cloud::domains::v1::ResetAuthorizationCodeRequest const&
                 request) {
        return stub_->ResetAuthorizationCode(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace domains_v1_internal
}  // namespace cloud
}  // namespace google
