// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datacatalog/lineage/v1/lineage.proto

#include "google/cloud/datacatalog/lineage/v1/internal/lineage_connection_impl.h"
#include "google/cloud/datacatalog/lineage/v1/internal/lineage_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace datacatalog_lineage_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<datacatalog_lineage_v1::LineageRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<datacatalog_lineage_v1::LineageRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<datacatalog_lineage_v1::LineageBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<datacatalog_lineage_v1::LineageConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<datacatalog_lineage_v1::LineageConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<datacatalog_lineage_v1::LineagePollingPolicyOption>()
      ->clone();
}

}  // namespace

LineageConnectionImpl::LineageConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<datacatalog_lineage_v1_internal::LineageStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      LineageConnection::options())) {}

StatusOr<
    google::cloud::datacatalog::lineage::v1::ProcessOpenLineageRunEventResponse>
LineageConnectionImpl::ProcessOpenLineageRunEvent(
    google::cloud::datacatalog::lineage::v1::
        ProcessOpenLineageRunEventRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ProcessOpenLineageRunEvent(request),
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::lineage::v1::
                 ProcessOpenLineageRunEventRequest const& request) {
        return stub_->ProcessOpenLineageRunEvent(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Process>
LineageConnectionImpl::CreateProcess(
    google::cloud::datacatalog::lineage::v1::CreateProcessRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateProcess(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::lineage::v1::CreateProcessRequest const&
              request) { return stub_->CreateProcess(context, request); },
      request, __func__);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Process>
LineageConnectionImpl::UpdateProcess(
    google::cloud::datacatalog::lineage::v1::UpdateProcessRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateProcess(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::lineage::v1::UpdateProcessRequest const&
              request) { return stub_->UpdateProcess(context, request); },
      request, __func__);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Process>
LineageConnectionImpl::GetProcess(
    google::cloud::datacatalog::lineage::v1::GetProcessRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetProcess(request),
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::lineage::v1::GetProcessRequest const&
                 request) { return stub_->GetProcess(context, request); },
      request, __func__);
}

StreamRange<google::cloud::datacatalog::lineage::v1::Process>
LineageConnectionImpl::ListProcesses(
    google::cloud::datacatalog::lineage::v1::ListProcessesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListProcesses(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::datacatalog::lineage::v1::Process>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<datacatalog_lineage_v1::LineageRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::datacatalog::lineage::v1::ListProcessesRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::datacatalog::lineage::v1::
                       ListProcessesRequest const& request) {
              return stub->ListProcesses(context, request);
            },
            r, function_name);
      },
      [](google::cloud::datacatalog::lineage::v1::ListProcessesResponse r) {
        std::vector<google::cloud::datacatalog::lineage::v1::Process> result(
            r.processes().size());
        auto& messages = *r.mutable_processes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
LineageConnectionImpl::DeleteProcess(
    google::cloud::datacatalog::lineage::v1::DeleteProcessRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::datacatalog::lineage::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::datacatalog::lineage::v1::DeleteProcessRequest const&
              request) {
        return stub->AsyncDeleteProcess(cq, std::move(context), options,
                                        request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::datacatalog::lineage::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteProcess(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Run>
LineageConnectionImpl::CreateRun(
    google::cloud::datacatalog::lineage::v1::CreateRunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateRun(request),
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::lineage::v1::CreateRunRequest const&
                 request) { return stub_->CreateRun(context, request); },
      request, __func__);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Run>
LineageConnectionImpl::UpdateRun(
    google::cloud::datacatalog::lineage::v1::UpdateRunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateRun(request),
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::lineage::v1::UpdateRunRequest const&
                 request) { return stub_->UpdateRun(context, request); },
      request, __func__);
}

StatusOr<google::cloud::datacatalog::lineage::v1::Run>
LineageConnectionImpl::GetRun(
    google::cloud::datacatalog::lineage::v1::GetRunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetRun(request),
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::lineage::v1::GetRunRequest const&
                 request) { return stub_->GetRun(context, request); },
      request, __func__);
}

StreamRange<google::cloud::datacatalog::lineage::v1::Run>
LineageConnectionImpl::ListRuns(
    google::cloud::datacatalog::lineage::v1::ListRunsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListRuns(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::datacatalog::lineage::v1::Run>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<datacatalog_lineage_v1::LineageRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::datacatalog::lineage::v1::ListRunsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::datacatalog::lineage::v1::ListRunsRequest const&
                    request) { return stub->ListRuns(context, request); },
            r, function_name);
      },
      [](google::cloud::datacatalog::lineage::v1::ListRunsResponse r) {
        std::vector<google::cloud::datacatalog::lineage::v1::Run> result(
            r.runs().size());
        auto& messages = *r.mutable_runs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::datacatalog::lineage::v1::OperationMetadata>>
LineageConnectionImpl::DeleteRun(
    google::cloud::datacatalog::lineage::v1::DeleteRunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::datacatalog::lineage::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::datacatalog::lineage::v1::DeleteRunRequest const&
              request) {
        return stub->AsyncDeleteRun(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::datacatalog::lineage::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteRun(request),
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::datacatalog::lineage::v1::LineageEvent>
LineageConnectionImpl::CreateLineageEvent(
    google::cloud::datacatalog::lineage::v1::CreateLineageEventRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateLineageEvent(request),
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::lineage::v1::
                 CreateLineageEventRequest const& request) {
        return stub_->CreateLineageEvent(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::datacatalog::lineage::v1::LineageEvent>
LineageConnectionImpl::GetLineageEvent(
    google::cloud::datacatalog::lineage::v1::GetLineageEventRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetLineageEvent(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::datacatalog::lineage::v1::GetLineageEventRequest const&
              request) { return stub_->GetLineageEvent(context, request); },
      request, __func__);
}

StreamRange<google::cloud::datacatalog::lineage::v1::LineageEvent>
LineageConnectionImpl::ListLineageEvents(
    google::cloud::datacatalog::lineage::v1::ListLineageEventsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLineageEvents(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::datacatalog::lineage::v1::LineageEvent>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<datacatalog_lineage_v1::LineageRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::datacatalog::lineage::v1::
              ListLineageEventsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::datacatalog::lineage::v1::
                       ListLineageEventsRequest const& request) {
              return stub->ListLineageEvents(context, request);
            },
            r, function_name);
      },
      [](google::cloud::datacatalog::lineage::v1::ListLineageEventsResponse r) {
        std::vector<google::cloud::datacatalog::lineage::v1::LineageEvent>
            result(r.lineage_events().size());
        auto& messages = *r.mutable_lineage_events();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status LineageConnectionImpl::DeleteLineageEvent(
    google::cloud::datacatalog::lineage::v1::DeleteLineageEventRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteLineageEvent(request),
      [this](grpc::ClientContext& context,
             google::cloud::datacatalog::lineage::v1::
                 DeleteLineageEventRequest const& request) {
        return stub_->DeleteLineageEvent(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::datacatalog::lineage::v1::Link>
LineageConnectionImpl::SearchLinks(
    google::cloud::datacatalog::lineage::v1::SearchLinksRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->SearchLinks(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::datacatalog::lineage::v1::Link>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<datacatalog_lineage_v1::LineageRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::datacatalog::lineage::v1::SearchLinksRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::datacatalog::lineage::v1::
                       SearchLinksRequest const& request) {
              return stub->SearchLinks(context, request);
            },
            r, function_name);
      },
      [](google::cloud::datacatalog::lineage::v1::SearchLinksResponse r) {
        std::vector<google::cloud::datacatalog::lineage::v1::Link> result(
            r.links().size());
        auto& messages = *r.mutable_links();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::datacatalog::lineage::v1::ProcessLinks>
LineageConnectionImpl::BatchSearchLinkProcesses(
    google::cloud::datacatalog::lineage::v1::BatchSearchLinkProcessesRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->BatchSearchLinkProcesses(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::datacatalog::lineage::v1::ProcessLinks>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<datacatalog_lineage_v1::LineageRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::datacatalog::lineage::v1::
              BatchSearchLinkProcessesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::datacatalog::lineage::v1::
                       BatchSearchLinkProcessesRequest const& request) {
              return stub->BatchSearchLinkProcesses(context, request);
            },
            r, function_name);
      },
      [](google::cloud::datacatalog::lineage::v1::
             BatchSearchLinkProcessesResponse r) {
        std::vector<google::cloud::datacatalog::lineage::v1::ProcessLinks>
            result(r.process_links().size());
        auto& messages = *r.mutable_process_links();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datacatalog_lineage_v1_internal
}  // namespace cloud
}  // namespace google
