// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/ruleset_service.proto

#include "google/cloud/contentwarehouse/v1/internal/rule_set_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/contentwarehouse/v1/ruleset_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace contentwarehouse_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RuleSetServiceStub::~RuleSetServiceStub() = default;

StatusOr<google::cloud::contentwarehouse::v1::RuleSet>
DefaultRuleSetServiceStub::CreateRuleSet(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::CreateRuleSetRequest const& request) {
  google::cloud::contentwarehouse::v1::RuleSet response;
  auto status = grpc_stub_->CreateRuleSet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::contentwarehouse::v1::RuleSet>
DefaultRuleSetServiceStub::GetRuleSet(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::GetRuleSetRequest const& request) {
  google::cloud::contentwarehouse::v1::RuleSet response;
  auto status = grpc_stub_->GetRuleSet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::contentwarehouse::v1::RuleSet>
DefaultRuleSetServiceStub::UpdateRuleSet(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::UpdateRuleSetRequest const& request) {
  google::cloud::contentwarehouse::v1::RuleSet response;
  auto status = grpc_stub_->UpdateRuleSet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultRuleSetServiceStub::DeleteRuleSet(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::DeleteRuleSetRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteRuleSet(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::contentwarehouse::v1::ListRuleSetsResponse>
DefaultRuleSetServiceStub::ListRuleSets(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::ListRuleSetsRequest const& request) {
  google::cloud::contentwarehouse::v1::ListRuleSetsResponse response;
  auto status = grpc_stub_->ListRuleSets(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1_internal
}  // namespace cloud
}  // namespace google
