// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_schema_service.proto

#include "google/cloud/contentwarehouse/v1/internal/document_schema_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace contentwarehouse_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DocumentSchemaServiceTracingConnection::DocumentSchemaServiceTracingConnection(
    std::shared_ptr<contentwarehouse_v1::DocumentSchemaServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceTracingConnection::CreateDocumentSchema(
    google::cloud::contentwarehouse::v1::CreateDocumentSchemaRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentSchemaServiceConnection::"
      "CreateDocumentSchema");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateDocumentSchema(request));
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceTracingConnection::UpdateDocumentSchema(
    google::cloud::contentwarehouse::v1::UpdateDocumentSchemaRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentSchemaServiceConnection::"
      "UpdateDocumentSchema");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateDocumentSchema(request));
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceTracingConnection::GetDocumentSchema(
    google::cloud::contentwarehouse::v1::GetDocumentSchemaRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentSchemaServiceConnection::"
      "GetDocumentSchema");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDocumentSchema(request));
}

Status DocumentSchemaServiceTracingConnection::DeleteDocumentSchema(
    google::cloud::contentwarehouse::v1::DeleteDocumentSchemaRequest const&
        request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentSchemaServiceConnection::"
      "DeleteDocumentSchema");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteDocumentSchema(request));
}

StreamRange<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceTracingConnection::ListDocumentSchemas(
    google::cloud::contentwarehouse::v1::ListDocumentSchemasRequest request) {
  auto span = internal::MakeSpan(
      "contentwarehouse_v1::DocumentSchemaServiceConnection::"
      "ListDocumentSchemas");
  internal::OTelScope scope(span);
  auto sr = child_->ListDocumentSchemas(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::contentwarehouse::v1::DocumentSchema>(std::move(span),
                                                           std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<contentwarehouse_v1::DocumentSchemaServiceConnection>
MakeDocumentSchemaServiceTracingConnection(
    std::shared_ptr<contentwarehouse_v1::DocumentSchemaServiceConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DocumentSchemaServiceTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1_internal
}  // namespace cloud
}  // namespace google
