// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/billing/budgets/v1/budget_service.proto

#include "google/cloud/billing/budgets/v1/budget_connection.h"
#include "google/cloud/billing/budgets/v1/budget_options.h"
#include "google/cloud/billing/budgets/v1/internal/budget_connection_impl.h"
#include "google/cloud/billing/budgets/v1/internal/budget_option_defaults.h"
#include "google/cloud/billing/budgets/v1/internal/budget_stub_factory.h"
#include "google/cloud/billing/budgets/v1/internal/budget_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace billing_budgets_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BudgetServiceConnection::~BudgetServiceConnection() = default;

StatusOr<google::cloud::billing::budgets::v1::Budget>
BudgetServiceConnection::CreateBudget(
    google::cloud::billing::budgets::v1::CreateBudgetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::billing::budgets::v1::Budget>
BudgetServiceConnection::UpdateBudget(
    google::cloud::billing::budgets::v1::UpdateBudgetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::billing::budgets::v1::Budget>
BudgetServiceConnection::GetBudget(
    google::cloud::billing::budgets::v1::GetBudgetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::billing::budgets::v1::Budget>
BudgetServiceConnection::ListBudgets(
    google::cloud::billing::budgets::v1::
        ListBudgetsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::billing::budgets::v1::Budget>>();
}

Status BudgetServiceConnection::DeleteBudget(
    google::cloud::billing::budgets::v1::DeleteBudgetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<BudgetServiceConnection> MakeBudgetServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 BudgetServicePolicyOptionList>(options,
                                                                __func__);
  options = billing_budgets_v1_internal::BudgetServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = billing_budgets_v1_internal::CreateDefaultBudgetServiceStub(
      background->cq(), options);
  return billing_budgets_v1_internal::MakeBudgetServiceTracingConnection(
      std::make_shared<
          billing_budgets_v1_internal::BudgetServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace billing_budgets_v1
}  // namespace cloud
}  // namespace google
