/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.providersupport.shared;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.common.registry.ManagedProvider;
import org.openhab.core.thing.link.ItemChannelLink;
import org.openhab.core.thing.link.ItemChannelLinkProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ScriptedItemChannelLinkProvider.class, ItemChannelLinkProvider.class})
public class ScriptedItemChannelLinkProvider
extends AbstractProvider<ItemChannelLink>
implements ItemChannelLinkProvider,
ManagedProvider<ItemChannelLink, String> {
    private final Logger logger = LoggerFactory.getLogger(ScriptedItemChannelLinkProvider.class);
    private final Map<String, ItemChannelLink> itemChannelLinks = new HashMap<String, ItemChannelLink>();

    public Collection<ItemChannelLink> getAll() {
        return this.itemChannelLinks.values();
    }

    public @Nullable ItemChannelLink get(String key) {
        return this.itemChannelLinks.get(key);
    }

    public void add(ItemChannelLink itemChannelLink) {
        if (this.get(itemChannelLink.getUID()) != null) {
            throw new IllegalArgumentException("Cannot add item->channel link, because an item->channel link with same UID (" + itemChannelLink.getUID() + ") already exists.");
        }
        this.itemChannelLinks.put(itemChannelLink.getUID(), itemChannelLink);
        this.notifyListenersAboutAddedElement(itemChannelLink);
    }

    public @Nullable ItemChannelLink update(ItemChannelLink itemChannelLink) {
        ItemChannelLink oldItemChannelLink = this.itemChannelLinks.get(itemChannelLink.getUID());
        if (oldItemChannelLink != null) {
            this.itemChannelLinks.put(itemChannelLink.getUID(), itemChannelLink);
            this.notifyListenersAboutUpdatedElement(oldItemChannelLink, itemChannelLink);
        } else {
            this.logger.warn("Cannot update item->channel link with UID '{}', because it does not exist.", (Object)itemChannelLink.getUID());
        }
        return oldItemChannelLink;
    }

    public @Nullable ItemChannelLink remove(String key) {
        ItemChannelLink itemChannelLink = this.itemChannelLinks.remove(key);
        if (itemChannelLink != null) {
            this.notifyListenersAboutRemovedElement(itemChannelLink);
        }
        return itemChannelLink;
    }
}

