// cylon.c -- a "cylon" (think Battlestar Galactica TV series) robots
//            for C++Robots
//
// Copyright (c) 1997-2003,2006, Richard Rognlie <rrognlie@gamerz.net>
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
// 
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
// 
//     * Neither the name of Gamerz.NET Enterprises nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
// 
//     * If you do make any modifications, please drop Richard a note so
//       that he can incorporate interesting patches into the baseline.
// 
// This software is provided by the copyright holders and contributors
// "AS IS" and any express or implied warranties, including, but not
// limited to, the implied warranties of MERCHANTABILITY and FITNESS FOR
// A PARTICULAR PURPOSE are disclaimed.  In no event shall the copyright
// owner or contributors be liable for any direct, indirect, incidental,
// special, exemplary, or consequential damages (including, but not limited
// to, procurement of substitute goods or services; loss of use, data, or
// profits; or business interruption) however caused and on any theory of
// liability, whether in contract, strict liability, or tort (including
// negligence or otherwise) arising in any way out of the use of this
// software, even if advised of the possibility of such damage.

#include "robots.h"

int Distance(int x1, int y1, int x2, int y2)
{
    int dx = x1-x2;
    int dy = y1-y2;
//printlog("Distance: dx = %d  dy=%d",dx,dy);
    return sqrt(dx*dx + dy*dy);
}

void Goto(int x, int y)
{
    int dir = atan2(y-loc_y(),x-loc_x());
    int dist = Distance(x,y,loc_x(),loc_y());
    int t = time();
    int sc = 0;
    int sd = 1;
    int range=0;

    drive(dir,100);

printlog("Goto: x,y = %d,%d  dir,dist = %d,%d",x,y,dir,dist);
    while (speed() && time()-t < dist) {
        if (abs(sc) == 45)
            sd *= -1;
        sc += 3*sd;
        range = scan(dir+sc,5);
        if (range > 200 && range < 7000)
            cannon(dir+sc,range);
        int tdir = atan2(y-loc_y(),x-loc_x());
        if (speed() && tdir != dir)
            drive(dir=tdir,100);
    }

    drive(dir,0);
    while (speed())
        drive(dir,0);
}

int main()
{
    while (1)
        Goto(rand(9000)+500,rand(9000)+500);
}
