# $Id: ruby-dict.spec,v 1.9 2007/05/20 00:05:10 ianmacd Exp $
#
Summary: Ruby/DICT library
Name: ruby-dict
Version: 0.9.4
Release: 1
License: GPL
Group: Applications/Ruby
Source: http://www.caliban.org/files/ruby/%{name}-%{version}.tar.gz
URL: http://www.caliban.org/ruby/
Packager: Ian Macdonald <ian@caliban.org>
BuildRoot: /var/tmp/%{name}-%{version}
BuildRequires: ruby
%define ruby18 %( [ `ruby -r rbconfig -e 'print Config::CONFIG["MAJOR"], ".", Config::CONFIG["MINOR"]'` = '1.8' ] && echo 1 || echo 0 )
%if %{ruby18}
Requires: ruby >= 1.8.0
%else
Requires: ruby >= 1.6.0
%endif

%description
Ruby/DICT is an RFC 2229 compliant client-side library implementation of the
DICT protocol, written in the Ruby programming language. It can be used to
write clients that access dictionary definitions from a set of natural
language dictionary databases.

In addition, rdict, a dictionary client built on Ruby/DICT, is included.

%prep
%setup
make config ROOT=$RPM_BUILD_ROOT%{_prefix}
make setup

%clean 
rm -rf $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make install ROOT=$RPM_BUILD_ROOT%{_prefix}
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man{1,3}
install doc/dict.3 $RPM_BUILD_ROOT%{_mandir}/man3/dict.3
install doc/rdict.1 $RPM_BUILD_ROOT%{_mandir}/man1/rdict.1
gzip -9 $RPM_BUILD_ROOT%{_mandir}/{man1/rdict.1,man3/dict.3}

find $RPM_BUILD_ROOT%{_prefix} -type f -print | \
    ruby -pe 'sub(%r(^'$RPM_BUILD_ROOT'), "")' > %{name}-%{version}-filelist

%files -f %{name}-%{version}-filelist
%defattr(-,root,root)
%doc Changelog COPYING doc/dict.html doc/rdict.html doc/rfc2229.txt README TODO

%changelog
* Sun May 20 2007 Ian Macdonald <ian@caliban.org> 0.9.4-1
- 0.9.4
- Server banner handling treated capabilities string as mandatory and didn't
  allow for null message IDs.

* Thu May 26 2005 Ian Macdonald <ian@caliban.org> 0.9.3-1
- 0.9.3
- Fix bug whereby text response could be mistaken for numeric status response.

* Wed Jun 10 2003 Ian Macdonald <ian@caliban.org>
- 0.9.2
- Print a message when a non-default matching strategy is used with rdict
  and no definitions are found.
- Fix a warning when run with Ruby 1.8.

* Thu Jan  2 2003 Ian Macdonald <ian@caliban.org>
- 0.9.1
- Allow multiple words to be specified on the command line of rdict.

* Fri May 24 2002 Ian Macdonald <ian@caliban.org>
- 0.9.0
