/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.util;

import com.projectlibre1.datatype.Duration;
import com.projectlibre1.datatype.Money;
import com.projectlibre1.datatype.Rate;
import com.projectlibre1.datatype.Work;
import com.projectlibre1.util.DateTime;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.comparators.ComparableComparator;

public class ClassUtils {
    public static final Long defaultLong = new Long(0L);
    public static final Double defaultDouble = new Double(0.0);
    public static final Integer defaultInteger = new Integer(0);
    public static final Float defaultFloat = new Float(0.0);
    public static final Boolean defaultBoolean = new Boolean(false);
    public static final String defaultString = new String();
    public static final Rate defaultRate = new Rate(1.0);
    public static final Rate defaultUnitlessRate = new Rate(1.0, -2);
    public static final Long LONG_MULTIPLE_VALUES = new Long(0L);
    public static final Double DOUBLE_MULTIPLE_VALUES = new Double(0.0);
    public static final Integer INTEGER_MULTIPLE_VALUES = new Integer(0);
    public static final Float FLOAT_MULTIPLE_VALUES = new Float(0.0);
    public static final Boolean BOOLEAN_MULTIPLE_VALUES = new Boolean(false);
    public static final String STRING_MULTIPLE_VALUES = new String();
    public static final Double PERCENT_MULTIPLE_VALUES = new Double(-9876543.21);
    public static final Rate RATE_MULTIPLE_VALUES = new Rate();
    private static Class[] getterParams = new Class[0];
    private static Class[] fieldGetterParams = new Class[]{com.projectlibre1.field.Field.class};
    private static HashMap<Class, Comparator> comparatorMap = null;
    private static final Comparator defaultTextComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return ("" + object).compareTo("" + object2);
        }
    };

    public static Object getDefaultValueForType(Class clazz) {
        if (clazz == String.class) {
            return defaultString;
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return defaultDouble;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return defaultInteger;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return defaultLong;
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return defaultFloat;
        }
        if (clazz == Boolean.class) {
            return defaultBoolean;
        }
        if (clazz == Rate.class) {
            return defaultRate;
        }
        try {
            System.out.println("making default for class" + clazz);
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }

    public static boolean isDefaultValue(Object object) {
        return object == defaultLong || object == defaultDouble || object == defaultInteger || object == defaultFloat || object == defaultString || object == Duration.ZERO || object == defaultRate || object == DateTime.getZeroDate();
    }

    public static Object getMultipleValueForType(Class clazz) {
        if (clazz == String.class) {
            return STRING_MULTIPLE_VALUES;
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return DOUBLE_MULTIPLE_VALUES;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return INTEGER_MULTIPLE_VALUES;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return LONG_MULTIPLE_VALUES;
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return FLOAT_MULTIPLE_VALUES;
        }
        if (clazz == Boolean.class) {
            return BOOLEAN_MULTIPLE_VALUES;
        }
        if (clazz == Rate.class) {
            return RATE_MULTIPLE_VALUES;
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isMultipleValue(Object object) {
        if (object == null) {
            return false;
        }
        return object == LONG_MULTIPLE_VALUES || object == DOUBLE_MULTIPLE_VALUES || object == INTEGER_MULTIPLE_VALUES || object == FLOAT_MULTIPLE_VALUES || object == STRING_MULTIPLE_VALUES || object.equals(PERCENT_MULTIPLE_VALUES) || object == RATE_MULTIPLE_VALUES || object == Duration.ZERO || object == DateTime.getZeroDate();
    }

    public static Class primitiveToObjectClass(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        throw new ClassCastException("Cannot convert class" + clazz + " to an object class");
    }

    public static Object doubleToObject(Double d, Class clazz) {
        if (clazz == Boolean.class) {
            return new Boolean(d != 0.0);
        }
        if (clazz == Byte.class) {
            return new Byte(d.byteValue());
        }
        if (clazz == Short.class) {
            return new Short(d.shortValue());
        }
        if (clazz == Integer.class) {
            return new Integer(d.intValue());
        }
        if (clazz == Long.class) {
            return new Long(d.longValue());
        }
        if (clazz == Float.class) {
            return new Float(d.floatValue());
        }
        if (clazz == Double.class) {
            return d;
        }
        if (clazz == Money.class) {
            return Money.getInstance(d);
        }
        if (clazz == Duration.class) {
            return Duration.getInstanceFromDouble(d);
        }
        if (clazz == Work.class) {
            return Work.getWorkInstanceFromDouble(d);
        }
        throw new IllegalArgumentException("Class " + clazz + " cannot be converted from a Double");
    }

    public static Field staticFieldFromFullName(String string) {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            return ClassUtils.forName(string2).getDeclaredField(string3);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return null;
    }

    public static Method staticVoidMethodFromFullName(String string) {
        return ClassUtils.staticMethodFromFullName(string, null);
    }

    public static Method staticMethodFromFullName(String string, Class[] classArray) {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            return ClassUtils.forName(string2).getDeclaredMethod(string3, classArray);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return null;
    }

    public static void setStaticField(String string, int n) {
        try {
            ClassUtils.staticFieldFromFullName(string).setInt(null, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public static void setStaticField(String string, String string2) {
        try {
            ClassUtils.staticFieldFromFullName(string).set(null, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public static Class forName(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = Class.forName(string);
        }
        return clazz;
    }

    public static boolean setSimpleProperty(Object object, String string, Object object2) {
        try {
            PropertyUtils.setSimpleProperty(object, string, object2);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isObjectReadOnly(Object object) {
        if (object == null) {
            return false;
        }
        Boolean bl = null;
        try {
            Method method = object.getClass().getMethod("isReadOnly", getterParams);
            if (method != null) {
                bl = (Boolean)method.invoke(object, null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return bl != null && bl != false;
    }

    public static boolean isObjectFieldReadOnly(Object object, com.projectlibre1.field.Field field) {
        if (object == null) {
            return false;
        }
        Boolean bl = null;
        try {
            Method method = object.getClass().getMethod("isReadOnly", fieldGetterParams);
            if (method != null) {
                bl = (Boolean)method.invoke(object, field);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return bl != null && bl != false;
    }

    public static Comparator getComparator(Class clazz) {
        Comparator comparator;
        if (comparatorMap == null) {
            comparatorMap = new HashMap();
            comparatorMap.put(String.class, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null) {
                        return object2 == null ? 0 : -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return ((String)object).compareTo((String)object2);
                }
            });
            comparatorMap.put(Date.class, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null) {
                        return object2 == null ? 0 : -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return ((Date)object).compareTo((Date)object2);
                }
            });
            comparatorMap.put(Integer.class, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null) {
                        return object2 == null ? 0 : -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return ((Integer)object).compareTo((Integer)object2);
                }
            });
            comparatorMap.put(Long.class, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null) {
                        return object2 == null ? 0 : -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return ((Long)object).compareTo((Long)object2);
                }
            });
            comparatorMap.put(Short.class, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null) {
                        return object2 == null ? 0 : -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return ((Short)object).compareTo((Short)object2);
                }
            });
            comparatorMap.put(Float.class, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null) {
                        return object2 == null ? 0 : -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return ((Float)object).compareTo((Float)object2);
                }
            });
            comparatorMap.put(Double.class, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null) {
                        return object2 == null ? 0 : -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return ((Double)object).compareTo((Double)object2);
                }
            });
            comparatorMap.put(Byte.class, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null) {
                        return object2 == null ? 0 : -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return ((Byte)object).compareTo((Byte)object2);
                }
            });
            comparatorMap.put(Boolean.class, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null) {
                        return object2 == null ? 0 : -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return ((Boolean)object).compareTo((Boolean)object2);
                }
            });
            comparatorMap.put(Money.class, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null) {
                        return object2 == null ? 0 : -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return ((Money)object).compareTo((Money)object2);
                }
            });
            comparatorMap.put(Duration.class, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null) {
                        return object2 == null ? 0 : -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return ((Duration)object).compareTo(object2);
                }
            });
            comparatorMap.put(Work.class, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null) {
                        return object2 == null ? 0 : -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return ((Work)object).compareTo(object2);
                }
            });
            comparatorMap.put(Rate.class, new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object == null) {
                        return object2 == null ? 0 : -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return ((Rate)object).compareTo(object2);
                }
            });
        }
        if ((comparator = comparatorMap.get(clazz)) == null) {
            if (Comparable.class.isAssignableFrom(clazz)) {
                return ComparableComparator.getInstance();
            }
            return defaultTextComparator;
        }
        return comparatorMap.get(clazz);
    }
}

