/*============================================================================*
 *============================================================================*
 * Component:           plextor-tool
 * Filename:            cplextor-tool.h
 *                                                                             
 * Authors:             Georg Huettenegger
 *                                                                             
 * Date of Creation:    Sat Oct 30 14:39:38 1999
 *                                                                             
 * Last Modification:   Sat Oct 30 14:39:38 1999
 *                                                                             
 * Copyright:           Georg Huettenegger
 *                                                                             
 * General Description: 
 *                                                                             
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                             
 *============================================================================*
 *============================================================================*
 */

#ifndef ___CPLEXTOR_TOOL_H
#define ___CPLEXTOR_TOOL_H

#include "plextor-tool.h"

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Returns value for mode page 0x31 with given speed (Plextor specific).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
int PlextorFieldValueForSpeed (int speed);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Returns a string for the given speed, taking drive_type into account.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
const char * PrintPlextorSpeedString (unsigned char speed);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Prints all available speed settings to stdout (uses mmc_drive and
 * drive_type to distinguish the different CD-ROM/CD-R(W) capabilities).
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void PrintAvailableSpeedSettings ();

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Prints the about message to stdout.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void about ();

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Prints usage information to stdout.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void usage ();

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Calls about and usage and then exits with ret_code.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void explain_abort (int ret_code);

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Used to list all available drives that may be controlles by plextor-tool.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void list_plextor_mmc_drives ();

/*============================================================================*
 *                                                                             
 * DESCRIPTION:                                                                
 * ------------                                                                
 * Prints information about the selected drive to stdout.
 *                                                                             
 *----------------------------------------------------------------------------*
 */
void query_plextor_mmc_drive ();

#endif

/*============================================================================*
 *============================================================================*
 * EOF cplextor-tool.h
 *============================================================================*
 *============================================================================*
 */
