# Known package releases of git-machete

In case the given package system provides multiple channels (stable/edge etc.),
the **edge-most** channel that corresponds to the **released** versions of git-machete is listed
(so as to make spotting potential blockers/errors in the given system easier).

| Package system                                      | Version                                                                                                         | Package link                                                                                                                                                                                                              | Definition link                                                                                                                            | PRs link                                                                     | Controlled by                                                                               | Released by                                                                                                                                                                           | Installs completions [^0] and/or man page? | Downloads, last modified etc.                                                                                                                                                                                                                                                                                         |
|-----------------------------------------------------|-----------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Alpine Linux                                        | ![Alpine Linux Edge package](https://repology.org/badge/version-for-repo/alpine_edge/git-machete.svg?header=)   | [**Alpine Linux Edge package**](https://pkgs.alpinelinux.org/package/edge/community/x86/git-machete)                                                                                                                      | [APKBUILD](https://git.alpinelinux.org/aports/tree/community/git-machete/APKBUILD) (points to GitHub)                                      |                                                                              | Alpine Linux package maintainers                                                            | Alpine Linux package maintainers                                                                                                                                                      | bash, fish, zsh                            |                                                                                                                                                                                                                                                                                                                       |
| Arch User Repository                                | ![AUR package](https://img.shields.io/aur/version/git-machete.svg?label=)                                       | [**AUR package**](https://aur.archlinux.org/packages/git-machete)                                                                                                                                                         | [PKGBUILD](https://aur.archlinux.org/cgit/aur.git/tree/PKGBUILD?h=git-machete) (points to GitHub)                                          |                                                                              | AUR maintainers, incl. [Ila&iuml; Deutel](https://github.com/ilai-deutel)                   | AUR maintainers[^1]                                                                                                                                                                   | bash, fish, zsh                            | ![AUR last modified](https://img.shields.io/aur/last-modified/git-machete.svg)                                                                                                                                                                                                                                        |
| Conda Forge                                         | ![Conda package](https://img.shields.io/conda/vn/conda-forge/git-machete.svg?label=)                            | [**Conda package**](https://anaconda.org/conda-forge/git-machete)                                                                                                                                                         | [Recipe](https://github.com/conda-forge/git-machete-feedstock/blob/main/recipe/meta.yaml) (points to PyPI)                                 | [PRs](https://github.com/conda-forge/git-machete-feedstock/pulls?q=is%3Apr)  | Feedstock maintainers, incl. [@asford (Alex Ford)](https://github.com/asford) and ourselves | Feedstock GitHub bot                                                                                                                                                                  | -                                          | ![Conda downloads](https://img.shields.io/conda/dn/conda-forge/git-machete.svg)                                                                                                                                                                                                                                       |
| Gentoo                                              | ![Gentoo package](https://repology.org/badge/version-for-repo/gentoo/git-machete.svg?header=)                   | [**Gentoo package**](https://packages.gentoo.org/packages/dev-vcs/git-machete)                                                                                                                                            | [ebuild](https://gitweb.gentoo.org/repo/gentoo.git/tree/dev-vcs/git-machete) (points to GitHub)                                            |                                                                              | Gentoo package maintainers                                                                  | Gentoo package maintainers                                                                                                                                                            | bash, fish, zsh                            |                                                                                                                                                                                                                                                                                                                       |
| GitHub Releases (rpm)                               | ![GitHub latest release](https://img.shields.io/github/v/release/VirtusLab/git-machete?label=)                  | [**GitHub releases**](https://github.com/VirtusLab/git-machete/releases)                                                                                                                                                  |                                                                                                                                            |                                                                              | Ourselves                                                                                   | Our CI on `master` builds                                                                                                                                                             | -                                          | ![GitHub releases total downloads](https://img.shields.io/github/downloads/VirtusLab/git-machete/total)[^2]                                                                                                                                                                                                           |
| Homebrew                                            | ![homebrew formula](https://img.shields.io/homebrew/v/git-machete.svg?label=)                                   | [**Formula**](https://formulae.brew.sh/formula/git-machete)                                                                                                                                                               | [Formula source](https://github.com/Homebrew/homebrew-core/blob/master/Formula/g/git-machete.rb) (points to PyPI)                          | [PRs](https://github.com/Homebrew/homebrew-core/pulls?q=is%3Apr+git-machete) | Homebrew maintainers                                                                        | Our CI on `master` builds (opens formula-bump PR), then homebrew-core GitHub Actions                                                                                                  | bash, fish, zsh + man page                 | ![homebrew formula monthly downloads](https://img.shields.io/homebrew/installs/dm/git-machete.svg) <br/> ![homebrew formula quarterly downloads](https://img.shields.io/homebrew/installs/dq/git-machete.svg) <br/> ![homebrew formula yearly downloads](https://img.shields.io/homebrew/installs/dy/git-machete.svg) |
| [LiGurOS (Gentoo fork)](https://liguros.gitlab.io/) | ![LiGurOS develop package](https://repology.org/badge/version-for-repo/liguros_develop/git-machete.svg?header=) |                                                                                                                                                                                                                           | [ebuild](https://gitlab.com/liguros/liguros-repo/-/tree/develop/dev-vcs/git-machete) (points to GitHub)                                    |                                                                              | LiGurOS package maintainers                                                                 | LiGurOS package maintainers                                                                                                                                                           | bash, fish, zsh                            |                                                                                                                                                                                                                                                                                                                       |
| nixpkgs                                             | ![nixpkgs unstable package](https://repology.org/badge/version-for-repo/nix_unstable/git-machete.svg?header=)   | [**nixpkgs unstable package**](https://search.nixos.org/packages?channel=unstable&show=git-machete&query=git-machete)                                                                                                     | [Expression](https://github.com/NixOS/nixpkgs/blob/master/pkgs/applications/version-management/git-machete/default.nix) (points to GitHub) | [PRs](https://github.com/NixOS/nixpkgs/pulls?q=is%3Apr+git-machete)          | nixpkgs maintainers, incl. [@blitz (Julian Stecklina)](https://github.com/blitz)            | [@r-ryantm bot](https://github.com/r-ryantm) ([logs](https://r.ryantm.com/log/git-machete/))[^3]                                                                                      | bash, fish, zsh                            |                                                                                                                                                                                                                                                                                                                       |
| PyPI                                                | ![PyPI package](https://img.shields.io/pypi/v/git-machete.svg?label=)                                           | [**PyPI package**](https://pypi.org/project/git-machete) <br/> [Test PyPI package](https://test.pypi.org/project/git-machete)                                                                                             |                                                                                                                                            |                                                                              | Ourselves                                                                                   | Our CI on `master` builds[^4]                                                                                                                                                         | -                                          | ![PyPI daily downloads](https://img.shields.io/pypi/dd/git-machete.svg) <br/> ![PyPI weekly downloads](https://img.shields.io/pypi/dw/git-machete.svg) <br/> ![PyPI monthly downloads](https://img.shields.io/pypi/dm/git-machete.svg) <br/> ![PyPI wheel?](https://img.shields.io/pypi/wheel/git-machete.svg)        |
| PPA (Ubuntu)                                        | [^5]                                                                                                            | [**PPA packages**](https://launchpad.net/~virtuslab/+archive/ubuntu/git-machete/+packages)                                                                                                                                | [debian/ folder (in this repo)](debian)                                                                                                    |                                                                              | Ourselves                                                                                   | Our CI on `master` builds (uploads source package), then Launchpad build system (see [builds](https://launchpad.net/~virtuslab/+archive/ubuntu/git-machete/+builds?&build_state=all)) | -                                          |                                                                                                                                                                                                                                                                                                                       |
| Read the Docs                                       | N/A                                                                                                             | [**Read the Docs (stable)**](https://git-machete.readthedocs.io/en/stable) <br/> [Read the Docs (latest)](https://git-machete.readthedocs.io/en/latest) <br/> [Admin page](https://readthedocs.org/projects/git-machete/) |                                                                                                                                            |                                                                              | Ourselves                                                                                   | Read the Docs itself (see [builds](https://readthedocs.org/projects/git-machete/builds)), triggered by GitHub webhook [^6]                                                            | N/A                                        | ![Read the Docs build status](https://readthedocs.org/projects/git-machete/badge/?version=stable)                                                                                                                                                                                                                     |
| Scoop (Windows)                                     | ![Scoop](https://img.shields.io/scoop/v/git-machete?label=)                                                     | [**Scoop package**](https://scoop.sh/#/apps?q=git-machete)                                                                                                                                                                | [Manifest](https://github.com/ScoopInstaller/Main/blob/master/bucket/git-machete.json) (points to PyPI, auto-updates based on GitHub)      | [PRs](https://github.com/ScoopInstaller/Main/pulls?q=is%3Apr+git-machete)    | Scoop maintainers                                                                           | Scoop itself (thanks to `autoupdate` attribute in manifest)                                                                                                                           | -                                          |                                                                                                                                                                                                                                                                                                                       |
| Snap                                                | ![Snap](https://img.shields.io/snapcraft/v/git-machete/latest/stable?label=)                                    | [**Snap package**](https://snapcraft.io/git-machete)                                                                                                                                                                      | [snapcraft.yaml (in this repo)](snap/snapcraft.yaml)                                                                                       |                                                                              | Ourselves                                                                                   | Our CI on `master` builds[^7]                                                                                                                                                         | -                                          |                                                                                                                                                                                                                                                                                                                       |
| [T2 SDE](https://t2sde.org/)                        | ![T2 SDE package](https://repology.org/badge/version-for-repo/t2/git-machete.svg?header=)                       | [**T2 SDE package**](https://t2sde.org/packages/git-machete)                                                                                                                                                              | [Package definition](http://svn.exactcode.de/t2/trunk/package/contrib/git-machete/) (points to GitHub)                                     |                                                                              | T2 SDE package maintainers                                                                  | T2 SDE package maintainers                                                                                                                                                            | -                                          |                                                                                                                                                                                                                                                                                                                       |

[^0]: Completions are available under all package managers via `git machete completion <shell>`.
      This column tells whether the completions are installed out of the box in the system, with no need for `source <(git machete completion <shell>)` in shell rc file.

[^1]: If a release introduces significant changes/critical bugfixes, we should [flag the package as out of date](https://aur.archlinux.org/pkgbase/git-machete/flag).

[^2]: GitHub downloads most likely correspond to the RPM packages attached to the releases.

[^3]: nixpkgs releases used to be done by our CI until @blitz's [PR #131141 to NixOS/nixpkgs](https://github.com/NixOS/nixpkgs/pull/131141) which set up the bot.

[^4]: CI builds of `develop` publish the package to Test PyPI.
      CI builds of `master`  publish the package to main (production) PyPI.

[^5]: There are no badges available for PPA packages; see [badges/shields#560](https://github.com/badges/shields/issues/560).

[^6]: Read the Docs builds of `develop` are published as [latest](https://git-machete.readthedocs.io/en/latest).
      Read the Docs builds of `master`  are published as [stable](https://git-machete.readthedocs.io/en/stable).

[^7]: Releases used to be done by Snap Store itself, triggered by webhook. [We moved that process to CI](https://github.com/VirtusLab/git-machete/issues/436) to skip a manual promotion step.

## [Repology](https://repology.org/project/git-machete/versions)

May duplicate badges already included in the above table,
but may also include newly-added packages that we're not aware of yet.

[![Packaging status](https://repology.org/badge/vertical-allrepos/git-machete.svg)](https://repology.org/project/git-machete/versions)
