/* window.c generated by valac 0.52.3, the Vala compiler
 * generated from window.vala, do not modify */

/* Window handling functions

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */
/* The current window. */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;
typedef struct _WindowPrivate WindowPrivate;

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;
#define _window_unref0(var) ((var == NULL) ? NULL : (var = (window_unref (var), NULL)))
#define _buffer_unref0(var) ((var == NULL) ? NULL : (var = (buffer_unref (var), NULL)))
#define _marker_unref0(var) ((var == NULL) ? NULL : (var = (marker_unref (var), NULL)))
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
typedef struct _ParamSpecWindow ParamSpecWindow;
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Window {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WindowPrivate * priv;
	Window* next;
	Buffer* bp;
	gsize topdelta;
	gsize start_column;
	Marker* saved_pt;
	gsize fwidth;
	gsize fheight;
	gsize ewidth;
	gsize eheight;
	gboolean all_displayed;
	gsize lastpointn;
};

struct _WindowClass {
	GTypeClass parent_class;
	void (*finalize) (Window *self);
};

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

struct _ParamSpecWindow {
	GParamSpec parent_instance;
};

extern Window* cur_wp;
Window* cur_wp = NULL;
extern Window* head_wp;
Window* head_wp = NULL;
static gpointer window_parent_class = NULL;
extern Buffer* cur_bp;

gpointer window_ref (gpointer instance);
void window_unref (gpointer instance);
GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_window (GValue* value,
                       gpointer v_object);
void value_take_window (GValue* value,
                        gpointer v_object);
gpointer value_get_window (const GValue* value);
GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
gpointer buffer_ref (gpointer instance);
void buffer_unref (gpointer instance);
GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_buffer (GValue* value,
                       gpointer v_object);
void value_take_buffer (GValue* value,
                        gpointer v_object);
gpointer value_get_buffer (const GValue* value);
GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
gpointer marker_ref (gpointer instance);
void marker_unref (gpointer instance);
GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_marker (GValue* value,
                       gpointer v_object);
void value_take_marker (GValue* value,
                        gpointer v_object);
gpointer value_get_marker (const GValue* value);
GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
Window* window_find (const gchar* name);
gpointer undo_ref (gpointer instance);
void undo_unref (gpointer instance);
GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_undo (GValue* value,
                     gpointer v_object);
void value_take_undo (GValue* value,
                      gpointer v_object);
gpointer value_get_undo (const GValue* value);
GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
gpointer var_entry_ref (gpointer instance);
void var_entry_unref (gpointer instance);
GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_var_entry (GValue* value,
                          gpointer v_object);
void value_take_var_entry (GValue* value,
                           gpointer v_object);
gpointer value_get_var_entry (const GValue* value);
GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
gsize window_o (Window* self);
gsize buffer_get_pt (Buffer* self);
gsize marker_get_o (Marker* self);
gboolean window_top_visible (Window* self);
gsize buffer_offset_to_line (Buffer* self,
                             gsize offset);
gboolean window_bottom_visible (Window* self);
void window_resync (Window* self);
void window_set_current (Window* self);
void marker_unchain (Marker* self);
Marker* marker_point (void);
void buffer_goto_offset (Buffer* self,
                         gsize o);
void window_delete (Window* self);
Window* window_new (void);
Window* window_construct (GType object_type);
static void window_finalize (Window * obj);
static GType window_get_type_once (void);
void create_scratch_window (void);
Buffer* create_scratch_buffer (void);
gsize term_width (void);
gsize term_height (void);
Window* popup_window (void);
gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
void window_init (void);
static gboolean __lambda137_ (glong uniarg,
                       GeeQueue* args);
void minibuf_error (const gchar* fmt,
                    ...);
void recenter (Window* wp);
static gboolean ___lambda137__function (glong uniarg,
                                 GeeQueue* args);
LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
gpointer lisp_func_ref (gpointer instance);
void lisp_func_unref (gpointer instance);
GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_lisp_func (GValue* value,
                          gpointer v_object);
void value_take_lisp_func (GValue* value,
                           gpointer v_object);
gpointer value_get_lisp_func (const GValue* value);
GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
static gboolean __lambda138_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda138__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda139_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda139__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda140_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda140__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda141_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda141__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda142_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda142__function (glong uniarg,
                                 GeeQueue* args);

static gpointer
_window_ref0 (gpointer self)
{
#line 44 "src/window.vala"
	return self ? window_ref (self) : NULL;
#line 324 "window.c"
}

Window*
window_find (const gchar* name)
{
	Window* result = NULL;
#line 43 "src/window.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 333 "window.c"
	{
		Window* wp = NULL;
		Window* _tmp0_;
		Window* _tmp1_;
#line 44 "src/window.vala"
		_tmp0_ = head_wp;
#line 44 "src/window.vala"
		_tmp1_ = _window_ref0 (_tmp0_);
#line 44 "src/window.vala"
		wp = _tmp1_;
#line 344 "window.c"
		{
			gboolean _tmp2_ = FALSE;
#line 44 "src/window.vala"
			_tmp2_ = TRUE;
#line 44 "src/window.vala"
			while (TRUE) {
#line 351 "window.c"
				Window* _tmp6_;
				Window* _tmp7_;
				Buffer* _tmp8_;
				const gchar* _tmp9_;
#line 44 "src/window.vala"
				if (!_tmp2_) {
#line 358 "window.c"
					Window* _tmp3_;
					Window* _tmp4_;
					Window* _tmp5_;
#line 44 "src/window.vala"
					_tmp3_ = wp;
#line 44 "src/window.vala"
					_tmp4_ = _tmp3_->next;
#line 44 "src/window.vala"
					_tmp5_ = _window_ref0 (_tmp4_);
#line 44 "src/window.vala"
					_window_unref0 (wp);
#line 44 "src/window.vala"
					wp = _tmp5_;
#line 372 "window.c"
				}
#line 44 "src/window.vala"
				_tmp2_ = FALSE;
#line 44 "src/window.vala"
				_tmp6_ = wp;
#line 44 "src/window.vala"
				if (!(_tmp6_ != NULL)) {
#line 44 "src/window.vala"
					break;
#line 382 "window.c"
				}
#line 45 "src/window.vala"
				_tmp7_ = wp;
#line 45 "src/window.vala"
				_tmp8_ = _tmp7_->bp;
#line 45 "src/window.vala"
				_tmp9_ = _tmp8_->name;
#line 45 "src/window.vala"
				if (g_strcmp0 (_tmp9_, name) == 0) {
#line 46 "src/window.vala"
					result = wp;
#line 46 "src/window.vala"
					return result;
#line 396 "window.c"
				}
			}
		}
#line 44 "src/window.vala"
		_window_unref0 (wp);
#line 402 "window.c"
	}
#line 48 "src/window.vala"
	result = NULL;
#line 48 "src/window.vala"
	return result;
#line 408 "window.c"
}

gsize
window_o (Window* self)
{
	Window* _tmp0_;
	gsize result = 0UL;
#line 51 "src/window.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 55 "src/window.vala"
	_tmp0_ = cur_wp;
#line 55 "src/window.vala"
	if (self == _tmp0_) {
#line 422 "window.c"
		Buffer* _tmp1_;
		Buffer* _tmp2_;
		Marker* _tmp3_;
		Buffer* _tmp4_;
		gsize _tmp5_;
		gsize _tmp6_;
#line 56 "src/window.vala"
		_tmp1_ = self->bp;
#line 56 "src/window.vala"
		_tmp2_ = cur_bp;
#line 56 "src/window.vala"
		_vala_assert (_tmp1_ == _tmp2_, "bp == cur_bp");
#line 57 "src/window.vala"
		_tmp3_ = self->saved_pt;
#line 57 "src/window.vala"
		_vala_assert (_tmp3_ == NULL, "saved_pt == null");
#line 58 "src/window.vala"
		_tmp4_ = cur_bp;
#line 58 "src/window.vala"
		_tmp5_ = buffer_get_pt (_tmp4_);
#line 58 "src/window.vala"
		_tmp6_ = _tmp5_;
#line 58 "src/window.vala"
		result = _tmp6_;
#line 58 "src/window.vala"
		return result;
#line 449 "window.c"
	} else {
		Marker* _tmp7_;
#line 60 "src/window.vala"
		_tmp7_ = self->saved_pt;
#line 60 "src/window.vala"
		if (_tmp7_ != NULL) {
#line 456 "window.c"
			Marker* _tmp8_;
			gsize _tmp9_;
			gsize _tmp10_;
#line 61 "src/window.vala"
			_tmp8_ = self->saved_pt;
#line 61 "src/window.vala"
			_tmp9_ = marker_get_o (_tmp8_);
#line 61 "src/window.vala"
			_tmp10_ = _tmp9_;
#line 61 "src/window.vala"
			result = _tmp10_;
#line 61 "src/window.vala"
			return result;
#line 470 "window.c"
		} else {
			Buffer* _tmp11_;
			gsize _tmp12_;
			gsize _tmp13_;
#line 63 "src/window.vala"
			_tmp11_ = self->bp;
#line 63 "src/window.vala"
			_tmp12_ = buffer_get_pt (_tmp11_);
#line 63 "src/window.vala"
			_tmp13_ = _tmp12_;
#line 63 "src/window.vala"
			result = _tmp13_;
#line 63 "src/window.vala"
			return result;
#line 485 "window.c"
		}
	}
}

gboolean
window_top_visible (Window* self)
{
	Buffer* _tmp0_;
	gboolean result = FALSE;
#line 67 "src/window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 68 "src/window.vala"
	_tmp0_ = self->bp;
#line 68 "src/window.vala"
	result = buffer_offset_to_line (_tmp0_, window_o (self)) == self->topdelta;
#line 68 "src/window.vala"
	return result;
#line 503 "window.c"
}

gboolean
window_bottom_visible (Window* self)
{
	gboolean result = FALSE;
#line 71 "src/window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 72 "src/window.vala"
	result = self->all_displayed;
#line 72 "src/window.vala"
	return result;
#line 516 "window.c"
}

void
window_resync (Window* self)
{
	gsize n = 0UL;
	Buffer* _tmp0_;
	Buffer* _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	glong delta = 0L;
#line 75 "src/window.vala"
	g_return_if_fail (self != NULL);
#line 76 "src/window.vala"
	_tmp0_ = self->bp;
#line 76 "src/window.vala"
	_tmp1_ = self->bp;
#line 76 "src/window.vala"
	_tmp2_ = buffer_get_pt (_tmp1_);
#line 76 "src/window.vala"
	_tmp3_ = _tmp2_;
#line 76 "src/window.vala"
	n = buffer_offset_to_line (_tmp0_, _tmp3_);
#line 77 "src/window.vala"
	delta = (glong) (n - self->lastpointn);
#line 79 "src/window.vala"
	if (delta != ((glong) 0)) {
#line 544 "window.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 80 "src/window.vala"
		if (delta > ((glong) 0)) {
#line 80 "src/window.vala"
			_tmp5_ = (self->topdelta + delta) < self->eheight;
#line 551 "window.c"
		} else {
#line 80 "src/window.vala"
			_tmp5_ = FALSE;
#line 555 "window.c"
		}
#line 80 "src/window.vala"
		if (_tmp5_) {
#line 80 "src/window.vala"
			_tmp4_ = TRUE;
#line 561 "window.c"
		} else {
			gboolean _tmp6_ = FALSE;
#line 81 "src/window.vala"
			if (delta < ((glong) 0)) {
#line 81 "src/window.vala"
				_tmp6_ = self->topdelta >= ((gsize) (-delta));
#line 568 "window.c"
			} else {
#line 81 "src/window.vala"
				_tmp6_ = FALSE;
#line 572 "window.c"
			}
#line 81 "src/window.vala"
			_tmp4_ = _tmp6_;
#line 576 "window.c"
		}
#line 80 "src/window.vala"
		if (_tmp4_) {
#line 82 "src/window.vala"
			self->topdelta = self->topdelta + delta;
#line 582 "window.c"
		} else {
#line 83 "src/window.vala"
			if (n > (self->eheight / 2)) {
#line 84 "src/window.vala"
				self->topdelta = self->eheight / 2;
#line 588 "window.c"
			} else {
#line 86 "src/window.vala"
				self->topdelta = n;
#line 592 "window.c"
			}
		}
	}
#line 88 "src/window.vala"
	self->lastpointn = n;
#line 598 "window.c"
}

static gpointer
_buffer_ref0 (gpointer self)
{
#line 102 "src/window.vala"
	return self ? buffer_ref (self) : NULL;
#line 606 "window.c"
}

void
window_set_current (Window* self)
{
	Window* _tmp0_;
	Marker* _tmp1_;
	Window* _tmp4_;
	Marker* _tmp5_;
	Window* _tmp6_;
	Buffer* _tmp7_;
	Buffer* _tmp8_;
	Window* _tmp9_;
	Marker* _tmp10_;
#line 94 "src/window.vala"
	g_return_if_fail (self != NULL);
#line 96 "src/window.vala"
	_tmp0_ = cur_wp;
#line 96 "src/window.vala"
	_tmp1_ = _tmp0_->saved_pt;
#line 96 "src/window.vala"
	if (_tmp1_ != NULL) {
#line 629 "window.c"
		Window* _tmp2_;
		Marker* _tmp3_;
#line 97 "src/window.vala"
		_tmp2_ = cur_wp;
#line 97 "src/window.vala"
		_tmp3_ = _tmp2_->saved_pt;
#line 97 "src/window.vala"
		marker_unchain (_tmp3_);
#line 638 "window.c"
	}
#line 99 "src/window.vala"
	_tmp4_ = cur_wp;
#line 99 "src/window.vala"
	_tmp5_ = marker_point ();
#line 99 "src/window.vala"
	_marker_unref0 (_tmp4_->saved_pt);
#line 99 "src/window.vala"
	_tmp4_->saved_pt = _tmp5_;
#line 101 "src/window.vala"
	_tmp6_ = _window_ref0 (self);
#line 101 "src/window.vala"
	_window_unref0 (cur_wp);
#line 101 "src/window.vala"
	cur_wp = _tmp6_;
#line 102 "src/window.vala"
	_tmp7_ = self->bp;
#line 102 "src/window.vala"
	_tmp8_ = _buffer_ref0 (_tmp7_);
#line 102 "src/window.vala"
	_buffer_unref0 (cur_bp);
#line 102 "src/window.vala"
	cur_bp = _tmp8_;
#line 106 "src/window.vala"
	_tmp9_ = cur_wp;
#line 106 "src/window.vala"
	_tmp10_ = _tmp9_->saved_pt;
#line 106 "src/window.vala"
	if (_tmp10_ != NULL) {
#line 668 "window.c"
		Buffer* _tmp11_;
		Window* _tmp12_;
		Marker* _tmp13_;
		gsize _tmp14_;
		gsize _tmp15_;
		Window* _tmp16_;
		Marker* _tmp17_;
		Window* _tmp18_;
#line 107 "src/window.vala"
		_tmp11_ = cur_bp;
#line 107 "src/window.vala"
		_tmp12_ = cur_wp;
#line 107 "src/window.vala"
		_tmp13_ = _tmp12_->saved_pt;
#line 107 "src/window.vala"
		_tmp14_ = marker_get_o (_tmp13_);
#line 107 "src/window.vala"
		_tmp15_ = _tmp14_;
#line 107 "src/window.vala"
		buffer_goto_offset (_tmp11_, _tmp15_);
#line 108 "src/window.vala"
		_tmp16_ = cur_wp;
#line 108 "src/window.vala"
		_tmp17_ = _tmp16_->saved_pt;
#line 108 "src/window.vala"
		marker_unchain (_tmp17_);
#line 109 "src/window.vala"
		_tmp18_ = cur_wp;
#line 109 "src/window.vala"
		_marker_unref0 (_tmp18_->saved_pt);
#line 109 "src/window.vala"
		_tmp18_->saved_pt = NULL;
#line 701 "window.c"
	}
}

void
window_delete (Window* self)
{
	Window* wp = NULL;
	Window* _tmp0_;
	Window* _tmp20_;
	Marker* _tmp26_;
#line 113 "src/window.vala"
	g_return_if_fail (self != NULL);
#line 116 "src/window.vala"
	_tmp0_ = head_wp;
#line 116 "src/window.vala"
	if (self == _tmp0_) {
#line 718 "window.c"
		Window* _tmp1_;
		Window* _tmp2_;
		Window* _tmp3_;
		Window* _tmp4_;
		Window* _tmp5_;
#line 117 "src/window.vala"
		_tmp1_ = head_wp;
#line 117 "src/window.vala"
		_tmp2_ = _tmp1_->next;
#line 117 "src/window.vala"
		_tmp3_ = _window_ref0 (_tmp2_);
#line 117 "src/window.vala"
		_window_unref0 (head_wp);
#line 117 "src/window.vala"
		head_wp = _tmp3_;
#line 117 "src/window.vala"
		_tmp4_ = head_wp;
#line 117 "src/window.vala"
		_tmp5_ = _window_ref0 (_tmp4_);
#line 117 "src/window.vala"
		_window_unref0 (wp);
#line 117 "src/window.vala"
		wp = _tmp5_;
#line 742 "window.c"
	} else {
		{
			Window* _tmp6_;
			Window* _tmp7_;
			gboolean _tmp8_ = FALSE;
#line 119 "src/window.vala"
			_tmp6_ = head_wp;
#line 119 "src/window.vala"
			_tmp7_ = _window_ref0 (_tmp6_);
#line 119 "src/window.vala"
			_window_unref0 (wp);
#line 119 "src/window.vala"
			wp = _tmp7_;
#line 119 "src/window.vala"
			_tmp8_ = TRUE;
#line 119 "src/window.vala"
			while (TRUE) {
#line 760 "window.c"
				Window* _tmp12_;
				Window* _tmp13_;
				Window* _tmp14_;
#line 119 "src/window.vala"
				if (!_tmp8_) {
#line 766 "window.c"
					Window* _tmp9_;
					Window* _tmp10_;
					Window* _tmp11_;
#line 119 "src/window.vala"
					_tmp9_ = wp;
#line 119 "src/window.vala"
					_tmp10_ = _tmp9_->next;
#line 119 "src/window.vala"
					_tmp11_ = _window_ref0 (_tmp10_);
#line 119 "src/window.vala"
					_window_unref0 (wp);
#line 119 "src/window.vala"
					wp = _tmp11_;
#line 780 "window.c"
				}
#line 119 "src/window.vala"
				_tmp8_ = FALSE;
#line 119 "src/window.vala"
				_tmp12_ = wp;
#line 119 "src/window.vala"
				if (!(_tmp12_ != NULL)) {
#line 119 "src/window.vala"
					break;
#line 790 "window.c"
				}
#line 120 "src/window.vala"
				_tmp13_ = wp;
#line 120 "src/window.vala"
				_tmp14_ = _tmp13_->next;
#line 120 "src/window.vala"
				if (_tmp14_ == self) {
#line 798 "window.c"
					Window* _tmp15_;
					Window* _tmp16_;
					Window* _tmp17_;
					Window* _tmp18_;
					Window* _tmp19_;
#line 121 "src/window.vala"
					_tmp15_ = wp;
#line 121 "src/window.vala"
					_tmp16_ = wp;
#line 121 "src/window.vala"
					_tmp17_ = _tmp16_->next;
#line 121 "src/window.vala"
					_tmp18_ = _tmp17_->next;
#line 121 "src/window.vala"
					_tmp19_ = _window_ref0 (_tmp18_);
#line 121 "src/window.vala"
					_window_unref0 (_tmp15_->next);
#line 121 "src/window.vala"
					_tmp15_->next = _tmp19_;
#line 122 "src/window.vala"
					break;
#line 820 "window.c"
				}
			}
		}
	}
#line 125 "src/window.vala"
	_tmp20_ = wp;
#line 125 "src/window.vala"
	if (_tmp20_ != NULL) {
#line 829 "window.c"
		Window* _tmp21_;
		Window* _tmp22_;
		Window* _tmp23_;
		Window* _tmp24_;
		Window* _tmp25_;
#line 126 "src/window.vala"
		_tmp21_ = wp;
#line 126 "src/window.vala"
		_tmp22_ = wp;
#line 126 "src/window.vala"
		_tmp22_->fheight = _tmp22_->fheight + self->fheight;
#line 127 "src/window.vala"
		_tmp23_ = wp;
#line 127 "src/window.vala"
		_tmp24_ = wp;
#line 127 "src/window.vala"
		_tmp24_->eheight = _tmp24_->eheight + (self->eheight + 1);
#line 128 "src/window.vala"
		_tmp25_ = wp;
#line 128 "src/window.vala"
		window_set_current (_tmp25_);
#line 851 "window.c"
	}
#line 131 "src/window.vala"
	_tmp26_ = self->saved_pt;
#line 131 "src/window.vala"
	if (_tmp26_ != NULL) {
#line 857 "window.c"
		Marker* _tmp27_;
#line 132 "src/window.vala"
		_tmp27_ = self->saved_pt;
#line 132 "src/window.vala"
		marker_unchain (_tmp27_);
#line 863 "window.c"
	}
#line 113 "src/window.vala"
	_window_unref0 (wp);
#line 867 "window.c"
}

Window*
window_construct (GType object_type)
{
	Window* self = NULL;
#line 28 "src/window.vala"
	self = (Window*) g_type_create_instance (object_type);
#line 28 "src/window.vala"
	return self;
#line 878 "window.c"
}

Window*
window_new (void)
{
#line 28 "src/window.vala"
	return window_construct (TYPE_WINDOW);
#line 886 "window.c"
}

static void
value_window_init (GValue* value)
{
#line 28 "src/window.vala"
	value->data[0].v_pointer = NULL;
#line 894 "window.c"
}

static void
value_window_free_value (GValue* value)
{
#line 28 "src/window.vala"
	if (value->data[0].v_pointer) {
#line 28 "src/window.vala"
		window_unref (value->data[0].v_pointer);
#line 904 "window.c"
	}
}

static void
value_window_copy_value (const GValue* src_value,
                         GValue* dest_value)
{
#line 28 "src/window.vala"
	if (src_value->data[0].v_pointer) {
#line 28 "src/window.vala"
		dest_value->data[0].v_pointer = window_ref (src_value->data[0].v_pointer);
#line 916 "window.c"
	} else {
#line 28 "src/window.vala"
		dest_value->data[0].v_pointer = NULL;
#line 920 "window.c"
	}
}

static gpointer
value_window_peek_pointer (const GValue* value)
{
#line 28 "src/window.vala"
	return value->data[0].v_pointer;
#line 929 "window.c"
}

static gchar*
value_window_collect_value (GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
#line 28 "src/window.vala"
	if (collect_values[0].v_pointer) {
#line 940 "window.c"
		Window * object;
		object = collect_values[0].v_pointer;
#line 28 "src/window.vala"
		if (object->parent_instance.g_class == NULL) {
#line 28 "src/window.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 947 "window.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 28 "src/window.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 951 "window.c"
		}
#line 28 "src/window.vala"
		value->data[0].v_pointer = window_ref (object);
#line 955 "window.c"
	} else {
#line 28 "src/window.vala"
		value->data[0].v_pointer = NULL;
#line 959 "window.c"
	}
#line 28 "src/window.vala"
	return NULL;
#line 963 "window.c"
}

static gchar*
value_window_lcopy_value (const GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	Window ** object_p;
	object_p = collect_values[0].v_pointer;
#line 28 "src/window.vala"
	if (!object_p) {
#line 28 "src/window.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 978 "window.c"
	}
#line 28 "src/window.vala"
	if (!value->data[0].v_pointer) {
#line 28 "src/window.vala"
		*object_p = NULL;
#line 984 "window.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 28 "src/window.vala"
		*object_p = value->data[0].v_pointer;
#line 988 "window.c"
	} else {
#line 28 "src/window.vala"
		*object_p = window_ref (value->data[0].v_pointer);
#line 992 "window.c"
	}
#line 28 "src/window.vala"
	return NULL;
#line 996 "window.c"
}

GParamSpec*
param_spec_window (const gchar* name,
                   const gchar* nick,
                   const gchar* blurb,
                   GType object_type,
                   GParamFlags flags)
{
	ParamSpecWindow* spec;
#line 28 "src/window.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_WINDOW), NULL);
#line 28 "src/window.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 28 "src/window.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 28 "src/window.vala"
	return G_PARAM_SPEC (spec);
#line 1015 "window.c"
}

gpointer
value_get_window (const GValue* value)
{
#line 28 "src/window.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WINDOW), NULL);
#line 28 "src/window.vala"
	return value->data[0].v_pointer;
#line 1025 "window.c"
}

void
value_set_window (GValue* value,
                  gpointer v_object)
{
	Window * old;
#line 28 "src/window.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WINDOW));
#line 28 "src/window.vala"
	old = value->data[0].v_pointer;
#line 28 "src/window.vala"
	if (v_object) {
#line 28 "src/window.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_WINDOW));
#line 28 "src/window.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "src/window.vala"
		value->data[0].v_pointer = v_object;
#line 28 "src/window.vala"
		window_ref (value->data[0].v_pointer);
#line 1047 "window.c"
	} else {
#line 28 "src/window.vala"
		value->data[0].v_pointer = NULL;
#line 1051 "window.c"
	}
#line 28 "src/window.vala"
	if (old) {
#line 28 "src/window.vala"
		window_unref (old);
#line 1057 "window.c"
	}
}

void
value_take_window (GValue* value,
                   gpointer v_object)
{
	Window * old;
#line 28 "src/window.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WINDOW));
#line 28 "src/window.vala"
	old = value->data[0].v_pointer;
#line 28 "src/window.vala"
	if (v_object) {
#line 28 "src/window.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_WINDOW));
#line 28 "src/window.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "src/window.vala"
		value->data[0].v_pointer = v_object;
#line 1078 "window.c"
	} else {
#line 28 "src/window.vala"
		value->data[0].v_pointer = NULL;
#line 1082 "window.c"
	}
#line 28 "src/window.vala"
	if (old) {
#line 28 "src/window.vala"
		window_unref (old);
#line 1088 "window.c"
	}
}

static void
window_class_init (WindowClass * klass,
                   gpointer klass_data)
{
#line 28 "src/window.vala"
	window_parent_class = g_type_class_peek_parent (klass);
#line 28 "src/window.vala"
	((WindowClass *) klass)->finalize = window_finalize;
#line 1100 "window.c"
}

static void
window_instance_init (Window * self,
                      gpointer klass)
{
#line 28 "src/window.vala"
	self->ref_count = 1;
#line 1109 "window.c"
}

static void
window_finalize (Window * obj)
{
	Window * self;
#line 28 "src/window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WINDOW, Window);
#line 28 "src/window.vala"
	g_signal_handlers_destroy (self);
#line 29 "src/window.vala"
	_window_unref0 (self->next);
#line 30 "src/window.vala"
	_buffer_unref0 (self->bp);
#line 34 "src/window.vala"
	_marker_unref0 (self->saved_pt);
#line 1126 "window.c"
}

static GType
window_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_window_init, value_window_free_value, value_window_copy_value, value_window_peek_pointer, "p", value_window_collect_value, "p", value_window_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (WindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Window), 0, (GInstanceInitFunc) window_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType window_type_id;
	window_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Window", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return window_type_id;
}

GType
window_get_type (void)
{
	static volatile gsize window_type_id__volatile = 0;
	if (g_once_init_enter (&window_type_id__volatile)) {
		GType window_type_id;
		window_type_id = window_get_type_once ();
		g_once_init_leave (&window_type_id__volatile, window_type_id);
	}
	return window_type_id__volatile;
}

gpointer
window_ref (gpointer instance)
{
	Window * self;
	self = instance;
#line 28 "src/window.vala"
	g_atomic_int_inc (&self->ref_count);
#line 28 "src/window.vala"
	return instance;
#line 1161 "window.c"
}

void
window_unref (gpointer instance)
{
	Window * self;
	self = instance;
#line 28 "src/window.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 28 "src/window.vala"
		WINDOW_GET_CLASS (self)->finalize (self);
#line 28 "src/window.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1175 "window.c"
	}
}

void
create_scratch_window (void)
{
	Buffer* bp = NULL;
	Buffer* _tmp0_;
	Window* wp = NULL;
	Window* _tmp1_;
	Window* _tmp2_;
	Window* _tmp3_;
	Window* _tmp4_;
	Buffer* _tmp5_;
	Buffer* _tmp6_;
	Buffer* _tmp7_;
#line 141 "src/window.vala"
	_tmp0_ = create_scratch_buffer ();
#line 141 "src/window.vala"
	bp = _tmp0_;
#line 142 "src/window.vala"
	_tmp1_ = window_new ();
#line 142 "src/window.vala"
	wp = _tmp1_;
#line 143 "src/window.vala"
	_tmp2_ = _window_ref0 (wp);
#line 143 "src/window.vala"
	_window_unref0 (head_wp);
#line 143 "src/window.vala"
	head_wp = _tmp2_;
#line 143 "src/window.vala"
	_tmp3_ = head_wp;
#line 143 "src/window.vala"
	_tmp4_ = _window_ref0 (_tmp3_);
#line 143 "src/window.vala"
	_window_unref0 (cur_wp);
#line 143 "src/window.vala"
	cur_wp = _tmp4_;
#line 144 "src/window.vala"
	wp->ewidth = term_width ();
#line 144 "src/window.vala"
	wp->fwidth = wp->ewidth;
#line 146 "src/window.vala"
	wp->fheight = term_height () - 1;
#line 148 "src/window.vala"
	wp->eheight = wp->fheight - 1;
#line 149 "src/window.vala"
	_tmp5_ = _buffer_ref0 (bp);
#line 149 "src/window.vala"
	_buffer_unref0 (cur_bp);
#line 149 "src/window.vala"
	cur_bp = _tmp5_;
#line 149 "src/window.vala"
	_tmp6_ = cur_bp;
#line 149 "src/window.vala"
	_tmp7_ = _buffer_ref0 (_tmp6_);
#line 149 "src/window.vala"
	_buffer_unref0 (wp->bp);
#line 149 "src/window.vala"
	wp->bp = _tmp7_;
#line 140 "src/window.vala"
	_window_unref0 (wp);
#line 140 "src/window.vala"
	_buffer_unref0 (bp);
#line 1240 "window.c"
}

Window*
popup_window (void)
{
	gboolean _tmp0_ = FALSE;
	Window* _tmp1_;
	Window* _tmp7_ = NULL;
	Window* _tmp8_;
	Window* _tmp9_;
	Window* _tmp11_;
	Window* result = NULL;
#line 153 "src/window.vala"
	_tmp1_ = head_wp;
#line 153 "src/window.vala"
	if (_tmp1_ != NULL) {
#line 1257 "window.c"
		Window* _tmp2_;
		Window* _tmp3_;
#line 153 "src/window.vala"
		_tmp2_ = head_wp;
#line 153 "src/window.vala"
		_tmp3_ = _tmp2_->next;
#line 153 "src/window.vala"
		_tmp0_ = _tmp3_ == NULL;
#line 1266 "window.c"
	} else {
#line 153 "src/window.vala"
		_tmp0_ = FALSE;
#line 1270 "window.c"
	}
#line 153 "src/window.vala"
	if (_tmp0_) {
#line 1274 "window.c"
		Window* _tmp4_;
		Window* _tmp5_;
		Window* _tmp6_;
#line 155 "src/window.vala"
		funcall ("split-window", NULL, NULL);
#line 156 "src/window.vala"
		_tmp4_ = cur_wp;
#line 156 "src/window.vala"
		_tmp5_ = _tmp4_->next;
#line 156 "src/window.vala"
		_tmp6_ = _window_ref0 (_tmp5_);
#line 156 "src/window.vala"
		result = _tmp6_;
#line 156 "src/window.vala"
		return result;
#line 1290 "window.c"
	}
#line 160 "src/window.vala"
	_tmp8_ = cur_wp;
#line 160 "src/window.vala"
	_tmp9_ = _tmp8_->next;
#line 160 "src/window.vala"
	_tmp7_ = _tmp9_;
#line 160 "src/window.vala"
	if (_tmp7_ == NULL) {
#line 1300 "window.c"
		Window* _tmp10_;
#line 160 "src/window.vala"
		_tmp10_ = head_wp;
#line 160 "src/window.vala"
		_tmp7_ = _tmp10_;
#line 1306 "window.c"
	}
#line 160 "src/window.vala"
	_tmp11_ = _window_ref0 (_tmp7_);
#line 160 "src/window.vala"
	result = _tmp11_;
#line 160 "src/window.vala"
	return result;
#line 1314 "window.c"
}

static gpointer
_marker_ref0 (gpointer self)
{
#line 181 "src/window.vala"
	return self ? marker_ref (self) : NULL;
#line 1322 "window.c"
}

static gboolean
__lambda137_ (glong uniarg,
              GeeQueue* args)
{
	Window* _tmp0_;
	Window* newwp = NULL;
	Window* _tmp2_;
	Window* _tmp3_;
	Window* _tmp4_;
	Window* _tmp5_;
	Window* _tmp6_;
	Window* _tmp7_;
	Window* _tmp8_;
	Buffer* _tmp9_;
	Buffer* _tmp10_;
	Window* _tmp11_;
	Window* _tmp12_;
	Window* _tmp13_;
	Window* _tmp14_;
	Window* _tmp15_;
	Window* _tmp16_;
	Marker* _tmp17_;
	Marker* _tmp18_;
	Window* _tmp19_;
	Window* _tmp20_;
	Window* _tmp21_;
	Window* _tmp22_;
	Window* _tmp23_;
	Window* _tmp24_;
	Window* _tmp25_;
	Window* _tmp26_;
	Window* _tmp27_;
	Window* _tmp28_;
	Window* _tmp29_;
	Window* _tmp30_;
	Window* _tmp31_;
	Window* _tmp32_;
	Window* _tmp33_;
	Window* _tmp34_;
	Window* _tmp35_;
	Window* _tmp36_;
	Marker* _tmp37_;
	Window* _tmp38_;
	Window* _tmp39_;
	Window* _tmp40_;
	Window* _tmp41_;
	Window* _tmp42_;
	Window* _tmp43_;
	Window* _tmp44_;
	Window* _tmp45_;
	Window* _tmp46_;
	gboolean result = FALSE;
#line 169 "src/window.vala"
	_tmp0_ = cur_wp;
#line 169 "src/window.vala"
	if (_tmp0_->fheight < ((gsize) 4)) {
#line 1381 "window.c"
		Window* _tmp1_;
#line 170 "src/window.vala"
		_tmp1_ = cur_wp;
#line 170 "src/window.vala"
		minibuf_error ("Window height %zu too small (after splitting)", _tmp1_->fheight, NULL);
#line 172 "src/window.vala"
		result = FALSE;
#line 172 "src/window.vala"
		return result;
#line 1391 "window.c"
	}
#line 176 "src/window.vala"
	_tmp2_ = window_new ();
#line 176 "src/window.vala"
	newwp = _tmp2_;
#line 177 "src/window.vala"
	_tmp3_ = newwp;
#line 177 "src/window.vala"
	_tmp4_ = cur_wp;
#line 177 "src/window.vala"
	_tmp5_ = _tmp4_->next;
#line 177 "src/window.vala"
	_tmp6_ = _window_ref0 (_tmp5_);
#line 177 "src/window.vala"
	_window_unref0 (_tmp3_->next);
#line 177 "src/window.vala"
	_tmp3_->next = _tmp6_;
#line 178 "src/window.vala"
	_tmp7_ = newwp;
#line 178 "src/window.vala"
	_tmp8_ = cur_wp;
#line 178 "src/window.vala"
	_tmp9_ = _tmp8_->bp;
#line 178 "src/window.vala"
	_tmp10_ = _buffer_ref0 (_tmp9_);
#line 178 "src/window.vala"
	_buffer_unref0 (_tmp7_->bp);
#line 178 "src/window.vala"
	_tmp7_->bp = _tmp10_;
#line 179 "src/window.vala"
	_tmp11_ = newwp;
#line 179 "src/window.vala"
	_tmp12_ = cur_wp;
#line 179 "src/window.vala"
	_tmp11_->topdelta = _tmp12_->topdelta;
#line 180 "src/window.vala"
	_tmp13_ = newwp;
#line 180 "src/window.vala"
	_tmp14_ = cur_wp;
#line 180 "src/window.vala"
	_tmp13_->start_column = _tmp14_->start_column;
#line 181 "src/window.vala"
	_tmp15_ = newwp;
#line 181 "src/window.vala"
	_tmp16_ = cur_wp;
#line 181 "src/window.vala"
	_tmp17_ = _tmp16_->saved_pt;
#line 181 "src/window.vala"
	_tmp18_ = _marker_ref0 (_tmp17_);
#line 181 "src/window.vala"
	_marker_unref0 (_tmp15_->saved_pt);
#line 181 "src/window.vala"
	_tmp15_->saved_pt = _tmp18_;
#line 182 "src/window.vala"
	_tmp19_ = newwp;
#line 182 "src/window.vala"
	_tmp20_ = cur_wp;
#line 182 "src/window.vala"
	_tmp19_->fwidth = _tmp20_->fwidth;
#line 183 "src/window.vala"
	_tmp21_ = newwp;
#line 183 "src/window.vala"
	_tmp22_ = cur_wp;
#line 183 "src/window.vala"
	_tmp21_->fheight = _tmp22_->fheight;
#line 184 "src/window.vala"
	_tmp23_ = newwp;
#line 184 "src/window.vala"
	_tmp24_ = cur_wp;
#line 184 "src/window.vala"
	_tmp23_->ewidth = _tmp24_->ewidth;
#line 185 "src/window.vala"
	_tmp25_ = newwp;
#line 185 "src/window.vala"
	_tmp26_ = cur_wp;
#line 185 "src/window.vala"
	_tmp25_->eheight = _tmp26_->eheight;
#line 186 "src/window.vala"
	_tmp27_ = newwp;
#line 186 "src/window.vala"
	_tmp28_ = cur_wp;
#line 186 "src/window.vala"
	_tmp27_->all_displayed = _tmp28_->all_displayed;
#line 187 "src/window.vala"
	_tmp29_ = newwp;
#line 187 "src/window.vala"
	_tmp30_ = cur_wp;
#line 187 "src/window.vala"
	_tmp29_->lastpointn = _tmp30_->lastpointn;
#line 190 "src/window.vala"
	_tmp31_ = newwp;
#line 190 "src/window.vala"
	_tmp32_ = cur_wp;
#line 190 "src/window.vala"
	_tmp33_ = cur_wp;
#line 190 "src/window.vala"
	_tmp31_->fheight = (_tmp32_->fheight / 2) + (_tmp33_->fheight % 2);
#line 191 "src/window.vala"
	_tmp34_ = newwp;
#line 191 "src/window.vala"
	_tmp35_ = newwp;
#line 191 "src/window.vala"
	_tmp34_->eheight = _tmp35_->fheight - 1;
#line 192 "src/window.vala"
	_tmp36_ = newwp;
#line 192 "src/window.vala"
	_tmp37_ = marker_point ();
#line 192 "src/window.vala"
	_marker_unref0 (_tmp36_->saved_pt);
#line 192 "src/window.vala"
	_tmp36_->saved_pt = _tmp37_;
#line 195 "src/window.vala"
	_tmp38_ = cur_wp;
#line 195 "src/window.vala"
	_tmp39_ = newwp;
#line 195 "src/window.vala"
	_tmp40_ = _window_ref0 (_tmp39_);
#line 195 "src/window.vala"
	_window_unref0 (_tmp38_->next);
#line 195 "src/window.vala"
	_tmp38_->next = _tmp40_;
#line 196 "src/window.vala"
	_tmp41_ = cur_wp;
#line 196 "src/window.vala"
	_tmp42_ = cur_wp;
#line 196 "src/window.vala"
	_tmp41_->fheight = _tmp42_->fheight / 2;
#line 197 "src/window.vala"
	_tmp43_ = cur_wp;
#line 197 "src/window.vala"
	_tmp44_ = cur_wp;
#line 197 "src/window.vala"
	_tmp43_->eheight = _tmp44_->fheight - 1;
#line 198 "src/window.vala"
	_tmp45_ = cur_wp;
#line 198 "src/window.vala"
	_tmp46_ = cur_wp;
#line 198 "src/window.vala"
	if (_tmp45_->topdelta >= _tmp46_->eheight) {
#line 1531 "window.c"
		Window* _tmp47_;
#line 199 "src/window.vala"
		_tmp47_ = cur_wp;
#line 199 "src/window.vala"
		recenter (_tmp47_);
#line 1537 "window.c"
	}
#line 201 "src/window.vala"
	result = TRUE;
#line 201 "src/window.vala"
	_window_unref0 (newwp);
#line 201 "src/window.vala"
	return result;
#line 1545 "window.c"
}

static gboolean
___lambda137__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda137_ (uniarg, args);
#line 165 "src/window.vala"
	return result;
#line 1556 "window.c"
}

static gboolean
__lambda138_ (glong uniarg,
              GeeQueue* args)
{
	gboolean _tmp0_ = FALSE;
	Window* _tmp1_;
	Window* _tmp2_;
	Window* _tmp5_;
	gboolean result = FALSE;
#line 211 "src/window.vala"
	_tmp1_ = cur_wp;
#line 211 "src/window.vala"
	_tmp2_ = head_wp;
#line 211 "src/window.vala"
	if (_tmp1_ == _tmp2_) {
#line 1574 "window.c"
		Window* _tmp3_;
		Window* _tmp4_;
#line 211 "src/window.vala"
		_tmp3_ = cur_wp;
#line 211 "src/window.vala"
		_tmp4_ = _tmp3_->next;
#line 211 "src/window.vala"
		_tmp0_ = _tmp4_ == NULL;
#line 1583 "window.c"
	} else {
#line 211 "src/window.vala"
		_tmp0_ = FALSE;
#line 1587 "window.c"
	}
#line 211 "src/window.vala"
	if (_tmp0_) {
#line 212 "src/window.vala"
		minibuf_error ("Attempt to delete sole ordinary window", NULL);
#line 213 "src/window.vala"
		result = FALSE;
#line 213 "src/window.vala"
		return result;
#line 1597 "window.c"
	}
#line 216 "src/window.vala"
	_tmp5_ = cur_wp;
#line 216 "src/window.vala"
	window_delete (_tmp5_);
#line 217 "src/window.vala"
	result = TRUE;
#line 217 "src/window.vala"
	return result;
#line 1607 "window.c"
}

static gboolean
___lambda138__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda138_ (uniarg, args);
#line 208 "src/window.vala"
	return result;
#line 1618 "window.c"
}

static gboolean
__lambda139_ (glong uniarg,
              GeeQueue* args)
{
	gboolean _tmp0_ = FALSE;
	Window* _tmp1_;
	Window* _tmp2_;
	Window* wp = NULL;
	Window* _tmp8_;
	Window* _tmp9_;
	Window* _tmp10_;
	gboolean _tmp11_ = FALSE;
	Window* _tmp12_;
	Window* _tmp25_;
	Window* _tmp26_;
	gsize _tmp27_;
	Window* _tmp28_;
	gsize _tmp29_;
	Window* _tmp30_;
	Window* _tmp31_;
	Window* _tmp33_;
	gsize _tmp34_;
	Window* _tmp35_;
	gsize _tmp36_;
	gboolean result = FALSE;
#line 226 "src/window.vala"
	_tmp1_ = cur_wp;
#line 226 "src/window.vala"
	_tmp2_ = head_wp;
#line 226 "src/window.vala"
	if (_tmp1_ == _tmp2_) {
#line 1652 "window.c"
		gboolean _tmp3_ = FALSE;
		Window* _tmp4_;
		Window* _tmp5_;
#line 226 "src/window.vala"
		_tmp4_ = cur_wp;
#line 226 "src/window.vala"
		_tmp5_ = _tmp4_->next;
#line 226 "src/window.vala"
		if (_tmp5_ == NULL) {
#line 226 "src/window.vala"
			_tmp3_ = TRUE;
#line 1664 "window.c"
		} else {
			Window* _tmp6_;
			Window* _tmp7_;
#line 226 "src/window.vala"
			_tmp6_ = cur_wp;
#line 226 "src/window.vala"
			_tmp7_ = _tmp6_->next;
#line 226 "src/window.vala"
			_tmp3_ = _tmp7_->fheight < ((gsize) 3);
#line 1674 "window.c"
		}
#line 226 "src/window.vala"
		_tmp0_ = _tmp3_;
#line 1678 "window.c"
	} else {
#line 226 "src/window.vala"
		_tmp0_ = FALSE;
#line 1682 "window.c"
	}
#line 226 "src/window.vala"
	if (_tmp0_) {
#line 227 "src/window.vala"
		result = FALSE;
#line 227 "src/window.vala"
		return result;
#line 1690 "window.c"
	}
#line 229 "src/window.vala"
	_tmp8_ = cur_wp;
#line 229 "src/window.vala"
	_tmp9_ = _tmp8_->next;
#line 229 "src/window.vala"
	_tmp10_ = _window_ref0 (_tmp9_);
#line 229 "src/window.vala"
	wp = _tmp10_;
#line 230 "src/window.vala"
	_tmp12_ = wp;
#line 230 "src/window.vala"
	if (_tmp12_ == NULL) {
#line 230 "src/window.vala"
		_tmp11_ = TRUE;
#line 1706 "window.c"
	} else {
		Window* _tmp13_;
#line 230 "src/window.vala"
		_tmp13_ = wp;
#line 230 "src/window.vala"
		_tmp11_ = _tmp13_->fheight < ((gsize) 3);
#line 1713 "window.c"
	}
#line 230 "src/window.vala"
	if (_tmp11_) {
#line 1717 "window.c"
		{
			Window* _tmp14_;
			Window* _tmp15_;
			gboolean _tmp16_ = FALSE;
#line 231 "src/window.vala"
			_tmp14_ = head_wp;
#line 231 "src/window.vala"
			_tmp15_ = _window_ref0 (_tmp14_);
#line 231 "src/window.vala"
			_window_unref0 (wp);
#line 231 "src/window.vala"
			wp = _tmp15_;
#line 231 "src/window.vala"
			_tmp16_ = TRUE;
#line 231 "src/window.vala"
			while (TRUE) {
#line 1734 "window.c"
				Window* _tmp20_;
				Window* _tmp21_;
				Window* _tmp22_;
				Window* _tmp23_;
#line 231 "src/window.vala"
				if (!_tmp16_) {
#line 1741 "window.c"
					Window* _tmp17_;
					Window* _tmp18_;
					Window* _tmp19_;
#line 231 "src/window.vala"
					_tmp17_ = wp;
#line 231 "src/window.vala"
					_tmp18_ = _tmp17_->next;
#line 231 "src/window.vala"
					_tmp19_ = _window_ref0 (_tmp18_);
#line 231 "src/window.vala"
					_window_unref0 (wp);
#line 231 "src/window.vala"
					wp = _tmp19_;
#line 1755 "window.c"
				}
#line 231 "src/window.vala"
				_tmp16_ = FALSE;
#line 231 "src/window.vala"
				_tmp20_ = wp;
#line 231 "src/window.vala"
				if (!(_tmp20_ != NULL)) {
#line 231 "src/window.vala"
					break;
#line 1765 "window.c"
				}
#line 232 "src/window.vala"
				_tmp21_ = wp;
#line 232 "src/window.vala"
				_tmp22_ = _tmp21_->next;
#line 232 "src/window.vala"
				_tmp23_ = cur_wp;
#line 232 "src/window.vala"
				if (_tmp22_ == _tmp23_) {
#line 1775 "window.c"
					Window* _tmp24_;
#line 233 "src/window.vala"
					_tmp24_ = wp;
#line 233 "src/window.vala"
					if (_tmp24_->fheight < ((gsize) 3)) {
#line 234 "src/window.vala"
						result = FALSE;
#line 234 "src/window.vala"
						_window_unref0 (wp);
#line 234 "src/window.vala"
						return result;
#line 1787 "window.c"
					}
#line 235 "src/window.vala"
					break;
#line 1791 "window.c"
				}
			}
		}
	}
#line 238 "src/window.vala"
	_tmp25_ = wp;
#line 238 "src/window.vala"
	_vala_assert (_tmp25_ != NULL, "wp != null");
#line 239 "src/window.vala"
	_tmp26_ = wp;
#line 239 "src/window.vala"
	_tmp26_->fheight = _tmp26_->fheight - 1;
#line 239 "src/window.vala"
	_tmp27_ = _tmp26_->fheight;
#line 240 "src/window.vala"
	_tmp28_ = wp;
#line 240 "src/window.vala"
	_tmp28_->eheight = _tmp28_->eheight - 1;
#line 240 "src/window.vala"
	_tmp29_ = _tmp28_->eheight;
#line 241 "src/window.vala"
	_tmp30_ = wp;
#line 241 "src/window.vala"
	_tmp31_ = wp;
#line 241 "src/window.vala"
	if (_tmp30_->topdelta >= _tmp31_->eheight) {
#line 1818 "window.c"
		Window* _tmp32_;
#line 242 "src/window.vala"
		_tmp32_ = wp;
#line 242 "src/window.vala"
		recenter (_tmp32_);
#line 1824 "window.c"
	}
#line 243 "src/window.vala"
	_tmp33_ = cur_wp;
#line 243 "src/window.vala"
	_tmp33_->fheight = _tmp33_->fheight + 1;
#line 243 "src/window.vala"
	_tmp34_ = _tmp33_->fheight;
#line 244 "src/window.vala"
	_tmp35_ = cur_wp;
#line 244 "src/window.vala"
	_tmp35_->eheight = _tmp35_->eheight + 1;
#line 244 "src/window.vala"
	_tmp36_ = _tmp35_->eheight;
#line 246 "src/window.vala"
	result = TRUE;
#line 246 "src/window.vala"
	_window_unref0 (wp);
#line 246 "src/window.vala"
	return result;
#line 1844 "window.c"
}

static gboolean
___lambda139__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda139_ (uniarg, args);
#line 223 "src/window.vala"
	return result;
#line 1855 "window.c"
}

static gboolean
__lambda140_ (glong uniarg,
              GeeQueue* args)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Window* _tmp2_;
	Window* _tmp3_;
	Window* wp = NULL;
	Window* _tmp7_;
	Window* _tmp8_;
	Window* _tmp9_;
	Window* _tmp10_;
	Window* _tmp21_;
	Window* _tmp22_;
	gsize _tmp23_;
	Window* _tmp24_;
	gsize _tmp25_;
	Window* _tmp26_;
	gsize _tmp27_;
	Window* _tmp28_;
	gsize _tmp29_;
	Window* _tmp30_;
	Window* _tmp31_;
	gboolean result = FALSE;
#line 255 "src/window.vala"
	_tmp2_ = cur_wp;
#line 255 "src/window.vala"
	_tmp3_ = head_wp;
#line 255 "src/window.vala"
	if (_tmp2_ == _tmp3_) {
#line 1889 "window.c"
		Window* _tmp4_;
		Window* _tmp5_;
#line 255 "src/window.vala"
		_tmp4_ = cur_wp;
#line 255 "src/window.vala"
		_tmp5_ = _tmp4_->next;
#line 255 "src/window.vala"
		_tmp1_ = _tmp5_ == NULL;
#line 1898 "window.c"
	} else {
#line 255 "src/window.vala"
		_tmp1_ = FALSE;
#line 1902 "window.c"
	}
#line 255 "src/window.vala"
	if (_tmp1_) {
#line 255 "src/window.vala"
		_tmp0_ = TRUE;
#line 1908 "window.c"
	} else {
		Window* _tmp6_;
#line 255 "src/window.vala"
		_tmp6_ = cur_wp;
#line 255 "src/window.vala"
		_tmp0_ = _tmp6_->fheight < ((gsize) 3);
#line 1915 "window.c"
	}
#line 255 "src/window.vala"
	if (_tmp0_) {
#line 256 "src/window.vala"
		result = FALSE;
#line 256 "src/window.vala"
		return result;
#line 1923 "window.c"
	}
#line 258 "src/window.vala"
	_tmp7_ = cur_wp;
#line 258 "src/window.vala"
	_tmp8_ = _tmp7_->next;
#line 258 "src/window.vala"
	_tmp9_ = _window_ref0 (_tmp8_);
#line 258 "src/window.vala"
	wp = _tmp9_;
#line 259 "src/window.vala"
	_tmp10_ = wp;
#line 259 "src/window.vala"
	if (_tmp10_ == NULL) {
#line 1937 "window.c"
		{
			Window* _tmp11_;
			Window* _tmp12_;
			gboolean _tmp13_ = FALSE;
#line 260 "src/window.vala"
			_tmp11_ = head_wp;
#line 260 "src/window.vala"
			_tmp12_ = _window_ref0 (_tmp11_);
#line 260 "src/window.vala"
			_window_unref0 (wp);
#line 260 "src/window.vala"
			wp = _tmp12_;
#line 260 "src/window.vala"
			_tmp13_ = TRUE;
#line 260 "src/window.vala"
			while (TRUE) {
#line 1954 "window.c"
				Window* _tmp17_;
				Window* _tmp18_;
				Window* _tmp19_;
				Window* _tmp20_;
#line 260 "src/window.vala"
				if (!_tmp13_) {
#line 1961 "window.c"
					Window* _tmp14_;
					Window* _tmp15_;
					Window* _tmp16_;
#line 260 "src/window.vala"
					_tmp14_ = wp;
#line 260 "src/window.vala"
					_tmp15_ = _tmp14_->next;
#line 260 "src/window.vala"
					_tmp16_ = _window_ref0 (_tmp15_);
#line 260 "src/window.vala"
					_window_unref0 (wp);
#line 260 "src/window.vala"
					wp = _tmp16_;
#line 1975 "window.c"
				}
#line 260 "src/window.vala"
				_tmp13_ = FALSE;
#line 260 "src/window.vala"
				_tmp17_ = wp;
#line 260 "src/window.vala"
				if (!(_tmp17_ != NULL)) {
#line 260 "src/window.vala"
					break;
#line 1985 "window.c"
				}
#line 261 "src/window.vala"
				_tmp18_ = wp;
#line 261 "src/window.vala"
				_tmp19_ = _tmp18_->next;
#line 261 "src/window.vala"
				_tmp20_ = cur_wp;
#line 261 "src/window.vala"
				if (_tmp19_ == _tmp20_) {
#line 262 "src/window.vala"
					break;
#line 1997 "window.c"
				}
			}
		}
	}
#line 264 "src/window.vala"
	_tmp21_ = wp;
#line 264 "src/window.vala"
	_vala_assert (_tmp21_ != NULL, "wp != null");
#line 265 "src/window.vala"
	_tmp22_ = wp;
#line 265 "src/window.vala"
	_tmp22_->fheight = _tmp22_->fheight + 1;
#line 265 "src/window.vala"
	_tmp23_ = _tmp22_->fheight;
#line 266 "src/window.vala"
	_tmp24_ = wp;
#line 266 "src/window.vala"
	_tmp24_->eheight = _tmp24_->eheight + 1;
#line 266 "src/window.vala"
	_tmp25_ = _tmp24_->eheight;
#line 267 "src/window.vala"
	_tmp26_ = cur_wp;
#line 267 "src/window.vala"
	_tmp26_->fheight = _tmp26_->fheight - 1;
#line 267 "src/window.vala"
	_tmp27_ = _tmp26_->fheight;
#line 268 "src/window.vala"
	_tmp28_ = cur_wp;
#line 268 "src/window.vala"
	_tmp28_->eheight = _tmp28_->eheight - 1;
#line 268 "src/window.vala"
	_tmp29_ = _tmp28_->eheight;
#line 269 "src/window.vala"
	_tmp30_ = cur_wp;
#line 269 "src/window.vala"
	_tmp31_ = cur_wp;
#line 269 "src/window.vala"
	if (_tmp30_->topdelta >= _tmp31_->eheight) {
#line 2036 "window.c"
		Window* _tmp32_;
#line 270 "src/window.vala"
		_tmp32_ = cur_wp;
#line 270 "src/window.vala"
		recenter (_tmp32_);
#line 2042 "window.c"
	}
#line 272 "src/window.vala"
	result = TRUE;
#line 272 "src/window.vala"
	_window_unref0 (wp);
#line 272 "src/window.vala"
	return result;
#line 2050 "window.c"
}

static gboolean
___lambda140__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda140_ (uniarg, args);
#line 252 "src/window.vala"
	return result;
#line 2061 "window.c"
}

static gboolean
__lambda141_ (glong uniarg,
              GeeQueue* args)
{
	gboolean result = FALSE;
	{
		Window* wp = NULL;
		Window* _tmp0_;
		Window* _tmp1_;
		Window* nextwp = NULL;
#line 281 "src/window.vala"
		_tmp0_ = head_wp;
#line 281 "src/window.vala"
		_tmp1_ = _window_ref0 (_tmp0_);
#line 281 "src/window.vala"
		wp = _tmp1_;
#line 281 "src/window.vala"
		nextwp = NULL;
#line 2082 "window.c"
		{
			gboolean _tmp2_ = FALSE;
#line 281 "src/window.vala"
			_tmp2_ = TRUE;
#line 281 "src/window.vala"
			while (TRUE) {
#line 2089 "window.c"
				Window* _tmp5_;
				Window* _tmp6_;
				Window* _tmp7_;
				Window* _tmp8_;
				Window* _tmp9_;
				Window* _tmp10_;
#line 281 "src/window.vala"
				if (!_tmp2_) {
#line 2098 "window.c"
					Window* _tmp3_;
					Window* _tmp4_;
#line 281 "src/window.vala"
					_tmp3_ = nextwp;
#line 281 "src/window.vala"
					_tmp4_ = _window_ref0 (_tmp3_);
#line 281 "src/window.vala"
					_window_unref0 (wp);
#line 281 "src/window.vala"
					wp = _tmp4_;
#line 2109 "window.c"
				}
#line 281 "src/window.vala"
				_tmp2_ = FALSE;
#line 281 "src/window.vala"
				_tmp5_ = wp;
#line 281 "src/window.vala"
				if (!(_tmp5_ != NULL)) {
#line 281 "src/window.vala"
					break;
#line 2119 "window.c"
				}
#line 282 "src/window.vala"
				_tmp6_ = wp;
#line 282 "src/window.vala"
				_tmp7_ = _tmp6_->next;
#line 282 "src/window.vala"
				_tmp8_ = _window_ref0 (_tmp7_);
#line 282 "src/window.vala"
				_window_unref0 (nextwp);
#line 282 "src/window.vala"
				nextwp = _tmp8_;
#line 283 "src/window.vala"
				_tmp9_ = wp;
#line 283 "src/window.vala"
				_tmp10_ = cur_wp;
#line 283 "src/window.vala"
				if (_tmp9_ != _tmp10_) {
#line 2137 "window.c"
					Window* _tmp11_;
#line 284 "src/window.vala"
					_tmp11_ = wp;
#line 284 "src/window.vala"
					window_delete (_tmp11_);
#line 2143 "window.c"
				}
			}
		}
#line 281 "src/window.vala"
		_window_unref0 (nextwp);
#line 281 "src/window.vala"
		_window_unref0 (wp);
#line 2151 "window.c"
	}
#line 286 "src/window.vala"
	result = TRUE;
#line 286 "src/window.vala"
	return result;
#line 2157 "window.c"
}

static gboolean
___lambda141__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda141_ (uniarg, args);
#line 278 "src/window.vala"
	return result;
#line 2168 "window.c"
}

static gboolean
__lambda142_ (glong uniarg,
              GeeQueue* args)
{
	Window* _tmp0_;
	Window* _tmp1_;
	gboolean result = FALSE;
#line 295 "src/window.vala"
	_tmp0_ = cur_wp;
#line 295 "src/window.vala"
	_tmp1_ = _tmp0_->next;
#line 295 "src/window.vala"
	if (_tmp1_ != NULL) {
#line 2184 "window.c"
		Window* _tmp2_;
		Window* _tmp3_;
#line 296 "src/window.vala"
		_tmp2_ = cur_wp;
#line 296 "src/window.vala"
		_tmp3_ = _tmp2_->next;
#line 296 "src/window.vala"
		window_set_current (_tmp3_);
#line 2193 "window.c"
	} else {
		Window* _tmp4_;
#line 298 "src/window.vala"
		_tmp4_ = head_wp;
#line 298 "src/window.vala"
		window_set_current (_tmp4_);
#line 2200 "window.c"
	}
#line 299 "src/window.vala"
	result = TRUE;
#line 299 "src/window.vala"
	return result;
#line 2206 "window.c"
}

static gboolean
___lambda142__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda142_ (uniarg, args);
#line 292 "src/window.vala"
	return result;
#line 2217 "window.c"
}

void
window_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
	LispFunc* _tmp6_;
	LispFunc* _tmp7_;
	LispFunc* _tmp8_;
	LispFunc* _tmp9_;
	LispFunc* _tmp10_;
	LispFunc* _tmp11_;
#line 165 "src/window.vala"
	_tmp0_ = lisp_func_new ("split-window", ___lambda137__function, TRUE, "Split current window into two windows, one above the other.\n" \
"\t\tBoth windows display the same buffer now current.");
#line 165 "src/window.vala"
	_tmp1_ = _tmp0_;
#line 165 "src/window.vala"
	_lisp_func_unref0 (_tmp1_);
#line 208 "src/window.vala"
	_tmp2_ = lisp_func_new ("delete-window", ___lambda138__function, TRUE, "Remove the current window from the screen.");
#line 208 "src/window.vala"
	_tmp3_ = _tmp2_;
#line 208 "src/window.vala"
	_lisp_func_unref0 (_tmp3_);
#line 223 "src/window.vala"
	_tmp4_ = lisp_func_new ("enlarge-window", ___lambda139__function, TRUE, "Make current window one line bigger.");
#line 223 "src/window.vala"
	_tmp5_ = _tmp4_;
#line 223 "src/window.vala"
	_lisp_func_unref0 (_tmp5_);
#line 252 "src/window.vala"
	_tmp6_ = lisp_func_new ("shrink-window", ___lambda140__function, TRUE, "Make current window one line smaller.");
#line 252 "src/window.vala"
	_tmp7_ = _tmp6_;
#line 252 "src/window.vala"
	_lisp_func_unref0 (_tmp7_);
#line 278 "src/window.vala"
	_tmp8_ = lisp_func_new ("delete-other-windows", ___lambda141__function, TRUE, "Make the selected window fill the screen.");
#line 278 "src/window.vala"
	_tmp9_ = _tmp8_;
#line 278 "src/window.vala"
	_lisp_func_unref0 (_tmp9_);
#line 292 "src/window.vala"
	_tmp10_ = lisp_func_new ("other-window", ___lambda142__function, TRUE, "Select the first different window on the screen.\n" \
"All windows are arranged in a cyclic order.\n" \
"This command selects the window one step away in that order.");
#line 292 "src/window.vala"
	_tmp11_ = _tmp10_;
#line 292 "src/window.vala"
	_lisp_func_unref0 (_tmp11_);
#line 2271 "window.c"
}

