package videosearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddSearchVideoTask invokes the videosearch.AddSearchVideoTask API synchronously
// api document: https://help.aliyun.com/api/videosearch/addsearchvideotask.html
func (client *Client) AddSearchVideoTask(request *AddSearchVideoTaskRequest) (response *AddSearchVideoTaskResponse, err error) {
	response = CreateAddSearchVideoTaskResponse()
	err = client.DoAction(request, response)
	return
}

// AddSearchVideoTaskWithChan invokes the videosearch.AddSearchVideoTask API asynchronously
// api document: https://help.aliyun.com/api/videosearch/addsearchvideotask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddSearchVideoTaskWithChan(request *AddSearchVideoTaskRequest) (<-chan *AddSearchVideoTaskResponse, <-chan error) {
	responseChan := make(chan *AddSearchVideoTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddSearchVideoTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddSearchVideoTaskWithCallback invokes the videosearch.AddSearchVideoTask API asynchronously
// api document: https://help.aliyun.com/api/videosearch/addsearchvideotask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddSearchVideoTaskWithCallback(request *AddSearchVideoTaskRequest, callback func(response *AddSearchVideoTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddSearchVideoTaskResponse
		var err error
		defer close(result)
		response, err = client.AddSearchVideoTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddSearchVideoTaskRequest is the request struct for api AddSearchVideoTask
type AddSearchVideoTaskRequest struct {
	*requests.RpcRequest
	ClientToken             string           `position:"Query" name:"ClientToken"`
	StorageType             requests.Integer `position:"Body" name:"StorageType"`
	VideoTags               string           `position:"Body" name:"VideoTags"`
	ReturnVideoNumber       requests.Integer `position:"Body" name:"ReturnVideoNumber"`
	VideoId                 string           `position:"Body" name:"VideoId"`
	ReplaceStorageThreshold requests.Float   `position:"Body" name:"ReplaceStorageThreshold"`
	InstanceId              string           `position:"Body" name:"InstanceId"`
	VideoUrl                string           `position:"Body" name:"VideoUrl"`
	QueryTags               string           `position:"Body" name:"QueryTags"`
	CallbackUrl             string           `position:"Body" name:"CallbackUrl"`
}

// AddSearchVideoTaskResponse is the response struct for api AddSearchVideoTask
type AddSearchVideoTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddSearchVideoTaskRequest creates a request to invoke AddSearchVideoTask API
func CreateAddSearchVideoTaskRequest() (request *AddSearchVideoTaskRequest) {
	request = &AddSearchVideoTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videosearch", "2020-02-25", "AddSearchVideoTask", "", "")
	request.Method = requests.POST
	return
}

// CreateAddSearchVideoTaskResponse creates a response to parse from AddSearchVideoTask response
func CreateAddSearchVideoTaskResponse() (response *AddSearchVideoTaskResponse) {
	response = &AddSearchVideoTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
