package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewayImages invokes the sgw.DescribeGatewayImages API synchronously
func (client *Client) DescribeGatewayImages(request *DescribeGatewayImagesRequest) (response *DescribeGatewayImagesResponse, err error) {
	response = CreateDescribeGatewayImagesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayImagesWithChan invokes the sgw.DescribeGatewayImages API asynchronously
func (client *Client) DescribeGatewayImagesWithChan(request *DescribeGatewayImagesRequest) (<-chan *DescribeGatewayImagesResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayImagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewayImages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayImagesWithCallback invokes the sgw.DescribeGatewayImages API asynchronously
func (client *Client) DescribeGatewayImagesWithCallback(request *DescribeGatewayImagesRequest, callback func(response *DescribeGatewayImagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayImagesResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewayImages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayImagesRequest is the request struct for api DescribeGatewayImages
type DescribeGatewayImagesRequest struct {
	*requests.RpcRequest
	Type          string `position:"Query" name:"Type"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	Category      string `position:"Query" name:"Category"`
}

// DescribeGatewayImagesResponse is the response struct for api DescribeGatewayImages
type DescribeGatewayImagesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Images    Images `json:"Images" xml:"Images"`
}

// CreateDescribeGatewayImagesRequest creates a request to invoke DescribeGatewayImages API
func CreateDescribeGatewayImagesRequest() (request *DescribeGatewayImagesRequest) {
	request = &DescribeGatewayImagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewayImages", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayImagesResponse creates a response to parse from DescribeGatewayImages response
func CreateDescribeGatewayImagesResponse() (response *DescribeGatewayImagesResponse) {
	response = &DescribeGatewayImagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
