package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataMaskingTasks invokes the sddp.DescribeDataMaskingTasks API synchronously
func (client *Client) DescribeDataMaskingTasks(request *DescribeDataMaskingTasksRequest) (response *DescribeDataMaskingTasksResponse, err error) {
	response = CreateDescribeDataMaskingTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataMaskingTasksWithChan invokes the sddp.DescribeDataMaskingTasks API asynchronously
func (client *Client) DescribeDataMaskingTasksWithChan(request *DescribeDataMaskingTasksRequest) (<-chan *DescribeDataMaskingTasksResponse, <-chan error) {
	responseChan := make(chan *DescribeDataMaskingTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataMaskingTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataMaskingTasksWithCallback invokes the sddp.DescribeDataMaskingTasks API asynchronously
func (client *Client) DescribeDataMaskingTasksWithCallback(request *DescribeDataMaskingTasksRequest, callback func(response *DescribeDataMaskingTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataMaskingTasksResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataMaskingTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataMaskingTasksRequest is the request struct for api DescribeDataMaskingTasks
type DescribeDataMaskingTasksRequest struct {
	*requests.RpcRequest
	SearchKey   string           `position:"Query" name:"SearchKey"`
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Lang        string           `position:"Query" name:"Lang"`
	FeatureType requests.Integer `position:"Query" name:"FeatureType"`
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	DstType     requests.Integer `position:"Query" name:"DstType"`
}

// DescribeDataMaskingTasksResponse is the response struct for api DescribeDataMaskingTasks
type DescribeDataMaskingTasksResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	PageSize    int    `json:"PageSize" xml:"PageSize"`
	CurrentPage int    `json:"CurrentPage" xml:"CurrentPage"`
	TotalCount  int    `json:"TotalCount" xml:"TotalCount"`
	Items       []Task `json:"Items" xml:"Items"`
}

// CreateDescribeDataMaskingTasksRequest creates a request to invoke DescribeDataMaskingTasks API
func CreateDescribeDataMaskingTasksRequest() (request *DescribeDataMaskingTasksRequest) {
	request = &DescribeDataMaskingTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeDataMaskingTasks", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDataMaskingTasksResponse creates a response to parse from DescribeDataMaskingTasks response
func CreateDescribeDataMaskingTasksResponse() (response *DescribeDataMaskingTasksResponse) {
	response = &DescribeDataMaskingTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
