package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetScdnDDoSInfo invokes the scdn.SetScdnDDoSInfo API synchronously
func (client *Client) SetScdnDDoSInfo(request *SetScdnDDoSInfoRequest) (response *SetScdnDDoSInfoResponse, err error) {
	response = CreateSetScdnDDoSInfoResponse()
	err = client.DoAction(request, response)
	return
}

// SetScdnDDoSInfoWithChan invokes the scdn.SetScdnDDoSInfo API asynchronously
func (client *Client) SetScdnDDoSInfoWithChan(request *SetScdnDDoSInfoRequest) (<-chan *SetScdnDDoSInfoResponse, <-chan error) {
	responseChan := make(chan *SetScdnDDoSInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetScdnDDoSInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetScdnDDoSInfoWithCallback invokes the scdn.SetScdnDDoSInfo API asynchronously
func (client *Client) SetScdnDDoSInfoWithCallback(request *SetScdnDDoSInfoRequest, callback func(response *SetScdnDDoSInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetScdnDDoSInfoResponse
		var err error
		defer close(result)
		response, err = client.SetScdnDDoSInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetScdnDDoSInfoRequest is the request struct for api SetScdnDDoSInfo
type SetScdnDDoSInfoRequest struct {
	*requests.RpcRequest
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	ElasticBandwidth requests.Integer `position:"Query" name:"ElasticBandwidth"`
}

// SetScdnDDoSInfoResponse is the response struct for api SetScdnDDoSInfo
type SetScdnDDoSInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetScdnDDoSInfoRequest creates a request to invoke SetScdnDDoSInfo API
func CreateSetScdnDDoSInfoRequest() (request *SetScdnDDoSInfoRequest) {
	request = &SetScdnDDoSInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "SetScdnDDoSInfo", "", "")
	request.Method = requests.GET
	return
}

// CreateSetScdnDDoSInfoResponse creates a response to parse from SetScdnDDoSInfo response
func CreateSetScdnDDoSInfoResponse() (response *SetScdnDDoSInfoResponse) {
	response = &SetScdnDDoSInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
