package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRdsAccount invokes the retailcloud.DeleteRdsAccount API synchronously
func (client *Client) DeleteRdsAccount(request *DeleteRdsAccountRequest) (response *DeleteRdsAccountResponse, err error) {
	response = CreateDeleteRdsAccountResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRdsAccountWithChan invokes the retailcloud.DeleteRdsAccount API asynchronously
func (client *Client) DeleteRdsAccountWithChan(request *DeleteRdsAccountRequest) (<-chan *DeleteRdsAccountResponse, <-chan error) {
	responseChan := make(chan *DeleteRdsAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRdsAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRdsAccountWithCallback invokes the retailcloud.DeleteRdsAccount API asynchronously
func (client *Client) DeleteRdsAccountWithCallback(request *DeleteRdsAccountRequest, callback func(response *DeleteRdsAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRdsAccountResponse
		var err error
		defer close(result)
		response, err = client.DeleteRdsAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRdsAccountRequest is the request struct for api DeleteRdsAccount
type DeleteRdsAccountRequest struct {
	*requests.RpcRequest
	AccountName  string `position:"Body" name:"AccountName"`
	DbInstanceId string `position:"Body" name:"DbInstanceId"`
}

// DeleteRdsAccountResponse is the response struct for api DeleteRdsAccount
type DeleteRdsAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	Code      int    `json:"Code" xml:"Code"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDeleteRdsAccountRequest creates a request to invoke DeleteRdsAccount API
func CreateDeleteRdsAccountRequest() (request *DeleteRdsAccountRequest) {
	request = &DeleteRdsAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "DeleteRdsAccount", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteRdsAccountResponse creates a response to parse from DeleteRdsAccount response
func CreateDeleteRdsAccountResponse() (response *DeleteRdsAccountResponse) {
	response = &DeleteRdsAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
