package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataSourceTableFields invokes the opensearch.ListDataSourceTableFields API synchronously
func (client *Client) ListDataSourceTableFields(request *ListDataSourceTableFieldsRequest) (response *ListDataSourceTableFieldsResponse, err error) {
	response = CreateListDataSourceTableFieldsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDataSourceTableFieldsWithChan invokes the opensearch.ListDataSourceTableFields API asynchronously
func (client *Client) ListDataSourceTableFieldsWithChan(request *ListDataSourceTableFieldsRequest) (<-chan *ListDataSourceTableFieldsResponse, <-chan error) {
	responseChan := make(chan *ListDataSourceTableFieldsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataSourceTableFields(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDataSourceTableFieldsWithCallback invokes the opensearch.ListDataSourceTableFields API asynchronously
func (client *Client) ListDataSourceTableFieldsWithCallback(request *ListDataSourceTableFieldsRequest, callback func(response *ListDataSourceTableFieldsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDataSourceTableFieldsResponse
		var err error
		defer close(result)
		response, err = client.ListDataSourceTableFields(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDataSourceTableFieldsRequest is the request struct for api ListDataSourceTableFields
type ListDataSourceTableFieldsRequest struct {
	*requests.RoaRequest
	DataSourceType string `position:"Path" name:"dataSourceType"`
	Params         string `position:"Query" name:"params"`
}

// ListDataSourceTableFieldsResponse is the response struct for api ListDataSourceTableFields
type ListDataSourceTableFieldsResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"requestId" xml:"requestId"`
	Result    map[string]interface{} `json:"result" xml:"result"`
}

// CreateListDataSourceTableFieldsRequest creates a request to invoke ListDataSourceTableFields API
func CreateListDataSourceTableFieldsRequest() (request *ListDataSourceTableFieldsRequest) {
	request = &ListDataSourceTableFieldsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListDataSourceTableFields", "/v4/openapi/assist/data-sources/[dataSourceType]/fields", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDataSourceTableFieldsResponse creates a response to parse from ListDataSourceTableFields response
func CreateListDataSourceTableFieldsResponse() (response *ListDataSourceTableFieldsResponse) {
	response = &ListDataSourceTableFieldsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
