package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchRoleByResourceAndAction invokes the oam.SearchRoleByResourceAndAction API synchronously
// api document: https://help.aliyun.com/api/oam/searchrolebyresourceandaction.html
func (client *Client) SearchRoleByResourceAndAction(request *SearchRoleByResourceAndActionRequest) (response *SearchRoleByResourceAndActionResponse, err error) {
	response = CreateSearchRoleByResourceAndActionResponse()
	err = client.DoAction(request, response)
	return
}

// SearchRoleByResourceAndActionWithChan invokes the oam.SearchRoleByResourceAndAction API asynchronously
// api document: https://help.aliyun.com/api/oam/searchrolebyresourceandaction.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchRoleByResourceAndActionWithChan(request *SearchRoleByResourceAndActionRequest) (<-chan *SearchRoleByResourceAndActionResponse, <-chan error) {
	responseChan := make(chan *SearchRoleByResourceAndActionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchRoleByResourceAndAction(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchRoleByResourceAndActionWithCallback invokes the oam.SearchRoleByResourceAndAction API asynchronously
// api document: https://help.aliyun.com/api/oam/searchrolebyresourceandaction.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchRoleByResourceAndActionWithCallback(request *SearchRoleByResourceAndActionRequest, callback func(response *SearchRoleByResourceAndActionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchRoleByResourceAndActionResponse
		var err error
		defer close(result)
		response, err = client.SearchRoleByResourceAndAction(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchRoleByResourceAndActionRequest is the request struct for api SearchRoleByResourceAndAction
type SearchRoleByResourceAndActionRequest struct {
	*requests.RpcRequest
	ResourceAction *[]SearchRoleByResourceAndActionResourceAction `position:"Query" name:"ResourceAction"  type:"Repeated"`
}

// SearchRoleByResourceAndActionResourceAction is a repeated param struct in SearchRoleByResourceAndActionRequest
type SearchRoleByResourceAndActionResourceAction struct {
	Resource    string `name:"Resource"`
	ActionField string `name:"ActionField"`
}

// SearchRoleByResourceAndActionResponse is the response struct for api SearchRoleByResourceAndAction
type SearchRoleByResourceAndActionResponse struct {
	*responses.BaseResponse
	Code    string                              `json:"Code" xml:"Code"`
	Message string                              `json:"Message" xml:"Message"`
	Data    DataInSearchRoleByResourceAndAction `json:"Data" xml:"Data"`
}

// CreateSearchRoleByResourceAndActionRequest creates a request to invoke SearchRoleByResourceAndAction API
func CreateSearchRoleByResourceAndActionRequest() (request *SearchRoleByResourceAndActionRequest) {
	request = &SearchRoleByResourceAndActionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "SearchRoleByResourceAndAction", "", "")
	request.Method = requests.POST
	return
}

// CreateSearchRoleByResourceAndActionResponse creates a response to parse from SearchRoleByResourceAndAction response
func CreateSearchRoleByResourceAndActionResponse() (response *SearchRoleByResourceAndActionResponse) {
	response = &SearchRoleByResourceAndActionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
