package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitMediaDetailJob invokes the mts.SubmitMediaDetailJob API synchronously
func (client *Client) SubmitMediaDetailJob(request *SubmitMediaDetailJobRequest) (response *SubmitMediaDetailJobResponse, err error) {
	response = CreateSubmitMediaDetailJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitMediaDetailJobWithChan invokes the mts.SubmitMediaDetailJob API asynchronously
func (client *Client) SubmitMediaDetailJobWithChan(request *SubmitMediaDetailJobRequest) (<-chan *SubmitMediaDetailJobResponse, <-chan error) {
	responseChan := make(chan *SubmitMediaDetailJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitMediaDetailJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitMediaDetailJobWithCallback invokes the mts.SubmitMediaDetailJob API asynchronously
func (client *Client) SubmitMediaDetailJobWithCallback(request *SubmitMediaDetailJobRequest, callback func(response *SubmitMediaDetailJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitMediaDetailJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitMediaDetailJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitMediaDetailJobRequest is the request struct for api SubmitMediaDetailJob
type SubmitMediaDetailJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UserData             string           `position:"Query" name:"UserData"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PipelineId           string           `position:"Query" name:"PipelineId"`
	Input                string           `position:"Query" name:"Input"`
	MediaDetailConfig    string           `position:"Query" name:"MediaDetailConfig"`
}

// SubmitMediaDetailJobResponse is the response struct for api SubmitMediaDetailJob
type SubmitMediaDetailJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateSubmitMediaDetailJobRequest creates a request to invoke SubmitMediaDetailJob API
func CreateSubmitMediaDetailJobRequest() (request *SubmitMediaDetailJobRequest) {
	request = &SubmitMediaDetailJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitMediaDetailJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitMediaDetailJobResponse creates a response to parse from SubmitMediaDetailJob response
func CreateSubmitMediaDetailJobResponse() (response *SubmitMediaDetailJobResponse) {
	response = &SubmitMediaDetailJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
