package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDetectEvaluation invokes the idrsservice.GetDetectEvaluation API synchronously
func (client *Client) GetDetectEvaluation(request *GetDetectEvaluationRequest) (response *GetDetectEvaluationResponse, err error) {
	response = CreateGetDetectEvaluationResponse()
	err = client.DoAction(request, response)
	return
}

// GetDetectEvaluationWithChan invokes the idrsservice.GetDetectEvaluation API asynchronously
func (client *Client) GetDetectEvaluationWithChan(request *GetDetectEvaluationRequest) (<-chan *GetDetectEvaluationResponse, <-chan error) {
	responseChan := make(chan *GetDetectEvaluationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDetectEvaluation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDetectEvaluationWithCallback invokes the idrsservice.GetDetectEvaluation API asynchronously
func (client *Client) GetDetectEvaluationWithCallback(request *GetDetectEvaluationRequest, callback func(response *GetDetectEvaluationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDetectEvaluationResponse
		var err error
		defer close(result)
		response, err = client.GetDetectEvaluation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDetectEvaluationRequest is the request struct for api GetDetectEvaluation
type GetDetectEvaluationRequest struct {
	*requests.RpcRequest
	EndTime   string `position:"Query" name:"EndTime"`
	StartTime string `position:"Query" name:"StartTime"`
}

// GetDetectEvaluationResponse is the response struct for api GetDetectEvaluation
type GetDetectEvaluationResponse struct {
	*responses.BaseResponse
	Code      string     `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetDetectEvaluationRequest creates a request to invoke GetDetectEvaluation API
func CreateGetDetectEvaluationRequest() (request *GetDetectEvaluationRequest) {
	request = &GetDetectEvaluationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "GetDetectEvaluation", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDetectEvaluationResponse creates a response to parse from GetDetectEvaluation response
func CreateGetDetectEvaluationResponse() (response *GetDetectEvaluationResponse) {
	response = &GetDetectEvaluationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
