package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeMultiZoneCluster invokes the hbase.UpgradeMultiZoneCluster API synchronously
func (client *Client) UpgradeMultiZoneCluster(request *UpgradeMultiZoneClusterRequest) (response *UpgradeMultiZoneClusterResponse, err error) {
	response = CreateUpgradeMultiZoneClusterResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeMultiZoneClusterWithChan invokes the hbase.UpgradeMultiZoneCluster API asynchronously
func (client *Client) UpgradeMultiZoneClusterWithChan(request *UpgradeMultiZoneClusterRequest) (<-chan *UpgradeMultiZoneClusterResponse, <-chan error) {
	responseChan := make(chan *UpgradeMultiZoneClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeMultiZoneCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeMultiZoneClusterWithCallback invokes the hbase.UpgradeMultiZoneCluster API asynchronously
func (client *Client) UpgradeMultiZoneClusterWithCallback(request *UpgradeMultiZoneClusterRequest, callback func(response *UpgradeMultiZoneClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeMultiZoneClusterResponse
		var err error
		defer close(result)
		response, err = client.UpgradeMultiZoneCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeMultiZoneClusterRequest is the request struct for api UpgradeMultiZoneCluster
type UpgradeMultiZoneClusterRequest struct {
	*requests.RpcRequest
	RunMode           string `position:"Query" name:"RunMode"`
	Components        string `position:"Query" name:"Components"`
	UpgradeInsName    string `position:"Query" name:"UpgradeInsName"`
	RestartComponents string `position:"Query" name:"RestartComponents"`
	ClusterId         string `position:"Query" name:"ClusterId"`
	Versions          string `position:"Query" name:"Versions"`
}

// UpgradeMultiZoneClusterResponse is the response struct for api UpgradeMultiZoneCluster
type UpgradeMultiZoneClusterResponse struct {
	*responses.BaseResponse
	RequestId           string `json:"RequestId" xml:"RequestId"`
	UpgradingComponents string `json:"UpgradingComponents" xml:"UpgradingComponents"`
}

// CreateUpgradeMultiZoneClusterRequest creates a request to invoke UpgradeMultiZoneCluster API
func CreateUpgradeMultiZoneClusterRequest() (request *UpgradeMultiZoneClusterRequest) {
	request = &UpgradeMultiZoneClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "UpgradeMultiZoneCluster", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpgradeMultiZoneClusterResponse creates a response to parse from UpgradeMultiZoneCluster response
func CreateUpgradeMultiZoneClusterResponse() (response *UpgradeMultiZoneClusterResponse) {
	response = &UpgradeMultiZoneClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
