package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyMultiZoneClusterNodeType invokes the hbase.ModifyMultiZoneClusterNodeType API synchronously
func (client *Client) ModifyMultiZoneClusterNodeType(request *ModifyMultiZoneClusterNodeTypeRequest) (response *ModifyMultiZoneClusterNodeTypeResponse, err error) {
	response = CreateModifyMultiZoneClusterNodeTypeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyMultiZoneClusterNodeTypeWithChan invokes the hbase.ModifyMultiZoneClusterNodeType API asynchronously
func (client *Client) ModifyMultiZoneClusterNodeTypeWithChan(request *ModifyMultiZoneClusterNodeTypeRequest) (<-chan *ModifyMultiZoneClusterNodeTypeResponse, <-chan error) {
	responseChan := make(chan *ModifyMultiZoneClusterNodeTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyMultiZoneClusterNodeType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyMultiZoneClusterNodeTypeWithCallback invokes the hbase.ModifyMultiZoneClusterNodeType API asynchronously
func (client *Client) ModifyMultiZoneClusterNodeTypeWithCallback(request *ModifyMultiZoneClusterNodeTypeRequest, callback func(response *ModifyMultiZoneClusterNodeTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyMultiZoneClusterNodeTypeResponse
		var err error
		defer close(result)
		response, err = client.ModifyMultiZoneClusterNodeType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyMultiZoneClusterNodeTypeRequest is the request struct for api ModifyMultiZoneClusterNodeType
type ModifyMultiZoneClusterNodeTypeRequest struct {
	*requests.RpcRequest
	LogInstanceType    string `position:"Query" name:"LogInstanceType"`
	ClusterId          string `position:"Query" name:"ClusterId"`
	MasterInstanceType string `position:"Query" name:"MasterInstanceType"`
	CoreInstanceType   string `position:"Query" name:"CoreInstanceType"`
}

// ModifyMultiZoneClusterNodeTypeResponse is the response struct for api ModifyMultiZoneClusterNodeType
type ModifyMultiZoneClusterNodeTypeResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyMultiZoneClusterNodeTypeRequest creates a request to invoke ModifyMultiZoneClusterNodeType API
func CreateModifyMultiZoneClusterNodeTypeRequest() (request *ModifyMultiZoneClusterNodeTypeRequest) {
	request = &ModifyMultiZoneClusterNodeTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "ModifyMultiZoneClusterNodeType", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyMultiZoneClusterNodeTypeResponse creates a response to parse from ModifyMultiZoneClusterNodeType response
func CreateModifyMultiZoneClusterNodeTypeResponse() (response *ModifyMultiZoneClusterNodeTypeResponse) {
	response = &ModifyMultiZoneClusterNodeTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
