package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFlowCategoryTree invokes the emr.DescribeFlowCategoryTree API synchronously
func (client *Client) DescribeFlowCategoryTree(request *DescribeFlowCategoryTreeRequest) (response *DescribeFlowCategoryTreeResponse, err error) {
	response = CreateDescribeFlowCategoryTreeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFlowCategoryTreeWithChan invokes the emr.DescribeFlowCategoryTree API asynchronously
func (client *Client) DescribeFlowCategoryTreeWithChan(request *DescribeFlowCategoryTreeRequest) (<-chan *DescribeFlowCategoryTreeResponse, <-chan error) {
	responseChan := make(chan *DescribeFlowCategoryTreeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFlowCategoryTree(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFlowCategoryTreeWithCallback invokes the emr.DescribeFlowCategoryTree API asynchronously
func (client *Client) DescribeFlowCategoryTreeWithCallback(request *DescribeFlowCategoryTreeRequest, callback func(response *DescribeFlowCategoryTreeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFlowCategoryTreeResponse
		var err error
		defer close(result)
		response, err = client.DescribeFlowCategoryTree(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFlowCategoryTreeRequest is the request struct for api DescribeFlowCategoryTree
type DescribeFlowCategoryTreeRequest struct {
	*requests.RpcRequest
	Type       string `position:"Query" name:"Type"`
	Mode       string `position:"Query" name:"Mode"`
	Keyword    string `position:"Query" name:"Keyword"`
	ProjectId  string `position:"Query" name:"ProjectId"`
	CategoryId string `position:"Query" name:"CategoryId"`
}

// DescribeFlowCategoryTreeResponse is the response struct for api DescribeFlowCategoryTree
type DescribeFlowCategoryTreeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateDescribeFlowCategoryTreeRequest creates a request to invoke DescribeFlowCategoryTree API
func CreateDescribeFlowCategoryTreeRequest() (request *DescribeFlowCategoryTreeRequest) {
	request = &DescribeFlowCategoryTreeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeFlowCategoryTree", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeFlowCategoryTreeResponse creates a response to parse from DescribeFlowCategoryTree response
func CreateDescribeFlowCategoryTreeResponse() (response *DescribeFlowCategoryTreeResponse) {
	response = &DescribeFlowCategoryTreeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
