package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveApm invokes the elasticsearch.RemoveApm API synchronously
func (client *Client) RemoveApm(request *RemoveApmRequest) (response *RemoveApmResponse, err error) {
	response = CreateRemoveApmResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveApmWithChan invokes the elasticsearch.RemoveApm API asynchronously
func (client *Client) RemoveApmWithChan(request *RemoveApmRequest) (<-chan *RemoveApmResponse, <-chan error) {
	responseChan := make(chan *RemoveApmResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveApm(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveApmWithCallback invokes the elasticsearch.RemoveApm API asynchronously
func (client *Client) RemoveApmWithCallback(request *RemoveApmRequest, callback func(response *RemoveApmResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveApmResponse
		var err error
		defer close(result)
		response, err = client.RemoveApm(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveApmRequest is the request struct for api RemoveApm
type RemoveApmRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
}

// RemoveApmResponse is the response struct for api RemoveApm
type RemoveApmResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateRemoveApmRequest creates a request to invoke RemoveApm API
func CreateRemoveApmRequest() (request *RemoveApmRequest) {
	request = &RemoveApmRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "RemoveApm", "/openapi/apm/[instanceId]", "elasticsearch", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateRemoveApmResponse creates a response to parse from RemoveApm response
func CreateRemoveApmResponse() (response *RemoveApmResponse) {
	response = &RemoveApmResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
