package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteImagePipeline invokes the ecs.DeleteImagePipeline API synchronously
func (client *Client) DeleteImagePipeline(request *DeleteImagePipelineRequest) (response *DeleteImagePipelineResponse, err error) {
	response = CreateDeleteImagePipelineResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteImagePipelineWithChan invokes the ecs.DeleteImagePipeline API asynchronously
func (client *Client) DeleteImagePipelineWithChan(request *DeleteImagePipelineRequest) (<-chan *DeleteImagePipelineResponse, <-chan error) {
	responseChan := make(chan *DeleteImagePipelineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteImagePipeline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteImagePipelineWithCallback invokes the ecs.DeleteImagePipeline API asynchronously
func (client *Client) DeleteImagePipelineWithCallback(request *DeleteImagePipelineRequest, callback func(response *DeleteImagePipelineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteImagePipelineResponse
		var err error
		defer close(result)
		response, err = client.DeleteImagePipeline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteImagePipelineRequest is the request struct for api DeleteImagePipeline
type DeleteImagePipelineRequest struct {
	*requests.RpcRequest
	ImagePipelineId      string                            `position:"Query" name:"ImagePipelineId"`
	ResourceOwnerId      requests.Integer                  `position:"Query" name:"ResourceOwnerId"`
	TemplateTag          *[]DeleteImagePipelineTemplateTag `position:"Query" name:"TemplateTag"  type:"Repeated"`
	ResourceOwnerAccount string                            `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                            `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer                  `position:"Query" name:"OwnerId"`
}

// DeleteImagePipelineTemplateTag is a repeated param struct in DeleteImagePipelineRequest
type DeleteImagePipelineTemplateTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// DeleteImagePipelineResponse is the response struct for api DeleteImagePipeline
type DeleteImagePipelineResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteImagePipelineRequest creates a request to invoke DeleteImagePipeline API
func CreateDeleteImagePipelineRequest() (request *DeleteImagePipelineRequest) {
	request = &DeleteImagePipelineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DeleteImagePipeline", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteImagePipelineResponse creates a response to parse from DeleteImagePipeline response
func CreateDeleteImagePipelineResponse() (response *DeleteImagePipelineResponse) {
	response = &DeleteImagePipelineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
