package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOrderBaseInfo invokes the dms_enterprise.GetOrderBaseInfo API synchronously
func (client *Client) GetOrderBaseInfo(request *GetOrderBaseInfoRequest) (response *GetOrderBaseInfoResponse, err error) {
	response = CreateGetOrderBaseInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetOrderBaseInfoWithChan invokes the dms_enterprise.GetOrderBaseInfo API asynchronously
func (client *Client) GetOrderBaseInfoWithChan(request *GetOrderBaseInfoRequest) (<-chan *GetOrderBaseInfoResponse, <-chan error) {
	responseChan := make(chan *GetOrderBaseInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOrderBaseInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOrderBaseInfoWithCallback invokes the dms_enterprise.GetOrderBaseInfo API asynchronously
func (client *Client) GetOrderBaseInfoWithCallback(request *GetOrderBaseInfoRequest, callback func(response *GetOrderBaseInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOrderBaseInfoResponse
		var err error
		defer close(result)
		response, err = client.GetOrderBaseInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOrderBaseInfoRequest is the request struct for api GetOrderBaseInfo
type GetOrderBaseInfoRequest struct {
	*requests.RpcRequest
	OrderId requests.Integer `position:"Query" name:"OrderId"`
	Tid     requests.Integer `position:"Query" name:"Tid"`
}

// GetOrderBaseInfoResponse is the response struct for api GetOrderBaseInfo
type GetOrderBaseInfoResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ErrorCode     string        `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage  string        `json:"ErrorMessage" xml:"ErrorMessage"`
	Success       bool          `json:"Success" xml:"Success"`
	OrderBaseInfo OrderBaseInfo `json:"OrderBaseInfo" xml:"OrderBaseInfo"`
}

// CreateGetOrderBaseInfoRequest creates a request to invoke GetOrderBaseInfo API
func CreateGetOrderBaseInfoRequest() (request *GetOrderBaseInfoRequest) {
	request = &GetOrderBaseInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetOrderBaseInfo", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetOrderBaseInfoResponse creates a response to parse from GetOrderBaseInfo response
func CreateGetOrderBaseInfoResponse() (response *GetOrderBaseInfoResponse) {
	response = &GetOrderBaseInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
