package cloudgameapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTenant invokes the cloudgameapi.QueryTenant API synchronously
func (client *Client) QueryTenant(request *QueryTenantRequest) (response *QueryTenantResponse, err error) {
	response = CreateQueryTenantResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTenantWithChan invokes the cloudgameapi.QueryTenant API asynchronously
func (client *Client) QueryTenantWithChan(request *QueryTenantRequest) (<-chan *QueryTenantResponse, <-chan error) {
	responseChan := make(chan *QueryTenantResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTenant(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTenantWithCallback invokes the cloudgameapi.QueryTenant API asynchronously
func (client *Client) QueryTenantWithCallback(request *QueryTenantRequest, callback func(response *QueryTenantResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTenantResponse
		var err error
		defer close(result)
		response, err = client.QueryTenant(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTenantRequest is the request struct for api QueryTenant
type QueryTenantRequest struct {
	*requests.RpcRequest
	Param    string           `position:"Query" name:"Param"`
	PageNo   requests.Integer `position:"Query" name:"PageNo"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
}

// QueryTenantResponse is the response struct for api QueryTenant
type QueryTenantResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int     `json:"PageNumber" xml:"PageNumber"`
	PageSize   int     `json:"PageSize" xml:"PageSize"`
	TotalCount int     `json:"TotalCount" xml:"TotalCount"`
	Data       []Items `json:"Data" xml:"Data"`
}

// CreateQueryTenantRequest creates a request to invoke QueryTenant API
func CreateQueryTenantRequest() (request *QueryTenantRequest) {
	request = &QueryTenantRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudGameAPI", "2020-07-28", "QueryTenant", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryTenantResponse creates a response to parse from QueryTenant response
func CreateQueryTenantResponse() (response *QueryTenantResponse) {
	response = &QueryTenantResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
