package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnLockIndexVersion invokes the airec.UnLockIndexVersion API synchronously
func (client *Client) UnLockIndexVersion(request *UnLockIndexVersionRequest) (response *UnLockIndexVersionResponse, err error) {
	response = CreateUnLockIndexVersionResponse()
	err = client.DoAction(request, response)
	return
}

// UnLockIndexVersionWithChan invokes the airec.UnLockIndexVersion API asynchronously
func (client *Client) UnLockIndexVersionWithChan(request *UnLockIndexVersionRequest) (<-chan *UnLockIndexVersionResponse, <-chan error) {
	responseChan := make(chan *UnLockIndexVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnLockIndexVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnLockIndexVersionWithCallback invokes the airec.UnLockIndexVersion API asynchronously
func (client *Client) UnLockIndexVersionWithCallback(request *UnLockIndexVersionRequest, callback func(response *UnLockIndexVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnLockIndexVersionResponse
		var err error
		defer close(result)
		response, err = client.UnLockIndexVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnLockIndexVersionRequest is the request struct for api UnLockIndexVersion
type UnLockIndexVersionRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"instanceId"`
	AlgorithmId string `position:"Path" name:"algorithmId"`
}

// UnLockIndexVersionResponse is the response struct for api UnLockIndexVersion
type UnLockIndexVersionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    bool   `json:"result" xml:"result"`
}

// CreateUnLockIndexVersionRequest creates a request to invoke UnLockIndexVersion API
func CreateUnLockIndexVersionRequest() (request *UnLockIndexVersionRequest) {
	request = &UnLockIndexVersionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "UnLockIndexVersion", "/v2/openapi/instances/[instanceId]/filtering-algorithms/[algorithmId]/actions/unlock", "airec", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnLockIndexVersionResponse creates a response to parse from UnLockIndexVersion response
func CreateUnLockIndexVersionResponse() (response *UnLockIndexVersionResponse) {
	response = &UnLockIndexVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
