package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckRankingModelReachable invokes the airec.CheckRankingModelReachable API synchronously
func (client *Client) CheckRankingModelReachable(request *CheckRankingModelReachableRequest) (response *CheckRankingModelReachableResponse, err error) {
	response = CreateCheckRankingModelReachableResponse()
	err = client.DoAction(request, response)
	return
}

// CheckRankingModelReachableWithChan invokes the airec.CheckRankingModelReachable API asynchronously
func (client *Client) CheckRankingModelReachableWithChan(request *CheckRankingModelReachableRequest) (<-chan *CheckRankingModelReachableResponse, <-chan error) {
	responseChan := make(chan *CheckRankingModelReachableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckRankingModelReachable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckRankingModelReachableWithCallback invokes the airec.CheckRankingModelReachable API asynchronously
func (client *Client) CheckRankingModelReachableWithCallback(request *CheckRankingModelReachableRequest, callback func(response *CheckRankingModelReachableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckRankingModelReachableResponse
		var err error
		defer close(result)
		response, err = client.CheckRankingModelReachable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckRankingModelReachableRequest is the request struct for api CheckRankingModelReachable
type CheckRankingModelReachableRequest struct {
	*requests.RoaRequest
	InstanceId     string `position:"Path" name:"instanceId"`
	RankingModelId string `position:"Path" name:"rankingModelId"`
}

// CheckRankingModelReachableResponse is the response struct for api CheckRankingModelReachable
type CheckRankingModelReachableResponse struct {
	*responses.BaseResponse
	Code      string `json:"code" xml:"code"`
	Message   string `json:"message" xml:"message"`
	RequestId string `json:"requestId" xml:"requestId"`
	Result    bool   `json:"result" xml:"result"`
}

// CreateCheckRankingModelReachableRequest creates a request to invoke CheckRankingModelReachable API
func CreateCheckRankingModelReachableRequest() (request *CheckRankingModelReachableRequest) {
	request = &CheckRankingModelReachableRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "CheckRankingModelReachable", "/v2/openapi/instances/[instanceId]/ranking-models/[rankingModelId]/actions/check-connectivity", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateCheckRankingModelReachableResponse creates a response to parse from CheckRankingModelReachable response
func CreateCheckRankingModelReachableResponse() (response *CheckRankingModelReachableResponse) {
	response = &CheckRankingModelReachableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
