package qnamaker

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// EndpointSettingsClient is the an API for QnAMaker Service
type EndpointSettingsClient struct {
	BaseClient
}

// NewEndpointSettingsClient creates an instance of the EndpointSettingsClient client.
func NewEndpointSettingsClient(endpoint string) EndpointSettingsClient {
	return EndpointSettingsClient{New(endpoint)}
}

// GetSettings sends the get settings request.
func (client EndpointSettingsClient) GetSettings(ctx context.Context) (result EndpointSettingsDTO, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointSettingsClient.GetSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSettingsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "qnamaker.EndpointSettingsClient", "GetSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "qnamaker.EndpointSettingsClient", "GetSettings", resp, "Failure sending request")
		return
	}

	result, err = client.GetSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "qnamaker.EndpointSettingsClient", "GetSettings", resp, "Failure responding to request")
		return
	}

	return
}

// GetSettingsPreparer prepares the GetSettings request.
func (client EndpointSettingsClient) GetSettingsPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/qnamaker/v5.0-preview.1", urlParameters),
		autorest.WithPath("/endpointSettings"))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSettingsSender sends the GetSettings request. The method will close the
// http.Response Body if it receives an error.
func (client EndpointSettingsClient) GetSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSettingsResponder handles the response to the GetSettings request. The method always
// closes the http.Response Body.
func (client EndpointSettingsClient) GetSettingsResponder(resp *http.Response) (result EndpointSettingsDTO, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSettings sends the update settings request.
// Parameters:
// endpointSettingsPayload - post body of the request.
func (client EndpointSettingsClient) UpdateSettings(ctx context.Context, endpointSettingsPayload EndpointSettingsDTO) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointSettingsClient.UpdateSettings")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSettingsPreparer(ctx, endpointSettingsPayload)
	if err != nil {
		err = autorest.NewErrorWithError(err, "qnamaker.EndpointSettingsClient", "UpdateSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSettingsSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "qnamaker.EndpointSettingsClient", "UpdateSettings", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "qnamaker.EndpointSettingsClient", "UpdateSettings", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSettingsPreparer prepares the UpdateSettings request.
func (client EndpointSettingsClient) UpdateSettingsPreparer(ctx context.Context, endpointSettingsPayload EndpointSettingsDTO) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{Endpoint}/qnamaker/v5.0-preview.1", urlParameters),
		autorest.WithPath("/endpointSettings"),
		autorest.WithJSON(endpointSettingsPayload))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSettingsSender sends the UpdateSettings request. The method will close the
// http.Response Body if it receives an error.
func (client EndpointSettingsClient) UpdateSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateSettingsResponder handles the response to the UpdateSettings request. The method always
// closes the http.Response Body.
func (client EndpointSettingsClient) UpdateSettingsResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}
