/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"
        #include <wx/richtext/richtextbuffer.h>
    PyObject* _wxRichTextRange_Get(wxRichTextRange* self)
    {
        wxPyThreadBlocker blocker;
        return sipBuildResult(0, "(ii)", self->GetStart(), self->GetEnd());
    }


PyDoc_STRVAR(doc_wxRichTextRange_SetRange, "SetRange(start, end) -> None\n"
"\n"
"Sets the range start and end positions.");

extern "C" {static PyObject *meth_wxRichTextRange_SetRange(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_SetRange(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long start;
        long end;
        ::wxRichTextRange *sipCpp;

        static const char *sipKwdList[] = {
            sipName_start,
            sipName_end,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bll", &sipSelf, sipType_wxRichTextRange, &sipCpp, &start, &end))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRange(start, end);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_SetRange, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextRange_SetStart, "SetStart(start) -> None\n"
"\n"
"Sets the start position.");

extern "C" {static PyObject *meth_wxRichTextRange_SetStart(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_SetStart(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long start;
        ::wxRichTextRange *sipCpp;

        static const char *sipKwdList[] = {
            sipName_start,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxRichTextRange, &sipCpp, &start))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetStart(start);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_SetStart, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextRange_GetStart, "GetStart() -> int\n"
"\n"
"Returns the start position.");

extern "C" {static PyObject *meth_wxRichTextRange_GetStart(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_GetStart(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextRange *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextRange, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetStart();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_GetStart, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextRange_SetEnd, "SetEnd(end) -> None\n"
"\n"
"Sets the end position.");

extern "C" {static PyObject *meth_wxRichTextRange_SetEnd(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_SetEnd(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long end;
        ::wxRichTextRange *sipCpp;

        static const char *sipKwdList[] = {
            sipName_end,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxRichTextRange, &sipCpp, &end))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEnd(end);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_SetEnd, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextRange_GetEnd, "GetEnd() -> int\n"
"\n"
"Gets the end position.");

extern "C" {static PyObject *meth_wxRichTextRange_GetEnd(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_GetEnd(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextRange *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextRange, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEnd();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_GetEnd, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextRange_IsOutside, "IsOutside(range) -> bool\n"
"\n"
"Returns true if this range is completely outside range.");

extern "C" {static PyObject *meth_wxRichTextRange_IsOutside(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_IsOutside(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextRange* range;
        int rangeState = 0;
        const ::wxRichTextRange *sipCpp;

        static const char *sipKwdList[] = {
            sipName_range,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextRange, &sipCpp, sipType_wxRichTextRange, &range, &rangeState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOutside(*range);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRichTextRange *>(range), sipType_wxRichTextRange, rangeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_IsOutside, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextRange_IsWithin, "IsWithin(range) -> bool\n"
"\n"
"Returns true if this range is completely within range.");

extern "C" {static PyObject *meth_wxRichTextRange_IsWithin(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_IsWithin(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextRange* range;
        int rangeState = 0;
        const ::wxRichTextRange *sipCpp;

        static const char *sipKwdList[] = {
            sipName_range,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextRange, &sipCpp, sipType_wxRichTextRange, &range, &rangeState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsWithin(*range);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRichTextRange *>(range), sipType_wxRichTextRange, rangeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_IsWithin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextRange_Contains, "Contains(pos) -> bool\n"
"\n"
"Returns true if pos was within the range.");

extern "C" {static PyObject *meth_wxRichTextRange_Contains(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_Contains(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long pos;
        const ::wxRichTextRange *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxRichTextRange, &sipCpp, &pos))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(pos);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_Contains, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextRange_LimitTo, "LimitTo(range) -> bool\n"
"\n"
"Limit this range to be within range.");

extern "C" {static PyObject *meth_wxRichTextRange_LimitTo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_LimitTo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextRange* range;
        int rangeState = 0;
        ::wxRichTextRange *sipCpp;

        static const char *sipKwdList[] = {
            sipName_range,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextRange, &sipCpp, sipType_wxRichTextRange, &range, &rangeState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LimitTo(*range);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRichTextRange *>(range), sipType_wxRichTextRange, rangeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_LimitTo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextRange_GetLength, "GetLength() -> int\n"
"\n"
"Gets the length of the range.");

extern "C" {static PyObject *meth_wxRichTextRange_GetLength(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_GetLength(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextRange *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextRange, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetLength();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_GetLength, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextRange_Swap, "Swap() -> None\n"
"\n"
"Swaps the start and end.");

extern "C" {static PyObject *meth_wxRichTextRange_Swap(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_Swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextRange *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextRange, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Swap();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_Swap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextRange_ToInternal, "ToInternal() -> RichTextRange\n"
"\n"
"Converts the API-standard range, whose end is one past the last\n"
"character in the range, to the internal form, which uses the first and\n"
"last character positions of the range.");

extern "C" {static PyObject *meth_wxRichTextRange_ToInternal(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_ToInternal(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextRange *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextRange, &sipCpp))
        {
            ::wxRichTextRange*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxRichTextRange(sipCpp->ToInternal());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxRichTextRange, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_ToInternal, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextRange_FromInternal, "FromInternal() -> RichTextRange\n"
"\n"
"Converts the internal range, which uses the first and last character\n"
"positions of the range, to the API-standard range, whose end is one\n"
"past the last character in the range.");

extern "C" {static PyObject *meth_wxRichTextRange_FromInternal(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_FromInternal(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextRange *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextRange, &sipCpp))
        {
            ::wxRichTextRange*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxRichTextRange(sipCpp->FromInternal());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxRichTextRange, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_FromInternal, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextRange_Get, "Get() -> (start, end)\n"
"\n"
"Return the start and end properties as a tuple.");

extern "C" {static PyObject *meth_wxRichTextRange_Get(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextRange_Get(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextRange *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextRange, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxRichTextRange_Get(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextRange, sipName_Get, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxRichTextRange___add__(PyObject *, PyObject *);}
static PyObject *slot_wxRichTextRange___add__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextRange* a0;
        int a0State = 0;
        const ::wxRichTextRange* range;
        int rangeState = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_wxRichTextRange, &a0, &a0State, sipType_wxRichTextRange, &range, &rangeState))
        {
            ::wxRichTextRange*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxRichTextRange((*a0 + *range));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0, sipType_wxRichTextRange, a0State);
            sipReleaseType(const_cast< ::wxRichTextRange *>(range), sipType_wxRichTextRange, rangeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxRichTextRange, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__richtext, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxRichTextRange___sub__(PyObject *, PyObject *);}
static PyObject *slot_wxRichTextRange___sub__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRichTextRange* a0;
        int a0State = 0;
        const ::wxRichTextRange* range;
        int rangeState = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1J1", sipType_wxRichTextRange, &a0, &a0State, sipType_wxRichTextRange, &range, &rangeState))
        {
            ::wxRichTextRange*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxRichTextRange((*a0 - *range));
            Py_END_ALLOW_THREADS
            sipReleaseType(a0, sipType_wxRichTextRange, a0State);
            sipReleaseType(const_cast< ::wxRichTextRange *>(range), sipType_wxRichTextRange, rangeState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxRichTextRange, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__richtext, sub_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_wxRichTextRange___ne__(PyObject *, PyObject *);}
static PyObject *slot_wxRichTextRange___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxRichTextRange *sipCpp = reinterpret_cast< ::wxRichTextRange *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxRichTextRange));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextRange* range;
        int rangeState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxRichTextRange, &range, &rangeState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxRichTextRange::operator!=(*range);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRichTextRange *>(range), sipType_wxRichTextRange, rangeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__richtext, ne_slot, sipType_wxRichTextRange, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxRichTextRange___eq__(PyObject *, PyObject *);}
static PyObject *slot_wxRichTextRange___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::wxRichTextRange *sipCpp = reinterpret_cast< ::wxRichTextRange *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_wxRichTextRange));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextRange* range;
        int rangeState = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_wxRichTextRange, &range, &rangeState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->::wxRichTextRange::operator==(*range);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRichTextRange *>(range), sipType_wxRichTextRange, rangeState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__richtext, eq_slot, sipType_wxRichTextRange, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextRange(void *, int);}
static void release_wxRichTextRange(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxRichTextRange *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxRichTextRange(Py_ssize_t);}
static void *array_wxRichTextRange(Py_ssize_t sipNrElem)
{
    return new ::wxRichTextRange[sipNrElem];
}


extern "C" {static void array_delete_wxRichTextRange(void *);}
static void array_delete_wxRichTextRange(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxRichTextRange *>(sipCpp);
}


extern "C" {static void assign_wxRichTextRange(void *, Py_ssize_t, void *);}
static void assign_wxRichTextRange(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxRichTextRange *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxRichTextRange *>(sipSrc);
}


extern "C" {static void *copy_wxRichTextRange(const void *, Py_ssize_t);}
static void *copy_wxRichTextRange(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxRichTextRange(reinterpret_cast<const ::wxRichTextRange *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextRange(sipSimpleWrapper *);}
static void dealloc_wxRichTextRange(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextRange(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxRichTextRange(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextRange(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxRichTextRange *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRichTextRange();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        long start;
        long end;

        static const char *sipKwdList[] = {
            sipName_start,
            sipName_end,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "ll", &start, &end))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRichTextRange(start, end);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxRichTextRange* range;
        int rangeState = 0;

        static const char *sipKwdList[] = {
            sipName_range,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxRichTextRange, &range, &rangeState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRichTextRange(*range);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRichTextRange *>(range), sipType_wxRichTextRange, rangeState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static int convertTo_wxRichTextRange(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxRichTextRange(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::wxRichTextRange **sipCppPtr = reinterpret_cast< ::wxRichTextRange **>(sipCppPtrV);
        // is it just a typecheck?
        if (!sipIsErr) {
            // is it already an instance of wxRichTextRange?
            if (sipCanConvertToType(sipPy, sipType_wxRichTextRange, SIP_NO_CONVERTORS))
                return 1;
        
            if (wxPyNumberSequenceCheck(sipPy, 2)) {
                return 1;
            }
            return 0;
        }
        
         // otherwise do the conversion
         if (sipCanConvertToType(sipPy, sipType_wxRichTextRange, SIP_NO_CONVERTORS)) {
             // Just fetch the existing instance
             *sipCppPtr = reinterpret_cast<wxRichTextRange*>(sipConvertToType(
                     sipPy, sipType_wxRichTextRange, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));
             return 0;  // not a new instance
         }
        
         // or create a new instance
         PyObject* o1 = PySequence_ITEM(sipPy, 0);
         PyObject* o2 = PySequence_ITEM(sipPy, 1);
         *sipCppPtr = new wxRichTextRange(wxPyInt_AsLong(o1), wxPyInt_AsLong(o2));
         Py_DECREF(o1);
         Py_DECREF(o2);
         return SIP_TEMPORARY;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxRichTextRange[] = {
    {(void *)slot_wxRichTextRange___add__, add_slot},
    {(void *)slot_wxRichTextRange___sub__, sub_slot},
    {(void *)slot_wxRichTextRange___ne__, ne_slot},
    {(void *)slot_wxRichTextRange___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxRichTextRange[] = {
    {sipName_Contains, SIP_MLMETH_CAST(meth_wxRichTextRange_Contains), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextRange_Contains},
    {sipName_FromInternal, meth_wxRichTextRange_FromInternal, METH_VARARGS, doc_wxRichTextRange_FromInternal},
    {sipName_Get, meth_wxRichTextRange_Get, METH_VARARGS, doc_wxRichTextRange_Get},
    {sipName_GetEnd, meth_wxRichTextRange_GetEnd, METH_VARARGS, doc_wxRichTextRange_GetEnd},
    {sipName_GetLength, meth_wxRichTextRange_GetLength, METH_VARARGS, doc_wxRichTextRange_GetLength},
    {sipName_GetStart, meth_wxRichTextRange_GetStart, METH_VARARGS, doc_wxRichTextRange_GetStart},
    {sipName_IsOutside, SIP_MLMETH_CAST(meth_wxRichTextRange_IsOutside), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextRange_IsOutside},
    {sipName_IsWithin, SIP_MLMETH_CAST(meth_wxRichTextRange_IsWithin), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextRange_IsWithin},
    {sipName_LimitTo, SIP_MLMETH_CAST(meth_wxRichTextRange_LimitTo), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextRange_LimitTo},
    {sipName_SetEnd, SIP_MLMETH_CAST(meth_wxRichTextRange_SetEnd), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextRange_SetEnd},
    {sipName_SetRange, SIP_MLMETH_CAST(meth_wxRichTextRange_SetRange), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextRange_SetRange},
    {sipName_SetStart, SIP_MLMETH_CAST(meth_wxRichTextRange_SetStart), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextRange_SetStart},
    {sipName_Swap, meth_wxRichTextRange_Swap, METH_VARARGS, doc_wxRichTextRange_Swap},
    {sipName_ToInternal, meth_wxRichTextRange_ToInternal, METH_VARARGS, doc_wxRichTextRange_ToInternal}
};

sipVariableDef variables_wxRichTextRange[] = {
    {PropertyVariable, sipName_Start, &methods_wxRichTextRange[5], &methods_wxRichTextRange[11], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Length, &methods_wxRichTextRange[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_End, &methods_wxRichTextRange[3], &methods_wxRichTextRange[9], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxRichTextRange, "RichTextRange() -> None\n"
"RichTextRange(start, end) -> None\n"
"RichTextRange(range) -> None\n"
"\n"
"This stores beginning and end positions for a range of data.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextRange = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxRichTextRange,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_RichTextRange,
        {0, 0, 1},
        14, methods_wxRichTextRange,
        0, SIP_NULLPTR,
        3, variables_wxRichTextRange,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxRichTextRange,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxRichTextRange,
    init_type_wxRichTextRange,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxRichTextRange,
    assign_wxRichTextRange,
    array_wxRichTextRange,
    copy_wxRichTextRange,
    release_wxRichTextRange,
    SIP_NULLPTR,
    convertTo_wxRichTextRange,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxRichTextRange,
    sizeof (::wxRichTextRange),
};
