#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 365
#define LARGE_STATE_COUNT 34
#define SYMBOL_COUNT 110
#define ALIAS_COUNT 9
#define TOKEN_COUNT 51
#define EXTERNAL_TOKEN_COUNT 40
#define FIELD_COUNT 3
#define MAX_ALIAS_SEQUENCE_LENGTH 4
#define PRODUCTION_ID_COUNT 27

enum {
  aux_sym__classifiers_token1 = 1,
  aux_sym_target_token1 = 2,
  anon_sym_COLON_COLON = 3,
  anon_sym_ = 4,
  anon_sym_TAB = 5,
  anon_sym_2 = 6,
  anon_sym_3 = 7,
  anon_sym_4 = 8,
  sym___newline = 9,
  sym___whitespace = 10,
  sym__newline = 11,
  sym__blankline = 12,
  sym__indent = 13,
  sym__newline_indent = 14,
  sym__dedent = 15,
  sym__overline = 16,
  sym__underline = 17,
  sym_transition = 18,
  sym__char_bullet = 19,
  sym__numeric_bullet = 20,
  sym__field_mark = 21,
  sym__field_mark_end = 22,
  sym__literal_indented_block_mark = 23,
  sym__literal_quoted_block_mark = 24,
  sym__quoted_literal_block = 25,
  sym__line_block_mark = 26,
  sym__attribution_mark = 27,
  sym__doctest_block_mark = 28,
  sym__text = 29,
  sym_emphasis = 30,
  sym_strong = 31,
  sym__interpreted_text = 32,
  sym__interpreted_text_prefix = 33,
  sym__role_name_prefix = 34,
  sym__role_name_suffix = 35,
  sym_literal = 36,
  sym_substitution_reference = 37,
  sym_inline_target = 38,
  sym_footnote_reference = 39,
  sym_citation_reference = 40,
  sym_reference = 41,
  sym_standalone_hyperlink = 42,
  sym__explicit_markup_start = 43,
  sym__footnote_label = 44,
  sym__citation_label = 45,
  sym__target_name = 46,
  sym__anonymous_target_mark = 47,
  sym__directive_name = 48,
  sym__substitution_mark = 49,
  sym__empty_comment = 50,
  sym_document = 51,
  sym_section = 52,
  sym__overline_section = 53,
  sym__underline_section = 54,
  sym__transition_block = 55,
  sym__body_element_block = 56,
  sym_body = 57,
  sym__body_element = 58,
  sym_paragraph = 59,
  sym__paragraph_line = 60,
  sym__list = 61,
  sym_bullet_list = 62,
  sym__bullet_list_item = 63,
  sym_enumerated_list = 64,
  sym__numeric_list_item = 65,
  sym_definition_list = 66,
  sym__definition_list_item = 67,
  aux_sym__classifiers = 68,
  sym_field_list = 69,
  sym_field = 70,
  sym__literal_block = 71,
  sym__indented_text_block = 72,
  sym_line_block = 73,
  sym_line = 74,
  sym__block_quote_block = 75,
  sym_block_quote = 76,
  sym_attribution = 77,
  sym_doctest_block = 78,
  aux_sym__explicit_markup_block = 79,
  sym__markup_block = 80,
  sym_footnote = 81,
  sym_citation = 82,
  sym_target = 83,
  sym__anonymous_target = 84,
  sym_directive = 85,
  sym__directive_body = 86,
  sym_substitution_definition = 87,
  sym__embedded_directive = 88,
  sym_comment = 89,
  sym__line = 90,
  aux_sym__text_block = 91,
  sym__text_line = 92,
  sym__inline_markup = 93,
  sym_interpreted_text = 94,
  sym__default_role = 95,
  sym__prefix_role = 96,
  sym__suffix_role = 97,
  aux_sym_document_repeat1 = 98,
  aux_sym_body_repeat1 = 99,
  aux_sym_paragraph_repeat1 = 100,
  aux_sym__paragraph_line_repeat1 = 101,
  aux_sym_bullet_list_repeat1 = 102,
  aux_sym_enumerated_list_repeat1 = 103,
  aux_sym_definition_list_repeat1 = 104,
  aux_sym_field_list_repeat1 = 105,
  aux_sym__indented_text_block_repeat1 = 106,
  aux_sym_line_block_repeat1 = 107,
  aux_sym_line_repeat1 = 108,
  aux_sym__text_line_repeat1 = 109,
  alias_sym_arguments = 110,
  alias_sym_classifier = 111,
  alias_sym_content = 112,
  alias_sym_definition = 113,
  alias_sym_field_body = 114,
  alias_sym_field_name = 115,
  alias_sym_options = 116,
  alias_sym_term = 117,
  alias_sym_title = 118,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [aux_sym__classifiers_token1] = ":",
  [aux_sym_target_token1] = "link",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_] = " ",
  [anon_sym_TAB] = "\t",
  [anon_sym_2] = "",
  [anon_sym_3] = "\f",
  [anon_sym_4] = " ",
  [sym___newline] = "__newline",
  [sym___whitespace] = "__whitespace",
  [sym__newline] = "_newline",
  [sym__blankline] = "_blankline",
  [sym__indent] = "_indent",
  [sym__newline_indent] = "_newline_indent",
  [sym__dedent] = "_dedent",
  [sym__overline] = "adornment",
  [sym__underline] = "adornment",
  [sym_transition] = "transition",
  [sym__char_bullet] = "bullet",
  [sym__numeric_bullet] = "bullet",
  [sym__field_mark] = ":",
  [sym__field_mark_end] = ":",
  [sym__literal_indented_block_mark] = "::",
  [sym__literal_quoted_block_mark] = "::",
  [sym__quoted_literal_block] = "literal_block",
  [sym__line_block_mark] = "|",
  [sym__attribution_mark] = "--",
  [sym__doctest_block_mark] = "_doctest_block_mark",
  [sym__text] = "text",
  [sym_emphasis] = "emphasis",
  [sym_strong] = "strong",
  [sym__interpreted_text] = "interpreted_text",
  [sym__interpreted_text_prefix] = "interpreted_text",
  [sym__role_name_prefix] = "role",
  [sym__role_name_suffix] = "role",
  [sym_literal] = "literal",
  [sym_substitution_reference] = "substitution_reference",
  [sym_inline_target] = "inline_target",
  [sym_footnote_reference] = "footnote_reference",
  [sym_citation_reference] = "citation_reference",
  [sym_reference] = "reference",
  [sym_standalone_hyperlink] = "standalone_hyperlink",
  [sym__explicit_markup_start] = "..",
  [sym__footnote_label] = "label",
  [sym__citation_label] = "label",
  [sym__target_name] = "name",
  [sym__anonymous_target_mark] = "__",
  [sym__directive_name] = "type",
  [sym__substitution_mark] = "substitution",
  [sym__empty_comment] = "comment",
  [sym_document] = "document",
  [sym_section] = "section",
  [sym__overline_section] = "_overline_section",
  [sym__underline_section] = "_underline_section",
  [sym__transition_block] = "_transition_block",
  [sym__body_element_block] = "_body_element_block",
  [sym_body] = "body",
  [sym__body_element] = "_body_element",
  [sym_paragraph] = "paragraph",
  [sym__paragraph_line] = "_paragraph_line",
  [sym__list] = "_list",
  [sym_bullet_list] = "bullet_list",
  [sym__bullet_list_item] = "list_item",
  [sym_enumerated_list] = "enumerated_list",
  [sym__numeric_list_item] = "list_item",
  [sym_definition_list] = "definition_list",
  [sym__definition_list_item] = "list_item",
  [aux_sym__classifiers] = "_classifiers",
  [sym_field_list] = "field_list",
  [sym_field] = "field",
  [sym__literal_block] = "_literal_block",
  [sym__indented_text_block] = "_indented_text_block",
  [sym_line_block] = "line_block",
  [sym_line] = "line",
  [sym__block_quote_block] = "_block_quote_block",
  [sym_block_quote] = "block_quote",
  [sym_attribution] = "attribution",
  [sym_doctest_block] = "doctest_block",
  [aux_sym__explicit_markup_block] = "_explicit_markup_block",
  [sym__markup_block] = "_markup_block",
  [sym_footnote] = "footnote",
  [sym_citation] = "citation",
  [sym_target] = "target",
  [sym__anonymous_target] = "target",
  [sym_directive] = "directive",
  [sym__directive_body] = "body",
  [sym_substitution_definition] = "substitution_definition",
  [sym__embedded_directive] = "directive",
  [sym_comment] = "comment",
  [sym__line] = "_line",
  [aux_sym__text_block] = "_text_block",
  [sym__text_line] = "_text_line",
  [sym__inline_markup] = "_inline_markup",
  [sym_interpreted_text] = "interpreted_text",
  [sym__default_role] = "_default_role",
  [sym__prefix_role] = "_prefix_role",
  [sym__suffix_role] = "_suffix_role",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_body_repeat1] = "body_repeat1",
  [aux_sym_paragraph_repeat1] = "paragraph_repeat1",
  [aux_sym__paragraph_line_repeat1] = "_paragraph_line_repeat1",
  [aux_sym_bullet_list_repeat1] = "bullet_list_repeat1",
  [aux_sym_enumerated_list_repeat1] = "enumerated_list_repeat1",
  [aux_sym_definition_list_repeat1] = "definition_list_repeat1",
  [aux_sym_field_list_repeat1] = "field_list_repeat1",
  [aux_sym__indented_text_block_repeat1] = "_indented_text_block_repeat1",
  [aux_sym_line_block_repeat1] = "line_block_repeat1",
  [aux_sym_line_repeat1] = "line_repeat1",
  [aux_sym__text_line_repeat1] = "_text_line_repeat1",
  [alias_sym_arguments] = "arguments",
  [alias_sym_classifier] = "classifier",
  [alias_sym_content] = "content",
  [alias_sym_definition] = "definition",
  [alias_sym_field_body] = "field_body",
  [alias_sym_field_name] = "field_name",
  [alias_sym_options] = "options",
  [alias_sym_term] = "term",
  [alias_sym_title] = "title",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [aux_sym__classifiers_token1] = sym__field_mark,
  [aux_sym_target_token1] = aux_sym_target_token1,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_] = anon_sym_,
  [anon_sym_TAB] = anon_sym_TAB,
  [anon_sym_2] = anon_sym_2,
  [anon_sym_3] = anon_sym_3,
  [anon_sym_4] = anon_sym_4,
  [sym___newline] = sym___newline,
  [sym___whitespace] = sym___whitespace,
  [sym__newline] = sym__newline,
  [sym__blankline] = sym__blankline,
  [sym__indent] = sym__indent,
  [sym__newline_indent] = sym__newline_indent,
  [sym__dedent] = sym__dedent,
  [sym__overline] = sym__overline,
  [sym__underline] = sym__overline,
  [sym_transition] = sym_transition,
  [sym__char_bullet] = sym__char_bullet,
  [sym__numeric_bullet] = sym__char_bullet,
  [sym__field_mark] = sym__field_mark,
  [sym__field_mark_end] = sym__field_mark,
  [sym__literal_indented_block_mark] = anon_sym_COLON_COLON,
  [sym__literal_quoted_block_mark] = anon_sym_COLON_COLON,
  [sym__quoted_literal_block] = sym__quoted_literal_block,
  [sym__line_block_mark] = sym__line_block_mark,
  [sym__attribution_mark] = sym__attribution_mark,
  [sym__doctest_block_mark] = sym__doctest_block_mark,
  [sym__text] = sym__text,
  [sym_emphasis] = sym_emphasis,
  [sym_strong] = sym_strong,
  [sym__interpreted_text] = sym__interpreted_text,
  [sym__interpreted_text_prefix] = sym__interpreted_text,
  [sym__role_name_prefix] = sym__role_name_prefix,
  [sym__role_name_suffix] = sym__role_name_prefix,
  [sym_literal] = sym_literal,
  [sym_substitution_reference] = sym_substitution_reference,
  [sym_inline_target] = sym_inline_target,
  [sym_footnote_reference] = sym_footnote_reference,
  [sym_citation_reference] = sym_citation_reference,
  [sym_reference] = sym_reference,
  [sym_standalone_hyperlink] = sym_standalone_hyperlink,
  [sym__explicit_markup_start] = sym__explicit_markup_start,
  [sym__footnote_label] = sym__footnote_label,
  [sym__citation_label] = sym__footnote_label,
  [sym__target_name] = sym__target_name,
  [sym__anonymous_target_mark] = sym__anonymous_target_mark,
  [sym__directive_name] = sym__directive_name,
  [sym__substitution_mark] = sym__substitution_mark,
  [sym__empty_comment] = sym_comment,
  [sym_document] = sym_document,
  [sym_section] = sym_section,
  [sym__overline_section] = sym__overline_section,
  [sym__underline_section] = sym__underline_section,
  [sym__transition_block] = sym__transition_block,
  [sym__body_element_block] = sym__body_element_block,
  [sym_body] = sym_body,
  [sym__body_element] = sym__body_element,
  [sym_paragraph] = sym_paragraph,
  [sym__paragraph_line] = sym__paragraph_line,
  [sym__list] = sym__list,
  [sym_bullet_list] = sym_bullet_list,
  [sym__bullet_list_item] = sym__bullet_list_item,
  [sym_enumerated_list] = sym_enumerated_list,
  [sym__numeric_list_item] = sym__bullet_list_item,
  [sym_definition_list] = sym_definition_list,
  [sym__definition_list_item] = sym__bullet_list_item,
  [aux_sym__classifiers] = aux_sym__classifiers,
  [sym_field_list] = sym_field_list,
  [sym_field] = sym_field,
  [sym__literal_block] = sym__literal_block,
  [sym__indented_text_block] = sym__indented_text_block,
  [sym_line_block] = sym_line_block,
  [sym_line] = sym_line,
  [sym__block_quote_block] = sym__block_quote_block,
  [sym_block_quote] = sym_block_quote,
  [sym_attribution] = sym_attribution,
  [sym_doctest_block] = sym_doctest_block,
  [aux_sym__explicit_markup_block] = aux_sym__explicit_markup_block,
  [sym__markup_block] = sym__markup_block,
  [sym_footnote] = sym_footnote,
  [sym_citation] = sym_citation,
  [sym_target] = sym_target,
  [sym__anonymous_target] = sym_target,
  [sym_directive] = sym_directive,
  [sym__directive_body] = sym_body,
  [sym_substitution_definition] = sym_substitution_definition,
  [sym__embedded_directive] = sym_directive,
  [sym_comment] = sym_comment,
  [sym__line] = sym__line,
  [aux_sym__text_block] = aux_sym__text_block,
  [sym__text_line] = sym__text_line,
  [sym__inline_markup] = sym__inline_markup,
  [sym_interpreted_text] = sym_interpreted_text,
  [sym__default_role] = sym__default_role,
  [sym__prefix_role] = sym__prefix_role,
  [sym__suffix_role] = sym__suffix_role,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_body_repeat1] = aux_sym_body_repeat1,
  [aux_sym_paragraph_repeat1] = aux_sym_paragraph_repeat1,
  [aux_sym__paragraph_line_repeat1] = aux_sym__paragraph_line_repeat1,
  [aux_sym_bullet_list_repeat1] = aux_sym_bullet_list_repeat1,
  [aux_sym_enumerated_list_repeat1] = aux_sym_enumerated_list_repeat1,
  [aux_sym_definition_list_repeat1] = aux_sym_definition_list_repeat1,
  [aux_sym_field_list_repeat1] = aux_sym_field_list_repeat1,
  [aux_sym__indented_text_block_repeat1] = aux_sym__indented_text_block_repeat1,
  [aux_sym_line_block_repeat1] = aux_sym_line_block_repeat1,
  [aux_sym_line_repeat1] = aux_sym_line_repeat1,
  [aux_sym__text_line_repeat1] = aux_sym__text_line_repeat1,
  [alias_sym_arguments] = alias_sym_arguments,
  [alias_sym_classifier] = alias_sym_classifier,
  [alias_sym_content] = alias_sym_content,
  [alias_sym_definition] = alias_sym_definition,
  [alias_sym_field_body] = alias_sym_field_body,
  [alias_sym_field_name] = alias_sym_field_name,
  [alias_sym_options] = alias_sym_options,
  [alias_sym_term] = alias_sym_term,
  [alias_sym_title] = alias_sym_title,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__classifiers_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_target_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TAB] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_4] = {
    .visible = true,
    .named = false,
  },
  [sym___newline] = {
    .visible = false,
    .named = true,
  },
  [sym___whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__blankline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__newline_indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__overline] = {
    .visible = true,
    .named = false,
  },
  [sym__underline] = {
    .visible = true,
    .named = false,
  },
  [sym_transition] = {
    .visible = true,
    .named = true,
  },
  [sym__char_bullet] = {
    .visible = true,
    .named = false,
  },
  [sym__numeric_bullet] = {
    .visible = true,
    .named = false,
  },
  [sym__field_mark] = {
    .visible = true,
    .named = false,
  },
  [sym__field_mark_end] = {
    .visible = true,
    .named = false,
  },
  [sym__literal_indented_block_mark] = {
    .visible = true,
    .named = false,
  },
  [sym__literal_quoted_block_mark] = {
    .visible = true,
    .named = false,
  },
  [sym__quoted_literal_block] = {
    .visible = true,
    .named = true,
  },
  [sym__line_block_mark] = {
    .visible = true,
    .named = false,
  },
  [sym__attribution_mark] = {
    .visible = true,
    .named = false,
  },
  [sym__doctest_block_mark] = {
    .visible = false,
    .named = true,
  },
  [sym__text] = {
    .visible = true,
    .named = false,
  },
  [sym_emphasis] = {
    .visible = true,
    .named = true,
  },
  [sym_strong] = {
    .visible = true,
    .named = true,
  },
  [sym__interpreted_text] = {
    .visible = true,
    .named = false,
  },
  [sym__interpreted_text_prefix] = {
    .visible = true,
    .named = false,
  },
  [sym__role_name_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym__role_name_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_target] = {
    .visible = true,
    .named = true,
  },
  [sym_footnote_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_citation_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_standalone_hyperlink] = {
    .visible = true,
    .named = true,
  },
  [sym__explicit_markup_start] = {
    .visible = true,
    .named = false,
  },
  [sym__footnote_label] = {
    .visible = true,
    .named = true,
  },
  [sym__citation_label] = {
    .visible = true,
    .named = true,
  },
  [sym__target_name] = {
    .visible = true,
    .named = true,
  },
  [sym__anonymous_target_mark] = {
    .visible = true,
    .named = false,
  },
  [sym__directive_name] = {
    .visible = true,
    .named = true,
  },
  [sym__substitution_mark] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym_section] = {
    .visible = true,
    .named = true,
  },
  [sym__overline_section] = {
    .visible = false,
    .named = true,
  },
  [sym__underline_section] = {
    .visible = false,
    .named = true,
  },
  [sym__transition_block] = {
    .visible = false,
    .named = true,
  },
  [sym__body_element_block] = {
    .visible = false,
    .named = true,
  },
  [sym_body] = {
    .visible = true,
    .named = true,
  },
  [sym__body_element] = {
    .visible = false,
    .named = true,
  },
  [sym_paragraph] = {
    .visible = true,
    .named = true,
  },
  [sym__paragraph_line] = {
    .visible = false,
    .named = true,
  },
  [sym__list] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_bullet_list] = {
    .visible = true,
    .named = true,
  },
  [sym__bullet_list_item] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerated_list] = {
    .visible = true,
    .named = true,
  },
  [sym__numeric_list_item] = {
    .visible = true,
    .named = true,
  },
  [sym_definition_list] = {
    .visible = true,
    .named = true,
  },
  [sym__definition_list_item] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__classifiers] = {
    .visible = false,
    .named = false,
  },
  [sym_field_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym__literal_block] = {
    .visible = false,
    .named = true,
  },
  [sym__indented_text_block] = {
    .visible = false,
    .named = true,
  },
  [sym_line_block] = {
    .visible = true,
    .named = true,
  },
  [sym_line] = {
    .visible = true,
    .named = true,
  },
  [sym__block_quote_block] = {
    .visible = false,
    .named = true,
  },
  [sym_block_quote] = {
    .visible = true,
    .named = true,
  },
  [sym_attribution] = {
    .visible = true,
    .named = true,
  },
  [sym_doctest_block] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__explicit_markup_block] = {
    .visible = false,
    .named = false,
  },
  [sym__markup_block] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_footnote] = {
    .visible = true,
    .named = true,
  },
  [sym_citation] = {
    .visible = true,
    .named = true,
  },
  [sym_target] = {
    .visible = true,
    .named = true,
  },
  [sym__anonymous_target] = {
    .visible = true,
    .named = true,
  },
  [sym_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__directive_body] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__embedded_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__line] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__text_block] = {
    .visible = false,
    .named = false,
  },
  [sym__text_line] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_markup] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_interpreted_text] = {
    .visible = true,
    .named = true,
  },
  [sym__default_role] = {
    .visible = false,
    .named = true,
  },
  [sym__prefix_role] = {
    .visible = false,
    .named = true,
  },
  [sym__suffix_role] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_paragraph_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__paragraph_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bullet_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumerated_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_definition_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__indented_text_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_line_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__text_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_classifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_content] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_definition] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_field_body] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_field_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_options] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_term] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_title] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_body = 1,
  field_link = 2,
  field_name = 3,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_body] = "body",
  [field_link] = "link",
  [field_name] = "name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [5] = {.index = 1, .length = 2},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 4},
  [8] = {.index = 8, .length = 1},
  [13] = {.index = 9, .length = 2},
  [14] = {.index = 11, .length = 2},
  [24] = {.index = 13, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_link, 0, .inherited = true},
  [1] =
    {field_body, 2},
    {field_name, 1},
  [3] =
    {field_name, 1},
  [4] =
    {field_body, 2},
    {field_body, 2, .inherited = true},
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [8] =
    {field_link, 1},
  [9] =
    {field_link, 2},
    {field_name, 1},
  [11] =
    {field_body, 3},
    {field_name, 1},
  [13] =
    {field_body, 3},
    {field_name, 0},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [1] = sym__quoted_literal_block,
  },
  [3] = {
    [0] = alias_sym_title,
  },
  [4] = {
    [1] = alias_sym_title,
  },
  [9] = {
    [0] = alias_sym_term,
    [2] = alias_sym_definition,
  },
  [10] = {
    [1] = alias_sym_classifier,
  },
  [11] = {
    [1] = alias_sym_field_name,
  },
  [12] = {
    [1] = alias_sym_field_name,
    [3] = alias_sym_field_body,
  },
  [15] = {
    [0] = alias_sym_term,
    [3] = alias_sym_definition,
  },
  [16] = {
    [1] = alias_sym_content,
  },
  [17] = {
    [0] = alias_sym_options,
  },
  [18] = {
    [0] = alias_sym_arguments,
  },
  [19] = {
    [0] = alias_sym_arguments,
    [1] = alias_sym_content,
  },
  [20] = {
    [1] = alias_sym_options,
  },
  [21] = {
    [0] = alias_sym_options,
    [2] = alias_sym_content,
  },
  [22] = {
    [0] = alias_sym_arguments,
    [2] = alias_sym_content,
  },
  [23] = {
    [0] = alias_sym_arguments,
    [1] = alias_sym_options,
  },
  [25] = {
    [1] = alias_sym_options,
    [3] = alias_sym_content,
  },
  [26] = {
    [0] = alias_sym_arguments,
    [1] = alias_sym_options,
    [3] = alias_sym_content,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_body, 3,
    sym_body,
    alias_sym_definition,
    alias_sym_field_body,
  sym_field_list, 2,
    sym_field_list,
    alias_sym_options,
  sym__indented_text_block, 3,
    sym__indented_text_block,
    alias_sym_content,
    sym__quoted_literal_block,
  sym__line, 2,
    sym__line,
    alias_sym_title,
  sym__text_line, 2,
    sym__text_line,
    alias_sym_arguments,
  aux_sym__paragraph_line_repeat1, 4,
    aux_sym__paragraph_line_repeat1,
    alias_sym_classifier,
    alias_sym_field_name,
    alias_sym_term,
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(8);
      if (lookahead == '\t') ADVANCE(14);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == 11) ADVANCE(15);
      if (lookahead == '\f') ADVANCE(16);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == ' ') ADVANCE(13);
      if (lookahead == ':') ADVANCE(2);
      if (lookahead == 160) ADVANCE(17);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(18);
      END_STATE();
    case 2:
      if (lookahead == ':') ADVANCE(12);
      END_STATE();
    case 3:
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(20);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 160) ADVANCE(10);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead != 0) ADVANCE(11);
      END_STATE();
    case 4:
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(11);
      END_STATE();
    case 5:
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 160) ADVANCE(21);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '\r') ADVANCE(1);
      END_STATE();
    case 6:
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 160) ADVANCE(9);
      END_STATE();
    case 7:
      if (eof) ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 160) ADVANCE(20);
      if (lookahead == '\n') ADVANCE(18);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == ':') ADVANCE(2);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 9:
      ACCEPT_TOKEN(aux_sym__classifiers_token1);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 160) ADVANCE(9);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(aux_sym_target_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(19);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 160) ADVANCE(10);
      if (lookahead == '\r') ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(11);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(aux_sym_target_token1);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(11);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 160) ADVANCE(20);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_TAB);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 160) ADVANCE(20);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_2);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 160) ADVANCE(20);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_3);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 160) ADVANCE(20);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_4);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 160) ADVANCE(20);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(sym___newline);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym___whitespace);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(19);
      if (lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == 160) ADVANCE(10);
      if (lookahead == '\r') ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(11);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(sym___whitespace);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 160) ADVANCE(20);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym___whitespace);
      if (lookahead == '\t' ||
          lookahead == 11 ||
          lookahead == '\f' ||
          lookahead == ' ' ||
          lookahead == 160) ADVANCE(21);
      if (lookahead == ':') ADVANCE(6);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 7, .external_lex_state = 2},
  [2] = {.lex_state = 7, .external_lex_state = 2},
  [3] = {.lex_state = 7, .external_lex_state = 2},
  [4] = {.lex_state = 7, .external_lex_state = 3},
  [5] = {.lex_state = 7, .external_lex_state = 3},
  [6] = {.lex_state = 7, .external_lex_state = 3},
  [7] = {.lex_state = 7, .external_lex_state = 4},
  [8] = {.lex_state = 7, .external_lex_state = 4},
  [9] = {.lex_state = 7, .external_lex_state = 4},
  [10] = {.lex_state = 7, .external_lex_state = 3},
  [11] = {.lex_state = 7, .external_lex_state = 4},
  [12] = {.lex_state = 7, .external_lex_state = 4},
  [13] = {.lex_state = 7, .external_lex_state = 4},
  [14] = {.lex_state = 7, .external_lex_state = 4},
  [15] = {.lex_state = 7, .external_lex_state = 4},
  [16] = {.lex_state = 7, .external_lex_state = 4},
  [17] = {.lex_state = 7, .external_lex_state = 4},
  [18] = {.lex_state = 7, .external_lex_state = 5},
  [19] = {.lex_state = 7, .external_lex_state = 5},
  [20] = {.lex_state = 7, .external_lex_state = 5},
  [21] = {.lex_state = 7, .external_lex_state = 5},
  [22] = {.lex_state = 7, .external_lex_state = 3},
  [23] = {.lex_state = 7, .external_lex_state = 5},
  [24] = {.lex_state = 7, .external_lex_state = 5},
  [25] = {.lex_state = 7, .external_lex_state = 5},
  [26] = {.lex_state = 7, .external_lex_state = 5},
  [27] = {.lex_state = 7, .external_lex_state = 5},
  [28] = {.lex_state = 7, .external_lex_state = 5},
  [29] = {.lex_state = 7, .external_lex_state = 5},
  [30] = {.lex_state = 7, .external_lex_state = 5},
  [31] = {.lex_state = 7, .external_lex_state = 5},
  [32] = {.lex_state = 7, .external_lex_state = 5},
  [33] = {.lex_state = 7, .external_lex_state = 5},
  [34] = {.lex_state = 7, .external_lex_state = 2},
  [35] = {.lex_state = 7, .external_lex_state = 2},
  [36] = {.lex_state = 7, .external_lex_state = 2},
  [37] = {.lex_state = 7, .external_lex_state = 2},
  [38] = {.lex_state = 7, .external_lex_state = 2},
  [39] = {.lex_state = 5, .external_lex_state = 6},
  [40] = {.lex_state = 5, .external_lex_state = 6},
  [41] = {.lex_state = 5, .external_lex_state = 6},
  [42] = {.lex_state = 7, .external_lex_state = 3},
  [43] = {.lex_state = 5, .external_lex_state = 6},
  [44] = {.lex_state = 7, .external_lex_state = 5},
  [45] = {.lex_state = 7, .external_lex_state = 7},
  [46] = {.lex_state = 7, .external_lex_state = 8},
  [47] = {.lex_state = 7, .external_lex_state = 8},
  [48] = {.lex_state = 7, .external_lex_state = 7},
  [49] = {.lex_state = 7, .external_lex_state = 7},
  [50] = {.lex_state = 7, .external_lex_state = 7},
  [51] = {.lex_state = 7, .external_lex_state = 9},
  [52] = {.lex_state = 7, .external_lex_state = 10},
  [53] = {.lex_state = 7, .external_lex_state = 10},
  [54] = {.lex_state = 7, .external_lex_state = 9},
  [55] = {.lex_state = 5, .external_lex_state = 11},
  [56] = {.lex_state = 7, .external_lex_state = 10},
  [57] = {.lex_state = 7, .external_lex_state = 10},
  [58] = {.lex_state = 7, .external_lex_state = 8},
  [59] = {.lex_state = 7, .external_lex_state = 9},
  [60] = {.lex_state = 7, .external_lex_state = 10},
  [61] = {.lex_state = 7, .external_lex_state = 10},
  [62] = {.lex_state = 5, .external_lex_state = 11},
  [63] = {.lex_state = 7, .external_lex_state = 9},
  [64] = {.lex_state = 5, .external_lex_state = 11},
  [65] = {.lex_state = 5, .external_lex_state = 11},
  [66] = {.lex_state = 7, .external_lex_state = 12},
  [67] = {.lex_state = 7, .external_lex_state = 13},
  [68] = {.lex_state = 7, .external_lex_state = 14},
  [69] = {.lex_state = 7, .external_lex_state = 12},
  [70] = {.lex_state = 7, .external_lex_state = 13},
  [71] = {.lex_state = 7, .external_lex_state = 13},
  [72] = {.lex_state = 7, .external_lex_state = 14},
  [73] = {.lex_state = 7, .external_lex_state = 14},
  [74] = {.lex_state = 7, .external_lex_state = 12},
  [75] = {.lex_state = 7, .external_lex_state = 12},
  [76] = {.lex_state = 7, .external_lex_state = 12},
  [77] = {.lex_state = 5, .external_lex_state = 6},
  [78] = {.lex_state = 5, .external_lex_state = 6},
  [79] = {.lex_state = 5, .external_lex_state = 6},
  [80] = {.lex_state = 5, .external_lex_state = 6},
  [81] = {.lex_state = 5, .external_lex_state = 6},
  [82] = {.lex_state = 7, .external_lex_state = 8},
  [83] = {.lex_state = 7, .external_lex_state = 8},
  [84] = {.lex_state = 7, .external_lex_state = 8},
  [85] = {.lex_state = 7, .external_lex_state = 8},
  [86] = {.lex_state = 7, .external_lex_state = 8},
  [87] = {.lex_state = 7, .external_lex_state = 7},
  [88] = {.lex_state = 5, .external_lex_state = 11},
  [89] = {.lex_state = 7, .external_lex_state = 7},
  [90] = {.lex_state = 7, .external_lex_state = 7},
  [91] = {.lex_state = 7, .external_lex_state = 15},
  [92] = {.lex_state = 5, .external_lex_state = 11},
  [93] = {.lex_state = 7, .external_lex_state = 7},
  [94] = {.lex_state = 5, .external_lex_state = 11},
  [95] = {.lex_state = 5, .external_lex_state = 11},
  [96] = {.lex_state = 5, .external_lex_state = 11},
  [97] = {.lex_state = 7, .external_lex_state = 7},
  [98] = {.lex_state = 7, .external_lex_state = 7},
  [99] = {.lex_state = 7, .external_lex_state = 13},
  [100] = {.lex_state = 7, .external_lex_state = 16},
  [101] = {.lex_state = 7, .external_lex_state = 10},
  [102] = {.lex_state = 7, .external_lex_state = 9},
  [103] = {.lex_state = 7, .external_lex_state = 13},
  [104] = {.lex_state = 7, .external_lex_state = 16},
  [105] = {.lex_state = 7, .external_lex_state = 14},
  [106] = {.lex_state = 7, .external_lex_state = 9},
  [107] = {.lex_state = 7, .external_lex_state = 9},
  [108] = {.lex_state = 7, .external_lex_state = 14},
  [109] = {.lex_state = 7, .external_lex_state = 13},
  [110] = {.lex_state = 7, .external_lex_state = 14},
  [111] = {.lex_state = 7, .external_lex_state = 14},
  [112] = {.lex_state = 7, .external_lex_state = 13},
  [113] = {.lex_state = 7, .external_lex_state = 14},
  [114] = {.lex_state = 7, .external_lex_state = 9},
  [115] = {.lex_state = 7, .external_lex_state = 9},
  [116] = {.lex_state = 7, .external_lex_state = 9},
  [117] = {.lex_state = 7, .external_lex_state = 13},
  [118] = {.lex_state = 7, .external_lex_state = 17},
  [119] = {.lex_state = 7, .external_lex_state = 17},
  [120] = {.lex_state = 7, .external_lex_state = 18},
  [121] = {.lex_state = 7, .external_lex_state = 18},
  [122] = {.lex_state = 7, .external_lex_state = 19},
  [123] = {.lex_state = 7, .external_lex_state = 19},
  [124] = {.lex_state = 7, .external_lex_state = 20},
  [125] = {.lex_state = 7, .external_lex_state = 20},
  [126] = {.lex_state = 7, .external_lex_state = 20},
  [127] = {.lex_state = 7, .external_lex_state = 20},
  [128] = {.lex_state = 7, .external_lex_state = 21},
  [129] = {.lex_state = 7, .external_lex_state = 21},
  [130] = {.lex_state = 7, .external_lex_state = 22},
  [131] = {.lex_state = 7, .external_lex_state = 22},
  [132] = {.lex_state = 7, .external_lex_state = 22},
  [133] = {.lex_state = 7, .external_lex_state = 23},
  [134] = {.lex_state = 7, .external_lex_state = 23},
  [135] = {.lex_state = 0, .external_lex_state = 24},
  [136] = {.lex_state = 7, .external_lex_state = 23},
  [137] = {.lex_state = 7, .external_lex_state = 23},
  [138] = {.lex_state = 7, .external_lex_state = 23},
  [139] = {.lex_state = 7, .external_lex_state = 25},
  [140] = {.lex_state = 7, .external_lex_state = 23},
  [141] = {.lex_state = 7, .external_lex_state = 23},
  [142] = {.lex_state = 7, .external_lex_state = 25},
  [143] = {.lex_state = 7, .external_lex_state = 23},
  [144] = {.lex_state = 0, .external_lex_state = 24},
  [145] = {.lex_state = 7, .external_lex_state = 23},
  [146] = {.lex_state = 7, .external_lex_state = 25},
  [147] = {.lex_state = 7, .external_lex_state = 25},
  [148] = {.lex_state = 7, .external_lex_state = 25},
  [149] = {.lex_state = 7, .external_lex_state = 23},
  [150] = {.lex_state = 7, .external_lex_state = 25},
  [151] = {.lex_state = 7, .external_lex_state = 25},
  [152] = {.lex_state = 7, .external_lex_state = 25},
  [153] = {.lex_state = 7, .external_lex_state = 25},
  [154] = {.lex_state = 7, .external_lex_state = 25},
  [155] = {.lex_state = 7, .external_lex_state = 25},
  [156] = {.lex_state = 7, .external_lex_state = 26},
  [157] = {.lex_state = 7, .external_lex_state = 16},
  [158] = {.lex_state = 7, .external_lex_state = 16},
  [159] = {.lex_state = 7, .external_lex_state = 23},
  [160] = {.lex_state = 7, .external_lex_state = 16},
  [161] = {.lex_state = 7, .external_lex_state = 16},
  [162] = {.lex_state = 7, .external_lex_state = 27},
  [163] = {.lex_state = 7, .external_lex_state = 26},
  [164] = {.lex_state = 7, .external_lex_state = 16},
  [165] = {.lex_state = 7, .external_lex_state = 28},
  [166] = {.lex_state = 7, .external_lex_state = 29},
  [167] = {.lex_state = 7, .external_lex_state = 23},
  [168] = {.lex_state = 7, .external_lex_state = 16},
  [169] = {.lex_state = 7, .external_lex_state = 30},
  [170] = {.lex_state = 7, .external_lex_state = 23},
  [171] = {.lex_state = 7, .external_lex_state = 23},
  [172] = {.lex_state = 7, .external_lex_state = 30},
  [173] = {.lex_state = 7, .external_lex_state = 30},
  [174] = {.lex_state = 7, .external_lex_state = 16},
  [175] = {.lex_state = 7, .external_lex_state = 16},
  [176] = {.lex_state = 7, .external_lex_state = 16},
  [177] = {.lex_state = 7, .external_lex_state = 16},
  [178] = {.lex_state = 7, .external_lex_state = 16},
  [179] = {.lex_state = 7, .external_lex_state = 16},
  [180] = {.lex_state = 7, .external_lex_state = 27},
  [181] = {.lex_state = 7, .external_lex_state = 16},
  [182] = {.lex_state = 7, .external_lex_state = 16},
  [183] = {.lex_state = 7, .external_lex_state = 28},
  [184] = {.lex_state = 7, .external_lex_state = 29},
  [185] = {.lex_state = 7, .external_lex_state = 16},
  [186] = {.lex_state = 7, .external_lex_state = 16},
  [187] = {.lex_state = 7, .external_lex_state = 16},
  [188] = {.lex_state = 7, .external_lex_state = 16},
  [189] = {.lex_state = 7, .external_lex_state = 23},
  [190] = {.lex_state = 7, .external_lex_state = 16},
  [191] = {.lex_state = 7, .external_lex_state = 16},
  [192] = {.lex_state = 7, .external_lex_state = 30},
  [193] = {.lex_state = 7, .external_lex_state = 16},
  [194] = {.lex_state = 7, .external_lex_state = 16},
  [195] = {.lex_state = 7, .external_lex_state = 23},
  [196] = {.lex_state = 7, .external_lex_state = 16},
  [197] = {.lex_state = 7, .external_lex_state = 16},
  [198] = {.lex_state = 7, .external_lex_state = 16},
  [199] = {.lex_state = 7, .external_lex_state = 16},
  [200] = {.lex_state = 7, .external_lex_state = 18},
  [201] = {.lex_state = 7, .external_lex_state = 17},
  [202] = {.lex_state = 7, .external_lex_state = 31},
  [203] = {.lex_state = 7, .external_lex_state = 17},
  [204] = {.lex_state = 7, .external_lex_state = 32},
  [205] = {.lex_state = 7, .external_lex_state = 17},
  [206] = {.lex_state = 7, .external_lex_state = 17},
  [207] = {.lex_state = 7, .external_lex_state = 17},
  [208] = {.lex_state = 7, .external_lex_state = 17},
  [209] = {.lex_state = 7, .external_lex_state = 23},
  [210] = {.lex_state = 7, .external_lex_state = 17},
  [211] = {.lex_state = 7, .external_lex_state = 17},
  [212] = {.lex_state = 7, .external_lex_state = 33},
  [213] = {.lex_state = 7, .external_lex_state = 17},
  [214] = {.lex_state = 7, .external_lex_state = 34},
  [215] = {.lex_state = 7, .external_lex_state = 17},
  [216] = {.lex_state = 7, .external_lex_state = 17},
  [217] = {.lex_state = 7, .external_lex_state = 17},
  [218] = {.lex_state = 7, .external_lex_state = 17},
  [219] = {.lex_state = 7, .external_lex_state = 17},
  [220] = {.lex_state = 7, .external_lex_state = 17},
  [221] = {.lex_state = 7, .external_lex_state = 17},
  [222] = {.lex_state = 7, .external_lex_state = 17},
  [223] = {.lex_state = 7, .external_lex_state = 17},
  [224] = {.lex_state = 7, .external_lex_state = 17},
  [225] = {.lex_state = 7, .external_lex_state = 17},
  [226] = {.lex_state = 7, .external_lex_state = 17},
  [227] = {.lex_state = 7, .external_lex_state = 17},
  [228] = {.lex_state = 7, .external_lex_state = 23},
  [229] = {.lex_state = 7, .external_lex_state = 34},
  [230] = {.lex_state = 7, .external_lex_state = 33},
  [231] = {.lex_state = 7, .external_lex_state = 31},
  [232] = {.lex_state = 7, .external_lex_state = 32},
  [233] = {.lex_state = 7, .external_lex_state = 17},
  [234] = {.lex_state = 7, .external_lex_state = 17},
  [235] = {.lex_state = 7, .external_lex_state = 17},
  [236] = {.lex_state = 7, .external_lex_state = 17},
  [237] = {.lex_state = 5, .external_lex_state = 35},
  [238] = {.lex_state = 5, .external_lex_state = 35},
  [239] = {.lex_state = 7, .external_lex_state = 25},
  [240] = {.lex_state = 7, .external_lex_state = 27},
  [241] = {.lex_state = 7, .external_lex_state = 28},
  [242] = {.lex_state = 7, .external_lex_state = 26},
  [243] = {.lex_state = 7, .external_lex_state = 26},
  [244] = {.lex_state = 7, .external_lex_state = 26},
  [245] = {.lex_state = 7, .external_lex_state = 27},
  [246] = {.lex_state = 7, .external_lex_state = 28},
  [247] = {.lex_state = 7, .external_lex_state = 36},
  [248] = {.lex_state = 7, .external_lex_state = 27},
  [249] = {.lex_state = 7, .external_lex_state = 29},
  [250] = {.lex_state = 7, .external_lex_state = 36},
  [251] = {.lex_state = 7, .external_lex_state = 36},
  [252] = {.lex_state = 5, .external_lex_state = 35},
  [253] = {.lex_state = 7, .external_lex_state = 29},
  [254] = {.lex_state = 7, .external_lex_state = 28},
  [255] = {.lex_state = 7, .external_lex_state = 28},
  [256] = {.lex_state = 7, .external_lex_state = 36},
  [257] = {.lex_state = 7, .external_lex_state = 31},
  [258] = {.lex_state = 7, .external_lex_state = 33},
  [259] = {.lex_state = 7, .external_lex_state = 37},
  [260] = {.lex_state = 3, .external_lex_state = 24},
  [261] = {.lex_state = 7, .external_lex_state = 37},
  [262] = {.lex_state = 7, .external_lex_state = 37},
  [263] = {.lex_state = 7, .external_lex_state = 31},
  [264] = {.lex_state = 7, .external_lex_state = 37},
  [265] = {.lex_state = 7, .external_lex_state = 37},
  [266] = {.lex_state = 7, .external_lex_state = 37},
  [267] = {.lex_state = 7, .external_lex_state = 37},
  [268] = {.lex_state = 7, .external_lex_state = 34},
  [269] = {.lex_state = 7, .external_lex_state = 37},
  [270] = {.lex_state = 7, .external_lex_state = 37},
  [271] = {.lex_state = 7, .external_lex_state = 33},
  [272] = {.lex_state = 7, .external_lex_state = 30},
  [273] = {.lex_state = 7, .external_lex_state = 37},
  [274] = {.lex_state = 7, .external_lex_state = 37},
  [275] = {.lex_state = 3, .external_lex_state = 24},
  [276] = {.lex_state = 7, .external_lex_state = 37},
  [277] = {.lex_state = 7, .external_lex_state = 37},
  [278] = {.lex_state = 7, .external_lex_state = 37},
  [279] = {.lex_state = 7, .external_lex_state = 37},
  [280] = {.lex_state = 7, .external_lex_state = 37},
  [281] = {.lex_state = 7, .external_lex_state = 37},
  [282] = {.lex_state = 7, .external_lex_state = 37},
  [283] = {.lex_state = 7, .external_lex_state = 37},
  [284] = {.lex_state = 7, .external_lex_state = 37},
  [285] = {.lex_state = 7, .external_lex_state = 37},
  [286] = {.lex_state = 7, .external_lex_state = 37},
  [287] = {.lex_state = 3, .external_lex_state = 38},
  [288] = {.lex_state = 7, .external_lex_state = 39},
  [289] = {.lex_state = 7, .external_lex_state = 37},
  [290] = {.lex_state = 7, .external_lex_state = 34},
  [291] = {.lex_state = 7, .external_lex_state = 37},
  [292] = {.lex_state = 7, .external_lex_state = 37},
  [293] = {.lex_state = 7, .external_lex_state = 31},
  [294] = {.lex_state = 7, .external_lex_state = 37},
  [295] = {.lex_state = 7, .external_lex_state = 37},
  [296] = {.lex_state = 7, .external_lex_state = 37},
  [297] = {.lex_state = 7, .external_lex_state = 39},
  [298] = {.lex_state = 7, .external_lex_state = 37},
  [299] = {.lex_state = 7, .external_lex_state = 37},
  [300] = {.lex_state = 3, .external_lex_state = 38},
  [301] = {.lex_state = 7, .external_lex_state = 37},
  [302] = {.lex_state = 7, .external_lex_state = 37},
  [303] = {.lex_state = 7, .external_lex_state = 32},
  [304] = {.lex_state = 7, .external_lex_state = 37},
  [305] = {.lex_state = 7, .external_lex_state = 31},
  [306] = {.lex_state = 7, .external_lex_state = 37},
  [307] = {.lex_state = 7, .external_lex_state = 37},
  [308] = {.lex_state = 7, .external_lex_state = 37},
  [309] = {.lex_state = 7, .external_lex_state = 37},
  [310] = {.lex_state = 7, .external_lex_state = 33},
  [311] = {.lex_state = 7, .external_lex_state = 32},
  [312] = {.lex_state = 7, .external_lex_state = 37},
  [313] = {.lex_state = 7, .external_lex_state = 34},
  [314] = {.lex_state = 7, .external_lex_state = 37},
  [315] = {.lex_state = 7, .external_lex_state = 40},
  [316] = {.lex_state = 7, .external_lex_state = 40},
  [317] = {.lex_state = 7, .external_lex_state = 41},
  [318] = {.lex_state = 7, .external_lex_state = 42},
  [319] = {.lex_state = 7, .external_lex_state = 43},
  [320] = {.lex_state = 7, .external_lex_state = 40},
  [321] = {.lex_state = 7, .external_lex_state = 38},
  [322] = {.lex_state = 7, .external_lex_state = 43},
  [323] = {.lex_state = 7, .external_lex_state = 44},
  [324] = {.lex_state = 7, .external_lex_state = 40},
  [325] = {.lex_state = 7, .external_lex_state = 40},
  [326] = {.lex_state = 7, .external_lex_state = 24},
  [327] = {.lex_state = 7, .external_lex_state = 24},
  [328] = {.lex_state = 7, .external_lex_state = 43},
  [329] = {.lex_state = 7},
  [330] = {.lex_state = 7, .external_lex_state = 38},
  [331] = {.lex_state = 7, .external_lex_state = 40},
  [332] = {.lex_state = 7},
  [333] = {.lex_state = 7, .external_lex_state = 38},
  [334] = {.lex_state = 7, .external_lex_state = 24},
  [335] = {.lex_state = 7, .external_lex_state = 24},
  [336] = {.lex_state = 7, .external_lex_state = 24},
  [337] = {.lex_state = 7, .external_lex_state = 24},
  [338] = {.lex_state = 7, .external_lex_state = 40},
  [339] = {.lex_state = 7, .external_lex_state = 40},
  [340] = {.lex_state = 7, .external_lex_state = 44},
  [341] = {.lex_state = 7, .external_lex_state = 44},
  [342] = {.lex_state = 7, .external_lex_state = 40},
  [343] = {.lex_state = 7, .external_lex_state = 38},
  [344] = {.lex_state = 7, .external_lex_state = 40},
  [345] = {.lex_state = 7, .external_lex_state = 44},
  [346] = {.lex_state = 7, .external_lex_state = 43},
  [347] = {.lex_state = 7, .external_lex_state = 42},
  [348] = {.lex_state = 7, .external_lex_state = 38},
  [349] = {.lex_state = 7},
  [350] = {.lex_state = 7, .external_lex_state = 41},
  [351] = {.lex_state = 7, .external_lex_state = 42},
  [352] = {.lex_state = 7, .external_lex_state = 40},
  [353] = {.lex_state = 7, .external_lex_state = 23},
  [354] = {.lex_state = 7, .external_lex_state = 40},
  [355] = {.lex_state = 7, .external_lex_state = 38},
  [356] = {.lex_state = 7},
  [357] = {.lex_state = 7, .external_lex_state = 38},
  [358] = {.lex_state = 7, .external_lex_state = 40},
  [359] = {.lex_state = 7, .external_lex_state = 24},
  [360] = {.lex_state = 7, .external_lex_state = 44},
  [361] = {.lex_state = 7, .external_lex_state = 43},
  [362] = {.lex_state = 7, .external_lex_state = 24},
  [363] = {.lex_state = 7, .external_lex_state = 41},
  [364] = {.lex_state = 7},
};

enum {
  ts_external_token__newline = 0,
  ts_external_token__blankline = 1,
  ts_external_token__indent = 2,
  ts_external_token__newline_indent = 3,
  ts_external_token__dedent = 4,
  ts_external_token__overline = 5,
  ts_external_token__underline = 6,
  ts_external_token_transition = 7,
  ts_external_token__char_bullet = 8,
  ts_external_token__numeric_bullet = 9,
  ts_external_token__field_mark = 10,
  ts_external_token__field_mark_end = 11,
  ts_external_token__literal_indented_block_mark = 12,
  ts_external_token__literal_quoted_block_mark = 13,
  ts_external_token__quoted_literal_block = 14,
  ts_external_token__line_block_mark = 15,
  ts_external_token__attribution_mark = 16,
  ts_external_token__doctest_block_mark = 17,
  ts_external_token__text = 18,
  ts_external_token_emphasis = 19,
  ts_external_token_strong = 20,
  ts_external_token__interpreted_text = 21,
  ts_external_token__interpreted_text_prefix = 22,
  ts_external_token__role_name_prefix = 23,
  ts_external_token__role_name_suffix = 24,
  ts_external_token_literal = 25,
  ts_external_token_substitution_reference = 26,
  ts_external_token_inline_target = 27,
  ts_external_token_footnote_reference = 28,
  ts_external_token_citation_reference = 29,
  ts_external_token_reference = 30,
  ts_external_token_standalone_hyperlink = 31,
  ts_external_token__explicit_markup_start = 32,
  ts_external_token__footnote_label = 33,
  ts_external_token__citation_label = 34,
  ts_external_token__target_name = 35,
  ts_external_token__anonymous_target_mark = 36,
  ts_external_token__directive_name = 37,
  ts_external_token__substitution_mark = 38,
  ts_external_token__empty_comment = 39,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__newline] = sym__newline,
  [ts_external_token__blankline] = sym__blankline,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token__newline_indent] = sym__newline_indent,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__overline] = sym__overline,
  [ts_external_token__underline] = sym__underline,
  [ts_external_token_transition] = sym_transition,
  [ts_external_token__char_bullet] = sym__char_bullet,
  [ts_external_token__numeric_bullet] = sym__numeric_bullet,
  [ts_external_token__field_mark] = sym__field_mark,
  [ts_external_token__field_mark_end] = sym__field_mark_end,
  [ts_external_token__literal_indented_block_mark] = sym__literal_indented_block_mark,
  [ts_external_token__literal_quoted_block_mark] = sym__literal_quoted_block_mark,
  [ts_external_token__quoted_literal_block] = sym__quoted_literal_block,
  [ts_external_token__line_block_mark] = sym__line_block_mark,
  [ts_external_token__attribution_mark] = sym__attribution_mark,
  [ts_external_token__doctest_block_mark] = sym__doctest_block_mark,
  [ts_external_token__text] = sym__text,
  [ts_external_token_emphasis] = sym_emphasis,
  [ts_external_token_strong] = sym_strong,
  [ts_external_token__interpreted_text] = sym__interpreted_text,
  [ts_external_token__interpreted_text_prefix] = sym__interpreted_text_prefix,
  [ts_external_token__role_name_prefix] = sym__role_name_prefix,
  [ts_external_token__role_name_suffix] = sym__role_name_suffix,
  [ts_external_token_literal] = sym_literal,
  [ts_external_token_substitution_reference] = sym_substitution_reference,
  [ts_external_token_inline_target] = sym_inline_target,
  [ts_external_token_footnote_reference] = sym_footnote_reference,
  [ts_external_token_citation_reference] = sym_citation_reference,
  [ts_external_token_reference] = sym_reference,
  [ts_external_token_standalone_hyperlink] = sym_standalone_hyperlink,
  [ts_external_token__explicit_markup_start] = sym__explicit_markup_start,
  [ts_external_token__footnote_label] = sym__footnote_label,
  [ts_external_token__citation_label] = sym__citation_label,
  [ts_external_token__target_name] = sym__target_name,
  [ts_external_token__anonymous_target_mark] = sym__anonymous_target_mark,
  [ts_external_token__directive_name] = sym__directive_name,
  [ts_external_token__substitution_mark] = sym__substitution_mark,
  [ts_external_token__empty_comment] = sym__empty_comment,
};

static const bool ts_external_scanner_states[45][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__newline] = true,
    [ts_external_token__blankline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__newline_indent] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__overline] = true,
    [ts_external_token__underline] = true,
    [ts_external_token_transition] = true,
    [ts_external_token__char_bullet] = true,
    [ts_external_token__numeric_bullet] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__field_mark_end] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__quoted_literal_block] = true,
    [ts_external_token__line_block_mark] = true,
    [ts_external_token__attribution_mark] = true,
    [ts_external_token__doctest_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token__role_name_suffix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__footnote_label] = true,
    [ts_external_token__citation_label] = true,
    [ts_external_token__target_name] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__directive_name] = true,
    [ts_external_token__substitution_mark] = true,
    [ts_external_token__empty_comment] = true,
  },
  [2] = {
    [ts_external_token__indent] = true,
    [ts_external_token__overline] = true,
    [ts_external_token_transition] = true,
    [ts_external_token__char_bullet] = true,
    [ts_external_token__numeric_bullet] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__line_block_mark] = true,
    [ts_external_token__doctest_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__empty_comment] = true,
  },
  [3] = {
    [ts_external_token__indent] = true,
    [ts_external_token__char_bullet] = true,
    [ts_external_token__numeric_bullet] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__line_block_mark] = true,
    [ts_external_token__attribution_mark] = true,
    [ts_external_token__doctest_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__empty_comment] = true,
  },
  [4] = {
    [ts_external_token__indent] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__char_bullet] = true,
    [ts_external_token__numeric_bullet] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__line_block_mark] = true,
    [ts_external_token__doctest_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__empty_comment] = true,
  },
  [5] = {
    [ts_external_token__indent] = true,
    [ts_external_token__char_bullet] = true,
    [ts_external_token__numeric_bullet] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__line_block_mark] = true,
    [ts_external_token__doctest_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__empty_comment] = true,
  },
  [6] = {
    [ts_external_token__newline] = true,
    [ts_external_token__newline_indent] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [7] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [8] = {
    [ts_external_token__newline] = true,
    [ts_external_token__literal_indented_block_mark] = true,
    [ts_external_token__literal_quoted_block_mark] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [9] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [10] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [11] = {
    [ts_external_token__newline_indent] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [12] = {
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [13] = {
    [ts_external_token__field_mark_end] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [14] = {
    [ts_external_token__newline] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [15] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__underline] = true,
    [ts_external_token__text] = true,
    [ts_external_token_emphasis] = true,
    [ts_external_token_strong] = true,
    [ts_external_token__interpreted_text] = true,
    [ts_external_token__interpreted_text_prefix] = true,
    [ts_external_token__role_name_prefix] = true,
    [ts_external_token_literal] = true,
    [ts_external_token_substitution_reference] = true,
    [ts_external_token_inline_target] = true,
    [ts_external_token_footnote_reference] = true,
    [ts_external_token_citation_reference] = true,
    [ts_external_token_reference] = true,
    [ts_external_token_standalone_hyperlink] = true,
  },
  [16] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__empty_comment] = true,
  },
  [17] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__explicit_markup_start] = true,
    [ts_external_token__anonymous_target_mark] = true,
    [ts_external_token__empty_comment] = true,
  },
  [18] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__text] = true,
  },
  [19] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__text] = true,
    [ts_external_token__footnote_label] = true,
    [ts_external_token__citation_label] = true,
    [ts_external_token__target_name] = true,
    [ts_external_token__directive_name] = true,
    [ts_external_token__substitution_mark] = true,
  },
  [20] = {
    [ts_external_token__newline] = true,
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__field_mark] = true,
    [ts_external_token__text] = true,
  },
  [21] = {
    [ts_external_token__field_mark] = true,
    [ts_external_token__text] = true,
  },
  [22] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__text] = true,
  },
  [23] = {
    [ts_external_token__text] = true,
  },
  [24] = {
    [ts_external_token__newline] = true,
  },
  [25] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__text] = true,
  },
  [26] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__numeric_bullet] = true,
  },
  [27] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__char_bullet] = true,
  },
  [28] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__field_mark] = true,
  },
  [29] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__line_block_mark] = true,
  },
  [30] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__text] = true,
  },
  [31] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__field_mark] = true,
  },
  [32] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__line_block_mark] = true,
  },
  [33] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__numeric_bullet] = true,
  },
  [34] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__char_bullet] = true,
  },
  [35] = {
    [ts_external_token__newline_indent] = true,
  },
  [36] = {
    [ts_external_token__newline] = true,
    [ts_external_token__text] = true,
  },
  [37] = {
    [ts_external_token__blankline] = true,
    [ts_external_token__dedent] = true,
  },
  [38] = {
    [ts_external_token__dedent] = true,
  },
  [39] = {
    [ts_external_token__directive_name] = true,
  },
  [40] = {
    [ts_external_token__blankline] = true,
  },
  [41] = {
    [ts_external_token__quoted_literal_block] = true,
  },
  [42] = {
    [ts_external_token__underline] = true,
  },
  [43] = {
    [ts_external_token__role_name_suffix] = true,
  },
  [44] = {
    [ts_external_token__interpreted_text] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_] = ACTIONS(1),
    [anon_sym_TAB] = ACTIONS(1),
    [anon_sym_2] = ACTIONS(1),
    [anon_sym_3] = ACTIONS(1),
    [anon_sym_4] = ACTIONS(1),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(5),
    [sym__newline] = ACTIONS(1),
    [sym__blankline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__newline_indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__overline] = ACTIONS(1),
    [sym__underline] = ACTIONS(1),
    [sym_transition] = ACTIONS(1),
    [sym__char_bullet] = ACTIONS(1),
    [sym__numeric_bullet] = ACTIONS(1),
    [sym__field_mark] = ACTIONS(1),
    [sym__field_mark_end] = ACTIONS(1),
    [sym__literal_indented_block_mark] = ACTIONS(1),
    [sym__literal_quoted_block_mark] = ACTIONS(1),
    [sym__quoted_literal_block] = ACTIONS(1),
    [sym__line_block_mark] = ACTIONS(1),
    [sym__attribution_mark] = ACTIONS(1),
    [sym__doctest_block_mark] = ACTIONS(1),
    [sym__text] = ACTIONS(1),
    [sym_emphasis] = ACTIONS(1),
    [sym_strong] = ACTIONS(1),
    [sym__interpreted_text] = ACTIONS(1),
    [sym__interpreted_text_prefix] = ACTIONS(1),
    [sym__role_name_prefix] = ACTIONS(1),
    [sym__role_name_suffix] = ACTIONS(1),
    [sym_literal] = ACTIONS(1),
    [sym_substitution_reference] = ACTIONS(1),
    [sym_inline_target] = ACTIONS(1),
    [sym_footnote_reference] = ACTIONS(1),
    [sym_citation_reference] = ACTIONS(1),
    [sym_reference] = ACTIONS(1),
    [sym_standalone_hyperlink] = ACTIONS(1),
    [sym__explicit_markup_start] = ACTIONS(1),
    [sym__footnote_label] = ACTIONS(1),
    [sym__citation_label] = ACTIONS(1),
    [sym__target_name] = ACTIONS(1),
    [sym__anonymous_target_mark] = ACTIONS(1),
    [sym__directive_name] = ACTIONS(1),
    [sym__substitution_mark] = ACTIONS(1),
    [sym__empty_comment] = ACTIONS(1),
  },
  [1] = {
    [sym_document] = STATE(356),
    [sym_section] = STATE(3),
    [sym__overline_section] = STATE(38),
    [sym__underline_section] = STATE(38),
    [sym__transition_block] = STATE(3),
    [sym__body_element_block] = STATE(3),
    [sym__body_element] = STATE(354),
    [sym_paragraph] = STATE(354),
    [sym__paragraph_line] = STATE(54),
    [sym__list] = STATE(354),
    [sym_bullet_list] = STATE(352),
    [sym__bullet_list_item] = STATE(214),
    [sym_enumerated_list] = STATE(352),
    [sym__numeric_list_item] = STATE(212),
    [sym_definition_list] = STATE(352),
    [sym__definition_list_item] = STATE(59),
    [sym_field_list] = STATE(352),
    [sym_field] = STATE(202),
    [sym__literal_block] = STATE(354),
    [sym_line_block] = STATE(354),
    [sym_line] = STATE(204),
    [sym__block_quote_block] = STATE(354),
    [sym_doctest_block] = STATE(354),
    [aux_sym__explicit_markup_block] = STATE(119),
    [sym__markup_block] = STATE(119),
    [sym_footnote] = STATE(215),
    [sym_citation] = STATE(215),
    [sym_target] = STATE(215),
    [sym__anonymous_target] = STATE(216),
    [sym_directive] = STATE(215),
    [sym_substitution_definition] = STATE(215),
    [sym_comment] = STATE(215),
    [sym__line] = STATE(347),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_document_repeat1] = STATE(3),
    [aux_sym_paragraph_repeat1] = STATE(54),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(214),
    [aux_sym_enumerated_list_repeat1] = STATE(212),
    [aux_sym_definition_list_repeat1] = STATE(59),
    [aux_sym_field_list_repeat1] = STATE(202),
    [aux_sym_line_block_repeat1] = STATE(204),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(9),
    [sym__overline] = ACTIONS(11),
    [sym_transition] = ACTIONS(13),
    [sym__char_bullet] = ACTIONS(15),
    [sym__numeric_bullet] = ACTIONS(17),
    [sym__field_mark] = ACTIONS(19),
    [sym__literal_indented_block_mark] = ACTIONS(21),
    [sym__literal_quoted_block_mark] = ACTIONS(23),
    [sym__line_block_mark] = ACTIONS(25),
    [sym__doctest_block_mark] = ACTIONS(27),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(37),
    [sym__anonymous_target_mark] = ACTIONS(39),
    [sym__empty_comment] = ACTIONS(41),
  },
  [2] = {
    [sym_section] = STATE(2),
    [sym__overline_section] = STATE(38),
    [sym__underline_section] = STATE(38),
    [sym__transition_block] = STATE(2),
    [sym__body_element_block] = STATE(2),
    [sym__body_element] = STATE(354),
    [sym_paragraph] = STATE(354),
    [sym__paragraph_line] = STATE(54),
    [sym__list] = STATE(354),
    [sym_bullet_list] = STATE(352),
    [sym__bullet_list_item] = STATE(214),
    [sym_enumerated_list] = STATE(352),
    [sym__numeric_list_item] = STATE(212),
    [sym_definition_list] = STATE(352),
    [sym__definition_list_item] = STATE(59),
    [sym_field_list] = STATE(352),
    [sym_field] = STATE(202),
    [sym__literal_block] = STATE(354),
    [sym_line_block] = STATE(354),
    [sym_line] = STATE(204),
    [sym__block_quote_block] = STATE(354),
    [sym_doctest_block] = STATE(354),
    [aux_sym__explicit_markup_block] = STATE(119),
    [sym__markup_block] = STATE(119),
    [sym_footnote] = STATE(215),
    [sym_citation] = STATE(215),
    [sym_target] = STATE(215),
    [sym__anonymous_target] = STATE(216),
    [sym_directive] = STATE(215),
    [sym_substitution_definition] = STATE(215),
    [sym_comment] = STATE(215),
    [sym__line] = STATE(347),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_document_repeat1] = STATE(2),
    [aux_sym_paragraph_repeat1] = STATE(54),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(214),
    [aux_sym_enumerated_list_repeat1] = STATE(212),
    [aux_sym_definition_list_repeat1] = STATE(59),
    [aux_sym_field_list_repeat1] = STATE(202),
    [aux_sym_line_block_repeat1] = STATE(204),
    [ts_builtin_sym_end] = ACTIONS(43),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(45),
    [sym__overline] = ACTIONS(48),
    [sym_transition] = ACTIONS(51),
    [sym__char_bullet] = ACTIONS(54),
    [sym__numeric_bullet] = ACTIONS(57),
    [sym__field_mark] = ACTIONS(60),
    [sym__literal_indented_block_mark] = ACTIONS(63),
    [sym__literal_quoted_block_mark] = ACTIONS(66),
    [sym__line_block_mark] = ACTIONS(69),
    [sym__doctest_block_mark] = ACTIONS(72),
    [sym__text] = ACTIONS(75),
    [sym_emphasis] = ACTIONS(75),
    [sym_strong] = ACTIONS(75),
    [sym__interpreted_text] = ACTIONS(78),
    [sym__interpreted_text_prefix] = ACTIONS(81),
    [sym__role_name_prefix] = ACTIONS(84),
    [sym_literal] = ACTIONS(75),
    [sym_substitution_reference] = ACTIONS(75),
    [sym_inline_target] = ACTIONS(75),
    [sym_footnote_reference] = ACTIONS(75),
    [sym_citation_reference] = ACTIONS(75),
    [sym_reference] = ACTIONS(75),
    [sym_standalone_hyperlink] = ACTIONS(75),
    [sym__explicit_markup_start] = ACTIONS(87),
    [sym__anonymous_target_mark] = ACTIONS(90),
    [sym__empty_comment] = ACTIONS(93),
  },
  [3] = {
    [sym_section] = STATE(2),
    [sym__overline_section] = STATE(38),
    [sym__underline_section] = STATE(38),
    [sym__transition_block] = STATE(2),
    [sym__body_element_block] = STATE(2),
    [sym__body_element] = STATE(354),
    [sym_paragraph] = STATE(354),
    [sym__paragraph_line] = STATE(54),
    [sym__list] = STATE(354),
    [sym_bullet_list] = STATE(352),
    [sym__bullet_list_item] = STATE(214),
    [sym_enumerated_list] = STATE(352),
    [sym__numeric_list_item] = STATE(212),
    [sym_definition_list] = STATE(352),
    [sym__definition_list_item] = STATE(59),
    [sym_field_list] = STATE(352),
    [sym_field] = STATE(202),
    [sym__literal_block] = STATE(354),
    [sym_line_block] = STATE(354),
    [sym_line] = STATE(204),
    [sym__block_quote_block] = STATE(354),
    [sym_doctest_block] = STATE(354),
    [aux_sym__explicit_markup_block] = STATE(119),
    [sym__markup_block] = STATE(119),
    [sym_footnote] = STATE(215),
    [sym_citation] = STATE(215),
    [sym_target] = STATE(215),
    [sym__anonymous_target] = STATE(216),
    [sym_directive] = STATE(215),
    [sym_substitution_definition] = STATE(215),
    [sym_comment] = STATE(215),
    [sym__line] = STATE(347),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_document_repeat1] = STATE(2),
    [aux_sym_paragraph_repeat1] = STATE(54),
    [aux_sym__paragraph_line_repeat1] = STATE(40),
    [aux_sym_bullet_list_repeat1] = STATE(214),
    [aux_sym_enumerated_list_repeat1] = STATE(212),
    [aux_sym_definition_list_repeat1] = STATE(59),
    [aux_sym_field_list_repeat1] = STATE(202),
    [aux_sym_line_block_repeat1] = STATE(204),
    [ts_builtin_sym_end] = ACTIONS(96),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(9),
    [sym__overline] = ACTIONS(11),
    [sym_transition] = ACTIONS(13),
    [sym__char_bullet] = ACTIONS(15),
    [sym__numeric_bullet] = ACTIONS(17),
    [sym__field_mark] = ACTIONS(19),
    [sym__literal_indented_block_mark] = ACTIONS(21),
    [sym__literal_quoted_block_mark] = ACTIONS(23),
    [sym__line_block_mark] = ACTIONS(25),
    [sym__doctest_block_mark] = ACTIONS(27),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(37),
    [sym__anonymous_target_mark] = ACTIONS(39),
    [sym__empty_comment] = ACTIONS(41),
  },
  [4] = {
    [sym__body_element] = STATE(276),
    [sym_paragraph] = STATE(276),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(276),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(276),
    [sym_line_block] = STATE(276),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(276),
    [sym_block_quote] = STATE(261),
    [sym_attribution] = STATE(343),
    [sym_doctest_block] = STATE(276),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(6),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__attribution_mark] = ACTIONS(112),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [5] = {
    [sym__body_element] = STATE(301),
    [sym_paragraph] = STATE(301),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(301),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(301),
    [sym_line_block] = STATE(301),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(301),
    [sym_block_quote] = STATE(325),
    [sym_attribution] = STATE(321),
    [sym_doctest_block] = STATE(301),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(10),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__attribution_mark] = ACTIONS(112),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [6] = {
    [sym__body_element] = STATE(294),
    [sym_paragraph] = STATE(294),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(294),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(294),
    [sym_line_block] = STATE(294),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(294),
    [sym_attribution] = STATE(333),
    [sym_doctest_block] = STATE(294),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(22),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__attribution_mark] = ACTIONS(112),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [7] = {
    [sym_body] = STATE(305),
    [sym__body_element] = STATE(281),
    [sym_paragraph] = STATE(281),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(281),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(281),
    [sym_line_block] = STATE(281),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(281),
    [sym_doctest_block] = STATE(281),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(33),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(122),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [8] = {
    [sym_body] = STATE(196),
    [sym__body_element] = STATE(289),
    [sym_paragraph] = STATE(289),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(289),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(289),
    [sym_line_block] = STATE(289),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(289),
    [sym_doctest_block] = STATE(289),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(31),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(124),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [9] = {
    [sym_body] = STATE(245),
    [sym__body_element] = STATE(314),
    [sym_paragraph] = STATE(314),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(314),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(314),
    [sym_line_block] = STATE(314),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(314),
    [sym_doctest_block] = STATE(314),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(28),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(126),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [10] = {
    [sym__body_element] = STATE(274),
    [sym_paragraph] = STATE(274),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(274),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(274),
    [sym_line_block] = STATE(274),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(274),
    [sym_attribution] = STATE(348),
    [sym_doctest_block] = STATE(274),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(22),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__attribution_mark] = ACTIONS(112),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [11] = {
    [sym_body] = STATE(243),
    [sym__body_element] = STATE(307),
    [sym_paragraph] = STATE(307),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(307),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(307),
    [sym_line_block] = STATE(307),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(307),
    [sym_doctest_block] = STATE(307),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(29),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(128),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [12] = {
    [sym_body] = STATE(258),
    [sym__body_element] = STATE(280),
    [sym_paragraph] = STATE(280),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(280),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(280),
    [sym_line_block] = STATE(280),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(280),
    [sym_doctest_block] = STATE(280),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(24),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(130),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [13] = {
    [sym_body] = STATE(254),
    [sym__body_element] = STATE(278),
    [sym_paragraph] = STATE(278),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(278),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(278),
    [sym_line_block] = STATE(278),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(278),
    [sym_doctest_block] = STATE(278),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(25),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(132),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [14] = {
    [sym_body] = STATE(313),
    [sym__body_element] = STATE(312),
    [sym_paragraph] = STATE(312),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(312),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(312),
    [sym_line_block] = STATE(312),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(312),
    [sym_doctest_block] = STATE(312),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(27),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(134),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [15] = {
    [sym_body] = STATE(236),
    [sym__body_element] = STATE(299),
    [sym_paragraph] = STATE(299),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(299),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(299),
    [sym_line_block] = STATE(299),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(299),
    [sym_doctest_block] = STATE(299),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(30),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(136),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [16] = {
    [sym_body] = STATE(219),
    [sym__body_element] = STATE(299),
    [sym_paragraph] = STATE(299),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(299),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(299),
    [sym_line_block] = STATE(299),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(299),
    [sym_doctest_block] = STATE(299),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(30),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(138),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [17] = {
    [sym_body] = STATE(197),
    [sym__body_element] = STATE(289),
    [sym_paragraph] = STATE(289),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(289),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(289),
    [sym_line_block] = STATE(289),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(289),
    [sym_doctest_block] = STATE(289),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(31),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__dedent] = ACTIONS(140),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [18] = {
    [sym_body] = STATE(90),
    [sym__body_element] = STATE(285),
    [sym_paragraph] = STATE(285),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(285),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(285),
    [sym_line_block] = STATE(285),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(285),
    [sym_doctest_block] = STATE(285),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(32),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [19] = {
    [sym_body] = STATE(114),
    [sym__body_element] = STATE(292),
    [sym_paragraph] = STATE(292),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(292),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(292),
    [sym_line_block] = STATE(292),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(292),
    [sym_doctest_block] = STATE(292),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(23),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [20] = {
    [sym_body] = STATE(89),
    [sym__body_element] = STATE(285),
    [sym_paragraph] = STATE(285),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(285),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(285),
    [sym_line_block] = STATE(285),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(285),
    [sym_doctest_block] = STATE(285),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(32),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [21] = {
    [sym_body] = STATE(115),
    [sym__body_element] = STATE(292),
    [sym_paragraph] = STATE(292),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(292),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(292),
    [sym_line_block] = STATE(292),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(292),
    [sym_doctest_block] = STATE(292),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(23),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [22] = {
    [sym__body_element] = STATE(338),
    [sym_paragraph] = STATE(338),
    [sym__paragraph_line] = STATE(54),
    [sym__list] = STATE(338),
    [sym_bullet_list] = STATE(352),
    [sym__bullet_list_item] = STATE(214),
    [sym_enumerated_list] = STATE(352),
    [sym__numeric_list_item] = STATE(212),
    [sym_definition_list] = STATE(352),
    [sym__definition_list_item] = STATE(59),
    [sym_field_list] = STATE(352),
    [sym_field] = STATE(202),
    [sym__literal_block] = STATE(338),
    [sym_line_block] = STATE(338),
    [sym_line] = STATE(204),
    [sym__block_quote_block] = STATE(338),
    [sym_doctest_block] = STATE(338),
    [aux_sym__explicit_markup_block] = STATE(119),
    [sym__markup_block] = STATE(119),
    [sym_footnote] = STATE(215),
    [sym_citation] = STATE(215),
    [sym_target] = STATE(215),
    [sym__anonymous_target] = STATE(216),
    [sym_directive] = STATE(215),
    [sym_substitution_definition] = STATE(215),
    [sym_comment] = STATE(215),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(22),
    [aux_sym_paragraph_repeat1] = STATE(54),
    [aux_sym__paragraph_line_repeat1] = STATE(39),
    [aux_sym_bullet_list_repeat1] = STATE(214),
    [aux_sym_enumerated_list_repeat1] = STATE(212),
    [aux_sym_definition_list_repeat1] = STATE(59),
    [aux_sym_field_list_repeat1] = STATE(202),
    [aux_sym_line_block_repeat1] = STATE(204),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(142),
    [sym__char_bullet] = ACTIONS(145),
    [sym__numeric_bullet] = ACTIONS(148),
    [sym__field_mark] = ACTIONS(151),
    [sym__literal_indented_block_mark] = ACTIONS(154),
    [sym__literal_quoted_block_mark] = ACTIONS(157),
    [sym__line_block_mark] = ACTIONS(160),
    [sym__attribution_mark] = ACTIONS(163),
    [sym__doctest_block_mark] = ACTIONS(165),
    [sym__text] = ACTIONS(168),
    [sym_emphasis] = ACTIONS(168),
    [sym_strong] = ACTIONS(168),
    [sym__interpreted_text] = ACTIONS(171),
    [sym__interpreted_text_prefix] = ACTIONS(174),
    [sym__role_name_prefix] = ACTIONS(177),
    [sym_literal] = ACTIONS(168),
    [sym_substitution_reference] = ACTIONS(168),
    [sym_inline_target] = ACTIONS(168),
    [sym_footnote_reference] = ACTIONS(168),
    [sym_citation_reference] = ACTIONS(168),
    [sym_reference] = ACTIONS(168),
    [sym_standalone_hyperlink] = ACTIONS(168),
    [sym__explicit_markup_start] = ACTIONS(180),
    [sym__anonymous_target_mark] = ACTIONS(183),
    [sym__empty_comment] = ACTIONS(186),
  },
  [23] = {
    [sym__body_element] = STATE(291),
    [sym_paragraph] = STATE(291),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(291),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(291),
    [sym_line_block] = STATE(291),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(291),
    [sym_doctest_block] = STATE(291),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(26),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [24] = {
    [sym__body_element] = STATE(296),
    [sym_paragraph] = STATE(296),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(296),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(296),
    [sym_line_block] = STATE(296),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(296),
    [sym_doctest_block] = STATE(296),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(26),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [25] = {
    [sym__body_element] = STATE(277),
    [sym_paragraph] = STATE(277),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(277),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(277),
    [sym_line_block] = STATE(277),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(277),
    [sym_doctest_block] = STATE(277),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(26),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [26] = {
    [sym__body_element] = STATE(331),
    [sym_paragraph] = STATE(331),
    [sym__paragraph_line] = STATE(54),
    [sym__list] = STATE(331),
    [sym_bullet_list] = STATE(352),
    [sym__bullet_list_item] = STATE(214),
    [sym_enumerated_list] = STATE(352),
    [sym__numeric_list_item] = STATE(212),
    [sym_definition_list] = STATE(352),
    [sym__definition_list_item] = STATE(59),
    [sym_field_list] = STATE(352),
    [sym_field] = STATE(202),
    [sym__literal_block] = STATE(331),
    [sym_line_block] = STATE(331),
    [sym_line] = STATE(204),
    [sym__block_quote_block] = STATE(331),
    [sym_doctest_block] = STATE(331),
    [aux_sym__explicit_markup_block] = STATE(119),
    [sym__markup_block] = STATE(119),
    [sym_footnote] = STATE(215),
    [sym_citation] = STATE(215),
    [sym_target] = STATE(215),
    [sym__anonymous_target] = STATE(216),
    [sym_directive] = STATE(215),
    [sym_substitution_definition] = STATE(215),
    [sym_comment] = STATE(215),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(26),
    [aux_sym_paragraph_repeat1] = STATE(54),
    [aux_sym__paragraph_line_repeat1] = STATE(39),
    [aux_sym_bullet_list_repeat1] = STATE(214),
    [aux_sym_enumerated_list_repeat1] = STATE(212),
    [aux_sym_definition_list_repeat1] = STATE(59),
    [aux_sym_field_list_repeat1] = STATE(202),
    [aux_sym_line_block_repeat1] = STATE(204),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(142),
    [sym__char_bullet] = ACTIONS(145),
    [sym__numeric_bullet] = ACTIONS(148),
    [sym__field_mark] = ACTIONS(151),
    [sym__literal_indented_block_mark] = ACTIONS(154),
    [sym__literal_quoted_block_mark] = ACTIONS(157),
    [sym__line_block_mark] = ACTIONS(160),
    [sym__doctest_block_mark] = ACTIONS(165),
    [sym__text] = ACTIONS(168),
    [sym_emphasis] = ACTIONS(168),
    [sym_strong] = ACTIONS(168),
    [sym__interpreted_text] = ACTIONS(171),
    [sym__interpreted_text_prefix] = ACTIONS(174),
    [sym__role_name_prefix] = ACTIONS(177),
    [sym_literal] = ACTIONS(168),
    [sym_substitution_reference] = ACTIONS(168),
    [sym_inline_target] = ACTIONS(168),
    [sym_footnote_reference] = ACTIONS(168),
    [sym_citation_reference] = ACTIONS(168),
    [sym_reference] = ACTIONS(168),
    [sym_standalone_hyperlink] = ACTIONS(168),
    [sym__explicit_markup_start] = ACTIONS(180),
    [sym__anonymous_target_mark] = ACTIONS(183),
    [sym__empty_comment] = ACTIONS(186),
  },
  [27] = {
    [sym__body_element] = STATE(267),
    [sym_paragraph] = STATE(267),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(267),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(267),
    [sym_line_block] = STATE(267),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(267),
    [sym_doctest_block] = STATE(267),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(26),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [28] = {
    [sym__body_element] = STATE(308),
    [sym_paragraph] = STATE(308),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(308),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(308),
    [sym_line_block] = STATE(308),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(308),
    [sym_doctest_block] = STATE(308),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(26),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [29] = {
    [sym__body_element] = STATE(302),
    [sym_paragraph] = STATE(302),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(302),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(302),
    [sym_line_block] = STATE(302),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(302),
    [sym_doctest_block] = STATE(302),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(26),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [30] = {
    [sym__body_element] = STATE(298),
    [sym_paragraph] = STATE(298),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(298),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(298),
    [sym_line_block] = STATE(298),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(298),
    [sym_doctest_block] = STATE(298),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(26),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [31] = {
    [sym__body_element] = STATE(286),
    [sym_paragraph] = STATE(286),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(286),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(286),
    [sym_line_block] = STATE(286),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(286),
    [sym_doctest_block] = STATE(286),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(26),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [32] = {
    [sym__body_element] = STATE(282),
    [sym_paragraph] = STATE(282),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(282),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(282),
    [sym_line_block] = STATE(282),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(282),
    [sym_doctest_block] = STATE(282),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(26),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
  [33] = {
    [sym__body_element] = STATE(279),
    [sym_paragraph] = STATE(279),
    [sym__paragraph_line] = STATE(48),
    [sym__list] = STATE(279),
    [sym_bullet_list] = STATE(270),
    [sym__bullet_list_item] = STATE(162),
    [sym_enumerated_list] = STATE(270),
    [sym__numeric_list_item] = STATE(163),
    [sym_definition_list] = STATE(270),
    [sym__definition_list_item] = STATE(45),
    [sym_field_list] = STATE(270),
    [sym_field] = STATE(165),
    [sym__literal_block] = STATE(279),
    [sym_line_block] = STATE(279),
    [sym_line] = STATE(166),
    [sym__block_quote_block] = STATE(279),
    [sym_doctest_block] = STATE(279),
    [aux_sym__explicit_markup_block] = STATE(100),
    [sym__markup_block] = STATE(100),
    [sym_footnote] = STATE(188),
    [sym_citation] = STATE(188),
    [sym_target] = STATE(188),
    [sym__anonymous_target] = STATE(158),
    [sym_directive] = STATE(188),
    [sym_substitution_definition] = STATE(188),
    [sym_comment] = STATE(188),
    [sym__inline_markup] = STATE(81),
    [sym_interpreted_text] = STATE(78),
    [sym__default_role] = STATE(79),
    [sym__prefix_role] = STATE(79),
    [sym__suffix_role] = STATE(79),
    [aux_sym_body_repeat1] = STATE(26),
    [aux_sym_paragraph_repeat1] = STATE(48),
    [aux_sym__paragraph_line_repeat1] = STATE(41),
    [aux_sym_bullet_list_repeat1] = STATE(162),
    [aux_sym_enumerated_list_repeat1] = STATE(163),
    [aux_sym_definition_list_repeat1] = STATE(45),
    [aux_sym_field_list_repeat1] = STATE(165),
    [aux_sym_line_block_repeat1] = STATE(166),
    [sym___newline] = ACTIONS(3),
    [sym___whitespace] = ACTIONS(3),
    [sym__indent] = ACTIONS(98),
    [sym__char_bullet] = ACTIONS(100),
    [sym__numeric_bullet] = ACTIONS(102),
    [sym__field_mark] = ACTIONS(104),
    [sym__literal_indented_block_mark] = ACTIONS(106),
    [sym__literal_quoted_block_mark] = ACTIONS(108),
    [sym__line_block_mark] = ACTIONS(110),
    [sym__doctest_block_mark] = ACTIONS(114),
    [sym__text] = ACTIONS(29),
    [sym_emphasis] = ACTIONS(29),
    [sym_strong] = ACTIONS(29),
    [sym__interpreted_text] = ACTIONS(31),
    [sym__interpreted_text_prefix] = ACTIONS(33),
    [sym__role_name_prefix] = ACTIONS(35),
    [sym_literal] = ACTIONS(29),
    [sym_substitution_reference] = ACTIONS(29),
    [sym_inline_target] = ACTIONS(29),
    [sym_footnote_reference] = ACTIONS(29),
    [sym_citation_reference] = ACTIONS(29),
    [sym_reference] = ACTIONS(29),
    [sym_standalone_hyperlink] = ACTIONS(29),
    [sym__explicit_markup_start] = ACTIONS(116),
    [sym__anonymous_target_mark] = ACTIONS(118),
    [sym__empty_comment] = ACTIONS(120),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(189), 27,
      sym__indent,
      sym__overline,
      sym_transition,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
      ts_builtin_sym_end,
  [34] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(191), 27,
      sym__indent,
      sym__overline,
      sym_transition,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
      ts_builtin_sym_end,
  [68] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(193), 27,
      sym__indent,
      sym__overline,
      sym_transition,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
      ts_builtin_sym_end,
  [102] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(195), 27,
      sym__indent,
      sym__overline,
      sym_transition,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
      ts_builtin_sym_end,
  [136] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(197), 27,
      sym__indent,
      sym__overline,
      sym_transition,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
      ts_builtin_sym_end,
  [170] = 17,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(31), 1,
      sym__interpreted_text,
    ACTIONS(33), 1,
      sym__interpreted_text_prefix,
    ACTIONS(35), 1,
      sym__role_name_prefix,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(201), 1,
      sym__newline,
    ACTIONS(203), 1,
      sym__newline_indent,
    ACTIONS(205), 1,
      sym__literal_indented_block_mark,
    ACTIONS(207), 1,
      sym__literal_quoted_block_mark,
    STATE(43), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(78), 1,
      sym_interpreted_text,
    STATE(81), 1,
      sym__inline_markup,
    STATE(237), 1,
      aux_sym__classifiers,
    STATE(337), 1,
      sym__literal_block,
    STATE(79), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(29), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [233] = 17,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(31), 1,
      sym__interpreted_text,
    ACTIONS(33), 1,
      sym__interpreted_text_prefix,
    ACTIONS(35), 1,
      sym__role_name_prefix,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(203), 1,
      sym__newline_indent,
    ACTIONS(205), 1,
      sym__literal_indented_block_mark,
    ACTIONS(207), 1,
      sym__literal_quoted_block_mark,
    ACTIONS(209), 1,
      sym__newline,
    STATE(43), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(78), 1,
      sym_interpreted_text,
    STATE(81), 1,
      sym__inline_markup,
    STATE(237), 1,
      aux_sym__classifiers,
    STATE(337), 1,
      sym__literal_block,
    STATE(79), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(29), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [296] = 17,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(31), 1,
      sym__interpreted_text,
    ACTIONS(33), 1,
      sym__interpreted_text_prefix,
    ACTIONS(35), 1,
      sym__role_name_prefix,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(205), 1,
      sym__literal_indented_block_mark,
    ACTIONS(207), 1,
      sym__literal_quoted_block_mark,
    ACTIONS(211), 1,
      sym__newline,
    ACTIONS(213), 1,
      sym__newline_indent,
    STATE(43), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(78), 1,
      sym_interpreted_text,
    STATE(81), 1,
      sym__inline_markup,
    STATE(252), 1,
      aux_sym__classifiers,
    STATE(334), 1,
      sym__literal_block,
    STATE(79), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(29), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [359] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(163), 25,
      sym__indent,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__attribution_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [391] = 11,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(220), 1,
      sym__interpreted_text,
    ACTIONS(223), 1,
      sym__interpreted_text_prefix,
    ACTIONS(226), 1,
      sym__role_name_prefix,
    STATE(43), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(78), 1,
      sym_interpreted_text,
    STATE(81), 1,
      sym__inline_markup,
    STATE(79), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(215), 5,
      sym__newline,
      sym__newline_indent,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      aux_sym__classifiers_token1,
    ACTIONS(217), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [440] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(163), 24,
      sym__indent,
      sym__char_bullet,
      sym__numeric_bullet,
      sym__field_mark,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__line_block_mark,
      sym__doctest_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [471] = 11,
    ACTIONS(233), 1,
      sym__interpreted_text,
    ACTIONS(235), 1,
      sym__interpreted_text_prefix,
    ACTIONS(237), 1,
      sym__role_name_prefix,
    STATE(55), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(92), 1,
      sym_interpreted_text,
    STATE(96), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(229), 2,
      sym__blankline,
      sym__dedent,
    STATE(49), 2,
      sym__definition_list_item,
      aux_sym_definition_list_repeat1,
    STATE(95), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(231), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [519] = 13,
    ACTIONS(201), 1,
      sym__newline,
    ACTIONS(205), 1,
      sym__literal_indented_block_mark,
    ACTIONS(207), 1,
      sym__literal_quoted_block_mark,
    ACTIONS(241), 1,
      sym__interpreted_text,
    ACTIONS(243), 1,
      sym__interpreted_text_prefix,
    ACTIONS(245), 1,
      sym__role_name_prefix,
    STATE(58), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(85), 1,
      sym__inline_markup,
    STATE(86), 1,
      sym_interpreted_text,
    STATE(337), 1,
      sym__literal_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(84), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(239), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [571] = 13,
    ACTIONS(205), 1,
      sym__literal_indented_block_mark,
    ACTIONS(207), 1,
      sym__literal_quoted_block_mark,
    ACTIONS(211), 1,
      sym__newline,
    ACTIONS(241), 1,
      sym__interpreted_text,
    ACTIONS(243), 1,
      sym__interpreted_text_prefix,
    ACTIONS(245), 1,
      sym__role_name_prefix,
    STATE(58), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(85), 1,
      sym__inline_markup,
    STATE(86), 1,
      sym_interpreted_text,
    STATE(334), 1,
      sym__literal_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(84), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(239), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [623] = 11,
    ACTIONS(241), 1,
      sym__interpreted_text,
    ACTIONS(243), 1,
      sym__interpreted_text_prefix,
    ACTIONS(245), 1,
      sym__role_name_prefix,
    STATE(47), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(85), 1,
      sym__inline_markup,
    STATE(86), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(247), 2,
      sym__blankline,
      sym__dedent,
    STATE(50), 2,
      sym__paragraph_line,
      aux_sym_paragraph_repeat1,
    STATE(84), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(239), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [671] = 11,
    ACTIONS(254), 1,
      sym__interpreted_text,
    ACTIONS(257), 1,
      sym__interpreted_text_prefix,
    ACTIONS(260), 1,
      sym__role_name_prefix,
    STATE(55), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(92), 1,
      sym_interpreted_text,
    STATE(96), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(249), 2,
      sym__blankline,
      sym__dedent,
    STATE(49), 2,
      sym__definition_list_item,
      aux_sym_definition_list_repeat1,
    STATE(95), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(251), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [719] = 11,
    ACTIONS(268), 1,
      sym__interpreted_text,
    ACTIONS(271), 1,
      sym__interpreted_text_prefix,
    ACTIONS(274), 1,
      sym__role_name_prefix,
    STATE(47), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(85), 1,
      sym__inline_markup,
    STATE(86), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(263), 2,
      sym__blankline,
      sym__dedent,
    STATE(50), 2,
      sym__paragraph_line,
      aux_sym_paragraph_repeat1,
    STATE(84), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(265), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [767] = 11,
    ACTIONS(263), 1,
      sym__blankline,
    ACTIONS(268), 1,
      sym__interpreted_text,
    ACTIONS(271), 1,
      sym__interpreted_text_prefix,
    ACTIONS(274), 1,
      sym__role_name_prefix,
    STATE(46), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(85), 1,
      sym__inline_markup,
    STATE(86), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(51), 2,
      sym__paragraph_line,
      aux_sym_paragraph_repeat1,
    STATE(84), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(265), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [814] = 11,
    ACTIONS(277), 1,
      sym__dedent,
    ACTIONS(282), 1,
      sym__interpreted_text,
    ACTIONS(285), 1,
      sym__interpreted_text_prefix,
    ACTIONS(288), 1,
      sym__role_name_prefix,
    STATE(68), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(111), 1,
      sym__inline_markup,
    STATE(113), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(52), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(110), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(279), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [861] = 11,
    ACTIONS(291), 1,
      sym__dedent,
    ACTIONS(295), 1,
      sym__interpreted_text,
    ACTIONS(297), 1,
      sym__interpreted_text_prefix,
    ACTIONS(299), 1,
      sym__role_name_prefix,
    STATE(68), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(111), 1,
      sym__inline_markup,
    STATE(113), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(60), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(110), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(293), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [908] = 11,
    ACTIONS(241), 1,
      sym__interpreted_text,
    ACTIONS(243), 1,
      sym__interpreted_text_prefix,
    ACTIONS(245), 1,
      sym__role_name_prefix,
    ACTIONS(247), 1,
      sym__blankline,
    STATE(46), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(85), 1,
      sym__inline_markup,
    STATE(86), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(51), 2,
      sym__paragraph_line,
      aux_sym_paragraph_repeat1,
    STATE(84), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(239), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [955] = 13,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(213), 1,
      sym__newline_indent,
    ACTIONS(233), 1,
      sym__interpreted_text,
    ACTIONS(235), 1,
      sym__interpreted_text_prefix,
    ACTIONS(237), 1,
      sym__role_name_prefix,
    STATE(65), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(92), 1,
      sym_interpreted_text,
    STATE(96), 1,
      sym__inline_markup,
    STATE(252), 1,
      aux_sym__classifiers,
    STATE(95), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(231), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1006] = 11,
    ACTIONS(295), 1,
      sym__interpreted_text,
    ACTIONS(297), 1,
      sym__interpreted_text_prefix,
    ACTIONS(299), 1,
      sym__role_name_prefix,
    ACTIONS(301), 1,
      sym__dedent,
    STATE(68), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(111), 1,
      sym__inline_markup,
    STATE(113), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(61), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(110), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(293), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1053] = 11,
    ACTIONS(295), 1,
      sym__interpreted_text,
    ACTIONS(297), 1,
      sym__interpreted_text_prefix,
    ACTIONS(299), 1,
      sym__role_name_prefix,
    ACTIONS(303), 1,
      sym__dedent,
    STATE(68), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(111), 1,
      sym__inline_markup,
    STATE(113), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(52), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(110), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(293), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1100] = 10,
    ACTIONS(308), 1,
      sym__interpreted_text,
    ACTIONS(311), 1,
      sym__interpreted_text_prefix,
    ACTIONS(314), 1,
      sym__role_name_prefix,
    STATE(58), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(85), 1,
      sym__inline_markup,
    STATE(86), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(215), 3,
      sym__newline,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
    STATE(84), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(305), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1145] = 11,
    ACTIONS(229), 1,
      sym__blankline,
    ACTIONS(233), 1,
      sym__interpreted_text,
    ACTIONS(235), 1,
      sym__interpreted_text_prefix,
    ACTIONS(237), 1,
      sym__role_name_prefix,
    STATE(62), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(92), 1,
      sym_interpreted_text,
    STATE(96), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(63), 2,
      sym__definition_list_item,
      aux_sym_definition_list_repeat1,
    STATE(95), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(231), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1192] = 11,
    ACTIONS(295), 1,
      sym__interpreted_text,
    ACTIONS(297), 1,
      sym__interpreted_text_prefix,
    ACTIONS(299), 1,
      sym__role_name_prefix,
    ACTIONS(317), 1,
      sym__dedent,
    STATE(68), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(111), 1,
      sym__inline_markup,
    STATE(113), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(52), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(110), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(293), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1239] = 11,
    ACTIONS(295), 1,
      sym__interpreted_text,
    ACTIONS(297), 1,
      sym__interpreted_text_prefix,
    ACTIONS(299), 1,
      sym__role_name_prefix,
    ACTIONS(319), 1,
      sym__dedent,
    STATE(68), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(111), 1,
      sym__inline_markup,
    STATE(113), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(52), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(110), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(293), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1286] = 13,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(203), 1,
      sym__newline_indent,
    ACTIONS(233), 1,
      sym__interpreted_text,
    ACTIONS(235), 1,
      sym__interpreted_text_prefix,
    ACTIONS(237), 1,
      sym__role_name_prefix,
    STATE(65), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(92), 1,
      sym_interpreted_text,
    STATE(96), 1,
      sym__inline_markup,
    STATE(237), 1,
      aux_sym__classifiers,
    STATE(95), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(231), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1337] = 11,
    ACTIONS(249), 1,
      sym__blankline,
    ACTIONS(254), 1,
      sym__interpreted_text,
    ACTIONS(257), 1,
      sym__interpreted_text_prefix,
    ACTIONS(260), 1,
      sym__role_name_prefix,
    STATE(62), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(92), 1,
      sym_interpreted_text,
    STATE(96), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(63), 2,
      sym__definition_list_item,
      aux_sym_definition_list_repeat1,
    STATE(95), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(251), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1384] = 11,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(233), 1,
      sym__interpreted_text,
    ACTIONS(235), 1,
      sym__interpreted_text_prefix,
    ACTIONS(237), 1,
      sym__role_name_prefix,
    STATE(65), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(92), 1,
      sym_interpreted_text,
    STATE(96), 1,
      sym__inline_markup,
    ACTIONS(321), 2,
      sym__newline_indent,
      aux_sym__classifiers_token1,
    STATE(95), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(231), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1430] = 11,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(326), 1,
      sym__interpreted_text,
    ACTIONS(329), 1,
      sym__interpreted_text_prefix,
    ACTIONS(332), 1,
      sym__role_name_prefix,
    STATE(65), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(92), 1,
      sym_interpreted_text,
    STATE(96), 1,
      sym__inline_markup,
    ACTIONS(215), 2,
      sym__newline_indent,
      aux_sym__classifiers_token1,
    STATE(95), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(323), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1476] = 10,
    ACTIONS(295), 1,
      sym__interpreted_text,
    ACTIONS(297), 1,
      sym__interpreted_text_prefix,
    ACTIONS(299), 1,
      sym__role_name_prefix,
    STATE(68), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(111), 1,
      sym__inline_markup,
    STATE(113), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(57), 2,
      sym__line,
      aux_sym_line_repeat1,
    STATE(110), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(293), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1520] = 10,
    ACTIONS(335), 1,
      sym__field_mark_end,
    ACTIONS(339), 1,
      sym__interpreted_text,
    ACTIONS(341), 1,
      sym__interpreted_text_prefix,
    ACTIONS(343), 1,
      sym__role_name_prefix,
    STATE(71), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(109), 1,
      sym_interpreted_text,
    STATE(117), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(112), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(337), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1563] = 10,
    ACTIONS(295), 1,
      sym__interpreted_text,
    ACTIONS(297), 1,
      sym__interpreted_text_prefix,
    ACTIONS(299), 1,
      sym__role_name_prefix,
    ACTIONS(345), 1,
      sym__newline,
    STATE(73), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(111), 1,
      sym__inline_markup,
    STATE(113), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(110), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(293), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1606] = 10,
    ACTIONS(295), 1,
      sym__interpreted_text,
    ACTIONS(297), 1,
      sym__interpreted_text_prefix,
    ACTIONS(299), 1,
      sym__role_name_prefix,
    STATE(72), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(111), 1,
      sym__inline_markup,
    STATE(113), 1,
      sym_interpreted_text,
    STATE(318), 1,
      sym__line,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(110), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(293), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1649] = 10,
    ACTIONS(339), 1,
      sym__interpreted_text,
    ACTIONS(341), 1,
      sym__interpreted_text_prefix,
    ACTIONS(343), 1,
      sym__role_name_prefix,
    ACTIONS(347), 1,
      sym__field_mark_end,
    STATE(71), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(109), 1,
      sym_interpreted_text,
    STATE(117), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(112), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(337), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1692] = 10,
    ACTIONS(215), 1,
      sym__field_mark_end,
    ACTIONS(352), 1,
      sym__interpreted_text,
    ACTIONS(355), 1,
      sym__interpreted_text_prefix,
    ACTIONS(358), 1,
      sym__role_name_prefix,
    STATE(71), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(109), 1,
      sym_interpreted_text,
    STATE(117), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(112), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(349), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1735] = 10,
    ACTIONS(295), 1,
      sym__interpreted_text,
    ACTIONS(297), 1,
      sym__interpreted_text_prefix,
    ACTIONS(299), 1,
      sym__role_name_prefix,
    ACTIONS(361), 1,
      sym__newline,
    STATE(73), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(111), 1,
      sym__inline_markup,
    STATE(113), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(110), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(293), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1778] = 10,
    ACTIONS(215), 1,
      sym__newline,
    ACTIONS(366), 1,
      sym__interpreted_text,
    ACTIONS(369), 1,
      sym__interpreted_text_prefix,
    ACTIONS(372), 1,
      sym__role_name_prefix,
    STATE(73), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(111), 1,
      sym__inline_markup,
    STATE(113), 1,
      sym_interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(110), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(363), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1821] = 9,
    ACTIONS(339), 1,
      sym__interpreted_text,
    ACTIONS(341), 1,
      sym__interpreted_text_prefix,
    ACTIONS(343), 1,
      sym__role_name_prefix,
    STATE(70), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(109), 1,
      sym_interpreted_text,
    STATE(117), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(112), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(337), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1861] = 9,
    ACTIONS(339), 1,
      sym__interpreted_text,
    ACTIONS(341), 1,
      sym__interpreted_text_prefix,
    ACTIONS(343), 1,
      sym__role_name_prefix,
    STATE(67), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(109), 1,
      sym_interpreted_text,
    STATE(117), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(112), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(337), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1901] = 9,
    ACTIONS(233), 1,
      sym__interpreted_text,
    ACTIONS(235), 1,
      sym__interpreted_text_prefix,
    ACTIONS(237), 1,
      sym__role_name_prefix,
    STATE(64), 1,
      aux_sym__paragraph_line_repeat1,
    STATE(92), 1,
      sym_interpreted_text,
    STATE(96), 1,
      sym__inline_markup,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(95), 3,
      sym__default_role,
      sym__prefix_role,
      sym__suffix_role,
    ACTIONS(231), 10,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [1941] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(375), 18,
      sym__newline,
      sym__newline_indent,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [1968] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(377), 18,
      sym__newline,
      sym__newline_indent,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [1995] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(379), 18,
      sym__newline,
      sym__newline_indent,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2022] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(381), 18,
      sym__newline,
      sym__newline_indent,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2049] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(383), 18,
      sym__newline,
      sym__newline_indent,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2076] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(375), 16,
      sym__newline,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2099] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(381), 16,
      sym__newline,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2122] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(379), 16,
      sym__newline,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2145] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(383), 16,
      sym__newline,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2168] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(377), 16,
      sym__newline,
      sym__literal_indented_block_mark,
      sym__literal_quoted_block_mark,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2191] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(385), 15,
      sym__blankline,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2213] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(375), 15,
      sym__newline_indent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2237] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(387), 15,
      sym__blankline,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2259] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(389), 15,
      sym__blankline,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2281] = 3,
    ACTIONS(393), 1,
      sym__underline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(391), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2305] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(377), 15,
      sym__newline_indent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2329] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(391), 15,
      sym__blankline,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2351] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(381), 15,
      sym__newline_indent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2375] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(379), 15,
      sym__newline_indent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2399] = 3,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(383), 15,
      sym__newline_indent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
      aux_sym__classifiers_token1,
  [2423] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 15,
      sym__blankline,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2445] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(397), 15,
      sym__blankline,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2467] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(381), 14,
      sym__field_mark_end,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2488] = 8,
    ACTIONS(116), 1,
      sym__explicit_markup_start,
    ACTIONS(118), 1,
      sym__anonymous_target_mark,
    ACTIONS(120), 1,
      sym__empty_comment,
    STATE(158), 1,
      sym__anonymous_target,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(399), 2,
      sym__blankline,
      sym__dedent,
    STATE(104), 2,
      aux_sym__explicit_markup_block,
      sym__markup_block,
    STATE(188), 6,
      sym_footnote,
      sym_citation,
      sym_target,
      sym_directive,
      sym_substitution_definition,
      sym_comment,
  [2521] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(393), 14,
      sym__dedent,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2542] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(391), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2563] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(375), 14,
      sym__field_mark_end,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2584] = 8,
    ACTIONS(403), 1,
      sym__explicit_markup_start,
    ACTIONS(406), 1,
      sym__anonymous_target_mark,
    ACTIONS(409), 1,
      sym__empty_comment,
    STATE(158), 1,
      sym__anonymous_target,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(401), 2,
      sym__blankline,
      sym__dedent,
    STATE(104), 2,
      aux_sym__explicit_markup_block,
      sym__markup_block,
    STATE(188), 6,
      sym_footnote,
      sym_citation,
      sym_target,
      sym_directive,
      sym_substitution_definition,
      sym_comment,
  [2617] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(375), 14,
      sym__newline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2638] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2659] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(397), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2680] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(381), 14,
      sym__newline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2701] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(377), 14,
      sym__field_mark_end,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2722] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(379), 14,
      sym__newline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2743] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(383), 14,
      sym__newline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2764] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(379), 14,
      sym__field_mark_end,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2785] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(377), 14,
      sym__newline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2806] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(389), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2827] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(387), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2848] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(385), 14,
      sym__blankline,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2869] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(383), 14,
      sym__field_mark_end,
      sym__text,
      sym_emphasis,
      sym_strong,
      sym__interpreted_text,
      sym__interpreted_text_prefix,
      sym__role_name_prefix,
      sym_literal,
      sym_substitution_reference,
      sym_inline_target,
      sym_footnote_reference,
      sym_citation_reference,
      sym_reference,
      sym_standalone_hyperlink,
  [2890] = 8,
    ACTIONS(401), 1,
      sym__blankline,
    ACTIONS(412), 1,
      sym__explicit_markup_start,
    ACTIONS(415), 1,
      sym__anonymous_target_mark,
    ACTIONS(418), 1,
      sym__empty_comment,
    STATE(216), 1,
      sym__anonymous_target,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(118), 2,
      aux_sym__explicit_markup_block,
      sym__markup_block,
    STATE(215), 6,
      sym_footnote,
      sym_citation,
      sym_target,
      sym_directive,
      sym_substitution_definition,
      sym_comment,
  [2922] = 8,
    ACTIONS(37), 1,
      sym__explicit_markup_start,
    ACTIONS(39), 1,
      sym__anonymous_target_mark,
    ACTIONS(41), 1,
      sym__empty_comment,
    ACTIONS(399), 1,
      sym__blankline,
    STATE(216), 1,
      sym__anonymous_target,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(118), 2,
      aux_sym__explicit_markup_block,
      sym__markup_block,
    STATE(215), 6,
      sym_footnote,
      sym_citation,
      sym_target,
      sym_directive,
      sym_substitution_definition,
      sym_comment,
  [2954] = 11,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(421), 1,
      sym__blankline,
    ACTIONS(423), 1,
      sym__dedent,
    ACTIONS(425), 1,
      sym__text,
    STATE(189), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(205), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    STATE(262), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(142), 2,
      aux_sym__text_block,
      sym__text_line,
    STATE(165), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [2991] = 11,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(427), 1,
      sym__blankline,
    ACTIONS(429), 1,
      sym__dedent,
    STATE(170), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(186), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    STATE(309), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(152), 2,
      aux_sym__text_block,
      sym__text_line,
    STATE(165), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3028] = 12,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(431), 1,
      sym__dedent,
    ACTIONS(433), 1,
      sym__footnote_label,
    ACTIONS(435), 1,
      sym__citation_label,
    ACTIONS(437), 1,
      sym__target_name,
    ACTIONS(439), 1,
      sym__directive_name,
    ACTIONS(441), 1,
      sym__substitution_mark,
    STATE(170), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(175), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(152), 2,
      aux_sym__text_block,
      sym__text_line,
  [3067] = 12,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(443), 1,
      sym__dedent,
    ACTIONS(445), 1,
      sym__footnote_label,
    ACTIONS(447), 1,
      sym__citation_label,
    ACTIONS(449), 1,
      sym__target_name,
    ACTIONS(451), 1,
      sym__directive_name,
    ACTIONS(453), 1,
      sym__substitution_mark,
    STATE(189), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(226), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(142), 2,
      aux_sym__text_block,
      sym__text_line,
  [3106] = 11,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(455), 1,
      sym__newline,
    ACTIONS(457), 1,
      sym__blankline,
    ACTIONS(459), 1,
      sym__dedent,
    ACTIONS(461), 1,
      sym__text,
    STATE(121), 1,
      sym__text_line,
    STATE(178), 1,
      sym__directive_body,
    STATE(250), 1,
      aux_sym__text_line_repeat1,
    STATE(304), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(165), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3142] = 11,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(461), 1,
      sym__text,
    ACTIONS(463), 1,
      sym__newline,
    ACTIONS(465), 1,
      sym__blankline,
    ACTIONS(467), 1,
      sym__dedent,
    STATE(120), 1,
      sym__text_line,
    STATE(201), 1,
      sym__directive_body,
    STATE(250), 1,
      aux_sym__text_line_repeat1,
    STATE(259), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(165), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3178] = 11,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(461), 1,
      sym__text,
    ACTIONS(463), 1,
      sym__newline,
    ACTIONS(465), 1,
      sym__blankline,
    ACTIONS(469), 1,
      sym__dedent,
    STATE(120), 1,
      sym__text_line,
    STATE(203), 1,
      sym__directive_body,
    STATE(250), 1,
      aux_sym__text_line_repeat1,
    STATE(259), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(165), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3214] = 11,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(455), 1,
      sym__newline,
    ACTIONS(457), 1,
      sym__blankline,
    ACTIONS(461), 1,
      sym__text,
    ACTIONS(471), 1,
      sym__dedent,
    STATE(121), 1,
      sym__text_line,
    STATE(193), 1,
      sym__directive_body,
    STATE(250), 1,
      aux_sym__text_line_repeat1,
    STATE(304), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(165), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3250] = 9,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(425), 1,
      sym__text,
    STATE(189), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(207), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    STATE(269), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(142), 2,
      aux_sym__text_block,
      sym__text_line,
    STATE(165), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3281] = 9,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(425), 1,
      sym__text,
    STATE(170), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(191), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    STATE(306), 1,
      sym_field_list,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(152), 2,
      aux_sym__text_block,
      sym__text_line,
    STATE(165), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3312] = 7,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(473), 1,
      sym__dedent,
    STATE(167), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    STATE(327), 1,
      sym__indented_text_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(154), 2,
      aux_sym__text_block,
      sym__text_line,
  [3336] = 7,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(475), 1,
      sym__dedent,
    STATE(171), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    STATE(265), 1,
      sym__indented_text_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(150), 2,
      aux_sym__text_block,
      sym__text_line,
  [3360] = 7,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(477), 1,
      sym__dedent,
    STATE(195), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    STATE(320), 1,
      sym__indented_text_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(139), 2,
      aux_sym__text_block,
      sym__text_line,
  [3384] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(189), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(217), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(142), 2,
      aux_sym__text_block,
      sym__text_line,
  [3405] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(170), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(177), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(152), 2,
      aux_sym__text_block,
      sym__text_line,
  [3426] = 4,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(481), 1,
      sym__newline,
    ACTIONS(479), 5,
      anon_sym_,
      anon_sym_TAB,
      anon_sym_2,
      anon_sym_3,
      anon_sym_4,
  [3443] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(189), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(223), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(142), 2,
      aux_sym__text_block,
      sym__text_line,
  [3464] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(189), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(222), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(142), 2,
      aux_sym__text_block,
      sym__text_line,
  [3485] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(189), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(218), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(142), 2,
      aux_sym__text_block,
      sym__text_line,
  [3506] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(485), 1,
      sym__dedent,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(155), 2,
      aux_sym__text_block,
      sym__text_line,
  [3527] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(170), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(191), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(152), 2,
      aux_sym__text_block,
      sym__text_line,
  [3548] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(170), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(182), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(152), 2,
      aux_sym__text_block,
      sym__text_line,
  [3569] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(487), 1,
      sym__dedent,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(155), 2,
      aux_sym__text_block,
      sym__text_line,
  [3590] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(189), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(207), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(142), 2,
      aux_sym__text_block,
      sym__text_line,
  [3611] = 4,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(491), 1,
      sym__newline,
    ACTIONS(489), 5,
      anon_sym_,
      anon_sym_TAB,
      anon_sym_2,
      anon_sym_3,
      anon_sym_4,
  [3628] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(170), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(174), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(152), 2,
      aux_sym__text_block,
      sym__text_line,
  [3649] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(493), 1,
      sym__dedent,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(155), 2,
      aux_sym__text_block,
      sym__text_line,
  [3670] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(495), 1,
      sym__dedent,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(155), 2,
      aux_sym__text_block,
      sym__text_line,
  [3691] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(497), 1,
      sym__dedent,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(155), 2,
      aux_sym__text_block,
      sym__text_line,
  [3712] = 6,
    ACTIONS(425), 1,
      sym__text,
    STATE(170), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(181), 1,
      sym__indented_text_block,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(152), 2,
      aux_sym__text_block,
      sym__text_line,
  [3733] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(499), 1,
      sym__dedent,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(155), 2,
      aux_sym__text_block,
      sym__text_line,
  [3754] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(501), 1,
      sym__dedent,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(155), 2,
      aux_sym__text_block,
      sym__text_line,
  [3775] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(503), 1,
      sym__dedent,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(155), 2,
      aux_sym__text_block,
      sym__text_line,
  [3796] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(505), 1,
      sym__dedent,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(155), 2,
      aux_sym__text_block,
      sym__text_line,
  [3817] = 6,
    ACTIONS(425), 1,
      sym__text,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(507), 1,
      sym__dedent,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(155), 2,
      aux_sym__text_block,
      sym__text_line,
  [3838] = 5,
    ACTIONS(511), 1,
      sym__text,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(509), 2,
      sym__blankline,
      sym__dedent,
    STATE(155), 2,
      aux_sym__text_block,
      sym__text_line,
  [3857] = 4,
    ACTIONS(516), 1,
      sym__numeric_bullet,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(514), 2,
      sym__blankline,
      sym__dedent,
    STATE(156), 2,
      sym__numeric_list_item,
      aux_sym_enumerated_list_repeat1,
  [3873] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(519), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [3885] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(521), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [3897] = 5,
    ACTIONS(523), 1,
      sym__text,
    STATE(159), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(173), 2,
      aux_sym__text_block,
      sym__text_line,
  [3915] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [3927] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(397), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [3939] = 4,
    ACTIONS(100), 1,
      sym__char_bullet,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(526), 2,
      sym__blankline,
      sym__dedent,
    STATE(180), 2,
      sym__bullet_list_item,
      aux_sym_bullet_list_repeat1,
  [3955] = 4,
    ACTIONS(102), 1,
      sym__numeric_bullet,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(528), 2,
      sym__blankline,
      sym__dedent,
    STATE(156), 2,
      sym__numeric_list_item,
      aux_sym_enumerated_list_repeat1,
  [3971] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(530), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [3983] = 4,
    ACTIONS(104), 1,
      sym__field_mark,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(532), 2,
      sym__blankline,
      sym__dedent,
    STATE(183), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [3999] = 4,
    ACTIONS(110), 1,
      sym__line_block_mark,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(534), 2,
      sym__blankline,
      sym__dedent,
    STATE(184), 2,
      sym_line,
      aux_sym_line_block_repeat1,
  [4015] = 5,
    ACTIONS(425), 1,
      sym__text,
    STATE(159), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(147), 2,
      aux_sym__text_block,
      sym__text_line,
  [4033] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(536), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4045] = 5,
    ACTIONS(538), 1,
      sym__blankline,
    ACTIONS(540), 1,
      sym__text,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(192), 2,
      aux_sym__text_block,
      sym__text_line,
  [4063] = 5,
    ACTIONS(425), 1,
      sym__text,
    STATE(159), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(153), 2,
      aux_sym__text_block,
      sym__text_line,
  [4081] = 5,
    ACTIONS(425), 1,
      sym__text,
    STATE(159), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(151), 2,
      aux_sym__text_block,
      sym__text_line,
  [4099] = 5,
    ACTIONS(540), 1,
      sym__text,
    ACTIONS(542), 1,
      sym__blankline,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(192), 2,
      aux_sym__text_block,
      sym__text_line,
  [4117] = 5,
    ACTIONS(483), 1,
      sym__blankline,
    ACTIONS(540), 1,
      sym__text,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(192), 2,
      aux_sym__text_block,
      sym__text_line,
  [4135] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(544), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4147] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(546), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4159] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(548), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4171] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(550), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4183] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(552), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4195] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(554), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4207] = 4,
    ACTIONS(558), 1,
      sym__char_bullet,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(556), 2,
      sym__blankline,
      sym__dedent,
    STATE(180), 2,
      sym__bullet_list_item,
      aux_sym_bullet_list_repeat1,
  [4223] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(561), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4235] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(563), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4247] = 4,
    ACTIONS(567), 1,
      sym__field_mark,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(565), 2,
      sym__blankline,
      sym__dedent,
    STATE(183), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [4263] = 4,
    ACTIONS(572), 1,
      sym__line_block_mark,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(570), 2,
      sym__blankline,
      sym__dedent,
    STATE(184), 2,
      sym_line,
      aux_sym_line_block_repeat1,
  [4279] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(575), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4291] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(577), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4303] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(579), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4315] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(581), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4327] = 5,
    ACTIONS(425), 1,
      sym__text,
    STATE(159), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(146), 2,
      aux_sym__text_block,
      sym__text_line,
  [4345] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(583), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4357] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(585), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4369] = 5,
    ACTIONS(509), 1,
      sym__blankline,
    ACTIONS(587), 1,
      sym__text,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(192), 2,
      aux_sym__text_block,
      sym__text_line,
  [4387] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(590), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4399] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(592), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4411] = 5,
    ACTIONS(425), 1,
      sym__text,
    STATE(159), 1,
      aux_sym__indented_text_block_repeat1,
    STATE(251), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(148), 2,
      aux_sym__text_block,
      sym__text_line,
  [4429] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(594), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4441] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(596), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4453] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(598), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4465] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(600), 5,
      sym__blankline,
      sym__dedent,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4477] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(602), 4,
      sym__blankline,
      sym__dedent,
      sym__field_mark,
      sym__text,
  [4488] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(552), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4499] = 4,
    ACTIONS(19), 1,
      sym__field_mark,
    ACTIONS(532), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(231), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [4514] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(590), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4525] = 4,
    ACTIONS(25), 1,
      sym__line_block_mark,
    ACTIONS(534), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(232), 2,
      sym_line,
      aux_sym_line_block_repeat1,
  [4540] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(577), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4551] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4562] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(585), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4573] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(530), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4584] = 4,
    ACTIONS(540), 1,
      sym__text,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(172), 2,
      aux_sym__text_block,
      sym__text_line,
  [4599] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(397), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4610] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(592), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4621] = 4,
    ACTIONS(17), 1,
      sym__numeric_bullet,
    ACTIONS(528), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(230), 2,
      sym__numeric_list_item,
      aux_sym_enumerated_list_repeat1,
  [4636] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(536), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4647] = 4,
    ACTIONS(15), 1,
      sym__char_bullet,
    ACTIONS(526), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(229), 2,
      sym__bullet_list_item,
      aux_sym_bullet_list_repeat1,
  [4662] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(581), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4673] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(521), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4684] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(544), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4695] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(550), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4706] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(594), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4717] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(554), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4728] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(583), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4739] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(561), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4750] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(563), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4761] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(579), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4772] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(575), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4783] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(546), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4794] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(548), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4805] = 4,
    ACTIONS(540), 1,
      sym__text,
    STATE(247), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(169), 2,
      aux_sym__text_block,
      sym__text_line,
  [4820] = 4,
    ACTIONS(556), 1,
      sym__blankline,
    ACTIONS(604), 1,
      sym__char_bullet,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(229), 2,
      sym__bullet_list_item,
      aux_sym_bullet_list_repeat1,
  [4835] = 4,
    ACTIONS(514), 1,
      sym__blankline,
    ACTIONS(607), 1,
      sym__numeric_bullet,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(230), 2,
      sym__numeric_list_item,
      aux_sym_enumerated_list_repeat1,
  [4850] = 4,
    ACTIONS(565), 1,
      sym__blankline,
    ACTIONS(610), 1,
      sym__field_mark,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(231), 2,
      sym_field,
      aux_sym_field_list_repeat1,
  [4865] = 4,
    ACTIONS(570), 1,
      sym__blankline,
    ACTIONS(613), 1,
      sym__line_block_mark,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    STATE(232), 2,
      sym_line,
      aux_sym_line_block_repeat1,
  [4880] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(519), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4891] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(600), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4902] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(598), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4913] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(596), 4,
      sym__blankline,
      sym__explicit_markup_start,
      sym__anonymous_target_mark,
      sym__empty_comment,
  [4924] = 5,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(616), 1,
      sym__newline_indent,
    STATE(238), 1,
      aux_sym__classifiers,
  [4940] = 5,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(618), 1,
      aux_sym__classifiers_token1,
    ACTIONS(621), 1,
      sym__newline_indent,
    STATE(238), 1,
      aux_sym__classifiers,
  [4956] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(602), 3,
      sym__blankline,
      sym__dedent,
      sym__text,
  [4966] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 3,
      sym__blankline,
      sym__dedent,
      sym__char_bullet,
  [4976] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 3,
      sym__blankline,
      sym__dedent,
      sym__field_mark,
  [4986] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(397), 3,
      sym__blankline,
      sym__dedent,
      sym__numeric_bullet,
  [4996] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(623), 3,
      sym__blankline,
      sym__dedent,
      sym__numeric_bullet,
  [5006] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 3,
      sym__blankline,
      sym__dedent,
      sym__numeric_bullet,
  [5016] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(625), 3,
      sym__blankline,
      sym__dedent,
      sym__char_bullet,
  [5026] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(397), 3,
      sym__blankline,
      sym__dedent,
      sym__field_mark,
  [5036] = 4,
    ACTIONS(627), 1,
      sym__newline,
    ACTIONS(629), 1,
      sym__text,
    STATE(256), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5050] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(397), 3,
      sym__blankline,
      sym__dedent,
      sym__char_bullet,
  [5060] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(631), 3,
      sym__blankline,
      sym__dedent,
      sym__line_block_mark,
  [5070] = 4,
    ACTIONS(629), 1,
      sym__text,
    ACTIONS(633), 1,
      sym__newline,
    STATE(256), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5084] = 4,
    ACTIONS(629), 1,
      sym__text,
    ACTIONS(635), 1,
      sym__newline,
    STATE(256), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5098] = 5,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(199), 1,
      aux_sym__classifiers_token1,
    ACTIONS(637), 1,
      sym__newline_indent,
    STATE(238), 1,
      aux_sym__classifiers,
  [5114] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(639), 3,
      sym__blankline,
      sym__dedent,
      sym__line_block_mark,
  [5124] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(641), 3,
      sym__blankline,
      sym__dedent,
      sym__field_mark,
  [5134] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(643), 3,
      sym__blankline,
      sym__dedent,
      sym__field_mark,
  [5144] = 4,
    ACTIONS(645), 1,
      sym__newline,
    ACTIONS(647), 1,
      sym__text,
    STATE(256), 1,
      aux_sym__text_line_repeat1,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5158] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(397), 2,
      sym__blankline,
      sym__field_mark,
  [5167] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(623), 2,
      sym__blankline,
      sym__numeric_bullet,
  [5176] = 3,
    ACTIONS(650), 1,
      sym__blankline,
    ACTIONS(652), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5187] = 4,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(654), 1,
      aux_sym_target_token1,
    ACTIONS(656), 1,
      sym__newline,
  [5200] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(658), 2,
      sym__blankline,
      sym__dedent,
  [5209] = 3,
    ACTIONS(660), 1,
      sym__blankline,
    ACTIONS(662), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5220] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 2,
      sym__blankline,
      sym__field_mark,
  [5229] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(664), 2,
      sym__blankline,
      sym__dedent,
  [5238] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(666), 2,
      sym__blankline,
      sym__dedent,
  [5247] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(668), 2,
      sym__blankline,
      sym__dedent,
  [5256] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(672), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5267] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(397), 2,
      sym__blankline,
      sym__char_bullet,
  [5276] = 3,
    ACTIONS(674), 1,
      sym__blankline,
    ACTIONS(676), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5287] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(678), 2,
      sym__blankline,
      sym__dedent,
  [5296] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(397), 2,
      sym__blankline,
      sym__numeric_bullet,
  [5305] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(602), 2,
      sym__blankline,
      sym__text,
  [5314] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(680), 2,
      sym__blankline,
      sym__dedent,
  [5323] = 3,
    ACTIONS(682), 1,
      sym__blankline,
    ACTIONS(684), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5334] = 4,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(686), 1,
      aux_sym_target_token1,
    ACTIONS(688), 1,
      sym__newline,
  [5347] = 3,
    ACTIONS(682), 1,
      sym__blankline,
    ACTIONS(690), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5358] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(692), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5369] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(694), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5380] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(696), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5391] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(698), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5402] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(700), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5413] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(702), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5424] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(530), 2,
      sym__blankline,
      sym__dedent,
  [5433] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(536), 2,
      sym__blankline,
      sym__dedent,
  [5442] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(704), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5453] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(706), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5464] = 4,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(708), 1,
      aux_sym_target_token1,
    ACTIONS(710), 1,
      sym__dedent,
  [5477] = 3,
    ACTIONS(712), 1,
      sym__directive_name,
    STATE(199), 1,
      sym__embedded_directive,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5488] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(714), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5499] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 2,
      sym__blankline,
      sym__char_bullet,
  [5508] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(716), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5519] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(718), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5530] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(643), 2,
      sym__blankline,
      sym__field_mark,
  [5539] = 3,
    ACTIONS(682), 1,
      sym__blankline,
    ACTIONS(720), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5550] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(722), 2,
      sym__blankline,
      sym__dedent,
  [5559] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(724), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5570] = 3,
    ACTIONS(726), 1,
      sym__directive_name,
    STATE(234), 1,
      sym__embedded_directive,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5581] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(728), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5592] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(730), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5603] = 4,
    ACTIONS(3), 1,
      sym___newline,
    ACTIONS(5), 1,
      sym___whitespace,
    ACTIONS(732), 1,
      aux_sym_target_token1,
    ACTIONS(734), 1,
      sym__dedent,
  [5616] = 3,
    ACTIONS(682), 1,
      sym__blankline,
    ACTIONS(736), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5627] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(738), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5638] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(631), 2,
      sym__blankline,
      sym__line_block_mark,
  [5647] = 3,
    ACTIONS(740), 1,
      sym__blankline,
    ACTIONS(742), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5658] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(641), 2,
      sym__blankline,
      sym__field_mark,
  [5667] = 3,
    ACTIONS(744), 1,
      sym__blankline,
    ACTIONS(746), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5678] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(748), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5689] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(750), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5700] = 3,
    ACTIONS(752), 1,
      sym__blankline,
    ACTIONS(754), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5711] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(395), 2,
      sym__blankline,
      sym__numeric_bullet,
  [5720] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(639), 2,
      sym__blankline,
      sym__line_block_mark,
  [5729] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(756), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5740] = 2,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
    ACTIONS(625), 2,
      sym__blankline,
      sym__char_bullet,
  [5749] = 3,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(758), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5760] = 2,
    ACTIONS(760), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5768] = 2,
    ACTIONS(680), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5776] = 2,
    ACTIONS(762), 1,
      sym__quoted_literal_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5784] = 2,
    ACTIONS(764), 1,
      sym__underline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5792] = 2,
    ACTIONS(766), 1,
      sym__role_name_suffix,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5800] = 2,
    ACTIONS(666), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5808] = 2,
    ACTIONS(736), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5816] = 2,
    ACTIONS(768), 1,
      sym__role_name_suffix,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5824] = 2,
    ACTIONS(770), 1,
      sym__interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5832] = 2,
    ACTIONS(530), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5840] = 2,
    ACTIONS(658), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5848] = 2,
    ACTIONS(664), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5856] = 2,
    ACTIONS(666), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5864] = 2,
    ACTIONS(772), 1,
      sym__role_name_suffix,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5872] = 2,
    ACTIONS(774), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5880] = 2,
    ACTIONS(776), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5888] = 2,
    ACTIONS(670), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5896] = 2,
    ACTIONS(778), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5904] = 2,
    ACTIONS(720), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5912] = 2,
    ACTIONS(780), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5920] = 2,
    ACTIONS(782), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5928] = 2,
    ACTIONS(784), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5936] = 2,
    ACTIONS(786), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5944] = 2,
    ACTIONS(682), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5952] = 2,
    ACTIONS(664), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5960] = 2,
    ACTIONS(788), 1,
      sym__interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5968] = 2,
    ACTIONS(790), 1,
      sym__interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5976] = 2,
    ACTIONS(668), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5984] = 2,
    ACTIONS(690), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [5992] = 2,
    ACTIONS(722), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6000] = 2,
    ACTIONS(792), 1,
      sym__interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6008] = 2,
    ACTIONS(794), 1,
      sym__role_name_suffix,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6016] = 2,
    ACTIONS(796), 1,
      sym__underline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6024] = 2,
    ACTIONS(684), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6032] = 2,
    ACTIONS(798), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6040] = 2,
    ACTIONS(800), 1,
      sym__quoted_literal_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6048] = 2,
    ACTIONS(393), 1,
      sym__underline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6056] = 2,
    ACTIONS(678), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6064] = 2,
    ACTIONS(802), 1,
      sym__text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6072] = 2,
    ACTIONS(804), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6080] = 2,
    ACTIONS(806), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6088] = 2,
    ACTIONS(808), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6096] = 2,
    ACTIONS(810), 1,
      sym__dedent,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6104] = 2,
    ACTIONS(536), 1,
      sym__blankline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6112] = 2,
    ACTIONS(530), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6120] = 2,
    ACTIONS(812), 1,
      sym__interpreted_text,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6128] = 2,
    ACTIONS(814), 1,
      sym__role_name_suffix,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6136] = 2,
    ACTIONS(536), 1,
      sym__newline,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6144] = 2,
    ACTIONS(816), 1,
      sym__quoted_literal_block,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
  [6152] = 2,
    ACTIONS(818), 1,
      anon_sym_COLON_COLON,
    ACTIONS(3), 2,
      sym___newline,
      sym___whitespace,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(34)] = 0,
  [SMALL_STATE(35)] = 34,
  [SMALL_STATE(36)] = 68,
  [SMALL_STATE(37)] = 102,
  [SMALL_STATE(38)] = 136,
  [SMALL_STATE(39)] = 170,
  [SMALL_STATE(40)] = 233,
  [SMALL_STATE(41)] = 296,
  [SMALL_STATE(42)] = 359,
  [SMALL_STATE(43)] = 391,
  [SMALL_STATE(44)] = 440,
  [SMALL_STATE(45)] = 471,
  [SMALL_STATE(46)] = 519,
  [SMALL_STATE(47)] = 571,
  [SMALL_STATE(48)] = 623,
  [SMALL_STATE(49)] = 671,
  [SMALL_STATE(50)] = 719,
  [SMALL_STATE(51)] = 767,
  [SMALL_STATE(52)] = 814,
  [SMALL_STATE(53)] = 861,
  [SMALL_STATE(54)] = 908,
  [SMALL_STATE(55)] = 955,
  [SMALL_STATE(56)] = 1006,
  [SMALL_STATE(57)] = 1053,
  [SMALL_STATE(58)] = 1100,
  [SMALL_STATE(59)] = 1145,
  [SMALL_STATE(60)] = 1192,
  [SMALL_STATE(61)] = 1239,
  [SMALL_STATE(62)] = 1286,
  [SMALL_STATE(63)] = 1337,
  [SMALL_STATE(64)] = 1384,
  [SMALL_STATE(65)] = 1430,
  [SMALL_STATE(66)] = 1476,
  [SMALL_STATE(67)] = 1520,
  [SMALL_STATE(68)] = 1563,
  [SMALL_STATE(69)] = 1606,
  [SMALL_STATE(70)] = 1649,
  [SMALL_STATE(71)] = 1692,
  [SMALL_STATE(72)] = 1735,
  [SMALL_STATE(73)] = 1778,
  [SMALL_STATE(74)] = 1821,
  [SMALL_STATE(75)] = 1861,
  [SMALL_STATE(76)] = 1901,
  [SMALL_STATE(77)] = 1941,
  [SMALL_STATE(78)] = 1968,
  [SMALL_STATE(79)] = 1995,
  [SMALL_STATE(80)] = 2022,
  [SMALL_STATE(81)] = 2049,
  [SMALL_STATE(82)] = 2076,
  [SMALL_STATE(83)] = 2099,
  [SMALL_STATE(84)] = 2122,
  [SMALL_STATE(85)] = 2145,
  [SMALL_STATE(86)] = 2168,
  [SMALL_STATE(87)] = 2191,
  [SMALL_STATE(88)] = 2213,
  [SMALL_STATE(89)] = 2237,
  [SMALL_STATE(90)] = 2259,
  [SMALL_STATE(91)] = 2281,
  [SMALL_STATE(92)] = 2305,
  [SMALL_STATE(93)] = 2329,
  [SMALL_STATE(94)] = 2351,
  [SMALL_STATE(95)] = 2375,
  [SMALL_STATE(96)] = 2399,
  [SMALL_STATE(97)] = 2423,
  [SMALL_STATE(98)] = 2445,
  [SMALL_STATE(99)] = 2467,
  [SMALL_STATE(100)] = 2488,
  [SMALL_STATE(101)] = 2521,
  [SMALL_STATE(102)] = 2542,
  [SMALL_STATE(103)] = 2563,
  [SMALL_STATE(104)] = 2584,
  [SMALL_STATE(105)] = 2617,
  [SMALL_STATE(106)] = 2638,
  [SMALL_STATE(107)] = 2659,
  [SMALL_STATE(108)] = 2680,
  [SMALL_STATE(109)] = 2701,
  [SMALL_STATE(110)] = 2722,
  [SMALL_STATE(111)] = 2743,
  [SMALL_STATE(112)] = 2764,
  [SMALL_STATE(113)] = 2785,
  [SMALL_STATE(114)] = 2806,
  [SMALL_STATE(115)] = 2827,
  [SMALL_STATE(116)] = 2848,
  [SMALL_STATE(117)] = 2869,
  [SMALL_STATE(118)] = 2890,
  [SMALL_STATE(119)] = 2922,
  [SMALL_STATE(120)] = 2954,
  [SMALL_STATE(121)] = 2991,
  [SMALL_STATE(122)] = 3028,
  [SMALL_STATE(123)] = 3067,
  [SMALL_STATE(124)] = 3106,
  [SMALL_STATE(125)] = 3142,
  [SMALL_STATE(126)] = 3178,
  [SMALL_STATE(127)] = 3214,
  [SMALL_STATE(128)] = 3250,
  [SMALL_STATE(129)] = 3281,
  [SMALL_STATE(130)] = 3312,
  [SMALL_STATE(131)] = 3336,
  [SMALL_STATE(132)] = 3360,
  [SMALL_STATE(133)] = 3384,
  [SMALL_STATE(134)] = 3405,
  [SMALL_STATE(135)] = 3426,
  [SMALL_STATE(136)] = 3443,
  [SMALL_STATE(137)] = 3464,
  [SMALL_STATE(138)] = 3485,
  [SMALL_STATE(139)] = 3506,
  [SMALL_STATE(140)] = 3527,
  [SMALL_STATE(141)] = 3548,
  [SMALL_STATE(142)] = 3569,
  [SMALL_STATE(143)] = 3590,
  [SMALL_STATE(144)] = 3611,
  [SMALL_STATE(145)] = 3628,
  [SMALL_STATE(146)] = 3649,
  [SMALL_STATE(147)] = 3670,
  [SMALL_STATE(148)] = 3691,
  [SMALL_STATE(149)] = 3712,
  [SMALL_STATE(150)] = 3733,
  [SMALL_STATE(151)] = 3754,
  [SMALL_STATE(152)] = 3775,
  [SMALL_STATE(153)] = 3796,
  [SMALL_STATE(154)] = 3817,
  [SMALL_STATE(155)] = 3838,
  [SMALL_STATE(156)] = 3857,
  [SMALL_STATE(157)] = 3873,
  [SMALL_STATE(158)] = 3885,
  [SMALL_STATE(159)] = 3897,
  [SMALL_STATE(160)] = 3915,
  [SMALL_STATE(161)] = 3927,
  [SMALL_STATE(162)] = 3939,
  [SMALL_STATE(163)] = 3955,
  [SMALL_STATE(164)] = 3971,
  [SMALL_STATE(165)] = 3983,
  [SMALL_STATE(166)] = 3999,
  [SMALL_STATE(167)] = 4015,
  [SMALL_STATE(168)] = 4033,
  [SMALL_STATE(169)] = 4045,
  [SMALL_STATE(170)] = 4063,
  [SMALL_STATE(171)] = 4081,
  [SMALL_STATE(172)] = 4099,
  [SMALL_STATE(173)] = 4117,
  [SMALL_STATE(174)] = 4135,
  [SMALL_STATE(175)] = 4147,
  [SMALL_STATE(176)] = 4159,
  [SMALL_STATE(177)] = 4171,
  [SMALL_STATE(178)] = 4183,
  [SMALL_STATE(179)] = 4195,
  [SMALL_STATE(180)] = 4207,
  [SMALL_STATE(181)] = 4223,
  [SMALL_STATE(182)] = 4235,
  [SMALL_STATE(183)] = 4247,
  [SMALL_STATE(184)] = 4263,
  [SMALL_STATE(185)] = 4279,
  [SMALL_STATE(186)] = 4291,
  [SMALL_STATE(187)] = 4303,
  [SMALL_STATE(188)] = 4315,
  [SMALL_STATE(189)] = 4327,
  [SMALL_STATE(190)] = 4345,
  [SMALL_STATE(191)] = 4357,
  [SMALL_STATE(192)] = 4369,
  [SMALL_STATE(193)] = 4387,
  [SMALL_STATE(194)] = 4399,
  [SMALL_STATE(195)] = 4411,
  [SMALL_STATE(196)] = 4429,
  [SMALL_STATE(197)] = 4441,
  [SMALL_STATE(198)] = 4453,
  [SMALL_STATE(199)] = 4465,
  [SMALL_STATE(200)] = 4477,
  [SMALL_STATE(201)] = 4488,
  [SMALL_STATE(202)] = 4499,
  [SMALL_STATE(203)] = 4514,
  [SMALL_STATE(204)] = 4525,
  [SMALL_STATE(205)] = 4540,
  [SMALL_STATE(206)] = 4551,
  [SMALL_STATE(207)] = 4562,
  [SMALL_STATE(208)] = 4573,
  [SMALL_STATE(209)] = 4584,
  [SMALL_STATE(210)] = 4599,
  [SMALL_STATE(211)] = 4610,
  [SMALL_STATE(212)] = 4621,
  [SMALL_STATE(213)] = 4636,
  [SMALL_STATE(214)] = 4647,
  [SMALL_STATE(215)] = 4662,
  [SMALL_STATE(216)] = 4673,
  [SMALL_STATE(217)] = 4684,
  [SMALL_STATE(218)] = 4695,
  [SMALL_STATE(219)] = 4706,
  [SMALL_STATE(220)] = 4717,
  [SMALL_STATE(221)] = 4728,
  [SMALL_STATE(222)] = 4739,
  [SMALL_STATE(223)] = 4750,
  [SMALL_STATE(224)] = 4761,
  [SMALL_STATE(225)] = 4772,
  [SMALL_STATE(226)] = 4783,
  [SMALL_STATE(227)] = 4794,
  [SMALL_STATE(228)] = 4805,
  [SMALL_STATE(229)] = 4820,
  [SMALL_STATE(230)] = 4835,
  [SMALL_STATE(231)] = 4850,
  [SMALL_STATE(232)] = 4865,
  [SMALL_STATE(233)] = 4880,
  [SMALL_STATE(234)] = 4891,
  [SMALL_STATE(235)] = 4902,
  [SMALL_STATE(236)] = 4913,
  [SMALL_STATE(237)] = 4924,
  [SMALL_STATE(238)] = 4940,
  [SMALL_STATE(239)] = 4956,
  [SMALL_STATE(240)] = 4966,
  [SMALL_STATE(241)] = 4976,
  [SMALL_STATE(242)] = 4986,
  [SMALL_STATE(243)] = 4996,
  [SMALL_STATE(244)] = 5006,
  [SMALL_STATE(245)] = 5016,
  [SMALL_STATE(246)] = 5026,
  [SMALL_STATE(247)] = 5036,
  [SMALL_STATE(248)] = 5050,
  [SMALL_STATE(249)] = 5060,
  [SMALL_STATE(250)] = 5070,
  [SMALL_STATE(251)] = 5084,
  [SMALL_STATE(252)] = 5098,
  [SMALL_STATE(253)] = 5114,
  [SMALL_STATE(254)] = 5124,
  [SMALL_STATE(255)] = 5134,
  [SMALL_STATE(256)] = 5144,
  [SMALL_STATE(257)] = 5158,
  [SMALL_STATE(258)] = 5167,
  [SMALL_STATE(259)] = 5176,
  [SMALL_STATE(260)] = 5187,
  [SMALL_STATE(261)] = 5200,
  [SMALL_STATE(262)] = 5209,
  [SMALL_STATE(263)] = 5220,
  [SMALL_STATE(264)] = 5229,
  [SMALL_STATE(265)] = 5238,
  [SMALL_STATE(266)] = 5247,
  [SMALL_STATE(267)] = 5256,
  [SMALL_STATE(268)] = 5267,
  [SMALL_STATE(269)] = 5276,
  [SMALL_STATE(270)] = 5287,
  [SMALL_STATE(271)] = 5296,
  [SMALL_STATE(272)] = 5305,
  [SMALL_STATE(273)] = 5314,
  [SMALL_STATE(274)] = 5323,
  [SMALL_STATE(275)] = 5334,
  [SMALL_STATE(276)] = 5347,
  [SMALL_STATE(277)] = 5358,
  [SMALL_STATE(278)] = 5369,
  [SMALL_STATE(279)] = 5380,
  [SMALL_STATE(280)] = 5391,
  [SMALL_STATE(281)] = 5402,
  [SMALL_STATE(282)] = 5413,
  [SMALL_STATE(283)] = 5424,
  [SMALL_STATE(284)] = 5433,
  [SMALL_STATE(285)] = 5442,
  [SMALL_STATE(286)] = 5453,
  [SMALL_STATE(287)] = 5464,
  [SMALL_STATE(288)] = 5477,
  [SMALL_STATE(289)] = 5488,
  [SMALL_STATE(290)] = 5499,
  [SMALL_STATE(291)] = 5508,
  [SMALL_STATE(292)] = 5519,
  [SMALL_STATE(293)] = 5530,
  [SMALL_STATE(294)] = 5539,
  [SMALL_STATE(295)] = 5550,
  [SMALL_STATE(296)] = 5559,
  [SMALL_STATE(297)] = 5570,
  [SMALL_STATE(298)] = 5581,
  [SMALL_STATE(299)] = 5592,
  [SMALL_STATE(300)] = 5603,
  [SMALL_STATE(301)] = 5616,
  [SMALL_STATE(302)] = 5627,
  [SMALL_STATE(303)] = 5638,
  [SMALL_STATE(304)] = 5647,
  [SMALL_STATE(305)] = 5658,
  [SMALL_STATE(306)] = 5667,
  [SMALL_STATE(307)] = 5678,
  [SMALL_STATE(308)] = 5689,
  [SMALL_STATE(309)] = 5700,
  [SMALL_STATE(310)] = 5711,
  [SMALL_STATE(311)] = 5720,
  [SMALL_STATE(312)] = 5729,
  [SMALL_STATE(313)] = 5740,
  [SMALL_STATE(314)] = 5749,
  [SMALL_STATE(315)] = 5760,
  [SMALL_STATE(316)] = 5768,
  [SMALL_STATE(317)] = 5776,
  [SMALL_STATE(318)] = 5784,
  [SMALL_STATE(319)] = 5792,
  [SMALL_STATE(320)] = 5800,
  [SMALL_STATE(321)] = 5808,
  [SMALL_STATE(322)] = 5816,
  [SMALL_STATE(323)] = 5824,
  [SMALL_STATE(324)] = 5832,
  [SMALL_STATE(325)] = 5840,
  [SMALL_STATE(326)] = 5848,
  [SMALL_STATE(327)] = 5856,
  [SMALL_STATE(328)] = 5864,
  [SMALL_STATE(329)] = 5872,
  [SMALL_STATE(330)] = 5880,
  [SMALL_STATE(331)] = 5888,
  [SMALL_STATE(332)] = 5896,
  [SMALL_STATE(333)] = 5904,
  [SMALL_STATE(334)] = 5912,
  [SMALL_STATE(335)] = 5920,
  [SMALL_STATE(336)] = 5928,
  [SMALL_STATE(337)] = 5936,
  [SMALL_STATE(338)] = 5944,
  [SMALL_STATE(339)] = 5952,
  [SMALL_STATE(340)] = 5960,
  [SMALL_STATE(341)] = 5968,
  [SMALL_STATE(342)] = 5976,
  [SMALL_STATE(343)] = 5984,
  [SMALL_STATE(344)] = 5992,
  [SMALL_STATE(345)] = 6000,
  [SMALL_STATE(346)] = 6008,
  [SMALL_STATE(347)] = 6016,
  [SMALL_STATE(348)] = 6024,
  [SMALL_STATE(349)] = 6032,
  [SMALL_STATE(350)] = 6040,
  [SMALL_STATE(351)] = 6048,
  [SMALL_STATE(352)] = 6056,
  [SMALL_STATE(353)] = 6064,
  [SMALL_STATE(354)] = 6072,
  [SMALL_STATE(355)] = 6080,
  [SMALL_STATE(356)] = 6088,
  [SMALL_STATE(357)] = 6096,
  [SMALL_STATE(358)] = 6104,
  [SMALL_STATE(359)] = 6112,
  [SMALL_STATE(360)] = 6120,
  [SMALL_STATE(361)] = 6128,
  [SMALL_STATE(362)] = 6136,
  [SMALL_STATE(363)] = 6144,
  [SMALL_STATE(364)] = 6152,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 0),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [43] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2),
  [45] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(5),
  [48] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(69),
  [51] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(315),
  [54] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(14),
  [57] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(12),
  [60] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(74),
  [63] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(132),
  [66] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(363),
  [69] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(56),
  [72] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(209),
  [75] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(78),
  [78] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(79),
  [81] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(361),
  [84] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(360),
  [87] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(123),
  [90] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(260),
  [93] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_document_repeat1, 2), SHIFT_REPEAT(215),
  [96] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_document, 1),
  [98] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [142] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(5),
  [145] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(14),
  [148] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(12),
  [151] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(74),
  [154] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(132),
  [157] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(363),
  [160] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(56),
  [163] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2),
  [165] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(209),
  [168] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(78),
  [171] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(79),
  [174] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(361),
  [177] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(360),
  [180] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(123),
  [183] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(260),
  [186] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_body_repeat1, 2), SHIFT_REPEAT(215),
  [189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__body_element_block, 2),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__transition_block, 2),
  [193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__underline_section, 2, .production_id = 3),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__overline_section, 3, .production_id = 4),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_section, 1),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2),
  [217] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(78),
  [220] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(79),
  [223] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(361),
  [226] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(360),
  [229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_definition_list, 1),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [247] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paragraph, 1),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_definition_list_repeat1, 2),
  [251] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_definition_list_repeat1, 2), SHIFT_REPEAT(92),
  [254] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_definition_list_repeat1, 2), SHIFT_REPEAT(95),
  [257] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_definition_list_repeat1, 2), SHIFT_REPEAT(328),
  [260] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_definition_list_repeat1, 2), SHIFT_REPEAT(341),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2),
  [265] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(86),
  [268] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(84),
  [271] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(322),
  [274] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(323),
  [277] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2),
  [279] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(113),
  [282] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(110),
  [285] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(346),
  [288] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_repeat1, 2), SHIFT_REPEAT(345),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [305] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(86),
  [308] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(84),
  [311] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(322),
  [314] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(323),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__classifiers, 2, .production_id = 10),
  [323] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(92),
  [326] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(95),
  [329] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(328),
  [332] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(341),
  [335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [349] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(109),
  [352] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(112),
  [355] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(319),
  [358] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(340),
  [361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [363] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(113),
  [366] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(110),
  [369] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(346),
  [372] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 2), SHIFT_REPEAT(345),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__prefix_role, 2),
  [377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__inline_markup, 1),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpreted_text, 1),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__suffix_role, 2),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__paragraph_line_repeat1, 1),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paragraph_line, 3),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__definition_list_item, 3, .production_id = 9),
  [389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__definition_list_item, 4, .production_id = 15),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paragraph_line, 2),
  [393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__line, 2),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_body, 3),
  [397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_body, 2),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__body_element, 1),
  [401] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2),
  [403] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2), SHIFT_REPEAT(122),
  [406] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2), SHIFT_REPEAT(275),
  [409] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2), SHIFT_REPEAT(188),
  [412] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2), SHIFT_REPEAT(123),
  [415] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2), SHIFT_REPEAT(260),
  [418] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__explicit_markup_block, 2), SHIFT_REPEAT(215),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [479] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [489] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [509] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__text_block, 2),
  [511] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__text_block, 2), SHIFT_REPEAT(251),
  [514] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enumerated_list_repeat1, 2),
  [516] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enumerated_list_repeat1, 2), SHIFT_REPEAT(11),
  [519] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__anonymous_target, 3, .production_id = 8),
  [521] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__markup_block, 1, .production_id = 1),
  [523] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__indented_text_block_repeat1, 2), SHIFT_REPEAT(247),
  [526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bullet_list, 1),
  [528] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enumerated_list, 1),
  [530] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__indented_text_block, 3),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_list, 1),
  [534] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line_block, 1),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__indented_text_block, 2),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [544] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 4, .production_id = 26),
  [546] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__anonymous_target, 2),
  [550] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 4, .production_id = 25),
  [552] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__embedded_directive, 4, .production_id = 24),
  [554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 3, .production_id = 23),
  [556] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_bullet_list_repeat1, 2),
  [558] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_bullet_list_repeat1, 2), SHIFT_REPEAT(9),
  [561] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 3, .production_id = 22),
  [563] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 3, .production_id = 21),
  [565] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_field_list_repeat1, 2),
  [567] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_field_list_repeat1, 2), SHIFT_REPEAT(75),
  [570] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_line_block_repeat1, 2),
  [572] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_block_repeat1, 2), SHIFT_REPEAT(53),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 3, .production_id = 20),
  [577] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 2, .production_id = 19),
  [579] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 2, .production_id = 18),
  [581] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__markup_block, 1),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 2, .production_id = 17),
  [585] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive_body, 2, .production_id = 16),
  [587] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__text_block, 2), SHIFT_REPEAT(247),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_directive, 4, .production_id = 14),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_target, 4, .production_id = 13),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_footnote, 3, .production_id = 5),
  [596] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_citation, 3, .production_id = 5),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_target, 3, .production_id = 6),
  [600] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_substitution_definition, 3, .production_id = 7),
  [602] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__text_line, 2),
  [604] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_bullet_list_repeat1, 2), SHIFT_REPEAT(14),
  [607] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enumerated_list_repeat1, 2), SHIFT_REPEAT(12),
  [610] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_field_list_repeat1, 2), SHIFT_REPEAT(74),
  [613] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_line_block_repeat1, 2), SHIFT_REPEAT(56),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [618] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__classifiers, 2), SHIFT_REPEAT(76),
  [621] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__classifiers, 2),
  [623] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__numeric_list_item, 2),
  [625] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bullet_list_item, 2),
  [627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line, 2),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [639] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line, 3),
  [641] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 4, .production_id = 12),
  [643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 4, .production_id = 11),
  [645] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__text_line_repeat1, 2),
  [647] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__text_line_repeat1, 2), SHIFT_REPEAT(256),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [658] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__block_quote_block, 2),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [664] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__literal_block, 2),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__literal_block, 2, .production_id = 2),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_quote, 2),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [678] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__list, 1),
  [680] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_doctest_block, 3),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [722] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_quote, 3),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [784] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [786] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [788] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [790] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [792] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__indented_text_block_repeat1, 2),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [808] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [810] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribution, 3),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_rst_external_scanner_create(void);
void tree_sitter_rst_external_scanner_destroy(void *);
bool tree_sitter_rst_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_rst_external_scanner_serialize(void *, char *);
void tree_sitter_rst_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_rst(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_rst_external_scanner_create,
      tree_sitter_rst_external_scanner_destroy,
      tree_sitter_rst_external_scanner_scan,
      tree_sitter_rst_external_scanner_serialize,
      tree_sitter_rst_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
