#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 323
#define LARGE_STATE_COUNT 89
#define SYMBOL_COUNT 67
#define ALIAS_COUNT 0
#define TOKEN_COUNT 31
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 8
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 36

enum {
  sym__ws = 1,
  sym_comment = 2,
  anon_sym_POUND_ = 3,
  sym_num_lit = 4,
  sym_kwd_lit = 5,
  aux_sym_str_lit_token1 = 6,
  sym_char_lit = 7,
  sym_nil_lit = 8,
  sym_bool_lit = 9,
  aux_sym_sym_lit_token1 = 10,
  anon_sym_CARET = 11,
  anon_sym_POUND_CARET = 12,
  anon_sym_LPAREN = 13,
  anon_sym_RPAREN = 14,
  anon_sym_LBRACE = 15,
  anon_sym_RBRACE = 16,
  anon_sym_LBRACK = 17,
  anon_sym_RBRACK = 18,
  anon_sym_POUND = 19,
  anon_sym_POUND_QMARK = 20,
  anon_sym_POUND_QMARK_AT = 21,
  sym_auto_res_mark = 22,
  anon_sym_POUND_SQUOTE = 23,
  anon_sym_POUND_POUND = 24,
  anon_sym_POUND_EQ = 25,
  anon_sym_AT = 26,
  anon_sym_SQUOTE = 27,
  anon_sym_BQUOTE = 28,
  anon_sym_TILDE_AT = 29,
  anon_sym_TILDE = 30,
  sym_source = 31,
  sym__gap = 32,
  sym_dis_expr = 33,
  sym__form = 34,
  sym_str_lit = 35,
  sym_sym_lit = 36,
  sym__metadata_lit = 37,
  sym_meta_lit = 38,
  sym_old_meta_lit = 39,
  sym_list_lit = 40,
  sym__bare_list_lit = 41,
  sym_map_lit = 42,
  sym__bare_map_lit = 43,
  sym_vec_lit = 44,
  sym__bare_vec_lit = 45,
  sym_set_lit = 46,
  sym__bare_set_lit = 47,
  sym_anon_fn_lit = 48,
  sym_regex_lit = 49,
  sym_read_cond_lit = 50,
  sym_splicing_read_cond_lit = 51,
  sym_ns_map_lit = 52,
  sym_var_quoting_lit = 53,
  sym_sym_val_lit = 54,
  sym_evaling_lit = 55,
  sym_tagged_or_ctor_lit = 56,
  sym_derefing_lit = 57,
  sym_quoting_lit = 58,
  sym_syn_quoting_lit = 59,
  sym_unquote_splicing_lit = 60,
  sym_unquoting_lit = 61,
  aux_sym_source_repeat1 = 62,
  aux_sym_dis_expr_repeat1 = 63,
  aux_sym_sym_lit_repeat1 = 64,
  aux_sym__bare_list_lit_repeat1 = 65,
  aux_sym_read_cond_lit_repeat1 = 66,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__ws] = "_ws",
  [sym_comment] = "comment",
  [anon_sym_POUND_] = "#_",
  [sym_num_lit] = "num_lit",
  [sym_kwd_lit] = "kwd_lit",
  [aux_sym_str_lit_token1] = "str_lit_token1",
  [sym_char_lit] = "char_lit",
  [sym_nil_lit] = "nil_lit",
  [sym_bool_lit] = "bool_lit",
  [aux_sym_sym_lit_token1] = "sym_lit_token1",
  [anon_sym_CARET] = "^",
  [anon_sym_POUND_CARET] = "#^",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_POUND] = "#",
  [anon_sym_POUND_QMARK] = "#\?",
  [anon_sym_POUND_QMARK_AT] = "#\?@",
  [sym_auto_res_mark] = "auto_res_mark",
  [anon_sym_POUND_SQUOTE] = "#'",
  [anon_sym_POUND_POUND] = "##",
  [anon_sym_POUND_EQ] = "#=",
  [anon_sym_AT] = "@",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_TILDE_AT] = "~@",
  [anon_sym_TILDE] = "~",
  [sym_source] = "source",
  [sym__gap] = "_gap",
  [sym_dis_expr] = "dis_expr",
  [sym__form] = "_form",
  [sym_str_lit] = "str_lit",
  [sym_sym_lit] = "sym_lit",
  [sym__metadata_lit] = "_metadata_lit",
  [sym_meta_lit] = "meta_lit",
  [sym_old_meta_lit] = "old_meta_lit",
  [sym_list_lit] = "list_lit",
  [sym__bare_list_lit] = "_bare_list_lit",
  [sym_map_lit] = "map_lit",
  [sym__bare_map_lit] = "_bare_map_lit",
  [sym_vec_lit] = "vec_lit",
  [sym__bare_vec_lit] = "_bare_vec_lit",
  [sym_set_lit] = "set_lit",
  [sym__bare_set_lit] = "_bare_set_lit",
  [sym_anon_fn_lit] = "anon_fn_lit",
  [sym_regex_lit] = "regex_lit",
  [sym_read_cond_lit] = "read_cond_lit",
  [sym_splicing_read_cond_lit] = "splicing_read_cond_lit",
  [sym_ns_map_lit] = "ns_map_lit",
  [sym_var_quoting_lit] = "var_quoting_lit",
  [sym_sym_val_lit] = "sym_val_lit",
  [sym_evaling_lit] = "evaling_lit",
  [sym_tagged_or_ctor_lit] = "tagged_or_ctor_lit",
  [sym_derefing_lit] = "derefing_lit",
  [sym_quoting_lit] = "quoting_lit",
  [sym_syn_quoting_lit] = "syn_quoting_lit",
  [sym_unquote_splicing_lit] = "unquote_splicing_lit",
  [sym_unquoting_lit] = "unquoting_lit",
  [aux_sym_source_repeat1] = "source_repeat1",
  [aux_sym_dis_expr_repeat1] = "dis_expr_repeat1",
  [aux_sym_sym_lit_repeat1] = "sym_lit_repeat1",
  [aux_sym__bare_list_lit_repeat1] = "_bare_list_lit_repeat1",
  [aux_sym_read_cond_lit_repeat1] = "read_cond_lit_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__ws] = sym__ws,
  [sym_comment] = sym_comment,
  [anon_sym_POUND_] = anon_sym_POUND_,
  [sym_num_lit] = sym_num_lit,
  [sym_kwd_lit] = sym_kwd_lit,
  [aux_sym_str_lit_token1] = aux_sym_str_lit_token1,
  [sym_char_lit] = sym_char_lit,
  [sym_nil_lit] = sym_nil_lit,
  [sym_bool_lit] = sym_bool_lit,
  [aux_sym_sym_lit_token1] = aux_sym_sym_lit_token1,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_POUND_CARET] = anon_sym_POUND_CARET,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_POUND_QMARK] = anon_sym_POUND_QMARK,
  [anon_sym_POUND_QMARK_AT] = anon_sym_POUND_QMARK_AT,
  [sym_auto_res_mark] = sym_auto_res_mark,
  [anon_sym_POUND_SQUOTE] = anon_sym_POUND_SQUOTE,
  [anon_sym_POUND_POUND] = anon_sym_POUND_POUND,
  [anon_sym_POUND_EQ] = anon_sym_POUND_EQ,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_TILDE_AT] = anon_sym_TILDE_AT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [sym_source] = sym_source,
  [sym__gap] = sym__gap,
  [sym_dis_expr] = sym_dis_expr,
  [sym__form] = sym__form,
  [sym_str_lit] = sym_str_lit,
  [sym_sym_lit] = sym_sym_lit,
  [sym__metadata_lit] = sym__metadata_lit,
  [sym_meta_lit] = sym_meta_lit,
  [sym_old_meta_lit] = sym_old_meta_lit,
  [sym_list_lit] = sym_list_lit,
  [sym__bare_list_lit] = sym__bare_list_lit,
  [sym_map_lit] = sym_map_lit,
  [sym__bare_map_lit] = sym__bare_map_lit,
  [sym_vec_lit] = sym_vec_lit,
  [sym__bare_vec_lit] = sym__bare_vec_lit,
  [sym_set_lit] = sym_set_lit,
  [sym__bare_set_lit] = sym__bare_set_lit,
  [sym_anon_fn_lit] = sym_anon_fn_lit,
  [sym_regex_lit] = sym_regex_lit,
  [sym_read_cond_lit] = sym_read_cond_lit,
  [sym_splicing_read_cond_lit] = sym_splicing_read_cond_lit,
  [sym_ns_map_lit] = sym_ns_map_lit,
  [sym_var_quoting_lit] = sym_var_quoting_lit,
  [sym_sym_val_lit] = sym_sym_val_lit,
  [sym_evaling_lit] = sym_evaling_lit,
  [sym_tagged_or_ctor_lit] = sym_tagged_or_ctor_lit,
  [sym_derefing_lit] = sym_derefing_lit,
  [sym_quoting_lit] = sym_quoting_lit,
  [sym_syn_quoting_lit] = sym_syn_quoting_lit,
  [sym_unquote_splicing_lit] = sym_unquote_splicing_lit,
  [sym_unquoting_lit] = sym_unquoting_lit,
  [aux_sym_source_repeat1] = aux_sym_source_repeat1,
  [aux_sym_dis_expr_repeat1] = aux_sym_dis_expr_repeat1,
  [aux_sym_sym_lit_repeat1] = aux_sym_sym_lit_repeat1,
  [aux_sym__bare_list_lit_repeat1] = aux_sym__bare_list_lit_repeat1,
  [aux_sym_read_cond_lit_repeat1] = aux_sym_read_cond_lit_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__ws] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND_] = {
    .visible = true,
    .named = false,
  },
  [sym_num_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_kwd_lit] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_str_lit_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_char_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_nil_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_bool_lit] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_sym_lit_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_QMARK_AT] = {
    .visible = true,
    .named = false,
  },
  [sym_auto_res_mark] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [sym_source] = {
    .visible = true,
    .named = true,
  },
  [sym__gap] = {
    .visible = false,
    .named = true,
  },
  [sym_dis_expr] = {
    .visible = true,
    .named = true,
  },
  [sym__form] = {
    .visible = false,
    .named = true,
  },
  [sym_str_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_sym_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__metadata_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_meta_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_old_meta_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_list_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_list_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_map_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_map_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_vec_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_vec_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_set_lit] = {
    .visible = true,
    .named = true,
  },
  [sym__bare_set_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_anon_fn_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_read_cond_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_splicing_read_cond_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_ns_map_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_var_quoting_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_sym_val_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_evaling_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_tagged_or_ctor_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_derefing_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_quoting_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_syn_quoting_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_unquote_splicing_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_unquoting_lit] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dis_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sym_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__bare_list_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_read_cond_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_close = 1,
  field_marker = 2,
  field_meta = 3,
  field_old_meta = 4,
  field_open = 5,
  field_prefix = 6,
  field_tag = 7,
  field_value = 8,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_close] = "close",
  [field_marker] = "marker",
  [field_meta] = "meta",
  [field_old_meta] = "old_meta",
  [field_open] = "open",
  [field_prefix] = "prefix",
  [field_tag] = "tag",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 3},
  [5] = {.index = 7, .length = 4},
  [6] = {.index = 11, .length = 2},
  [7] = {.index = 13, .length = 2},
  [8] = {.index = 15, .length = 1},
  [9] = {.index = 16, .length = 1},
  [10] = {.index = 17, .length = 4},
  [11] = {.index = 21, .length = 5},
  [12] = {.index = 26, .length = 6},
  [13] = {.index = 32, .length = 4},
  [14] = {.index = 36, .length = 2},
  [15] = {.index = 38, .length = 3},
  [16] = {.index = 41, .length = 2},
  [17] = {.index = 43, .length = 5},
  [18] = {.index = 48, .length = 3},
  [19] = {.index = 51, .length = 3},
  [20] = {.index = 54, .length = 4},
  [21] = {.index = 58, .length = 6},
  [22] = {.index = 64, .length = 4},
  [23] = {.index = 68, .length = 5},
  [24] = {.index = 73, .length = 4},
  [25] = {.index = 77, .length = 3},
  [26] = {.index = 80, .length = 3},
  [27] = {.index = 83, .length = 7},
  [28] = {.index = 90, .length = 5},
  [29] = {.index = 95, .length = 6},
  [30] = {.index = 101, .length = 4},
  [31] = {.index = 105, .length = 3},
  [32] = {.index = 108, .length = 7},
  [33] = {.index = 115, .length = 5},
  [34] = {.index = 120, .length = 5},
  [35] = {.index = 125, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
  [2] =
    {field_meta, 0},
  [3] =
    {field_old_meta, 0},
  [4] =
    {field_close, 0, .inherited = true},
    {field_open, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [7] =
    {field_close, 0, .inherited = true},
    {field_marker, 0, .inherited = true},
    {field_open, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [11] =
    {field_marker, 0},
    {field_value, 1},
  [13] =
    {field_close, 1},
    {field_open, 0},
  [15] =
    {field_value, 0},
  [16] =
    {field_marker, 0},
  [17] =
    {field_close, 1, .inherited = true},
    {field_marker, 0},
    {field_open, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [21] =
    {field_close, 1, .inherited = true},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [26] =
    {field_close, 1, .inherited = true},
    {field_marker, 1, .inherited = true},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [32] =
    {field_meta, 0, .inherited = true},
    {field_meta, 1, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_old_meta, 1, .inherited = true},
  [36] =
    {field_marker, 0},
    {field_value, 2},
  [38] =
    {field_close, 2},
    {field_open, 0},
    {field_value, 1, .inherited = true},
  [41] =
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [43] =
    {field_close, 2, .inherited = true},
    {field_marker, 0},
    {field_open, 2, .inherited = true},
    {field_prefix, 1},
    {field_value, 2, .inherited = true},
  [48] =
    {field_close, 2},
    {field_marker, 0},
    {field_open, 1},
  [51] =
    {field_marker, 0},
    {field_tag, 1},
    {field_value, 2},
  [54] =
    {field_close, 2, .inherited = true},
    {field_marker, 0},
    {field_open, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [58] =
    {field_close, 2, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [64] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_value, 2},
  [68] =
    {field_close, 3, .inherited = true},
    {field_marker, 0},
    {field_open, 3, .inherited = true},
    {field_prefix, 1},
    {field_value, 3, .inherited = true},
  [73] =
    {field_close, 3},
    {field_marker, 0},
    {field_open, 1},
    {field_value, 2, .inherited = true},
  [77] =
    {field_marker, 0},
    {field_tag, 1},
    {field_value, 3},
  [80] =
    {field_marker, 0},
    {field_tag, 2},
    {field_value, 3},
  [83] =
    {field_close, 3, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_prefix, 2},
    {field_value, 3, .inherited = true},
  [90] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_tag, 2},
    {field_value, 3},
  [95] =
    {field_close, 3, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [101] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_value, 3},
  [105] =
    {field_marker, 0},
    {field_tag, 2},
    {field_value, 4},
  [108] =
    {field_close, 4, .inherited = true},
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_open, 4, .inherited = true},
    {field_prefix, 2},
    {field_value, 4, .inherited = true},
  [115] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_tag, 2},
    {field_value, 4},
  [120] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_tag, 3},
    {field_value, 4},
  [125] =
    {field_marker, 1},
    {field_meta, 0, .inherited = true},
    {field_old_meta, 0, .inherited = true},
    {field_tag, 3},
    {field_value, 5},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static inline bool sym__ws_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ','
      ? (c < 28
        ? (c >= '\t' && c <= '\r')
        : c <= ' ')
      : (c <= ',' || c == 5760))
    : (c <= 8198 || (c < 8287
      ? (c < 8232
        ? (c >= 8200 && c <= 8202)
        : c <= 8233)
      : (c <= 8287 || c == 12288))));
}

static inline bool sym_kwd_lit_character_set_1(int32_t c) {
  return (c < '`'
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < '@'
        ? (c < ';'
          ? c == ','
          : c <= ';')
        : (c <= '@' || (c >= '[' && c <= '^')))))
    : (c <= '`' || (c < 8200
      ? (c < 5760
        ? (c < '}'
          ? c == '{'
          : c <= '~')
        : (c <= 5760 || (c >= 8192 && c <= 8198)))
      : (c <= 8202 || (c < 8287
        ? (c >= 8232 && c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static inline bool aux_sym_sym_lit_token1_character_set_3(int32_t c) {
  return (c < '['
    ? (c < '('
      ? (c < 28
        ? (c < '\t'
          ? c == 0
          : c <= '\r')
        : (c <= ' ' || c == '"'))
      : (c <= ')' || (c < ';'
        ? (c < '0'
          ? c == ','
          : c <= '9')
        : (c <= ';' || c == '@'))))
    : (c <= '^' || (c < 8192
      ? (c < '}'
        ? (c < '{'
          ? c == '`'
          : c <= '{')
        : (c <= '~' || c == 5760))
      : (c <= 8198 || (c < 8287
        ? (c < 8232
          ? (c >= 8200 && c <= 8202)
          : c <= 8233)
        : (c <= 8287 || c == 12288))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(37);
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(94);
      if (lookahead == '\'') ADVANCE(104);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '0') ADVANCE(43);
      if (lookahead == ':') ADVANCE(4);
      if (lookahead == ';') ADVANCE(40);
      if (lookahead == '@') ADVANCE(103);
      if (lookahead == '[') ADVANCE(92);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == ']') ADVANCE(93);
      if (lookahead == '^') ADVANCE(86);
      if (lookahead == '`') ADVANCE(105);
      if (lookahead == 'f') ADVANCE(72);
      if (lookahead == 'n') ADVANCE(74);
      if (lookahead == 't') ADVANCE(77);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '}') ADVANCE(91);
      if (lookahead == '~') ADVANCE(107);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(71);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(45);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(38);
      if (lookahead != 0) ADVANCE(85);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(2);
      if (lookahead == '#') ADVANCE(95);
      if (lookahead == '\'') ADVANCE(104);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ':') ADVANCE(4);
      if (lookahead == ';') ADVANCE(40);
      if (lookahead == '@') ADVANCE(103);
      if (lookahead == '[') ADVANCE(92);
      if (lookahead == '^') ADVANCE(86);
      if (lookahead == '`') ADVANCE(105);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '~') ADVANCE(107);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(38);
      if (lookahead != 0 &&
          lookahead != ')' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '\\' &&
          lookahead != ']' &&
          lookahead != '}') ADVANCE(85);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(57);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead != 0) ADVANCE(2);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(96);
      if (lookahead == '\'') ADVANCE(104);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == '@') ADVANCE(103);
      if (lookahead == '[') ADVANCE(92);
      if (lookahead == '^') ADVANCE(86);
      if (lookahead == '`') ADVANCE(105);
      if (lookahead == '{') ADVANCE(90);
      if (lookahead == '~') ADVANCE(107);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != ')' &&
          lookahead != ',' &&
          (lookahead < '0' || ';' < lookahead) &&
          lookahead != '\\' &&
          lookahead != ']' &&
          lookahead != '}' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(85);
      END_STATE();
    case 4:
      if (lookahead == '/') ADVANCE(55);
      if (lookahead == ':') ADVANCE(99);
      if (!sym_kwd_lit_character_set_1(lookahead)) ADVANCE(56);
      END_STATE();
    case 5:
      if (lookahead == 'a') ADVANCE(8);
      END_STATE();
    case 6:
      if (lookahead == 'b') ADVANCE(58);
      END_STATE();
    case 7:
      if (lookahead == 'c') ADVANCE(15);
      END_STATE();
    case 8:
      if (lookahead == 'c') ADVANCE(10);
      END_STATE();
    case 9:
      if (lookahead == 'd') ADVANCE(58);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(58);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(9);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(11);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(12);
      END_STATE();
    case 14:
      if (lookahead == 'i') ADVANCE(19);
      END_STATE();
    case 15:
      if (lookahead == 'k') ADVANCE(23);
      END_STATE();
    case 16:
      if (lookahead == 'l') ADVANCE(14);
      END_STATE();
    case 17:
      if (lookahead == 'm') ADVANCE(13);
      END_STATE();
    case 18:
      if (lookahead == 'n') ADVANCE(58);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(10);
      END_STATE();
    case 20:
      if (lookahead == 'p') ADVANCE(5);
      END_STATE();
    case 21:
      if (lookahead == 'r') ADVANCE(17);
      END_STATE();
    case 22:
      if (lookahead == 'r') ADVANCE(18);
      END_STATE();
    case 23:
      if (lookahead == 's') ADVANCE(20);
      END_STATE();
    case 24:
      if (lookahead == 't') ADVANCE(25);
      END_STATE();
    case 25:
      if (lookahead == 'u') ADVANCE(22);
      END_STATE();
    case 26:
      if (lookahead == 'w') ADVANCE(16);
      END_STATE();
    case 27:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(29);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      END_STATE();
    case 28:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(53);
      END_STATE();
    case 29:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      END_STATE();
    case 30:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(58);
      END_STATE();
    case 31:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 32:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(30);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(32);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 35:
      if (lookahead != 0 &&
          lookahead != 'b' &&
          lookahead != 'f' &&
          lookahead != 'n' &&
          lookahead != 'o' &&
          (lookahead < 'r' || 'u' < lookahead)) ADVANCE(58);
      if (lookahead == 'b') ADVANCE(59);
      if (lookahead == 'f') ADVANCE(63);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead == 'o') ADVANCE(67);
      if (lookahead == 'r') ADVANCE(62);
      if (lookahead == 's') ADVANCE(64);
      if (lookahead == 't') ADVANCE(60);
      if (lookahead == 'u') ADVANCE(68);
      END_STATE();
    case 36:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(2);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(sym__ws);
      if (sym__ws_character_set_1(lookahead)) ADVANCE(38);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(39);
      if (lookahead != 0) ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_POUND_);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_num_lit);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(49);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(34);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(31);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(44);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(49);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(34);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(44);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(49);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(45);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(50);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(80);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(81);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(82);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(47);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(50);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(80);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(81);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(47);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == '.') ADVANCE(50);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead == 'M' ||
          lookahead == 'N') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(80);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'M') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(49);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'M') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'M') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_num_lit);
      if (lookahead == 'N') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_num_lit);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(53);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_num_lit);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_kwd_lit);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_kwd_lit);
      if (!sym_kwd_lit_character_set_1(lookahead)) ADVANCE(56);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym_str_lit_token1);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_char_lit);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'a') ADVANCE(7);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'a') ADVANCE(6);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'e') ADVANCE(26);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_char_lit);
      if (lookahead == 'p') ADVANCE(5);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_char_lit);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_char_lit);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_char_lit);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_char_lit);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_nil_lit);
      if (!sym_kwd_lit_character_set_1(lookahead)) ADVANCE(85);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_bool_lit);
      if (!sym_kwd_lit_character_set_1(lookahead)) ADVANCE(85);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == '0') ADVANCE(46);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          (lookahead < '1' || '9' < lookahead) &&
          lookahead != ';' &&
          lookahead != '@' &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(85);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(48);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'a') ADVANCE(75);
      if (!sym_kwd_lit_character_set_1(lookahead)) ADVANCE(85);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'e') ADVANCE(70);
      if (!sym_kwd_lit_character_set_1(lookahead)) ADVANCE(85);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'i') ADVANCE(76);
      if (!sym_kwd_lit_character_set_1(lookahead)) ADVANCE(85);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(78);
      if (!sym_kwd_lit_character_set_1(lookahead)) ADVANCE(85);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'l') ADVANCE(69);
      if (!sym_kwd_lit_character_set_1(lookahead)) ADVANCE(85);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'r') ADVANCE(79);
      if (!sym_kwd_lit_character_set_1(lookahead)) ADVANCE(85);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 's') ADVANCE(73);
      if (!sym_kwd_lit_character_set_1(lookahead)) ADVANCE(85);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == 'u') ADVANCE(73);
      if (!sym_kwd_lit_character_set_1(lookahead)) ADVANCE(85);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(84);
      if (!aux_sym_sym_lit_token1_character_set_3(lookahead)) ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != ';' &&
          (lookahead < '@' || '^' < lookahead) &&
          (lookahead < '`' || '{' < lookahead) &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != ';' &&
          (lookahead < '@' || 'F' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '`' || 'f' < lookahead) &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (!aux_sym_sym_lit_token1_character_set_3(lookahead)) ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(53);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (!aux_sym_sym_lit_token1_character_set_3(lookahead)) ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(51);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym_sym_lit_token1);
      if (!sym_kwd_lit_character_set_1(lookahead)) ADVANCE(85);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_POUND_CARET);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(40);
      if (lookahead == '#') ADVANCE(101);
      if (lookahead == '\'') ADVANCE(100);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '?') ADVANCE(97);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == '_') ADVANCE(41);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '!') ADVANCE(40);
      if (lookahead == '\'') ADVANCE(100);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '?') ADVANCE(97);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == '_') ADVANCE(41);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '\'') ADVANCE(100);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '?') ADVANCE(97);
      if (lookahead == '^') ADVANCE(87);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK);
      if (lookahead == '@') ADVANCE(98);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_POUND_QMARK_AT);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_auto_res_mark);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          (lookahead < 28 || ' ' < lookahead) &&
          lookahead != '"' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != ',' &&
          lookahead != '/' &&
          lookahead != ':' &&
          lookahead != ';' &&
          lookahead != '@' &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          lookahead != '{' &&
          lookahead != '}' &&
          lookahead != '~' &&
          lookahead != 5760 &&
          (lookahead < 8192 || 8198 < lookahead) &&
          (lookahead < 8200 || 8202 < lookahead) &&
          lookahead != 8232 &&
          lookahead != 8233 &&
          lookahead != 8287 &&
          lookahead != 12288) ADVANCE(56);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_POUND_SQUOTE);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_POUND_POUND);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_POUND_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_TILDE_AT);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '@') ADVANCE(106);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 0},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 0},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 0},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 0},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 0},
  [56] = {.lex_state = 0},
  [57] = {.lex_state = 0},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 0},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 0},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 0},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 0},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 0},
  [72] = {.lex_state = 0},
  [73] = {.lex_state = 0},
  [74] = {.lex_state = 0},
  [75] = {.lex_state = 0},
  [76] = {.lex_state = 0},
  [77] = {.lex_state = 0},
  [78] = {.lex_state = 0},
  [79] = {.lex_state = 0},
  [80] = {.lex_state = 0},
  [81] = {.lex_state = 0},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 0},
  [85] = {.lex_state = 0},
  [86] = {.lex_state = 0},
  [87] = {.lex_state = 0},
  [88] = {.lex_state = 0},
  [89] = {.lex_state = 0},
  [90] = {.lex_state = 0},
  [91] = {.lex_state = 0},
  [92] = {.lex_state = 0},
  [93] = {.lex_state = 0},
  [94] = {.lex_state = 0},
  [95] = {.lex_state = 0},
  [96] = {.lex_state = 0},
  [97] = {.lex_state = 0},
  [98] = {.lex_state = 0},
  [99] = {.lex_state = 0},
  [100] = {.lex_state = 0},
  [101] = {.lex_state = 0},
  [102] = {.lex_state = 0},
  [103] = {.lex_state = 0},
  [104] = {.lex_state = 0},
  [105] = {.lex_state = 0},
  [106] = {.lex_state = 0},
  [107] = {.lex_state = 0},
  [108] = {.lex_state = 0},
  [109] = {.lex_state = 0},
  [110] = {.lex_state = 0},
  [111] = {.lex_state = 0},
  [112] = {.lex_state = 0},
  [113] = {.lex_state = 0},
  [114] = {.lex_state = 0},
  [115] = {.lex_state = 0},
  [116] = {.lex_state = 0},
  [117] = {.lex_state = 0},
  [118] = {.lex_state = 0},
  [119] = {.lex_state = 0},
  [120] = {.lex_state = 0},
  [121] = {.lex_state = 0},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 0},
  [124] = {.lex_state = 0},
  [125] = {.lex_state = 0},
  [126] = {.lex_state = 0},
  [127] = {.lex_state = 0},
  [128] = {.lex_state = 0},
  [129] = {.lex_state = 0},
  [130] = {.lex_state = 0},
  [131] = {.lex_state = 0},
  [132] = {.lex_state = 0},
  [133] = {.lex_state = 0},
  [134] = {.lex_state = 0},
  [135] = {.lex_state = 0},
  [136] = {.lex_state = 0},
  [137] = {.lex_state = 0},
  [138] = {.lex_state = 0},
  [139] = {.lex_state = 0},
  [140] = {.lex_state = 0},
  [141] = {.lex_state = 0},
  [142] = {.lex_state = 0},
  [143] = {.lex_state = 0},
  [144] = {.lex_state = 0},
  [145] = {.lex_state = 0},
  [146] = {.lex_state = 0},
  [147] = {.lex_state = 0},
  [148] = {.lex_state = 0},
  [149] = {.lex_state = 0},
  [150] = {.lex_state = 0},
  [151] = {.lex_state = 0},
  [152] = {.lex_state = 0},
  [153] = {.lex_state = 0},
  [154] = {.lex_state = 0},
  [155] = {.lex_state = 0},
  [156] = {.lex_state = 0},
  [157] = {.lex_state = 0},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 0},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 0},
  [169] = {.lex_state = 0},
  [170] = {.lex_state = 0},
  [171] = {.lex_state = 3},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 3},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 1},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 1},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 1},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 1},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 1},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 1},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 1},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 3},
  [263] = {.lex_state = 1},
  [264] = {.lex_state = 1},
  [265] = {.lex_state = 1},
  [266] = {.lex_state = 1},
  [267] = {.lex_state = 1},
  [268] = {.lex_state = 1},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 1},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 3},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 1},
  [283] = {.lex_state = 1},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 3},
  [289] = {.lex_state = 3},
  [290] = {.lex_state = 3},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 0},
  [294] = {.lex_state = 0},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 3},
  [304] = {.lex_state = 3},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__ws] = ACTIONS(1),
    [sym_comment] = ACTIONS(1),
    [anon_sym_POUND_] = ACTIONS(1),
    [sym_num_lit] = ACTIONS(1),
    [sym_kwd_lit] = ACTIONS(1),
    [aux_sym_str_lit_token1] = ACTIONS(1),
    [sym_char_lit] = ACTIONS(1),
    [sym_nil_lit] = ACTIONS(1),
    [sym_bool_lit] = ACTIONS(1),
    [aux_sym_sym_lit_token1] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_POUND_CARET] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_POUND_QMARK] = ACTIONS(1),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(1),
    [sym_auto_res_mark] = ACTIONS(1),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1),
    [anon_sym_POUND_POUND] = ACTIONS(1),
    [anon_sym_POUND_EQ] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_TILDE_AT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
  },
  [1] = {
    [sym_source] = STATE(322),
    [sym__gap] = STATE(10),
    [sym_dis_expr] = STATE(10),
    [sym__form] = STATE(10),
    [sym_str_lit] = STATE(10),
    [sym_sym_lit] = STATE(10),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(10),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(10),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(10),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(10),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(10),
    [sym_regex_lit] = STATE(10),
    [sym_read_cond_lit] = STATE(10),
    [sym_splicing_read_cond_lit] = STATE(10),
    [sym_ns_map_lit] = STATE(10),
    [sym_var_quoting_lit] = STATE(10),
    [sym_sym_val_lit] = STATE(10),
    [sym_evaling_lit] = STATE(10),
    [sym_tagged_or_ctor_lit] = STATE(10),
    [sym_derefing_lit] = STATE(10),
    [sym_quoting_lit] = STATE(10),
    [sym_syn_quoting_lit] = STATE(10),
    [sym_unquote_splicing_lit] = STATE(10),
    [sym_unquoting_lit] = STATE(10),
    [aux_sym_source_repeat1] = STATE(10),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [ts_builtin_sym_end] = ACTIONS(3),
    [sym__ws] = ACTIONS(5),
    [sym_comment] = ACTIONS(5),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(5),
    [sym_kwd_lit] = ACTIONS(5),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(5),
    [sym_nil_lit] = ACTIONS(11),
    [sym_bool_lit] = ACTIONS(11),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [2] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(47),
    [sym_comment] = ACTIONS(47),
    [anon_sym_POUND_] = ACTIONS(50),
    [sym_num_lit] = ACTIONS(53),
    [sym_kwd_lit] = ACTIONS(53),
    [aux_sym_str_lit_token1] = ACTIONS(56),
    [sym_char_lit] = ACTIONS(53),
    [sym_nil_lit] = ACTIONS(59),
    [sym_bool_lit] = ACTIONS(59),
    [aux_sym_sym_lit_token1] = ACTIONS(62),
    [anon_sym_CARET] = ACTIONS(65),
    [anon_sym_POUND_CARET] = ACTIONS(68),
    [anon_sym_LPAREN] = ACTIONS(71),
    [anon_sym_RPAREN] = ACTIONS(74),
    [anon_sym_LBRACE] = ACTIONS(76),
    [anon_sym_RBRACE] = ACTIONS(74),
    [anon_sym_LBRACK] = ACTIONS(79),
    [anon_sym_RBRACK] = ACTIONS(74),
    [anon_sym_POUND] = ACTIONS(82),
    [anon_sym_POUND_QMARK] = ACTIONS(85),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(88),
    [anon_sym_POUND_SQUOTE] = ACTIONS(91),
    [anon_sym_POUND_POUND] = ACTIONS(94),
    [anon_sym_POUND_EQ] = ACTIONS(97),
    [anon_sym_AT] = ACTIONS(100),
    [anon_sym_SQUOTE] = ACTIONS(103),
    [anon_sym_BQUOTE] = ACTIONS(106),
    [anon_sym_TILDE_AT] = ACTIONS(109),
    [anon_sym_TILDE] = ACTIONS(112),
  },
  [3] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(115),
    [sym_comment] = ACTIONS(115),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(121),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [4] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(115),
    [sym_comment] = ACTIONS(115),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(123),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [5] = {
    [sym__gap] = STATE(5),
    [sym_dis_expr] = STATE(5),
    [sym__form] = STATE(5),
    [sym_str_lit] = STATE(5),
    [sym_sym_lit] = STATE(5),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(5),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(5),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(5),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(5),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(5),
    [sym_regex_lit] = STATE(5),
    [sym_read_cond_lit] = STATE(5),
    [sym_splicing_read_cond_lit] = STATE(5),
    [sym_ns_map_lit] = STATE(5),
    [sym_var_quoting_lit] = STATE(5),
    [sym_sym_val_lit] = STATE(5),
    [sym_evaling_lit] = STATE(5),
    [sym_tagged_or_ctor_lit] = STATE(5),
    [sym_derefing_lit] = STATE(5),
    [sym_quoting_lit] = STATE(5),
    [sym_syn_quoting_lit] = STATE(5),
    [sym_unquote_splicing_lit] = STATE(5),
    [sym_unquoting_lit] = STATE(5),
    [aux_sym_source_repeat1] = STATE(5),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [ts_builtin_sym_end] = ACTIONS(125),
    [sym__ws] = ACTIONS(127),
    [sym_comment] = ACTIONS(127),
    [anon_sym_POUND_] = ACTIONS(130),
    [sym_num_lit] = ACTIONS(127),
    [sym_kwd_lit] = ACTIONS(127),
    [aux_sym_str_lit_token1] = ACTIONS(133),
    [sym_char_lit] = ACTIONS(127),
    [sym_nil_lit] = ACTIONS(136),
    [sym_bool_lit] = ACTIONS(136),
    [aux_sym_sym_lit_token1] = ACTIONS(139),
    [anon_sym_CARET] = ACTIONS(142),
    [anon_sym_POUND_CARET] = ACTIONS(145),
    [anon_sym_LPAREN] = ACTIONS(148),
    [anon_sym_LBRACE] = ACTIONS(151),
    [anon_sym_LBRACK] = ACTIONS(154),
    [anon_sym_POUND] = ACTIONS(157),
    [anon_sym_POUND_QMARK] = ACTIONS(160),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(163),
    [anon_sym_POUND_SQUOTE] = ACTIONS(166),
    [anon_sym_POUND_POUND] = ACTIONS(169),
    [anon_sym_POUND_EQ] = ACTIONS(172),
    [anon_sym_AT] = ACTIONS(175),
    [anon_sym_SQUOTE] = ACTIONS(178),
    [anon_sym_BQUOTE] = ACTIONS(181),
    [anon_sym_TILDE_AT] = ACTIONS(184),
    [anon_sym_TILDE] = ACTIONS(187),
  },
  [6] = {
    [sym__gap] = STATE(12),
    [sym_dis_expr] = STATE(12),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(12),
    [sym__ws] = ACTIONS(190),
    [sym_comment] = ACTIONS(190),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(192),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [7] = {
    [sym__gap] = STATE(13),
    [sym_dis_expr] = STATE(13),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(13),
    [sym__ws] = ACTIONS(194),
    [sym_comment] = ACTIONS(194),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_RPAREN] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [8] = {
    [sym__gap] = STATE(17),
    [sym_dis_expr] = STATE(17),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(17),
    [sym__ws] = ACTIONS(198),
    [sym_comment] = ACTIONS(198),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(200),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [9] = {
    [sym__gap] = STATE(16),
    [sym_dis_expr] = STATE(16),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(16),
    [sym__ws] = ACTIONS(202),
    [sym_comment] = ACTIONS(202),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(204),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [10] = {
    [sym__gap] = STATE(5),
    [sym_dis_expr] = STATE(5),
    [sym__form] = STATE(5),
    [sym_str_lit] = STATE(5),
    [sym_sym_lit] = STATE(5),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(5),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(5),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(5),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(5),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(5),
    [sym_regex_lit] = STATE(5),
    [sym_read_cond_lit] = STATE(5),
    [sym_splicing_read_cond_lit] = STATE(5),
    [sym_ns_map_lit] = STATE(5),
    [sym_var_quoting_lit] = STATE(5),
    [sym_sym_val_lit] = STATE(5),
    [sym_evaling_lit] = STATE(5),
    [sym_tagged_or_ctor_lit] = STATE(5),
    [sym_derefing_lit] = STATE(5),
    [sym_quoting_lit] = STATE(5),
    [sym_syn_quoting_lit] = STATE(5),
    [sym_unquote_splicing_lit] = STATE(5),
    [sym_unquoting_lit] = STATE(5),
    [aux_sym_source_repeat1] = STATE(5),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [ts_builtin_sym_end] = ACTIONS(206),
    [sym__ws] = ACTIONS(208),
    [sym_comment] = ACTIONS(208),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(208),
    [sym_kwd_lit] = ACTIONS(208),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(208),
    [sym_nil_lit] = ACTIONS(210),
    [sym_bool_lit] = ACTIONS(210),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [11] = {
    [sym__gap] = STATE(3),
    [sym_dis_expr] = STATE(3),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(3),
    [sym__ws] = ACTIONS(212),
    [sym_comment] = ACTIONS(212),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(214),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [12] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(115),
    [sym_comment] = ACTIONS(115),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(216),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [13] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(115),
    [sym_comment] = ACTIONS(115),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_RPAREN] = ACTIONS(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [14] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(115),
    [sym_comment] = ACTIONS(115),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(220),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [15] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(115),
    [sym_comment] = ACTIONS(115),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_RPAREN] = ACTIONS(222),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [16] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(115),
    [sym_comment] = ACTIONS(115),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_RBRACK] = ACTIONS(224),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [17] = {
    [sym__gap] = STATE(2),
    [sym_dis_expr] = STATE(2),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(2),
    [sym__ws] = ACTIONS(115),
    [sym_comment] = ACTIONS(115),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(226),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [18] = {
    [sym__gap] = STATE(14),
    [sym_dis_expr] = STATE(14),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(14),
    [sym__ws] = ACTIONS(228),
    [sym_comment] = ACTIONS(228),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(230),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [19] = {
    [sym__gap] = STATE(4),
    [sym_dis_expr] = STATE(4),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(4),
    [sym__ws] = ACTIONS(232),
    [sym_comment] = ACTIONS(232),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(234),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [20] = {
    [sym__gap] = STATE(15),
    [sym_dis_expr] = STATE(15),
    [sym__form] = STATE(169),
    [sym_str_lit] = STATE(169),
    [sym_sym_lit] = STATE(169),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(169),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(169),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(169),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(169),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(169),
    [sym_regex_lit] = STATE(169),
    [sym_read_cond_lit] = STATE(169),
    [sym_splicing_read_cond_lit] = STATE(169),
    [sym_ns_map_lit] = STATE(169),
    [sym_var_quoting_lit] = STATE(169),
    [sym_sym_val_lit] = STATE(169),
    [sym_evaling_lit] = STATE(169),
    [sym_tagged_or_ctor_lit] = STATE(169),
    [sym_derefing_lit] = STATE(169),
    [sym_quoting_lit] = STATE(169),
    [sym_syn_quoting_lit] = STATE(169),
    [sym_unquote_splicing_lit] = STATE(169),
    [sym_unquoting_lit] = STATE(169),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [aux_sym__bare_list_lit_repeat1] = STATE(15),
    [sym__ws] = ACTIONS(236),
    [sym_comment] = ACTIONS(236),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(117),
    [sym_kwd_lit] = ACTIONS(117),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(117),
    [sym_nil_lit] = ACTIONS(119),
    [sym_bool_lit] = ACTIONS(119),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_RPAREN] = ACTIONS(238),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [21] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(162),
    [sym_str_lit] = STATE(162),
    [sym_sym_lit] = STATE(162),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(162),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(162),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(162),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(162),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(162),
    [sym_regex_lit] = STATE(162),
    [sym_read_cond_lit] = STATE(162),
    [sym_splicing_read_cond_lit] = STATE(162),
    [sym_ns_map_lit] = STATE(162),
    [sym_var_quoting_lit] = STATE(162),
    [sym_sym_val_lit] = STATE(162),
    [sym_evaling_lit] = STATE(162),
    [sym_tagged_or_ctor_lit] = STATE(162),
    [sym_derefing_lit] = STATE(162),
    [sym_quoting_lit] = STATE(162),
    [sym_syn_quoting_lit] = STATE(162),
    [sym_unquote_splicing_lit] = STATE(162),
    [sym_unquoting_lit] = STATE(162),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(242),
    [sym_kwd_lit] = ACTIONS(242),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(242),
    [sym_nil_lit] = ACTIONS(244),
    [sym_bool_lit] = ACTIONS(244),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [22] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(115),
    [sym_str_lit] = STATE(115),
    [sym_sym_lit] = STATE(115),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(115),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(115),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(115),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(115),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(115),
    [sym_regex_lit] = STATE(115),
    [sym_read_cond_lit] = STATE(115),
    [sym_splicing_read_cond_lit] = STATE(115),
    [sym_ns_map_lit] = STATE(115),
    [sym_var_quoting_lit] = STATE(115),
    [sym_sym_val_lit] = STATE(115),
    [sym_evaling_lit] = STATE(115),
    [sym_tagged_or_ctor_lit] = STATE(115),
    [sym_derefing_lit] = STATE(115),
    [sym_quoting_lit] = STATE(115),
    [sym_syn_quoting_lit] = STATE(115),
    [sym_unquote_splicing_lit] = STATE(115),
    [sym_unquoting_lit] = STATE(115),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(246),
    [sym_kwd_lit] = ACTIONS(246),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(246),
    [sym_nil_lit] = ACTIONS(248),
    [sym_bool_lit] = ACTIONS(248),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [23] = {
    [sym__gap] = STATE(57),
    [sym_dis_expr] = STATE(57),
    [sym__form] = STATE(107),
    [sym_str_lit] = STATE(107),
    [sym_sym_lit] = STATE(107),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(107),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(107),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(107),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(107),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(107),
    [sym_regex_lit] = STATE(107),
    [sym_read_cond_lit] = STATE(107),
    [sym_splicing_read_cond_lit] = STATE(107),
    [sym_ns_map_lit] = STATE(107),
    [sym_var_quoting_lit] = STATE(107),
    [sym_sym_val_lit] = STATE(107),
    [sym_evaling_lit] = STATE(107),
    [sym_tagged_or_ctor_lit] = STATE(107),
    [sym_derefing_lit] = STATE(107),
    [sym_quoting_lit] = STATE(107),
    [sym_syn_quoting_lit] = STATE(107),
    [sym_unquote_splicing_lit] = STATE(107),
    [sym_unquoting_lit] = STATE(107),
    [aux_sym_dis_expr_repeat1] = STATE(57),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(250),
    [sym_comment] = ACTIONS(250),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(252),
    [sym_kwd_lit] = ACTIONS(252),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(252),
    [sym_nil_lit] = ACTIONS(254),
    [sym_bool_lit] = ACTIONS(254),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [24] = {
    [sym__gap] = STATE(64),
    [sym_dis_expr] = STATE(64),
    [sym__form] = STATE(126),
    [sym_str_lit] = STATE(126),
    [sym_sym_lit] = STATE(126),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(126),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(126),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(126),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(126),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(126),
    [sym_regex_lit] = STATE(126),
    [sym_read_cond_lit] = STATE(126),
    [sym_splicing_read_cond_lit] = STATE(126),
    [sym_ns_map_lit] = STATE(126),
    [sym_var_quoting_lit] = STATE(126),
    [sym_sym_val_lit] = STATE(126),
    [sym_evaling_lit] = STATE(126),
    [sym_tagged_or_ctor_lit] = STATE(126),
    [sym_derefing_lit] = STATE(126),
    [sym_quoting_lit] = STATE(126),
    [sym_syn_quoting_lit] = STATE(126),
    [sym_unquote_splicing_lit] = STATE(126),
    [sym_unquoting_lit] = STATE(126),
    [aux_sym_dis_expr_repeat1] = STATE(64),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(256),
    [sym_comment] = ACTIONS(256),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(258),
    [sym_kwd_lit] = ACTIONS(258),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(258),
    [sym_nil_lit] = ACTIONS(260),
    [sym_bool_lit] = ACTIONS(260),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [25] = {
    [sym__gap] = STATE(66),
    [sym_dis_expr] = STATE(66),
    [sym__form] = STATE(124),
    [sym_str_lit] = STATE(124),
    [sym_sym_lit] = STATE(124),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(124),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(124),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(124),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(124),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(124),
    [sym_regex_lit] = STATE(124),
    [sym_read_cond_lit] = STATE(124),
    [sym_splicing_read_cond_lit] = STATE(124),
    [sym_ns_map_lit] = STATE(124),
    [sym_var_quoting_lit] = STATE(124),
    [sym_sym_val_lit] = STATE(124),
    [sym_evaling_lit] = STATE(124),
    [sym_tagged_or_ctor_lit] = STATE(124),
    [sym_derefing_lit] = STATE(124),
    [sym_quoting_lit] = STATE(124),
    [sym_syn_quoting_lit] = STATE(124),
    [sym_unquote_splicing_lit] = STATE(124),
    [sym_unquoting_lit] = STATE(124),
    [aux_sym_dis_expr_repeat1] = STATE(66),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(262),
    [sym_comment] = ACTIONS(262),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(264),
    [sym_kwd_lit] = ACTIONS(264),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(264),
    [sym_nil_lit] = ACTIONS(266),
    [sym_bool_lit] = ACTIONS(266),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [26] = {
    [sym__gap] = STATE(22),
    [sym_dis_expr] = STATE(22),
    [sym__form] = STATE(122),
    [sym_str_lit] = STATE(122),
    [sym_sym_lit] = STATE(122),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(122),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(122),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(122),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(122),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(122),
    [sym_regex_lit] = STATE(122),
    [sym_read_cond_lit] = STATE(122),
    [sym_splicing_read_cond_lit] = STATE(122),
    [sym_ns_map_lit] = STATE(122),
    [sym_var_quoting_lit] = STATE(122),
    [sym_sym_val_lit] = STATE(122),
    [sym_evaling_lit] = STATE(122),
    [sym_tagged_or_ctor_lit] = STATE(122),
    [sym_derefing_lit] = STATE(122),
    [sym_quoting_lit] = STATE(122),
    [sym_syn_quoting_lit] = STATE(122),
    [sym_unquote_splicing_lit] = STATE(122),
    [sym_unquoting_lit] = STATE(122),
    [aux_sym_dis_expr_repeat1] = STATE(22),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(268),
    [sym_comment] = ACTIONS(268),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(270),
    [sym_kwd_lit] = ACTIONS(270),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(270),
    [sym_nil_lit] = ACTIONS(272),
    [sym_bool_lit] = ACTIONS(272),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [27] = {
    [sym__gap] = STATE(70),
    [sym_dis_expr] = STATE(70),
    [sym__form] = STATE(99),
    [sym_str_lit] = STATE(99),
    [sym_sym_lit] = STATE(99),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(99),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(99),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(99),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(99),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(99),
    [sym_regex_lit] = STATE(99),
    [sym_read_cond_lit] = STATE(99),
    [sym_splicing_read_cond_lit] = STATE(99),
    [sym_ns_map_lit] = STATE(99),
    [sym_var_quoting_lit] = STATE(99),
    [sym_sym_val_lit] = STATE(99),
    [sym_evaling_lit] = STATE(99),
    [sym_tagged_or_ctor_lit] = STATE(99),
    [sym_derefing_lit] = STATE(99),
    [sym_quoting_lit] = STATE(99),
    [sym_syn_quoting_lit] = STATE(99),
    [sym_unquote_splicing_lit] = STATE(99),
    [sym_unquoting_lit] = STATE(99),
    [aux_sym_dis_expr_repeat1] = STATE(70),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(274),
    [sym_comment] = ACTIONS(274),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(276),
    [sym_kwd_lit] = ACTIONS(276),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(276),
    [sym_nil_lit] = ACTIONS(278),
    [sym_bool_lit] = ACTIONS(278),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [28] = {
    [sym__gap] = STATE(72),
    [sym_dis_expr] = STATE(72),
    [sym__form] = STATE(118),
    [sym_str_lit] = STATE(118),
    [sym_sym_lit] = STATE(118),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(118),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(118),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(118),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(118),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(118),
    [sym_regex_lit] = STATE(118),
    [sym_read_cond_lit] = STATE(118),
    [sym_splicing_read_cond_lit] = STATE(118),
    [sym_ns_map_lit] = STATE(118),
    [sym_var_quoting_lit] = STATE(118),
    [sym_sym_val_lit] = STATE(118),
    [sym_evaling_lit] = STATE(118),
    [sym_tagged_or_ctor_lit] = STATE(118),
    [sym_derefing_lit] = STATE(118),
    [sym_quoting_lit] = STATE(118),
    [sym_syn_quoting_lit] = STATE(118),
    [sym_unquote_splicing_lit] = STATE(118),
    [sym_unquoting_lit] = STATE(118),
    [aux_sym_dis_expr_repeat1] = STATE(72),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(280),
    [sym_comment] = ACTIONS(280),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(282),
    [sym_kwd_lit] = ACTIONS(282),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(282),
    [sym_nil_lit] = ACTIONS(284),
    [sym_bool_lit] = ACTIONS(284),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [29] = {
    [sym__gap] = STATE(58),
    [sym_dis_expr] = STATE(58),
    [sym__form] = STATE(209),
    [sym_str_lit] = STATE(209),
    [sym_sym_lit] = STATE(209),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(209),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(209),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(209),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(209),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(209),
    [sym_regex_lit] = STATE(209),
    [sym_read_cond_lit] = STATE(209),
    [sym_splicing_read_cond_lit] = STATE(209),
    [sym_ns_map_lit] = STATE(209),
    [sym_var_quoting_lit] = STATE(209),
    [sym_sym_val_lit] = STATE(209),
    [sym_evaling_lit] = STATE(209),
    [sym_tagged_or_ctor_lit] = STATE(209),
    [sym_derefing_lit] = STATE(209),
    [sym_quoting_lit] = STATE(209),
    [sym_syn_quoting_lit] = STATE(209),
    [sym_unquote_splicing_lit] = STATE(209),
    [sym_unquoting_lit] = STATE(209),
    [aux_sym_dis_expr_repeat1] = STATE(58),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(286),
    [sym_comment] = ACTIONS(286),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(288),
    [sym_kwd_lit] = ACTIONS(288),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(288),
    [sym_nil_lit] = ACTIONS(292),
    [sym_bool_lit] = ACTIONS(292),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [30] = {
    [sym__gap] = STATE(44),
    [sym_dis_expr] = STATE(44),
    [sym__form] = STATE(207),
    [sym_str_lit] = STATE(207),
    [sym_sym_lit] = STATE(207),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(207),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(207),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(207),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(207),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(207),
    [sym_regex_lit] = STATE(207),
    [sym_read_cond_lit] = STATE(207),
    [sym_splicing_read_cond_lit] = STATE(207),
    [sym_ns_map_lit] = STATE(207),
    [sym_var_quoting_lit] = STATE(207),
    [sym_sym_val_lit] = STATE(207),
    [sym_evaling_lit] = STATE(207),
    [sym_tagged_or_ctor_lit] = STATE(207),
    [sym_derefing_lit] = STATE(207),
    [sym_quoting_lit] = STATE(207),
    [sym_syn_quoting_lit] = STATE(207),
    [sym_unquote_splicing_lit] = STATE(207),
    [sym_unquoting_lit] = STATE(207),
    [aux_sym_dis_expr_repeat1] = STATE(44),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(324),
    [sym_comment] = ACTIONS(324),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(326),
    [sym_kwd_lit] = ACTIONS(326),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(326),
    [sym_nil_lit] = ACTIONS(328),
    [sym_bool_lit] = ACTIONS(328),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [31] = {
    [sym__gap] = STATE(43),
    [sym_dis_expr] = STATE(43),
    [sym__form] = STATE(205),
    [sym_str_lit] = STATE(205),
    [sym_sym_lit] = STATE(205),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(205),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(205),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(205),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(205),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(205),
    [sym_regex_lit] = STATE(205),
    [sym_read_cond_lit] = STATE(205),
    [sym_splicing_read_cond_lit] = STATE(205),
    [sym_ns_map_lit] = STATE(205),
    [sym_var_quoting_lit] = STATE(205),
    [sym_sym_val_lit] = STATE(205),
    [sym_evaling_lit] = STATE(205),
    [sym_tagged_or_ctor_lit] = STATE(205),
    [sym_derefing_lit] = STATE(205),
    [sym_quoting_lit] = STATE(205),
    [sym_syn_quoting_lit] = STATE(205),
    [sym_unquote_splicing_lit] = STATE(205),
    [sym_unquoting_lit] = STATE(205),
    [aux_sym_dis_expr_repeat1] = STATE(43),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(330),
    [sym_comment] = ACTIONS(330),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(332),
    [sym_kwd_lit] = ACTIONS(332),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(332),
    [sym_nil_lit] = ACTIONS(334),
    [sym_bool_lit] = ACTIONS(334),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [32] = {
    [sym__gap] = STATE(37),
    [sym_dis_expr] = STATE(37),
    [sym__form] = STATE(203),
    [sym_str_lit] = STATE(203),
    [sym_sym_lit] = STATE(203),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(203),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(203),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(203),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(203),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(203),
    [sym_regex_lit] = STATE(203),
    [sym_read_cond_lit] = STATE(203),
    [sym_splicing_read_cond_lit] = STATE(203),
    [sym_ns_map_lit] = STATE(203),
    [sym_var_quoting_lit] = STATE(203),
    [sym_sym_val_lit] = STATE(203),
    [sym_evaling_lit] = STATE(203),
    [sym_tagged_or_ctor_lit] = STATE(203),
    [sym_derefing_lit] = STATE(203),
    [sym_quoting_lit] = STATE(203),
    [sym_syn_quoting_lit] = STATE(203),
    [sym_unquote_splicing_lit] = STATE(203),
    [sym_unquoting_lit] = STATE(203),
    [aux_sym_dis_expr_repeat1] = STATE(37),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(336),
    [sym_comment] = ACTIONS(336),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(338),
    [sym_kwd_lit] = ACTIONS(338),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(338),
    [sym_nil_lit] = ACTIONS(340),
    [sym_bool_lit] = ACTIONS(340),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [33] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(225),
    [sym_str_lit] = STATE(225),
    [sym_sym_lit] = STATE(225),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(225),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(225),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(225),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(225),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(225),
    [sym_regex_lit] = STATE(225),
    [sym_read_cond_lit] = STATE(225),
    [sym_splicing_read_cond_lit] = STATE(225),
    [sym_ns_map_lit] = STATE(225),
    [sym_var_quoting_lit] = STATE(225),
    [sym_sym_val_lit] = STATE(225),
    [sym_evaling_lit] = STATE(225),
    [sym_tagged_or_ctor_lit] = STATE(225),
    [sym_derefing_lit] = STATE(225),
    [sym_quoting_lit] = STATE(225),
    [sym_syn_quoting_lit] = STATE(225),
    [sym_unquote_splicing_lit] = STATE(225),
    [sym_unquoting_lit] = STATE(225),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(342),
    [sym_kwd_lit] = ACTIONS(342),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(342),
    [sym_nil_lit] = ACTIONS(344),
    [sym_bool_lit] = ACTIONS(344),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [34] = {
    [sym__gap] = STATE(87),
    [sym_dis_expr] = STATE(87),
    [sym__form] = STATE(232),
    [sym_str_lit] = STATE(232),
    [sym_sym_lit] = STATE(232),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(232),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(232),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(232),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(232),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(232),
    [sym_regex_lit] = STATE(232),
    [sym_read_cond_lit] = STATE(232),
    [sym_splicing_read_cond_lit] = STATE(232),
    [sym_ns_map_lit] = STATE(232),
    [sym_var_quoting_lit] = STATE(232),
    [sym_sym_val_lit] = STATE(232),
    [sym_evaling_lit] = STATE(232),
    [sym_tagged_or_ctor_lit] = STATE(232),
    [sym_derefing_lit] = STATE(232),
    [sym_quoting_lit] = STATE(232),
    [sym_syn_quoting_lit] = STATE(232),
    [sym_unquote_splicing_lit] = STATE(232),
    [sym_unquoting_lit] = STATE(232),
    [aux_sym_dis_expr_repeat1] = STATE(87),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(346),
    [sym_comment] = ACTIONS(346),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(348),
    [sym_kwd_lit] = ACTIONS(348),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(348),
    [sym_nil_lit] = ACTIONS(350),
    [sym_bool_lit] = ACTIONS(350),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [35] = {
    [sym__gap] = STATE(36),
    [sym_dis_expr] = STATE(36),
    [sym__form] = STATE(197),
    [sym_str_lit] = STATE(197),
    [sym_sym_lit] = STATE(197),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(197),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(197),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(197),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(197),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(197),
    [sym_regex_lit] = STATE(197),
    [sym_read_cond_lit] = STATE(197),
    [sym_splicing_read_cond_lit] = STATE(197),
    [sym_ns_map_lit] = STATE(197),
    [sym_var_quoting_lit] = STATE(197),
    [sym_sym_val_lit] = STATE(197),
    [sym_evaling_lit] = STATE(197),
    [sym_tagged_or_ctor_lit] = STATE(197),
    [sym_derefing_lit] = STATE(197),
    [sym_quoting_lit] = STATE(197),
    [sym_syn_quoting_lit] = STATE(197),
    [sym_unquote_splicing_lit] = STATE(197),
    [sym_unquoting_lit] = STATE(197),
    [aux_sym_dis_expr_repeat1] = STATE(36),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(352),
    [sym_comment] = ACTIONS(352),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(354),
    [sym_kwd_lit] = ACTIONS(354),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(354),
    [sym_nil_lit] = ACTIONS(356),
    [sym_bool_lit] = ACTIONS(356),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [36] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(237),
    [sym_str_lit] = STATE(237),
    [sym_sym_lit] = STATE(237),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(237),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(237),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(237),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(237),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(237),
    [sym_regex_lit] = STATE(237),
    [sym_read_cond_lit] = STATE(237),
    [sym_splicing_read_cond_lit] = STATE(237),
    [sym_ns_map_lit] = STATE(237),
    [sym_var_quoting_lit] = STATE(237),
    [sym_sym_val_lit] = STATE(237),
    [sym_evaling_lit] = STATE(237),
    [sym_tagged_or_ctor_lit] = STATE(237),
    [sym_derefing_lit] = STATE(237),
    [sym_quoting_lit] = STATE(237),
    [sym_syn_quoting_lit] = STATE(237),
    [sym_unquote_splicing_lit] = STATE(237),
    [sym_unquoting_lit] = STATE(237),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(358),
    [sym_kwd_lit] = ACTIONS(358),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(358),
    [sym_nil_lit] = ACTIONS(360),
    [sym_bool_lit] = ACTIONS(360),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [37] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(182),
    [sym_str_lit] = STATE(182),
    [sym_sym_lit] = STATE(182),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(182),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(182),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(182),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(182),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(182),
    [sym_regex_lit] = STATE(182),
    [sym_read_cond_lit] = STATE(182),
    [sym_splicing_read_cond_lit] = STATE(182),
    [sym_ns_map_lit] = STATE(182),
    [sym_var_quoting_lit] = STATE(182),
    [sym_sym_val_lit] = STATE(182),
    [sym_evaling_lit] = STATE(182),
    [sym_tagged_or_ctor_lit] = STATE(182),
    [sym_derefing_lit] = STATE(182),
    [sym_quoting_lit] = STATE(182),
    [sym_syn_quoting_lit] = STATE(182),
    [sym_unquote_splicing_lit] = STATE(182),
    [sym_unquoting_lit] = STATE(182),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(362),
    [sym_kwd_lit] = ACTIONS(362),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(362),
    [sym_nil_lit] = ACTIONS(364),
    [sym_bool_lit] = ACTIONS(364),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [38] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(92),
    [sym_str_lit] = STATE(92),
    [sym_sym_lit] = STATE(92),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(92),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(92),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(92),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(92),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(92),
    [sym_regex_lit] = STATE(92),
    [sym_read_cond_lit] = STATE(92),
    [sym_splicing_read_cond_lit] = STATE(92),
    [sym_ns_map_lit] = STATE(92),
    [sym_var_quoting_lit] = STATE(92),
    [sym_sym_val_lit] = STATE(92),
    [sym_evaling_lit] = STATE(92),
    [sym_tagged_or_ctor_lit] = STATE(92),
    [sym_derefing_lit] = STATE(92),
    [sym_quoting_lit] = STATE(92),
    [sym_syn_quoting_lit] = STATE(92),
    [sym_unquote_splicing_lit] = STATE(92),
    [sym_unquoting_lit] = STATE(92),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(366),
    [sym_kwd_lit] = ACTIONS(366),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(366),
    [sym_nil_lit] = ACTIONS(368),
    [sym_bool_lit] = ACTIONS(368),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [39] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(108),
    [sym_str_lit] = STATE(108),
    [sym_sym_lit] = STATE(108),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(108),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(108),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(108),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(108),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(108),
    [sym_regex_lit] = STATE(108),
    [sym_read_cond_lit] = STATE(108),
    [sym_splicing_read_cond_lit] = STATE(108),
    [sym_ns_map_lit] = STATE(108),
    [sym_var_quoting_lit] = STATE(108),
    [sym_sym_val_lit] = STATE(108),
    [sym_evaling_lit] = STATE(108),
    [sym_tagged_or_ctor_lit] = STATE(108),
    [sym_derefing_lit] = STATE(108),
    [sym_quoting_lit] = STATE(108),
    [sym_syn_quoting_lit] = STATE(108),
    [sym_unquote_splicing_lit] = STATE(108),
    [sym_unquoting_lit] = STATE(108),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(370),
    [sym_kwd_lit] = ACTIONS(370),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(370),
    [sym_nil_lit] = ACTIONS(372),
    [sym_bool_lit] = ACTIONS(372),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [40] = {
    [sym__gap] = STATE(33),
    [sym_dis_expr] = STATE(33),
    [sym__form] = STATE(187),
    [sym_str_lit] = STATE(187),
    [sym_sym_lit] = STATE(187),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(187),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(187),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(187),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(187),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(187),
    [sym_regex_lit] = STATE(187),
    [sym_read_cond_lit] = STATE(187),
    [sym_splicing_read_cond_lit] = STATE(187),
    [sym_ns_map_lit] = STATE(187),
    [sym_var_quoting_lit] = STATE(187),
    [sym_sym_val_lit] = STATE(187),
    [sym_evaling_lit] = STATE(187),
    [sym_tagged_or_ctor_lit] = STATE(187),
    [sym_derefing_lit] = STATE(187),
    [sym_quoting_lit] = STATE(187),
    [sym_syn_quoting_lit] = STATE(187),
    [sym_unquote_splicing_lit] = STATE(187),
    [sym_unquoting_lit] = STATE(187),
    [aux_sym_dis_expr_repeat1] = STATE(33),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(374),
    [sym_comment] = ACTIONS(374),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(376),
    [sym_kwd_lit] = ACTIONS(376),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(376),
    [sym_nil_lit] = ACTIONS(378),
    [sym_bool_lit] = ACTIONS(378),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [41] = {
    [sym__gap] = STATE(39),
    [sym_dis_expr] = STATE(39),
    [sym__form] = STATE(151),
    [sym_str_lit] = STATE(151),
    [sym_sym_lit] = STATE(151),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(151),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(151),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(151),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(151),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(151),
    [sym_regex_lit] = STATE(151),
    [sym_read_cond_lit] = STATE(151),
    [sym_splicing_read_cond_lit] = STATE(151),
    [sym_ns_map_lit] = STATE(151),
    [sym_var_quoting_lit] = STATE(151),
    [sym_sym_val_lit] = STATE(151),
    [sym_evaling_lit] = STATE(151),
    [sym_tagged_or_ctor_lit] = STATE(151),
    [sym_derefing_lit] = STATE(151),
    [sym_quoting_lit] = STATE(151),
    [sym_syn_quoting_lit] = STATE(151),
    [sym_unquote_splicing_lit] = STATE(151),
    [sym_unquoting_lit] = STATE(151),
    [aux_sym_dis_expr_repeat1] = STATE(39),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(380),
    [sym_comment] = ACTIONS(380),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(382),
    [sym_kwd_lit] = ACTIONS(382),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(382),
    [sym_nil_lit] = ACTIONS(384),
    [sym_bool_lit] = ACTIONS(384),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [42] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(154),
    [sym_str_lit] = STATE(154),
    [sym_sym_lit] = STATE(154),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(154),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(154),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(154),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(154),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(154),
    [sym_regex_lit] = STATE(154),
    [sym_read_cond_lit] = STATE(154),
    [sym_splicing_read_cond_lit] = STATE(154),
    [sym_ns_map_lit] = STATE(154),
    [sym_var_quoting_lit] = STATE(154),
    [sym_sym_val_lit] = STATE(154),
    [sym_evaling_lit] = STATE(154),
    [sym_tagged_or_ctor_lit] = STATE(154),
    [sym_derefing_lit] = STATE(154),
    [sym_quoting_lit] = STATE(154),
    [sym_syn_quoting_lit] = STATE(154),
    [sym_unquote_splicing_lit] = STATE(154),
    [sym_unquoting_lit] = STATE(154),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(386),
    [sym_kwd_lit] = ACTIONS(386),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(386),
    [sym_nil_lit] = ACTIONS(388),
    [sym_bool_lit] = ACTIONS(388),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [43] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(241),
    [sym_str_lit] = STATE(241),
    [sym_sym_lit] = STATE(241),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(241),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(241),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(241),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(241),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(241),
    [sym_regex_lit] = STATE(241),
    [sym_read_cond_lit] = STATE(241),
    [sym_splicing_read_cond_lit] = STATE(241),
    [sym_ns_map_lit] = STATE(241),
    [sym_var_quoting_lit] = STATE(241),
    [sym_sym_val_lit] = STATE(241),
    [sym_evaling_lit] = STATE(241),
    [sym_tagged_or_ctor_lit] = STATE(241),
    [sym_derefing_lit] = STATE(241),
    [sym_quoting_lit] = STATE(241),
    [sym_syn_quoting_lit] = STATE(241),
    [sym_unquote_splicing_lit] = STATE(241),
    [sym_unquoting_lit] = STATE(241),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(390),
    [sym_kwd_lit] = ACTIONS(390),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(390),
    [sym_nil_lit] = ACTIONS(392),
    [sym_bool_lit] = ACTIONS(392),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [44] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(242),
    [sym_str_lit] = STATE(242),
    [sym_sym_lit] = STATE(242),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(242),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(242),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(242),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(242),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(242),
    [sym_regex_lit] = STATE(242),
    [sym_read_cond_lit] = STATE(242),
    [sym_splicing_read_cond_lit] = STATE(242),
    [sym_ns_map_lit] = STATE(242),
    [sym_var_quoting_lit] = STATE(242),
    [sym_sym_val_lit] = STATE(242),
    [sym_evaling_lit] = STATE(242),
    [sym_tagged_or_ctor_lit] = STATE(242),
    [sym_derefing_lit] = STATE(242),
    [sym_quoting_lit] = STATE(242),
    [sym_syn_quoting_lit] = STATE(242),
    [sym_unquote_splicing_lit] = STATE(242),
    [sym_unquoting_lit] = STATE(242),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(394),
    [sym_kwd_lit] = ACTIONS(394),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(394),
    [sym_nil_lit] = ACTIONS(396),
    [sym_bool_lit] = ACTIONS(396),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [45] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(166),
    [sym_str_lit] = STATE(166),
    [sym_sym_lit] = STATE(166),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(166),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(166),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(166),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(166),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(166),
    [sym_regex_lit] = STATE(166),
    [sym_read_cond_lit] = STATE(166),
    [sym_splicing_read_cond_lit] = STATE(166),
    [sym_ns_map_lit] = STATE(166),
    [sym_var_quoting_lit] = STATE(166),
    [sym_sym_val_lit] = STATE(166),
    [sym_evaling_lit] = STATE(166),
    [sym_tagged_or_ctor_lit] = STATE(166),
    [sym_derefing_lit] = STATE(166),
    [sym_quoting_lit] = STATE(166),
    [sym_syn_quoting_lit] = STATE(166),
    [sym_unquote_splicing_lit] = STATE(166),
    [sym_unquoting_lit] = STATE(166),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(398),
    [sym_kwd_lit] = ACTIONS(398),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(398),
    [sym_nil_lit] = ACTIONS(400),
    [sym_bool_lit] = ACTIONS(400),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [46] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(188),
    [sym_str_lit] = STATE(188),
    [sym_sym_lit] = STATE(188),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(188),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(188),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(188),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(188),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(188),
    [sym_regex_lit] = STATE(188),
    [sym_read_cond_lit] = STATE(188),
    [sym_splicing_read_cond_lit] = STATE(188),
    [sym_ns_map_lit] = STATE(188),
    [sym_var_quoting_lit] = STATE(188),
    [sym_sym_val_lit] = STATE(188),
    [sym_evaling_lit] = STATE(188),
    [sym_tagged_or_ctor_lit] = STATE(188),
    [sym_derefing_lit] = STATE(188),
    [sym_quoting_lit] = STATE(188),
    [sym_syn_quoting_lit] = STATE(188),
    [sym_unquote_splicing_lit] = STATE(188),
    [sym_unquoting_lit] = STATE(188),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(402),
    [sym_kwd_lit] = ACTIONS(402),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(402),
    [sym_nil_lit] = ACTIONS(404),
    [sym_bool_lit] = ACTIONS(404),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [47] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(165),
    [sym_str_lit] = STATE(165),
    [sym_sym_lit] = STATE(165),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(165),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(165),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(165),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(165),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(165),
    [sym_regex_lit] = STATE(165),
    [sym_read_cond_lit] = STATE(165),
    [sym_splicing_read_cond_lit] = STATE(165),
    [sym_ns_map_lit] = STATE(165),
    [sym_var_quoting_lit] = STATE(165),
    [sym_sym_val_lit] = STATE(165),
    [sym_evaling_lit] = STATE(165),
    [sym_tagged_or_ctor_lit] = STATE(165),
    [sym_derefing_lit] = STATE(165),
    [sym_quoting_lit] = STATE(165),
    [sym_syn_quoting_lit] = STATE(165),
    [sym_unquote_splicing_lit] = STATE(165),
    [sym_unquoting_lit] = STATE(165),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(406),
    [sym_kwd_lit] = ACTIONS(406),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(406),
    [sym_nil_lit] = ACTIONS(408),
    [sym_bool_lit] = ACTIONS(408),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [48] = {
    [sym__gap] = STATE(76),
    [sym_dis_expr] = STATE(76),
    [sym__form] = STATE(104),
    [sym_str_lit] = STATE(104),
    [sym_sym_lit] = STATE(104),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(104),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(104),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(104),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(104),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(104),
    [sym_regex_lit] = STATE(104),
    [sym_read_cond_lit] = STATE(104),
    [sym_splicing_read_cond_lit] = STATE(104),
    [sym_ns_map_lit] = STATE(104),
    [sym_var_quoting_lit] = STATE(104),
    [sym_sym_val_lit] = STATE(104),
    [sym_evaling_lit] = STATE(104),
    [sym_tagged_or_ctor_lit] = STATE(104),
    [sym_derefing_lit] = STATE(104),
    [sym_quoting_lit] = STATE(104),
    [sym_syn_quoting_lit] = STATE(104),
    [sym_unquote_splicing_lit] = STATE(104),
    [sym_unquoting_lit] = STATE(104),
    [aux_sym_dis_expr_repeat1] = STATE(76),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(410),
    [sym_comment] = ACTIONS(410),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(412),
    [sym_kwd_lit] = ACTIONS(412),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(412),
    [sym_nil_lit] = ACTIONS(414),
    [sym_bool_lit] = ACTIONS(414),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [49] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(164),
    [sym_str_lit] = STATE(164),
    [sym_sym_lit] = STATE(164),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(164),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(164),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(164),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(164),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(164),
    [sym_regex_lit] = STATE(164),
    [sym_read_cond_lit] = STATE(164),
    [sym_splicing_read_cond_lit] = STATE(164),
    [sym_ns_map_lit] = STATE(164),
    [sym_var_quoting_lit] = STATE(164),
    [sym_sym_val_lit] = STATE(164),
    [sym_evaling_lit] = STATE(164),
    [sym_tagged_or_ctor_lit] = STATE(164),
    [sym_derefing_lit] = STATE(164),
    [sym_quoting_lit] = STATE(164),
    [sym_syn_quoting_lit] = STATE(164),
    [sym_unquote_splicing_lit] = STATE(164),
    [sym_unquoting_lit] = STATE(164),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(416),
    [sym_kwd_lit] = ACTIONS(416),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(416),
    [sym_nil_lit] = ACTIONS(418),
    [sym_bool_lit] = ACTIONS(418),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [50] = {
    [sym__gap] = STATE(46),
    [sym_dis_expr] = STATE(46),
    [sym__form] = STATE(193),
    [sym_str_lit] = STATE(193),
    [sym_sym_lit] = STATE(193),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(193),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(193),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(193),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(193),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(193),
    [sym_regex_lit] = STATE(193),
    [sym_read_cond_lit] = STATE(193),
    [sym_splicing_read_cond_lit] = STATE(193),
    [sym_ns_map_lit] = STATE(193),
    [sym_var_quoting_lit] = STATE(193),
    [sym_sym_val_lit] = STATE(193),
    [sym_evaling_lit] = STATE(193),
    [sym_tagged_or_ctor_lit] = STATE(193),
    [sym_derefing_lit] = STATE(193),
    [sym_quoting_lit] = STATE(193),
    [sym_syn_quoting_lit] = STATE(193),
    [sym_unquote_splicing_lit] = STATE(193),
    [sym_unquoting_lit] = STATE(193),
    [aux_sym_dis_expr_repeat1] = STATE(46),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(420),
    [sym_comment] = ACTIONS(420),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(422),
    [sym_kwd_lit] = ACTIONS(422),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(422),
    [sym_nil_lit] = ACTIONS(424),
    [sym_bool_lit] = ACTIONS(424),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [51] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(198),
    [sym_str_lit] = STATE(198),
    [sym_sym_lit] = STATE(198),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(198),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(198),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(198),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(198),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(198),
    [sym_regex_lit] = STATE(198),
    [sym_read_cond_lit] = STATE(198),
    [sym_splicing_read_cond_lit] = STATE(198),
    [sym_ns_map_lit] = STATE(198),
    [sym_var_quoting_lit] = STATE(198),
    [sym_sym_val_lit] = STATE(198),
    [sym_evaling_lit] = STATE(198),
    [sym_tagged_or_ctor_lit] = STATE(198),
    [sym_derefing_lit] = STATE(198),
    [sym_quoting_lit] = STATE(198),
    [sym_syn_quoting_lit] = STATE(198),
    [sym_unquote_splicing_lit] = STATE(198),
    [sym_unquoting_lit] = STATE(198),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(426),
    [sym_kwd_lit] = ACTIONS(426),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(426),
    [sym_nil_lit] = ACTIONS(428),
    [sym_bool_lit] = ACTIONS(428),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [52] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(163),
    [sym_str_lit] = STATE(163),
    [sym_sym_lit] = STATE(163),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(163),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(163),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(163),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(163),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(163),
    [sym_regex_lit] = STATE(163),
    [sym_read_cond_lit] = STATE(163),
    [sym_splicing_read_cond_lit] = STATE(163),
    [sym_ns_map_lit] = STATE(163),
    [sym_var_quoting_lit] = STATE(163),
    [sym_sym_val_lit] = STATE(163),
    [sym_evaling_lit] = STATE(163),
    [sym_tagged_or_ctor_lit] = STATE(163),
    [sym_derefing_lit] = STATE(163),
    [sym_quoting_lit] = STATE(163),
    [sym_syn_quoting_lit] = STATE(163),
    [sym_unquote_splicing_lit] = STATE(163),
    [sym_unquoting_lit] = STATE(163),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(430),
    [sym_kwd_lit] = ACTIONS(430),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(430),
    [sym_nil_lit] = ACTIONS(432),
    [sym_bool_lit] = ACTIONS(432),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [53] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(208),
    [sym_str_lit] = STATE(208),
    [sym_sym_lit] = STATE(208),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(208),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(208),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(208),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(208),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(208),
    [sym_regex_lit] = STATE(208),
    [sym_read_cond_lit] = STATE(208),
    [sym_splicing_read_cond_lit] = STATE(208),
    [sym_ns_map_lit] = STATE(208),
    [sym_var_quoting_lit] = STATE(208),
    [sym_sym_val_lit] = STATE(208),
    [sym_evaling_lit] = STATE(208),
    [sym_tagged_or_ctor_lit] = STATE(208),
    [sym_derefing_lit] = STATE(208),
    [sym_quoting_lit] = STATE(208),
    [sym_syn_quoting_lit] = STATE(208),
    [sym_unquote_splicing_lit] = STATE(208),
    [sym_unquoting_lit] = STATE(208),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(434),
    [sym_kwd_lit] = ACTIONS(434),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(434),
    [sym_nil_lit] = ACTIONS(436),
    [sym_bool_lit] = ACTIONS(436),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [54] = {
    [sym__gap] = STATE(63),
    [sym_dis_expr] = STATE(63),
    [sym__form] = STATE(211),
    [sym_str_lit] = STATE(211),
    [sym_sym_lit] = STATE(211),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(211),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(211),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(211),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(211),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(211),
    [sym_regex_lit] = STATE(211),
    [sym_read_cond_lit] = STATE(211),
    [sym_splicing_read_cond_lit] = STATE(211),
    [sym_ns_map_lit] = STATE(211),
    [sym_var_quoting_lit] = STATE(211),
    [sym_sym_val_lit] = STATE(211),
    [sym_evaling_lit] = STATE(211),
    [sym_tagged_or_ctor_lit] = STATE(211),
    [sym_derefing_lit] = STATE(211),
    [sym_quoting_lit] = STATE(211),
    [sym_syn_quoting_lit] = STATE(211),
    [sym_unquote_splicing_lit] = STATE(211),
    [sym_unquoting_lit] = STATE(211),
    [aux_sym_dis_expr_repeat1] = STATE(63),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(438),
    [sym_comment] = ACTIONS(438),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(440),
    [sym_kwd_lit] = ACTIONS(440),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(440),
    [sym_nil_lit] = ACTIONS(442),
    [sym_bool_lit] = ACTIONS(442),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [55] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(210),
    [sym_str_lit] = STATE(210),
    [sym_sym_lit] = STATE(210),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(210),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(210),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(210),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(210),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(210),
    [sym_regex_lit] = STATE(210),
    [sym_read_cond_lit] = STATE(210),
    [sym_splicing_read_cond_lit] = STATE(210),
    [sym_ns_map_lit] = STATE(210),
    [sym_var_quoting_lit] = STATE(210),
    [sym_sym_val_lit] = STATE(210),
    [sym_evaling_lit] = STATE(210),
    [sym_tagged_or_ctor_lit] = STATE(210),
    [sym_derefing_lit] = STATE(210),
    [sym_quoting_lit] = STATE(210),
    [sym_syn_quoting_lit] = STATE(210),
    [sym_unquote_splicing_lit] = STATE(210),
    [sym_unquoting_lit] = STATE(210),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(444),
    [sym_kwd_lit] = ACTIONS(444),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(444),
    [sym_nil_lit] = ACTIONS(446),
    [sym_bool_lit] = ACTIONS(446),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [56] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(161),
    [sym_str_lit] = STATE(161),
    [sym_sym_lit] = STATE(161),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(161),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(161),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(161),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(161),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(161),
    [sym_regex_lit] = STATE(161),
    [sym_read_cond_lit] = STATE(161),
    [sym_splicing_read_cond_lit] = STATE(161),
    [sym_ns_map_lit] = STATE(161),
    [sym_var_quoting_lit] = STATE(161),
    [sym_sym_val_lit] = STATE(161),
    [sym_evaling_lit] = STATE(161),
    [sym_tagged_or_ctor_lit] = STATE(161),
    [sym_derefing_lit] = STATE(161),
    [sym_quoting_lit] = STATE(161),
    [sym_syn_quoting_lit] = STATE(161),
    [sym_unquote_splicing_lit] = STATE(161),
    [sym_unquoting_lit] = STATE(161),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(448),
    [sym_kwd_lit] = ACTIONS(448),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(448),
    [sym_nil_lit] = ACTIONS(450),
    [sym_bool_lit] = ACTIONS(450),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [57] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(110),
    [sym_str_lit] = STATE(110),
    [sym_sym_lit] = STATE(110),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(110),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(110),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(110),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(110),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(110),
    [sym_regex_lit] = STATE(110),
    [sym_read_cond_lit] = STATE(110),
    [sym_splicing_read_cond_lit] = STATE(110),
    [sym_ns_map_lit] = STATE(110),
    [sym_var_quoting_lit] = STATE(110),
    [sym_sym_val_lit] = STATE(110),
    [sym_evaling_lit] = STATE(110),
    [sym_tagged_or_ctor_lit] = STATE(110),
    [sym_derefing_lit] = STATE(110),
    [sym_quoting_lit] = STATE(110),
    [sym_syn_quoting_lit] = STATE(110),
    [sym_unquote_splicing_lit] = STATE(110),
    [sym_unquoting_lit] = STATE(110),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(452),
    [sym_kwd_lit] = ACTIONS(452),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(452),
    [sym_nil_lit] = ACTIONS(454),
    [sym_bool_lit] = ACTIONS(454),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [58] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(243),
    [sym_str_lit] = STATE(243),
    [sym_sym_lit] = STATE(243),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(243),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(243),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(243),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(243),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(243),
    [sym_regex_lit] = STATE(243),
    [sym_read_cond_lit] = STATE(243),
    [sym_splicing_read_cond_lit] = STATE(243),
    [sym_ns_map_lit] = STATE(243),
    [sym_var_quoting_lit] = STATE(243),
    [sym_sym_val_lit] = STATE(243),
    [sym_evaling_lit] = STATE(243),
    [sym_tagged_or_ctor_lit] = STATE(243),
    [sym_derefing_lit] = STATE(243),
    [sym_quoting_lit] = STATE(243),
    [sym_syn_quoting_lit] = STATE(243),
    [sym_unquote_splicing_lit] = STATE(243),
    [sym_unquoting_lit] = STATE(243),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(456),
    [sym_kwd_lit] = ACTIONS(456),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(456),
    [sym_nil_lit] = ACTIONS(458),
    [sym_bool_lit] = ACTIONS(458),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [59] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(212),
    [sym_str_lit] = STATE(212),
    [sym_sym_lit] = STATE(212),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(212),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(212),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(212),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(212),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(212),
    [sym_regex_lit] = STATE(212),
    [sym_read_cond_lit] = STATE(212),
    [sym_splicing_read_cond_lit] = STATE(212),
    [sym_ns_map_lit] = STATE(212),
    [sym_var_quoting_lit] = STATE(212),
    [sym_sym_val_lit] = STATE(212),
    [sym_evaling_lit] = STATE(212),
    [sym_tagged_or_ctor_lit] = STATE(212),
    [sym_derefing_lit] = STATE(212),
    [sym_quoting_lit] = STATE(212),
    [sym_syn_quoting_lit] = STATE(212),
    [sym_unquote_splicing_lit] = STATE(212),
    [sym_unquoting_lit] = STATE(212),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(460),
    [sym_kwd_lit] = ACTIONS(460),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(460),
    [sym_nil_lit] = ACTIONS(462),
    [sym_bool_lit] = ACTIONS(462),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [60] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(157),
    [sym_str_lit] = STATE(157),
    [sym_sym_lit] = STATE(157),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(157),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(157),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(157),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(157),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(157),
    [sym_regex_lit] = STATE(157),
    [sym_read_cond_lit] = STATE(157),
    [sym_splicing_read_cond_lit] = STATE(157),
    [sym_ns_map_lit] = STATE(157),
    [sym_var_quoting_lit] = STATE(157),
    [sym_sym_val_lit] = STATE(157),
    [sym_evaling_lit] = STATE(157),
    [sym_tagged_or_ctor_lit] = STATE(157),
    [sym_derefing_lit] = STATE(157),
    [sym_quoting_lit] = STATE(157),
    [sym_syn_quoting_lit] = STATE(157),
    [sym_unquote_splicing_lit] = STATE(157),
    [sym_unquoting_lit] = STATE(157),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(464),
    [sym_kwd_lit] = ACTIONS(464),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(464),
    [sym_nil_lit] = ACTIONS(466),
    [sym_bool_lit] = ACTIONS(466),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [61] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(214),
    [sym_str_lit] = STATE(214),
    [sym_sym_lit] = STATE(214),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(214),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(214),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(214),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(214),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(214),
    [sym_regex_lit] = STATE(214),
    [sym_read_cond_lit] = STATE(214),
    [sym_splicing_read_cond_lit] = STATE(214),
    [sym_ns_map_lit] = STATE(214),
    [sym_var_quoting_lit] = STATE(214),
    [sym_sym_val_lit] = STATE(214),
    [sym_evaling_lit] = STATE(214),
    [sym_tagged_or_ctor_lit] = STATE(214),
    [sym_derefing_lit] = STATE(214),
    [sym_quoting_lit] = STATE(214),
    [sym_syn_quoting_lit] = STATE(214),
    [sym_unquote_splicing_lit] = STATE(214),
    [sym_unquoting_lit] = STATE(214),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(468),
    [sym_kwd_lit] = ACTIONS(468),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(468),
    [sym_nil_lit] = ACTIONS(470),
    [sym_bool_lit] = ACTIONS(470),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [62] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(215),
    [sym_str_lit] = STATE(215),
    [sym_sym_lit] = STATE(215),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(215),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(215),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(215),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(215),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(215),
    [sym_regex_lit] = STATE(215),
    [sym_read_cond_lit] = STATE(215),
    [sym_splicing_read_cond_lit] = STATE(215),
    [sym_ns_map_lit] = STATE(215),
    [sym_var_quoting_lit] = STATE(215),
    [sym_sym_val_lit] = STATE(215),
    [sym_evaling_lit] = STATE(215),
    [sym_tagged_or_ctor_lit] = STATE(215),
    [sym_derefing_lit] = STATE(215),
    [sym_quoting_lit] = STATE(215),
    [sym_syn_quoting_lit] = STATE(215),
    [sym_unquote_splicing_lit] = STATE(215),
    [sym_unquoting_lit] = STATE(215),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(472),
    [sym_kwd_lit] = ACTIONS(472),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(472),
    [sym_nil_lit] = ACTIONS(474),
    [sym_bool_lit] = ACTIONS(474),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [63] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(244),
    [sym_str_lit] = STATE(244),
    [sym_sym_lit] = STATE(244),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(244),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(244),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(244),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(244),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(244),
    [sym_regex_lit] = STATE(244),
    [sym_read_cond_lit] = STATE(244),
    [sym_splicing_read_cond_lit] = STATE(244),
    [sym_ns_map_lit] = STATE(244),
    [sym_var_quoting_lit] = STATE(244),
    [sym_sym_val_lit] = STATE(244),
    [sym_evaling_lit] = STATE(244),
    [sym_tagged_or_ctor_lit] = STATE(244),
    [sym_derefing_lit] = STATE(244),
    [sym_quoting_lit] = STATE(244),
    [sym_syn_quoting_lit] = STATE(244),
    [sym_unquote_splicing_lit] = STATE(244),
    [sym_unquoting_lit] = STATE(244),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(476),
    [sym_kwd_lit] = ACTIONS(476),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(476),
    [sym_nil_lit] = ACTIONS(478),
    [sym_bool_lit] = ACTIONS(478),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [64] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(113),
    [sym_str_lit] = STATE(113),
    [sym_sym_lit] = STATE(113),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(113),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(113),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(113),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(113),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(113),
    [sym_regex_lit] = STATE(113),
    [sym_read_cond_lit] = STATE(113),
    [sym_splicing_read_cond_lit] = STATE(113),
    [sym_ns_map_lit] = STATE(113),
    [sym_var_quoting_lit] = STATE(113),
    [sym_sym_val_lit] = STATE(113),
    [sym_evaling_lit] = STATE(113),
    [sym_tagged_or_ctor_lit] = STATE(113),
    [sym_derefing_lit] = STATE(113),
    [sym_quoting_lit] = STATE(113),
    [sym_syn_quoting_lit] = STATE(113),
    [sym_unquote_splicing_lit] = STATE(113),
    [sym_unquoting_lit] = STATE(113),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(480),
    [sym_kwd_lit] = ACTIONS(480),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(480),
    [sym_nil_lit] = ACTIONS(482),
    [sym_bool_lit] = ACTIONS(482),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [65] = {
    [sym__gap] = STATE(78),
    [sym_dis_expr] = STATE(78),
    [sym__form] = STATE(249),
    [sym_str_lit] = STATE(249),
    [sym_sym_lit] = STATE(249),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(249),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(249),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(249),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(249),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(249),
    [sym_regex_lit] = STATE(249),
    [sym_read_cond_lit] = STATE(249),
    [sym_splicing_read_cond_lit] = STATE(249),
    [sym_ns_map_lit] = STATE(249),
    [sym_var_quoting_lit] = STATE(249),
    [sym_sym_val_lit] = STATE(249),
    [sym_evaling_lit] = STATE(249),
    [sym_tagged_or_ctor_lit] = STATE(249),
    [sym_derefing_lit] = STATE(249),
    [sym_quoting_lit] = STATE(249),
    [sym_syn_quoting_lit] = STATE(249),
    [sym_unquote_splicing_lit] = STATE(249),
    [sym_unquoting_lit] = STATE(249),
    [aux_sym_dis_expr_repeat1] = STATE(78),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(484),
    [sym_comment] = ACTIONS(484),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(486),
    [sym_kwd_lit] = ACTIONS(486),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(486),
    [sym_nil_lit] = ACTIONS(488),
    [sym_bool_lit] = ACTIONS(488),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [66] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(114),
    [sym_str_lit] = STATE(114),
    [sym_sym_lit] = STATE(114),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(114),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(114),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(114),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(114),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(114),
    [sym_regex_lit] = STATE(114),
    [sym_read_cond_lit] = STATE(114),
    [sym_splicing_read_cond_lit] = STATE(114),
    [sym_ns_map_lit] = STATE(114),
    [sym_var_quoting_lit] = STATE(114),
    [sym_sym_val_lit] = STATE(114),
    [sym_evaling_lit] = STATE(114),
    [sym_tagged_or_ctor_lit] = STATE(114),
    [sym_derefing_lit] = STATE(114),
    [sym_quoting_lit] = STATE(114),
    [sym_syn_quoting_lit] = STATE(114),
    [sym_unquote_splicing_lit] = STATE(114),
    [sym_unquoting_lit] = STATE(114),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(490),
    [sym_kwd_lit] = ACTIONS(490),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(490),
    [sym_nil_lit] = ACTIONS(492),
    [sym_bool_lit] = ACTIONS(492),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [67] = {
    [sym__gap] = STATE(77),
    [sym_dis_expr] = STATE(77),
    [sym__form] = STATE(255),
    [sym_str_lit] = STATE(255),
    [sym_sym_lit] = STATE(255),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(255),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(255),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(255),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(255),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(255),
    [sym_regex_lit] = STATE(255),
    [sym_read_cond_lit] = STATE(255),
    [sym_splicing_read_cond_lit] = STATE(255),
    [sym_ns_map_lit] = STATE(255),
    [sym_var_quoting_lit] = STATE(255),
    [sym_sym_val_lit] = STATE(255),
    [sym_evaling_lit] = STATE(255),
    [sym_tagged_or_ctor_lit] = STATE(255),
    [sym_derefing_lit] = STATE(255),
    [sym_quoting_lit] = STATE(255),
    [sym_syn_quoting_lit] = STATE(255),
    [sym_unquote_splicing_lit] = STATE(255),
    [sym_unquoting_lit] = STATE(255),
    [aux_sym_dis_expr_repeat1] = STATE(77),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(494),
    [sym_comment] = ACTIONS(494),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(496),
    [sym_kwd_lit] = ACTIONS(496),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(496),
    [sym_nil_lit] = ACTIONS(498),
    [sym_bool_lit] = ACTIONS(498),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [68] = {
    [sym__gap] = STATE(42),
    [sym_dis_expr] = STATE(42),
    [sym__form] = STATE(152),
    [sym_str_lit] = STATE(152),
    [sym_sym_lit] = STATE(152),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(152),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(152),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(152),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(152),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(152),
    [sym_regex_lit] = STATE(152),
    [sym_read_cond_lit] = STATE(152),
    [sym_splicing_read_cond_lit] = STATE(152),
    [sym_ns_map_lit] = STATE(152),
    [sym_var_quoting_lit] = STATE(152),
    [sym_sym_val_lit] = STATE(152),
    [sym_evaling_lit] = STATE(152),
    [sym_tagged_or_ctor_lit] = STATE(152),
    [sym_derefing_lit] = STATE(152),
    [sym_quoting_lit] = STATE(152),
    [sym_syn_quoting_lit] = STATE(152),
    [sym_unquote_splicing_lit] = STATE(152),
    [sym_unquoting_lit] = STATE(152),
    [aux_sym_dis_expr_repeat1] = STATE(42),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(500),
    [sym_comment] = ACTIONS(500),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(502),
    [sym_kwd_lit] = ACTIONS(502),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(502),
    [sym_nil_lit] = ACTIONS(504),
    [sym_bool_lit] = ACTIONS(504),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [69] = {
    [sym__gap] = STATE(62),
    [sym_dis_expr] = STATE(62),
    [sym__form] = STATE(257),
    [sym_str_lit] = STATE(257),
    [sym_sym_lit] = STATE(257),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(257),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(257),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(257),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(257),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(257),
    [sym_regex_lit] = STATE(257),
    [sym_read_cond_lit] = STATE(257),
    [sym_splicing_read_cond_lit] = STATE(257),
    [sym_ns_map_lit] = STATE(257),
    [sym_var_quoting_lit] = STATE(257),
    [sym_sym_val_lit] = STATE(257),
    [sym_evaling_lit] = STATE(257),
    [sym_tagged_or_ctor_lit] = STATE(257),
    [sym_derefing_lit] = STATE(257),
    [sym_quoting_lit] = STATE(257),
    [sym_syn_quoting_lit] = STATE(257),
    [sym_unquote_splicing_lit] = STATE(257),
    [sym_unquoting_lit] = STATE(257),
    [aux_sym_dis_expr_repeat1] = STATE(62),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(506),
    [sym_comment] = ACTIONS(506),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(508),
    [sym_kwd_lit] = ACTIONS(508),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(508),
    [sym_nil_lit] = ACTIONS(510),
    [sym_bool_lit] = ACTIONS(510),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [70] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(116),
    [sym_str_lit] = STATE(116),
    [sym_sym_lit] = STATE(116),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(116),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(116),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(116),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(116),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(116),
    [sym_regex_lit] = STATE(116),
    [sym_read_cond_lit] = STATE(116),
    [sym_splicing_read_cond_lit] = STATE(116),
    [sym_ns_map_lit] = STATE(116),
    [sym_var_quoting_lit] = STATE(116),
    [sym_sym_val_lit] = STATE(116),
    [sym_evaling_lit] = STATE(116),
    [sym_tagged_or_ctor_lit] = STATE(116),
    [sym_derefing_lit] = STATE(116),
    [sym_quoting_lit] = STATE(116),
    [sym_syn_quoting_lit] = STATE(116),
    [sym_unquote_splicing_lit] = STATE(116),
    [sym_unquoting_lit] = STATE(116),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(512),
    [sym_kwd_lit] = ACTIONS(512),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(512),
    [sym_nil_lit] = ACTIONS(514),
    [sym_bool_lit] = ACTIONS(514),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [71] = {
    [sym__gap] = STATE(61),
    [sym_dis_expr] = STATE(61),
    [sym__form] = STATE(259),
    [sym_str_lit] = STATE(259),
    [sym_sym_lit] = STATE(259),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(259),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(259),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(259),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(259),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(259),
    [sym_regex_lit] = STATE(259),
    [sym_read_cond_lit] = STATE(259),
    [sym_splicing_read_cond_lit] = STATE(259),
    [sym_ns_map_lit] = STATE(259),
    [sym_var_quoting_lit] = STATE(259),
    [sym_sym_val_lit] = STATE(259),
    [sym_evaling_lit] = STATE(259),
    [sym_tagged_or_ctor_lit] = STATE(259),
    [sym_derefing_lit] = STATE(259),
    [sym_quoting_lit] = STATE(259),
    [sym_syn_quoting_lit] = STATE(259),
    [sym_unquote_splicing_lit] = STATE(259),
    [sym_unquoting_lit] = STATE(259),
    [aux_sym_dis_expr_repeat1] = STATE(61),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(516),
    [sym_comment] = ACTIONS(516),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(518),
    [sym_kwd_lit] = ACTIONS(518),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(518),
    [sym_nil_lit] = ACTIONS(520),
    [sym_bool_lit] = ACTIONS(520),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [72] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(117),
    [sym_str_lit] = STATE(117),
    [sym_sym_lit] = STATE(117),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(117),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(117),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(117),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(117),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(117),
    [sym_regex_lit] = STATE(117),
    [sym_read_cond_lit] = STATE(117),
    [sym_splicing_read_cond_lit] = STATE(117),
    [sym_ns_map_lit] = STATE(117),
    [sym_var_quoting_lit] = STATE(117),
    [sym_sym_val_lit] = STATE(117),
    [sym_evaling_lit] = STATE(117),
    [sym_tagged_or_ctor_lit] = STATE(117),
    [sym_derefing_lit] = STATE(117),
    [sym_quoting_lit] = STATE(117),
    [sym_syn_quoting_lit] = STATE(117),
    [sym_unquote_splicing_lit] = STATE(117),
    [sym_unquoting_lit] = STATE(117),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(522),
    [sym_kwd_lit] = ACTIONS(522),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(522),
    [sym_nil_lit] = ACTIONS(524),
    [sym_bool_lit] = ACTIONS(524),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [73] = {
    [sym__gap] = STATE(59),
    [sym_dis_expr] = STATE(59),
    [sym__form] = STATE(261),
    [sym_str_lit] = STATE(261),
    [sym_sym_lit] = STATE(261),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(261),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(261),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(261),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(261),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(261),
    [sym_regex_lit] = STATE(261),
    [sym_read_cond_lit] = STATE(261),
    [sym_splicing_read_cond_lit] = STATE(261),
    [sym_ns_map_lit] = STATE(261),
    [sym_var_quoting_lit] = STATE(261),
    [sym_sym_val_lit] = STATE(261),
    [sym_evaling_lit] = STATE(261),
    [sym_tagged_or_ctor_lit] = STATE(261),
    [sym_derefing_lit] = STATE(261),
    [sym_quoting_lit] = STATE(261),
    [sym_syn_quoting_lit] = STATE(261),
    [sym_unquote_splicing_lit] = STATE(261),
    [sym_unquoting_lit] = STATE(261),
    [aux_sym_dis_expr_repeat1] = STATE(59),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(526),
    [sym_comment] = ACTIONS(526),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(528),
    [sym_kwd_lit] = ACTIONS(528),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(528),
    [sym_nil_lit] = ACTIONS(530),
    [sym_bool_lit] = ACTIONS(530),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [74] = {
    [sym__gap] = STATE(45),
    [sym_dis_expr] = STATE(45),
    [sym__form] = STATE(146),
    [sym_str_lit] = STATE(146),
    [sym_sym_lit] = STATE(146),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(146),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(146),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(146),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(146),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(146),
    [sym_regex_lit] = STATE(146),
    [sym_read_cond_lit] = STATE(146),
    [sym_splicing_read_cond_lit] = STATE(146),
    [sym_ns_map_lit] = STATE(146),
    [sym_var_quoting_lit] = STATE(146),
    [sym_sym_val_lit] = STATE(146),
    [sym_evaling_lit] = STATE(146),
    [sym_tagged_or_ctor_lit] = STATE(146),
    [sym_derefing_lit] = STATE(146),
    [sym_quoting_lit] = STATE(146),
    [sym_syn_quoting_lit] = STATE(146),
    [sym_unquote_splicing_lit] = STATE(146),
    [sym_unquoting_lit] = STATE(146),
    [aux_sym_dis_expr_repeat1] = STATE(45),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(532),
    [sym_comment] = ACTIONS(532),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(534),
    [sym_kwd_lit] = ACTIONS(534),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(534),
    [sym_nil_lit] = ACTIONS(536),
    [sym_bool_lit] = ACTIONS(536),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [75] = {
    [sym__gap] = STATE(38),
    [sym_dis_expr] = STATE(38),
    [sym__form] = STATE(106),
    [sym_str_lit] = STATE(106),
    [sym_sym_lit] = STATE(106),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(106),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(106),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(106),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(106),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(106),
    [sym_regex_lit] = STATE(106),
    [sym_read_cond_lit] = STATE(106),
    [sym_splicing_read_cond_lit] = STATE(106),
    [sym_ns_map_lit] = STATE(106),
    [sym_var_quoting_lit] = STATE(106),
    [sym_sym_val_lit] = STATE(106),
    [sym_evaling_lit] = STATE(106),
    [sym_tagged_or_ctor_lit] = STATE(106),
    [sym_derefing_lit] = STATE(106),
    [sym_quoting_lit] = STATE(106),
    [sym_syn_quoting_lit] = STATE(106),
    [sym_unquote_splicing_lit] = STATE(106),
    [sym_unquoting_lit] = STATE(106),
    [aux_sym_dis_expr_repeat1] = STATE(38),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(538),
    [sym_comment] = ACTIONS(538),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(540),
    [sym_kwd_lit] = ACTIONS(540),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(540),
    [sym_nil_lit] = ACTIONS(542),
    [sym_bool_lit] = ACTIONS(542),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [76] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(145),
    [sym_str_lit] = STATE(145),
    [sym_sym_lit] = STATE(145),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(145),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(145),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(145),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(145),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(145),
    [sym_regex_lit] = STATE(145),
    [sym_read_cond_lit] = STATE(145),
    [sym_splicing_read_cond_lit] = STATE(145),
    [sym_ns_map_lit] = STATE(145),
    [sym_var_quoting_lit] = STATE(145),
    [sym_sym_val_lit] = STATE(145),
    [sym_evaling_lit] = STATE(145),
    [sym_tagged_or_ctor_lit] = STATE(145),
    [sym_derefing_lit] = STATE(145),
    [sym_quoting_lit] = STATE(145),
    [sym_syn_quoting_lit] = STATE(145),
    [sym_unquote_splicing_lit] = STATE(145),
    [sym_unquoting_lit] = STATE(145),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(544),
    [sym_kwd_lit] = ACTIONS(544),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(544),
    [sym_nil_lit] = ACTIONS(546),
    [sym_bool_lit] = ACTIONS(546),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [77] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(216),
    [sym_str_lit] = STATE(216),
    [sym_sym_lit] = STATE(216),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(216),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(216),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(216),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(216),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(216),
    [sym_regex_lit] = STATE(216),
    [sym_read_cond_lit] = STATE(216),
    [sym_splicing_read_cond_lit] = STATE(216),
    [sym_ns_map_lit] = STATE(216),
    [sym_var_quoting_lit] = STATE(216),
    [sym_sym_val_lit] = STATE(216),
    [sym_evaling_lit] = STATE(216),
    [sym_tagged_or_ctor_lit] = STATE(216),
    [sym_derefing_lit] = STATE(216),
    [sym_quoting_lit] = STATE(216),
    [sym_syn_quoting_lit] = STATE(216),
    [sym_unquote_splicing_lit] = STATE(216),
    [sym_unquoting_lit] = STATE(216),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(548),
    [sym_kwd_lit] = ACTIONS(548),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(548),
    [sym_nil_lit] = ACTIONS(550),
    [sym_bool_lit] = ACTIONS(550),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [78] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(220),
    [sym_str_lit] = STATE(220),
    [sym_sym_lit] = STATE(220),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(220),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(220),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(220),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(220),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(220),
    [sym_regex_lit] = STATE(220),
    [sym_read_cond_lit] = STATE(220),
    [sym_splicing_read_cond_lit] = STATE(220),
    [sym_ns_map_lit] = STATE(220),
    [sym_var_quoting_lit] = STATE(220),
    [sym_sym_val_lit] = STATE(220),
    [sym_evaling_lit] = STATE(220),
    [sym_tagged_or_ctor_lit] = STATE(220),
    [sym_derefing_lit] = STATE(220),
    [sym_quoting_lit] = STATE(220),
    [sym_syn_quoting_lit] = STATE(220),
    [sym_unquote_splicing_lit] = STATE(220),
    [sym_unquoting_lit] = STATE(220),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(552),
    [sym_kwd_lit] = ACTIONS(552),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(552),
    [sym_nil_lit] = ACTIONS(554),
    [sym_bool_lit] = ACTIONS(554),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [79] = {
    [sym__gap] = STATE(51),
    [sym_dis_expr] = STATE(51),
    [sym__form] = STATE(234),
    [sym_str_lit] = STATE(234),
    [sym_sym_lit] = STATE(234),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(234),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(234),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(234),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(234),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(234),
    [sym_regex_lit] = STATE(234),
    [sym_read_cond_lit] = STATE(234),
    [sym_splicing_read_cond_lit] = STATE(234),
    [sym_ns_map_lit] = STATE(234),
    [sym_var_quoting_lit] = STATE(234),
    [sym_sym_val_lit] = STATE(234),
    [sym_evaling_lit] = STATE(234),
    [sym_tagged_or_ctor_lit] = STATE(234),
    [sym_derefing_lit] = STATE(234),
    [sym_quoting_lit] = STATE(234),
    [sym_syn_quoting_lit] = STATE(234),
    [sym_unquote_splicing_lit] = STATE(234),
    [sym_unquoting_lit] = STATE(234),
    [aux_sym_dis_expr_repeat1] = STATE(51),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(556),
    [sym_comment] = ACTIONS(556),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(558),
    [sym_kwd_lit] = ACTIONS(558),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(558),
    [sym_nil_lit] = ACTIONS(560),
    [sym_bool_lit] = ACTIONS(560),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [80] = {
    [sym__gap] = STATE(60),
    [sym_dis_expr] = STATE(60),
    [sym__form] = STATE(127),
    [sym_str_lit] = STATE(127),
    [sym_sym_lit] = STATE(127),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(127),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(127),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(127),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(127),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(127),
    [sym_regex_lit] = STATE(127),
    [sym_read_cond_lit] = STATE(127),
    [sym_splicing_read_cond_lit] = STATE(127),
    [sym_ns_map_lit] = STATE(127),
    [sym_var_quoting_lit] = STATE(127),
    [sym_sym_val_lit] = STATE(127),
    [sym_evaling_lit] = STATE(127),
    [sym_tagged_or_ctor_lit] = STATE(127),
    [sym_derefing_lit] = STATE(127),
    [sym_quoting_lit] = STATE(127),
    [sym_syn_quoting_lit] = STATE(127),
    [sym_unquote_splicing_lit] = STATE(127),
    [sym_unquoting_lit] = STATE(127),
    [aux_sym_dis_expr_repeat1] = STATE(60),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(562),
    [sym_comment] = ACTIONS(562),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(564),
    [sym_kwd_lit] = ACTIONS(564),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(564),
    [sym_nil_lit] = ACTIONS(566),
    [sym_bool_lit] = ACTIONS(566),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [81] = {
    [sym__gap] = STATE(52),
    [sym_dis_expr] = STATE(52),
    [sym__form] = STATE(133),
    [sym_str_lit] = STATE(133),
    [sym_sym_lit] = STATE(133),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(133),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(133),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(133),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(133),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(133),
    [sym_regex_lit] = STATE(133),
    [sym_read_cond_lit] = STATE(133),
    [sym_splicing_read_cond_lit] = STATE(133),
    [sym_ns_map_lit] = STATE(133),
    [sym_var_quoting_lit] = STATE(133),
    [sym_sym_val_lit] = STATE(133),
    [sym_evaling_lit] = STATE(133),
    [sym_tagged_or_ctor_lit] = STATE(133),
    [sym_derefing_lit] = STATE(133),
    [sym_quoting_lit] = STATE(133),
    [sym_syn_quoting_lit] = STATE(133),
    [sym_unquote_splicing_lit] = STATE(133),
    [sym_unquoting_lit] = STATE(133),
    [aux_sym_dis_expr_repeat1] = STATE(52),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(568),
    [sym_comment] = ACTIONS(568),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(570),
    [sym_kwd_lit] = ACTIONS(570),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(570),
    [sym_nil_lit] = ACTIONS(572),
    [sym_bool_lit] = ACTIONS(572),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [82] = {
    [sym__gap] = STATE(56),
    [sym_dis_expr] = STATE(56),
    [sym__form] = STATE(137),
    [sym_str_lit] = STATE(137),
    [sym_sym_lit] = STATE(137),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(137),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(137),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(137),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(137),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(137),
    [sym_regex_lit] = STATE(137),
    [sym_read_cond_lit] = STATE(137),
    [sym_splicing_read_cond_lit] = STATE(137),
    [sym_ns_map_lit] = STATE(137),
    [sym_var_quoting_lit] = STATE(137),
    [sym_sym_val_lit] = STATE(137),
    [sym_evaling_lit] = STATE(137),
    [sym_tagged_or_ctor_lit] = STATE(137),
    [sym_derefing_lit] = STATE(137),
    [sym_quoting_lit] = STATE(137),
    [sym_syn_quoting_lit] = STATE(137),
    [sym_unquote_splicing_lit] = STATE(137),
    [sym_unquoting_lit] = STATE(137),
    [aux_sym_dis_expr_repeat1] = STATE(56),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(574),
    [sym_comment] = ACTIONS(574),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(576),
    [sym_kwd_lit] = ACTIONS(576),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(576),
    [sym_nil_lit] = ACTIONS(578),
    [sym_bool_lit] = ACTIONS(578),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [83] = {
    [sym__gap] = STATE(21),
    [sym_dis_expr] = STATE(21),
    [sym__form] = STATE(131),
    [sym_str_lit] = STATE(131),
    [sym_sym_lit] = STATE(131),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(131),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(131),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(131),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(131),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(131),
    [sym_regex_lit] = STATE(131),
    [sym_read_cond_lit] = STATE(131),
    [sym_splicing_read_cond_lit] = STATE(131),
    [sym_ns_map_lit] = STATE(131),
    [sym_var_quoting_lit] = STATE(131),
    [sym_sym_val_lit] = STATE(131),
    [sym_evaling_lit] = STATE(131),
    [sym_tagged_or_ctor_lit] = STATE(131),
    [sym_derefing_lit] = STATE(131),
    [sym_quoting_lit] = STATE(131),
    [sym_syn_quoting_lit] = STATE(131),
    [sym_unquote_splicing_lit] = STATE(131),
    [sym_unquoting_lit] = STATE(131),
    [aux_sym_dis_expr_repeat1] = STATE(21),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(580),
    [sym_comment] = ACTIONS(580),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(582),
    [sym_kwd_lit] = ACTIONS(582),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(582),
    [sym_nil_lit] = ACTIONS(584),
    [sym_bool_lit] = ACTIONS(584),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [84] = {
    [sym__gap] = STATE(55),
    [sym_dis_expr] = STATE(55),
    [sym__form] = STATE(260),
    [sym_str_lit] = STATE(260),
    [sym_sym_lit] = STATE(260),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(260),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(260),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(260),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(260),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(260),
    [sym_regex_lit] = STATE(260),
    [sym_read_cond_lit] = STATE(260),
    [sym_splicing_read_cond_lit] = STATE(260),
    [sym_ns_map_lit] = STATE(260),
    [sym_var_quoting_lit] = STATE(260),
    [sym_sym_val_lit] = STATE(260),
    [sym_evaling_lit] = STATE(260),
    [sym_tagged_or_ctor_lit] = STATE(260),
    [sym_derefing_lit] = STATE(260),
    [sym_quoting_lit] = STATE(260),
    [sym_syn_quoting_lit] = STATE(260),
    [sym_unquote_splicing_lit] = STATE(260),
    [sym_unquoting_lit] = STATE(260),
    [aux_sym_dis_expr_repeat1] = STATE(55),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(586),
    [sym_comment] = ACTIONS(586),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(588),
    [sym_kwd_lit] = ACTIONS(588),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(588),
    [sym_nil_lit] = ACTIONS(590),
    [sym_bool_lit] = ACTIONS(590),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [85] = {
    [sym__gap] = STATE(49),
    [sym_dis_expr] = STATE(49),
    [sym__form] = STATE(139),
    [sym_str_lit] = STATE(139),
    [sym_sym_lit] = STATE(139),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(139),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(139),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(139),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(139),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(139),
    [sym_regex_lit] = STATE(139),
    [sym_read_cond_lit] = STATE(139),
    [sym_splicing_read_cond_lit] = STATE(139),
    [sym_ns_map_lit] = STATE(139),
    [sym_var_quoting_lit] = STATE(139),
    [sym_sym_val_lit] = STATE(139),
    [sym_evaling_lit] = STATE(139),
    [sym_tagged_or_ctor_lit] = STATE(139),
    [sym_derefing_lit] = STATE(139),
    [sym_quoting_lit] = STATE(139),
    [sym_syn_quoting_lit] = STATE(139),
    [sym_unquote_splicing_lit] = STATE(139),
    [sym_unquoting_lit] = STATE(139),
    [aux_sym_dis_expr_repeat1] = STATE(49),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(592),
    [sym_comment] = ACTIONS(592),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(594),
    [sym_kwd_lit] = ACTIONS(594),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(594),
    [sym_nil_lit] = ACTIONS(596),
    [sym_bool_lit] = ACTIONS(596),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [86] = {
    [sym__gap] = STATE(47),
    [sym_dis_expr] = STATE(47),
    [sym__form] = STATE(141),
    [sym_str_lit] = STATE(141),
    [sym_sym_lit] = STATE(141),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(141),
    [sym__bare_list_lit] = STATE(93),
    [sym_map_lit] = STATE(141),
    [sym__bare_map_lit] = STATE(95),
    [sym_vec_lit] = STATE(141),
    [sym__bare_vec_lit] = STATE(101),
    [sym_set_lit] = STATE(141),
    [sym__bare_set_lit] = STATE(102),
    [sym_anon_fn_lit] = STATE(141),
    [sym_regex_lit] = STATE(141),
    [sym_read_cond_lit] = STATE(141),
    [sym_splicing_read_cond_lit] = STATE(141),
    [sym_ns_map_lit] = STATE(141),
    [sym_var_quoting_lit] = STATE(141),
    [sym_sym_val_lit] = STATE(141),
    [sym_evaling_lit] = STATE(141),
    [sym_tagged_or_ctor_lit] = STATE(141),
    [sym_derefing_lit] = STATE(141),
    [sym_quoting_lit] = STATE(141),
    [sym_syn_quoting_lit] = STATE(141),
    [sym_unquote_splicing_lit] = STATE(141),
    [sym_unquoting_lit] = STATE(141),
    [aux_sym_dis_expr_repeat1] = STATE(47),
    [aux_sym_sym_lit_repeat1] = STATE(171),
    [sym__ws] = ACTIONS(598),
    [sym_comment] = ACTIONS(598),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(600),
    [sym_kwd_lit] = ACTIONS(600),
    [aux_sym_str_lit_token1] = ACTIONS(9),
    [sym_char_lit] = ACTIONS(600),
    [sym_nil_lit] = ACTIONS(602),
    [sym_bool_lit] = ACTIONS(602),
    [aux_sym_sym_lit_token1] = ACTIONS(13),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_POUND_QMARK] = ACTIONS(27),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(29),
    [anon_sym_POUND_SQUOTE] = ACTIONS(31),
    [anon_sym_POUND_POUND] = ACTIONS(33),
    [anon_sym_POUND_EQ] = ACTIONS(35),
    [anon_sym_AT] = ACTIONS(37),
    [anon_sym_SQUOTE] = ACTIONS(39),
    [anon_sym_BQUOTE] = ACTIONS(41),
    [anon_sym_TILDE_AT] = ACTIONS(43),
    [anon_sym_TILDE] = ACTIONS(45),
  },
  [87] = {
    [sym__gap] = STATE(170),
    [sym_dis_expr] = STATE(170),
    [sym__form] = STATE(254),
    [sym_str_lit] = STATE(254),
    [sym_sym_lit] = STATE(254),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(254),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(254),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(254),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(254),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(254),
    [sym_regex_lit] = STATE(254),
    [sym_read_cond_lit] = STATE(254),
    [sym_splicing_read_cond_lit] = STATE(254),
    [sym_ns_map_lit] = STATE(254),
    [sym_var_quoting_lit] = STATE(254),
    [sym_sym_val_lit] = STATE(254),
    [sym_evaling_lit] = STATE(254),
    [sym_tagged_or_ctor_lit] = STATE(254),
    [sym_derefing_lit] = STATE(254),
    [sym_quoting_lit] = STATE(254),
    [sym_syn_quoting_lit] = STATE(254),
    [sym_unquote_splicing_lit] = STATE(254),
    [sym_unquoting_lit] = STATE(254),
    [aux_sym_dis_expr_repeat1] = STATE(170),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(240),
    [sym_comment] = ACTIONS(240),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(604),
    [sym_kwd_lit] = ACTIONS(604),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(604),
    [sym_nil_lit] = ACTIONS(606),
    [sym_bool_lit] = ACTIONS(606),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
  [88] = {
    [sym__gap] = STATE(53),
    [sym_dis_expr] = STATE(53),
    [sym__form] = STATE(250),
    [sym_str_lit] = STATE(250),
    [sym_sym_lit] = STATE(250),
    [sym__metadata_lit] = STATE(279),
    [sym_meta_lit] = STATE(181),
    [sym_old_meta_lit] = STATE(180),
    [sym_list_lit] = STATE(250),
    [sym__bare_list_lit] = STATE(200),
    [sym_map_lit] = STATE(250),
    [sym__bare_map_lit] = STATE(184),
    [sym_vec_lit] = STATE(250),
    [sym__bare_vec_lit] = STATE(185),
    [sym_set_lit] = STATE(250),
    [sym__bare_set_lit] = STATE(186),
    [sym_anon_fn_lit] = STATE(250),
    [sym_regex_lit] = STATE(250),
    [sym_read_cond_lit] = STATE(250),
    [sym_splicing_read_cond_lit] = STATE(250),
    [sym_ns_map_lit] = STATE(250),
    [sym_var_quoting_lit] = STATE(250),
    [sym_sym_val_lit] = STATE(250),
    [sym_evaling_lit] = STATE(250),
    [sym_tagged_or_ctor_lit] = STATE(250),
    [sym_derefing_lit] = STATE(250),
    [sym_quoting_lit] = STATE(250),
    [sym_syn_quoting_lit] = STATE(250),
    [sym_unquote_splicing_lit] = STATE(250),
    [sym_unquoting_lit] = STATE(250),
    [aux_sym_dis_expr_repeat1] = STATE(53),
    [aux_sym_sym_lit_repeat1] = STATE(173),
    [sym__ws] = ACTIONS(608),
    [sym_comment] = ACTIONS(608),
    [anon_sym_POUND_] = ACTIONS(7),
    [sym_num_lit] = ACTIONS(610),
    [sym_kwd_lit] = ACTIONS(610),
    [aux_sym_str_lit_token1] = ACTIONS(290),
    [sym_char_lit] = ACTIONS(610),
    [sym_nil_lit] = ACTIONS(612),
    [sym_bool_lit] = ACTIONS(612),
    [aux_sym_sym_lit_token1] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(15),
    [anon_sym_POUND_CARET] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_LBRACK] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(302),
    [anon_sym_POUND_QMARK] = ACTIONS(304),
    [anon_sym_POUND_QMARK_AT] = ACTIONS(306),
    [anon_sym_POUND_SQUOTE] = ACTIONS(308),
    [anon_sym_POUND_POUND] = ACTIONS(310),
    [anon_sym_POUND_EQ] = ACTIONS(312),
    [anon_sym_AT] = ACTIONS(314),
    [anon_sym_SQUOTE] = ACTIONS(316),
    [anon_sym_BQUOTE] = ACTIONS(318),
    [anon_sym_TILDE_AT] = ACTIONS(320),
    [anon_sym_TILDE] = ACTIONS(322),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 2,
    ACTIONS(616), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(614), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [35] = 2,
    ACTIONS(620), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(618), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [70] = 2,
    ACTIONS(624), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(622), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [105] = 2,
    ACTIONS(628), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(626), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [140] = 2,
    ACTIONS(632), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(630), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [175] = 2,
    ACTIONS(636), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(634), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [210] = 2,
    ACTIONS(640), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(638), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [245] = 2,
    ACTIONS(644), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(642), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [280] = 2,
    ACTIONS(648), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(646), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [315] = 2,
    ACTIONS(652), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(650), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [350] = 2,
    ACTIONS(656), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(654), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [385] = 2,
    ACTIONS(660), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(658), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [420] = 2,
    ACTIONS(664), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(662), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [455] = 2,
    ACTIONS(668), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(666), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [490] = 2,
    ACTIONS(672), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(670), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [525] = 2,
    ACTIONS(676), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(674), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [560] = 2,
    ACTIONS(680), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(678), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [595] = 2,
    ACTIONS(684), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(682), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [630] = 2,
    ACTIONS(688), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(686), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [665] = 2,
    ACTIONS(692), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(690), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [700] = 2,
    ACTIONS(696), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(694), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [735] = 2,
    ACTIONS(700), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(698), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [770] = 2,
    ACTIONS(704), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(702), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [805] = 2,
    ACTIONS(708), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(706), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [840] = 2,
    ACTIONS(712), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(710), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [875] = 2,
    ACTIONS(716), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(714), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [910] = 2,
    ACTIONS(720), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(718), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [945] = 2,
    ACTIONS(724), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(722), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [980] = 2,
    ACTIONS(728), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(726), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1015] = 2,
    ACTIONS(732), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(730), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1050] = 2,
    ACTIONS(736), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(734), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1085] = 2,
    ACTIONS(740), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(738), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1120] = 2,
    ACTIONS(744), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(742), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1155] = 2,
    ACTIONS(748), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(746), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1190] = 2,
    ACTIONS(752), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(750), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1225] = 2,
    ACTIONS(756), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(754), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1260] = 2,
    ACTIONS(760), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(758), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1295] = 2,
    ACTIONS(764), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(762), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1330] = 2,
    ACTIONS(768), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(766), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1365] = 2,
    ACTIONS(772), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(770), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1400] = 2,
    ACTIONS(616), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(614), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1435] = 2,
    ACTIONS(616), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(614), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1470] = 2,
    ACTIONS(776), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(774), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1505] = 2,
    ACTIONS(780), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(778), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1540] = 2,
    ACTIONS(784), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(782), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1575] = 2,
    ACTIONS(788), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(786), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1610] = 2,
    ACTIONS(792), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(790), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1645] = 2,
    ACTIONS(796), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(794), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1680] = 2,
    ACTIONS(800), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(798), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1715] = 2,
    ACTIONS(804), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(802), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1750] = 2,
    ACTIONS(808), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(806), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1785] = 2,
    ACTIONS(812), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(810), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1820] = 2,
    ACTIONS(816), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(814), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1855] = 2,
    ACTIONS(820), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(818), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1890] = 2,
    ACTIONS(824), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(822), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1925] = 2,
    ACTIONS(828), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(826), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1960] = 2,
    ACTIONS(832), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(830), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [1995] = 2,
    ACTIONS(836), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(834), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2030] = 2,
    ACTIONS(840), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(838), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2065] = 2,
    ACTIONS(844), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(842), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2100] = 2,
    ACTIONS(848), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(846), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2135] = 2,
    ACTIONS(844), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(842), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2170] = 2,
    ACTIONS(852), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(850), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2205] = 2,
    ACTIONS(856), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(854), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2240] = 2,
    ACTIONS(860), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(858), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2275] = 2,
    ACTIONS(864), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(862), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2310] = 2,
    ACTIONS(868), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(866), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2345] = 2,
    ACTIONS(872), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(870), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2380] = 2,
    ACTIONS(876), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(874), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2415] = 2,
    ACTIONS(880), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(878), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2450] = 2,
    ACTIONS(880), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(878), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2485] = 2,
    ACTIONS(880), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(878), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2520] = 2,
    ACTIONS(884), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(882), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2555] = 2,
    ACTIONS(888), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(886), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2590] = 2,
    ACTIONS(892), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(890), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2625] = 2,
    ACTIONS(896), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(894), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2660] = 2,
    ACTIONS(900), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(898), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2695] = 2,
    ACTIONS(904), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(902), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2730] = 2,
    ACTIONS(908), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(906), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2765] = 2,
    ACTIONS(908), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(906), 24,
      ts_builtin_sym_end,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2800] = 2,
    ACTIONS(912), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(910), 23,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2834] = 5,
    ACTIONS(917), 1,
      anon_sym_POUND_,
    ACTIONS(914), 2,
      sym__ws,
      sym_comment,
    STATE(170), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(922), 6,
      sym_nil_lit,
      sym_bool_lit,
      aux_sym_sym_lit_token1,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(920), 17,
      sym_num_lit,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      sym_char_lit,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_POUND,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2874] = 24,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(924), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(926), 1,
      anon_sym_POUND,
    ACTIONS(928), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(930), 1,
      anon_sym_POUND_QMARK_AT,
    ACTIONS(932), 1,
      anon_sym_POUND_SQUOTE,
    ACTIONS(934), 1,
      anon_sym_POUND_EQ,
    ACTIONS(936), 1,
      anon_sym_AT,
    ACTIONS(938), 1,
      anon_sym_SQUOTE,
    ACTIONS(940), 1,
      anon_sym_BQUOTE,
    ACTIONS(942), 1,
      anon_sym_TILDE_AT,
    ACTIONS(944), 1,
      anon_sym_TILDE,
    STATE(91), 1,
      sym__bare_map_lit,
    STATE(94), 1,
      sym__bare_list_lit,
    STATE(109), 1,
      sym__bare_vec_lit,
    STATE(136), 1,
      sym__bare_set_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(262), 1,
      aux_sym_sym_lit_repeat1,
    STATE(279), 1,
      sym__metadata_lit,
  [2947] = 5,
    ACTIONS(949), 1,
      anon_sym_POUND_,
    ACTIONS(946), 2,
      sym__ws,
      sym_comment,
    ACTIONS(922), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(920), 15,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [2982] = 24,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(298), 1,
      anon_sym_LBRACE,
    ACTIONS(300), 1,
      anon_sym_LBRACK,
    ACTIONS(952), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(954), 1,
      anon_sym_POUND,
    ACTIONS(956), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(958), 1,
      anon_sym_POUND_QMARK_AT,
    ACTIONS(960), 1,
      anon_sym_POUND_SQUOTE,
    ACTIONS(962), 1,
      anon_sym_POUND_EQ,
    ACTIONS(964), 1,
      anon_sym_AT,
    ACTIONS(966), 1,
      anon_sym_SQUOTE,
    ACTIONS(968), 1,
      anon_sym_BQUOTE,
    ACTIONS(970), 1,
      anon_sym_TILDE_AT,
    ACTIONS(972), 1,
      anon_sym_TILDE,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(221), 1,
      sym__bare_list_lit,
    STATE(222), 1,
      sym__bare_map_lit,
    STATE(223), 1,
      sym__bare_vec_lit,
    STATE(224), 1,
      sym__bare_set_lit,
    STATE(262), 1,
      aux_sym_sym_lit_repeat1,
    STATE(279), 1,
      sym__metadata_lit,
  [3055] = 16,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(290), 1,
      aux_sym_str_lit_token1,
    ACTIONS(298), 1,
      anon_sym_LBRACE,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(978), 1,
      sym_kwd_lit,
    ACTIONS(980), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(982), 1,
      anon_sym_POUND_QMARK,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(184), 1,
      sym__bare_map_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(289), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(275), 4,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [3110] = 16,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(290), 1,
      aux_sym_str_lit_token1,
    ACTIONS(298), 1,
      anon_sym_LBRACE,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(980), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(982), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(984), 1,
      sym_kwd_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(184), 1,
      sym__bare_map_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(289), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(272), 4,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [3165] = 5,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    ACTIONS(988), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(986), 13,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3198] = 5,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    ACTIONS(992), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(990), 13,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3231] = 16,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(290), 1,
      aux_sym_str_lit_token1,
    ACTIONS(298), 1,
      anon_sym_LBRACE,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(980), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(982), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(996), 1,
      sym_kwd_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(184), 1,
      sym__bare_map_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(289), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(994), 2,
      sym__ws,
      sym_comment,
    STATE(174), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(265), 4,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [3286] = 16,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(290), 1,
      aux_sym_str_lit_token1,
    ACTIONS(298), 1,
      anon_sym_LBRACE,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(980), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(982), 1,
      anon_sym_POUND_QMARK,
    ACTIONS(1000), 1,
      sym_kwd_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(184), 1,
      sym__bare_map_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(289), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(998), 2,
      sym__ws,
      sym_comment,
    STATE(175), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(278), 4,
      sym_str_lit,
      sym_sym_lit,
      sym_map_lit,
      sym_read_cond_lit,
  [3341] = 5,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1002), 2,
      sym__ws,
      sym_comment,
    ACTIONS(1006), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(177), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1004), 13,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3374] = 5,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1008), 2,
      sym__ws,
      sym_comment,
    ACTIONS(1012), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    STATE(176), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    ACTIONS(1010), 13,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3407] = 2,
    ACTIONS(712), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(710), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3433] = 2,
    ACTIONS(908), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(906), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3459] = 2,
    ACTIONS(640), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(638), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3485] = 2,
    ACTIONS(664), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(662), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3511] = 2,
    ACTIONS(668), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(666), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3537] = 2,
    ACTIONS(684), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(682), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3563] = 2,
    ACTIONS(692), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(690), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3589] = 2,
    ACTIONS(860), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(858), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3615] = 2,
    ACTIONS(848), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(846), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3641] = 2,
    ACTIONS(840), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(838), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3667] = 2,
    ACTIONS(820), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(818), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3693] = 2,
    ACTIONS(852), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(850), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3719] = 2,
    ACTIONS(812), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(810), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3745] = 2,
    ACTIONS(804), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(802), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3771] = 2,
    ACTIONS(736), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(734), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3797] = 2,
    ACTIONS(688), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(686), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3823] = 2,
    ACTIONS(864), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(862), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3849] = 2,
    ACTIONS(780), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(778), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3875] = 2,
    ACTIONS(632), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(630), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3901] = 2,
    ACTIONS(772), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(770), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3927] = 2,
    ACTIONS(908), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(906), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3953] = 2,
    ACTIONS(764), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(762), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [3979] = 2,
    ACTIONS(648), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(646), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4005] = 2,
    ACTIONS(756), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(754), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4031] = 2,
    ACTIONS(672), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(670), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4057] = 2,
    ACTIONS(748), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(746), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4083] = 2,
    ACTIONS(904), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(902), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4109] = 2,
    ACTIONS(656), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(654), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4135] = 2,
    ACTIONS(900), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(898), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4161] = 2,
    ACTIONS(732), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(730), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4187] = 2,
    ACTIONS(896), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(894), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4213] = 2,
    ACTIONS(680), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(678), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4239] = 2,
    ACTIONS(892), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(890), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4265] = 2,
    ACTIONS(888), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(886), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4291] = 2,
    ACTIONS(884), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(882), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4317] = 2,
    ACTIONS(880), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(878), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4343] = 2,
    ACTIONS(880), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(878), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4369] = 2,
    ACTIONS(880), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(878), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4395] = 2,
    ACTIONS(876), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(874), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4421] = 2,
    ACTIONS(636), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(634), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4447] = 2,
    ACTIONS(624), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(622), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4473] = 2,
    ACTIONS(696), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(694), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4499] = 2,
    ACTIONS(796), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(794), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4525] = 2,
    ACTIONS(628), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(626), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4551] = 2,
    ACTIONS(872), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(870), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4577] = 2,
    ACTIONS(644), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(642), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4603] = 2,
    ACTIONS(652), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(650), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4629] = 2,
    ACTIONS(620), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(618), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4655] = 2,
    ACTIONS(660), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(658), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4681] = 2,
    ACTIONS(740), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(738), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4707] = 2,
    ACTIONS(676), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(674), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4733] = 2,
    ACTIONS(868), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(866), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4759] = 2,
    ACTIONS(856), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(854), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4785] = 2,
    ACTIONS(788), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(786), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4811] = 2,
    ACTIONS(792), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(790), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4837] = 2,
    ACTIONS(700), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(698), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4863] = 2,
    ACTIONS(704), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(702), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4889] = 2,
    ACTIONS(708), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(706), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4915] = 2,
    ACTIONS(844), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(842), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4941] = 2,
    ACTIONS(716), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(714), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4967] = 2,
    ACTIONS(720), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(718), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [4993] = 2,
    ACTIONS(724), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(722), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5019] = 2,
    ACTIONS(728), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(726), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5045] = 2,
    ACTIONS(844), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(842), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5071] = 2,
    ACTIONS(744), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(742), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5097] = 2,
    ACTIONS(752), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(750), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5123] = 2,
    ACTIONS(760), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(758), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5149] = 2,
    ACTIONS(768), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(766), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5175] = 2,
    ACTIONS(836), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(834), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5201] = 2,
    ACTIONS(616), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(614), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5227] = 2,
    ACTIONS(616), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(614), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5253] = 2,
    ACTIONS(616), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(614), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5279] = 2,
    ACTIONS(832), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(830), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5305] = 2,
    ACTIONS(800), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(798), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5331] = 2,
    ACTIONS(828), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(826), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5357] = 2,
    ACTIONS(776), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(774), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5383] = 2,
    ACTIONS(824), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(822), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5409] = 2,
    ACTIONS(784), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(782), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5435] = 2,
    ACTIONS(816), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(814), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5461] = 2,
    ACTIONS(808), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(806), 18,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      sym_kwd_lit,
      aux_sym_str_lit_token1,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5487] = 8,
    ACTIONS(1016), 1,
      anon_sym_CARET,
    ACTIONS(1019), 1,
      anon_sym_POUND_CARET,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(262), 1,
      aux_sym_sym_lit_repeat1,
    STATE(279), 1,
      sym__metadata_lit,
    ACTIONS(1022), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1014), 11,
      aux_sym_sym_lit_token1,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5524] = 17,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1026), 1,
      sym_kwd_lit,
    ACTIONS(1028), 1,
      aux_sym_str_lit_token1,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(1032), 1,
      anon_sym_LBRACE,
    ACTIONS(1034), 1,
      sym_auto_res_mark,
    STATE(48), 1,
      sym_sym_lit,
    STATE(140), 1,
      sym__bare_list_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(304), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1024), 2,
      sym__ws,
      sym_comment,
    STATE(281), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [5579] = 17,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(1038), 1,
      sym_kwd_lit,
    ACTIONS(1040), 1,
      aux_sym_str_lit_token1,
    ACTIONS(1042), 1,
      anon_sym_LBRACE,
    ACTIONS(1044), 1,
      sym_auto_res_mark,
    STATE(34), 1,
      sym_sym_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(194), 1,
      sym__bare_list_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(304), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1036), 2,
      sym__ws,
      sym_comment,
    STATE(284), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [5634] = 2,
    ACTIONS(1048), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1046), 16,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5658] = 16,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(1050), 1,
      anon_sym_POUND_QMARK,
    STATE(93), 1,
      sym__bare_list_lit,
    STATE(158), 1,
      sym_sym_lit,
    STATE(159), 1,
      sym_list_lit,
    STATE(160), 1,
      sym_read_cond_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(288), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [5710] = 14,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(980), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(982), 1,
      anon_sym_POUND_QMARK,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(200), 1,
      sym__bare_list_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(290), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1052), 2,
      sym__ws,
      sym_comment,
    STATE(201), 3,
      sym_sym_lit,
      sym_list_lit,
      sym_read_cond_lit,
    STATE(270), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [5758] = 16,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(980), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(982), 1,
      anon_sym_POUND_QMARK,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(200), 1,
      sym__bare_list_lit,
    STATE(217), 1,
      sym_read_cond_lit,
    STATE(218), 1,
      sym_list_lit,
    STATE(219), 1,
      sym_sym_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(290), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [5810] = 16,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(1042), 1,
      anon_sym_LBRACE,
    ACTIONS(1056), 1,
      sym_kwd_lit,
    ACTIONS(1058), 1,
      sym_auto_res_mark,
    STATE(79), 1,
      sym_sym_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(246), 1,
      sym__bare_list_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(304), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1054), 2,
      sym__ws,
      sym_comment,
    STATE(287), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [5862] = 14,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(980), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(982), 1,
      anon_sym_POUND_QMARK,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(200), 1,
      sym__bare_list_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(290), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
    STATE(239), 3,
      sym_sym_lit,
      sym_list_lit,
      sym_read_cond_lit,
  [5910] = 16,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(1050), 1,
      anon_sym_POUND_QMARK,
    STATE(89), 1,
      sym_read_cond_lit,
    STATE(93), 1,
      sym__bare_list_lit,
    STATE(129), 1,
      sym_sym_lit,
    STATE(130), 1,
      sym_list_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(288), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1060), 2,
      sym__ws,
      sym_comment,
    STATE(266), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [5962] = 2,
    ACTIONS(1064), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1062), 16,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [5986] = 14,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(1050), 1,
      anon_sym_POUND_QMARK,
    STATE(93), 1,
      sym__bare_list_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(288), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    STATE(112), 3,
      sym_sym_lit,
      sym_list_lit,
      sym_read_cond_lit,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6034] = 16,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(1032), 1,
      anon_sym_LBRACE,
    ACTIONS(1068), 1,
      sym_kwd_lit,
    ACTIONS(1070), 1,
      sym_auto_res_mark,
    STATE(68), 1,
      sym_sym_lit,
    STATE(121), 1,
      sym__bare_list_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(304), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1066), 2,
      sym__ws,
      sym_comment,
    STATE(280), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6086] = 2,
    ACTIONS(1074), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1072), 16,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6110] = 14,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(1050), 1,
      anon_sym_POUND_QMARK,
    STATE(93), 1,
      sym__bare_list_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(288), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1076), 2,
      sym__ws,
      sym_comment,
    STATE(128), 3,
      sym_sym_lit,
      sym_list_lit,
      sym_read_cond_lit,
    STATE(273), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6158] = 16,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(980), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(982), 1,
      anon_sym_POUND_QMARK,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(200), 1,
      sym__bare_list_lit,
    STATE(251), 1,
      sym_sym_lit,
    STATE(252), 1,
      sym_list_lit,
    STATE(253), 1,
      sym_read_cond_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(290), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1078), 2,
      sym__ws,
      sym_comment,
    STATE(268), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6210] = 2,
    ACTIONS(1082), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1080), 16,
      sym__ws,
      sym_comment,
      anon_sym_POUND_,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6234] = 2,
    ACTIONS(1086), 3,
      anon_sym_POUND,
      anon_sym_POUND_QMARK,
      anon_sym_TILDE,
    ACTIONS(1084), 13,
      aux_sym_sym_lit_token1,
      anon_sym_CARET,
      anon_sym_POUND_CARET,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_POUND_QMARK_AT,
      anon_sym_POUND_SQUOTE,
      anon_sym_POUND_EQ,
      anon_sym_AT,
      anon_sym_SQUOTE,
      anon_sym_BQUOTE,
      anon_sym_TILDE_AT,
  [6255] = 11,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    STATE(41), 1,
      sym_sym_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(304), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6292] = 11,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    STATE(74), 1,
      sym_sym_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(304), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6329] = 11,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    STATE(132), 1,
      sym_sym_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(304), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1088), 2,
      sym__ws,
      sym_comment,
    STATE(283), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6366] = 11,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    STATE(111), 1,
      sym_sym_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(304), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6403] = 11,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    STATE(88), 1,
      sym_sym_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(304), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6440] = 11,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(980), 1,
      aux_sym_sym_lit_token1,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(238), 1,
      sym_sym_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(303), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6477] = 11,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(980), 1,
      aux_sym_sym_lit_token1,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(199), 1,
      sym_sym_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(303), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(1090), 2,
      sym__ws,
      sym_comment,
    STATE(285), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6514] = 11,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(976), 1,
      anon_sym_POUND_,
    ACTIONS(1030), 1,
      aux_sym_sym_lit_token1,
    STATE(50), 1,
      sym_sym_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(279), 1,
      sym__metadata_lit,
    STATE(304), 1,
      aux_sym_sym_lit_repeat1,
    ACTIONS(974), 2,
      sym__ws,
      sym_comment,
    STATE(172), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6551] = 10,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(924), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(1092), 1,
      anon_sym_POUND_QMARK,
    STATE(94), 1,
      sym__bare_list_lit,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(262), 1,
      aux_sym_sym_lit_repeat1,
    STATE(279), 1,
      sym__metadata_lit,
  [6582] = 10,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(298), 1,
      anon_sym_LBRACE,
    ACTIONS(952), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(1094), 1,
      anon_sym_POUND_QMARK,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(222), 1,
      sym__bare_map_lit,
    STATE(262), 1,
      aux_sym_sym_lit_repeat1,
    STATE(279), 1,
      sym__metadata_lit,
  [6613] = 10,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(952), 1,
      aux_sym_sym_lit_token1,
    ACTIONS(1094), 1,
      anon_sym_POUND_QMARK,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(221), 1,
      sym__bare_list_lit,
    STATE(262), 1,
      aux_sym_sym_lit_repeat1,
    STATE(279), 1,
      sym__metadata_lit,
  [6644] = 5,
    ACTIONS(7), 1,
      anon_sym_POUND_,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(167), 1,
      sym__bare_map_lit,
    ACTIONS(240), 2,
      sym__ws,
      sym_comment,
    STATE(170), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6663] = 5,
    ACTIONS(7), 1,
      anon_sym_POUND_,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(100), 1,
      sym__bare_map_lit,
    ACTIONS(1096), 2,
      sym__ws,
      sym_comment,
    STATE(301), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6682] = 5,
    ACTIONS(7), 1,
      anon_sym_POUND_,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(168), 1,
      sym__bare_map_lit,
    ACTIONS(240), 2,
      sym__ws,
      sym_comment,
    STATE(170), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6701] = 5,
    ACTIONS(7), 1,
      anon_sym_POUND_,
    ACTIONS(298), 1,
      anon_sym_LBRACE,
    STATE(183), 1,
      sym__bare_map_lit,
    ACTIONS(240), 2,
      sym__ws,
      sym_comment,
    STATE(170), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6720] = 5,
    ACTIONS(7), 1,
      anon_sym_POUND_,
    ACTIONS(298), 1,
      anon_sym_LBRACE,
    STATE(202), 1,
      sym__bare_map_lit,
    ACTIONS(240), 2,
      sym__ws,
      sym_comment,
    STATE(170), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6739] = 5,
    ACTIONS(7), 1,
      anon_sym_POUND_,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(150), 1,
      sym__bare_map_lit,
    ACTIONS(1098), 2,
      sym__ws,
      sym_comment,
    STATE(293), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6758] = 5,
    ACTIONS(7), 1,
      anon_sym_POUND_,
    ACTIONS(298), 1,
      anon_sym_LBRACE,
    STATE(240), 1,
      sym__bare_map_lit,
    ACTIONS(1100), 2,
      sym__ws,
      sym_comment,
    STATE(294), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6777] = 5,
    ACTIONS(7), 1,
      anon_sym_POUND_,
    ACTIONS(298), 1,
      anon_sym_LBRACE,
    STATE(245), 1,
      sym__bare_map_lit,
    ACTIONS(1102), 2,
      sym__ws,
      sym_comment,
    STATE(295), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6796] = 5,
    ACTIONS(7), 1,
      anon_sym_POUND_,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(148), 1,
      sym__bare_map_lit,
    ACTIONS(1104), 2,
      sym__ws,
      sym_comment,
    STATE(291), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6815] = 5,
    ACTIONS(7), 1,
      anon_sym_POUND_,
    ACTIONS(298), 1,
      anon_sym_LBRACE,
    STATE(258), 1,
      sym__bare_map_lit,
    ACTIONS(240), 2,
      sym__ws,
      sym_comment,
    STATE(170), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6834] = 5,
    ACTIONS(7), 1,
      anon_sym_POUND_,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    STATE(143), 1,
      sym__bare_map_lit,
    ACTIONS(240), 2,
      sym__ws,
      sym_comment,
    STATE(170), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6853] = 5,
    ACTIONS(7), 1,
      anon_sym_POUND_,
    ACTIONS(298), 1,
      anon_sym_LBRACE,
    STATE(230), 1,
      sym__bare_map_lit,
    ACTIONS(1106), 2,
      sym__ws,
      sym_comment,
    STATE(300), 3,
      sym__gap,
      sym_dis_expr,
      aux_sym_dis_expr_repeat1,
  [6872] = 7,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(952), 1,
      aux_sym_sym_lit_token1,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(262), 1,
      aux_sym_sym_lit_repeat1,
    STATE(279), 1,
      sym__metadata_lit,
  [6894] = 7,
    ACTIONS(15), 1,
      anon_sym_CARET,
    ACTIONS(17), 1,
      anon_sym_POUND_CARET,
    ACTIONS(924), 1,
      aux_sym_sym_lit_token1,
    STATE(180), 1,
      sym_old_meta_lit,
    STATE(181), 1,
      sym_meta_lit,
    STATE(262), 1,
      aux_sym_sym_lit_repeat1,
    STATE(279), 1,
      sym__metadata_lit,
  [6916] = 4,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(1108), 1,
      sym__ws,
    STATE(196), 1,
      sym__bare_list_lit,
    STATE(308), 1,
      aux_sym_read_cond_lit_repeat1,
  [6929] = 4,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(1110), 1,
      sym__ws,
    STATE(119), 1,
      sym__bare_list_lit,
    STATE(310), 1,
      aux_sym_read_cond_lit_repeat1,
  [6942] = 4,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(1112), 1,
      sym__ws,
    STATE(235), 1,
      sym__bare_list_lit,
    STATE(321), 1,
      aux_sym_read_cond_lit_repeat1,
  [6955] = 4,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(1112), 1,
      sym__ws,
    STATE(236), 1,
      sym__bare_list_lit,
    STATE(321), 1,
      aux_sym_read_cond_lit_repeat1,
  [6968] = 4,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(1112), 1,
      sym__ws,
    STATE(134), 1,
      sym__bare_list_lit,
    STATE(321), 1,
      aux_sym_read_cond_lit_repeat1,
  [6981] = 4,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(1112), 1,
      sym__ws,
    STATE(135), 1,
      sym__bare_list_lit,
    STATE(321), 1,
      aux_sym_read_cond_lit_repeat1,
  [6994] = 4,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(1114), 1,
      sym__ws,
    STATE(247), 1,
      sym__bare_list_lit,
    STATE(317), 1,
      aux_sym_read_cond_lit_repeat1,
  [7007] = 4,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(1116), 1,
      sym__ws,
    STATE(248), 1,
      sym__bare_list_lit,
    STATE(318), 1,
      aux_sym_read_cond_lit_repeat1,
  [7020] = 4,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(1112), 1,
      sym__ws,
    STATE(156), 1,
      sym__bare_list_lit,
    STATE(321), 1,
      aux_sym_read_cond_lit_repeat1,
  [7033] = 4,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(1118), 1,
      sym__ws,
    STATE(138), 1,
      sym__bare_list_lit,
    STATE(309), 1,
      aux_sym_read_cond_lit_repeat1,
  [7046] = 4,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(1120), 1,
      sym__ws,
    STATE(123), 1,
      sym__bare_list_lit,
    STATE(320), 1,
      aux_sym_read_cond_lit_repeat1,
  [7059] = 4,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(1122), 1,
      sym__ws,
    STATE(125), 1,
      sym__bare_list_lit,
    STATE(313), 1,
      aux_sym_read_cond_lit_repeat1,
  [7072] = 4,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(1112), 1,
      sym__ws,
    STATE(233), 1,
      sym__bare_list_lit,
    STATE(321), 1,
      aux_sym_read_cond_lit_repeat1,
  [7085] = 4,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(1112), 1,
      sym__ws,
    STATE(226), 1,
      sym__bare_list_lit,
    STATE(321), 1,
      aux_sym_read_cond_lit_repeat1,
  [7098] = 4,
    ACTIONS(296), 1,
      anon_sym_LPAREN,
    ACTIONS(1124), 1,
      sym__ws,
    STATE(195), 1,
      sym__bare_list_lit,
    STATE(307), 1,
      aux_sym_read_cond_lit_repeat1,
  [7111] = 4,
    ACTIONS(19), 1,
      anon_sym_LPAREN,
    ACTIONS(1112), 1,
      sym__ws,
    STATE(155), 1,
      sym__bare_list_lit,
    STATE(321), 1,
      aux_sym_read_cond_lit_repeat1,
  [7124] = 3,
    ACTIONS(1126), 1,
      sym__ws,
    ACTIONS(1129), 1,
      anon_sym_LPAREN,
    STATE(321), 1,
      aux_sym_read_cond_lit_repeat1,
  [7134] = 1,
    ACTIONS(1131), 1,
      ts_builtin_sym_end,
};

static uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(89)] = 0,
  [SMALL_STATE(90)] = 35,
  [SMALL_STATE(91)] = 70,
  [SMALL_STATE(92)] = 105,
  [SMALL_STATE(93)] = 140,
  [SMALL_STATE(94)] = 175,
  [SMALL_STATE(95)] = 210,
  [SMALL_STATE(96)] = 245,
  [SMALL_STATE(97)] = 280,
  [SMALL_STATE(98)] = 315,
  [SMALL_STATE(99)] = 350,
  [SMALL_STATE(100)] = 385,
  [SMALL_STATE(101)] = 420,
  [SMALL_STATE(102)] = 455,
  [SMALL_STATE(103)] = 490,
  [SMALL_STATE(104)] = 525,
  [SMALL_STATE(105)] = 560,
  [SMALL_STATE(106)] = 595,
  [SMALL_STATE(107)] = 630,
  [SMALL_STATE(108)] = 665,
  [SMALL_STATE(109)] = 700,
  [SMALL_STATE(110)] = 735,
  [SMALL_STATE(111)] = 770,
  [SMALL_STATE(112)] = 805,
  [SMALL_STATE(113)] = 840,
  [SMALL_STATE(114)] = 875,
  [SMALL_STATE(115)] = 910,
  [SMALL_STATE(116)] = 945,
  [SMALL_STATE(117)] = 980,
  [SMALL_STATE(118)] = 1015,
  [SMALL_STATE(119)] = 1050,
  [SMALL_STATE(120)] = 1085,
  [SMALL_STATE(121)] = 1120,
  [SMALL_STATE(122)] = 1155,
  [SMALL_STATE(123)] = 1190,
  [SMALL_STATE(124)] = 1225,
  [SMALL_STATE(125)] = 1260,
  [SMALL_STATE(126)] = 1295,
  [SMALL_STATE(127)] = 1330,
  [SMALL_STATE(128)] = 1365,
  [SMALL_STATE(129)] = 1400,
  [SMALL_STATE(130)] = 1435,
  [SMALL_STATE(131)] = 1470,
  [SMALL_STATE(132)] = 1505,
  [SMALL_STATE(133)] = 1540,
  [SMALL_STATE(134)] = 1575,
  [SMALL_STATE(135)] = 1610,
  [SMALL_STATE(136)] = 1645,
  [SMALL_STATE(137)] = 1680,
  [SMALL_STATE(138)] = 1715,
  [SMALL_STATE(139)] = 1750,
  [SMALL_STATE(140)] = 1785,
  [SMALL_STATE(141)] = 1820,
  [SMALL_STATE(142)] = 1855,
  [SMALL_STATE(143)] = 1890,
  [SMALL_STATE(144)] = 1925,
  [SMALL_STATE(145)] = 1960,
  [SMALL_STATE(146)] = 1995,
  [SMALL_STATE(147)] = 2030,
  [SMALL_STATE(148)] = 2065,
  [SMALL_STATE(149)] = 2100,
  [SMALL_STATE(150)] = 2135,
  [SMALL_STATE(151)] = 2170,
  [SMALL_STATE(152)] = 2205,
  [SMALL_STATE(153)] = 2240,
  [SMALL_STATE(154)] = 2275,
  [SMALL_STATE(155)] = 2310,
  [SMALL_STATE(156)] = 2345,
  [SMALL_STATE(157)] = 2380,
  [SMALL_STATE(158)] = 2415,
  [SMALL_STATE(159)] = 2450,
  [SMALL_STATE(160)] = 2485,
  [SMALL_STATE(161)] = 2520,
  [SMALL_STATE(162)] = 2555,
  [SMALL_STATE(163)] = 2590,
  [SMALL_STATE(164)] = 2625,
  [SMALL_STATE(165)] = 2660,
  [SMALL_STATE(166)] = 2695,
  [SMALL_STATE(167)] = 2730,
  [SMALL_STATE(168)] = 2765,
  [SMALL_STATE(169)] = 2800,
  [SMALL_STATE(170)] = 2834,
  [SMALL_STATE(171)] = 2874,
  [SMALL_STATE(172)] = 2947,
  [SMALL_STATE(173)] = 2982,
  [SMALL_STATE(174)] = 3055,
  [SMALL_STATE(175)] = 3110,
  [SMALL_STATE(176)] = 3165,
  [SMALL_STATE(177)] = 3198,
  [SMALL_STATE(178)] = 3231,
  [SMALL_STATE(179)] = 3286,
  [SMALL_STATE(180)] = 3341,
  [SMALL_STATE(181)] = 3374,
  [SMALL_STATE(182)] = 3407,
  [SMALL_STATE(183)] = 3433,
  [SMALL_STATE(184)] = 3459,
  [SMALL_STATE(185)] = 3485,
  [SMALL_STATE(186)] = 3511,
  [SMALL_STATE(187)] = 3537,
  [SMALL_STATE(188)] = 3563,
  [SMALL_STATE(189)] = 3589,
  [SMALL_STATE(190)] = 3615,
  [SMALL_STATE(191)] = 3641,
  [SMALL_STATE(192)] = 3667,
  [SMALL_STATE(193)] = 3693,
  [SMALL_STATE(194)] = 3719,
  [SMALL_STATE(195)] = 3745,
  [SMALL_STATE(196)] = 3771,
  [SMALL_STATE(197)] = 3797,
  [SMALL_STATE(198)] = 3823,
  [SMALL_STATE(199)] = 3849,
  [SMALL_STATE(200)] = 3875,
  [SMALL_STATE(201)] = 3901,
  [SMALL_STATE(202)] = 3927,
  [SMALL_STATE(203)] = 3953,
  [SMALL_STATE(204)] = 3979,
  [SMALL_STATE(205)] = 4005,
  [SMALL_STATE(206)] = 4031,
  [SMALL_STATE(207)] = 4057,
  [SMALL_STATE(208)] = 4083,
  [SMALL_STATE(209)] = 4109,
  [SMALL_STATE(210)] = 4135,
  [SMALL_STATE(211)] = 4161,
  [SMALL_STATE(212)] = 4187,
  [SMALL_STATE(213)] = 4213,
  [SMALL_STATE(214)] = 4239,
  [SMALL_STATE(215)] = 4265,
  [SMALL_STATE(216)] = 4291,
  [SMALL_STATE(217)] = 4317,
  [SMALL_STATE(218)] = 4343,
  [SMALL_STATE(219)] = 4369,
  [SMALL_STATE(220)] = 4395,
  [SMALL_STATE(221)] = 4421,
  [SMALL_STATE(222)] = 4447,
  [SMALL_STATE(223)] = 4473,
  [SMALL_STATE(224)] = 4499,
  [SMALL_STATE(225)] = 4525,
  [SMALL_STATE(226)] = 4551,
  [SMALL_STATE(227)] = 4577,
  [SMALL_STATE(228)] = 4603,
  [SMALL_STATE(229)] = 4629,
  [SMALL_STATE(230)] = 4655,
  [SMALL_STATE(231)] = 4681,
  [SMALL_STATE(232)] = 4707,
  [SMALL_STATE(233)] = 4733,
  [SMALL_STATE(234)] = 4759,
  [SMALL_STATE(235)] = 4785,
  [SMALL_STATE(236)] = 4811,
  [SMALL_STATE(237)] = 4837,
  [SMALL_STATE(238)] = 4863,
  [SMALL_STATE(239)] = 4889,
  [SMALL_STATE(240)] = 4915,
  [SMALL_STATE(241)] = 4941,
  [SMALL_STATE(242)] = 4967,
  [SMALL_STATE(243)] = 4993,
  [SMALL_STATE(244)] = 5019,
  [SMALL_STATE(245)] = 5045,
  [SMALL_STATE(246)] = 5071,
  [SMALL_STATE(247)] = 5097,
  [SMALL_STATE(248)] = 5123,
  [SMALL_STATE(249)] = 5149,
  [SMALL_STATE(250)] = 5175,
  [SMALL_STATE(251)] = 5201,
  [SMALL_STATE(252)] = 5227,
  [SMALL_STATE(253)] = 5253,
  [SMALL_STATE(254)] = 5279,
  [SMALL_STATE(255)] = 5305,
  [SMALL_STATE(256)] = 5331,
  [SMALL_STATE(257)] = 5357,
  [SMALL_STATE(258)] = 5383,
  [SMALL_STATE(259)] = 5409,
  [SMALL_STATE(260)] = 5435,
  [SMALL_STATE(261)] = 5461,
  [SMALL_STATE(262)] = 5487,
  [SMALL_STATE(263)] = 5524,
  [SMALL_STATE(264)] = 5579,
  [SMALL_STATE(265)] = 5634,
  [SMALL_STATE(266)] = 5658,
  [SMALL_STATE(267)] = 5710,
  [SMALL_STATE(268)] = 5758,
  [SMALL_STATE(269)] = 5810,
  [SMALL_STATE(270)] = 5862,
  [SMALL_STATE(271)] = 5910,
  [SMALL_STATE(272)] = 5962,
  [SMALL_STATE(273)] = 5986,
  [SMALL_STATE(274)] = 6034,
  [SMALL_STATE(275)] = 6086,
  [SMALL_STATE(276)] = 6110,
  [SMALL_STATE(277)] = 6158,
  [SMALL_STATE(278)] = 6210,
  [SMALL_STATE(279)] = 6234,
  [SMALL_STATE(280)] = 6255,
  [SMALL_STATE(281)] = 6292,
  [SMALL_STATE(282)] = 6329,
  [SMALL_STATE(283)] = 6366,
  [SMALL_STATE(284)] = 6403,
  [SMALL_STATE(285)] = 6440,
  [SMALL_STATE(286)] = 6477,
  [SMALL_STATE(287)] = 6514,
  [SMALL_STATE(288)] = 6551,
  [SMALL_STATE(289)] = 6582,
  [SMALL_STATE(290)] = 6613,
  [SMALL_STATE(291)] = 6644,
  [SMALL_STATE(292)] = 6663,
  [SMALL_STATE(293)] = 6682,
  [SMALL_STATE(294)] = 6701,
  [SMALL_STATE(295)] = 6720,
  [SMALL_STATE(296)] = 6739,
  [SMALL_STATE(297)] = 6758,
  [SMALL_STATE(298)] = 6777,
  [SMALL_STATE(299)] = 6796,
  [SMALL_STATE(300)] = 6815,
  [SMALL_STATE(301)] = 6834,
  [SMALL_STATE(302)] = 6853,
  [SMALL_STATE(303)] = 6872,
  [SMALL_STATE(304)] = 6894,
  [SMALL_STATE(305)] = 6916,
  [SMALL_STATE(306)] = 6929,
  [SMALL_STATE(307)] = 6942,
  [SMALL_STATE(308)] = 6955,
  [SMALL_STATE(309)] = 6968,
  [SMALL_STATE(310)] = 6981,
  [SMALL_STATE(311)] = 6994,
  [SMALL_STATE(312)] = 7007,
  [SMALL_STATE(313)] = 7020,
  [SMALL_STATE(314)] = 7033,
  [SMALL_STATE(315)] = 7046,
  [SMALL_STATE(316)] = 7059,
  [SMALL_STATE(317)] = 7072,
  [SMALL_STATE(318)] = 7085,
  [SMALL_STATE(319)] = 7098,
  [SMALL_STATE(320)] = 7111,
  [SMALL_STATE(321)] = 7124,
  [SMALL_STATE(322)] = 7134,
};

static TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(263),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(314),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [47] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(2),
  [50] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(75),
  [53] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(169),
  [56] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(103),
  [59] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(169),
  [62] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(97),
  [65] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(179),
  [68] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(178),
  [71] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(7),
  [74] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16),
  [76] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(8),
  [79] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(9),
  [82] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(263),
  [85] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(314),
  [88] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(306),
  [91] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(23),
  [94] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(282),
  [97] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(276),
  [100] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(24),
  [103] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(25),
  [106] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(26),
  [109] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(27),
  [112] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 2, .production_id = 16), SHIFT_REPEAT(28),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(169),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2),
  [127] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(5),
  [130] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(75),
  [133] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(103),
  [136] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(5),
  [139] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(97),
  [142] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(179),
  [145] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(178),
  [148] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(7),
  [151] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(8),
  [154] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(9),
  [157] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(263),
  [160] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(314),
  [163] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(306),
  [166] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(23),
  [169] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(282),
  [172] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(276),
  [175] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(24),
  [178] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(25),
  [181] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(26),
  [184] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(27),
  [187] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_repeat1, 2), SHIFT_REPEAT(28),
  [190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source, 1),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [210] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [244] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [248] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [254] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [260] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [266] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [272] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [278] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [284] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [292] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [294] = {.entry = {.count = 1, .reusable = false}}, SHIFT(204),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [302] = {.entry = {.count = 1, .reusable = false}}, SHIFT(264),
  [304] = {.entry = {.count = 1, .reusable = false}}, SHIFT(319),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [322] = {.entry = {.count = 1, .reusable = false}}, SHIFT(54),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [328] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [334] = {.entry = {.count = 1, .reusable = false}}, SHIFT(205),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [340] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [344] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [350] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [356] = {.entry = {.count = 1, .reusable = false}}, SHIFT(197),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [360] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [364] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [368] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [372] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [378] = {.entry = {.count = 1, .reusable = false}}, SHIFT(187),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [384] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [392] = {.entry = {.count = 1, .reusable = false}}, SHIFT(241),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [400] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [404] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [408] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [414] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [418] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [424] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [428] = {.entry = {.count = 1, .reusable = false}}, SHIFT(198),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [432] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [436] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [442] = {.entry = {.count = 1, .reusable = false}}, SHIFT(211),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [446] = {.entry = {.count = 1, .reusable = false}}, SHIFT(210),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [450] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [454] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [458] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [462] = {.entry = {.count = 1, .reusable = false}}, SHIFT(212),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [466] = {.entry = {.count = 1, .reusable = false}}, SHIFT(157),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [470] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [474] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [478] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [488] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [492] = {.entry = {.count = 1, .reusable = false}}, SHIFT(114),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(255),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [504] = {.entry = {.count = 1, .reusable = false}}, SHIFT(152),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [510] = {.entry = {.count = 1, .reusable = false}}, SHIFT(257),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [514] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [520] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [524] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [530] = {.entry = {.count = 1, .reusable = false}}, SHIFT(261),
  [532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [536] = {.entry = {.count = 1, .reusable = false}}, SHIFT(146),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [542] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [546] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [550] = {.entry = {.count = 1, .reusable = false}}, SHIFT(216),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [554] = {.entry = {.count = 1, .reusable = false}}, SHIFT(220),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [560] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [566] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [572] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [578] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [584] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [590] = {.entry = {.count = 1, .reusable = false}}, SHIFT(260),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [596] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [602] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [606] = {.entry = {.count = 1, .reusable = false}}, SHIFT(254),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [612] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [614] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_evaling_lit, 3, .production_id = 22),
  [616] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_evaling_lit, 3, .production_id = 22),
  [618] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_vec_lit, 3, .production_id = 15),
  [620] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_vec_lit, 3, .production_id = 15),
  [622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_lit, 2, .production_id = 11),
  [624] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map_lit, 2, .production_id = 11),
  [626] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dis_expr, 3, .production_id = 14),
  [628] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dis_expr, 3, .production_id = 14),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_lit, 1, .production_id = 4),
  [632] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_lit, 1, .production_id = 4),
  [634] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_lit, 2, .production_id = 11),
  [636] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_lit, 2, .production_id = 11),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_map_lit, 1, .production_id = 4),
  [640] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_map_lit, 1, .production_id = 4),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_list_lit, 3, .production_id = 15),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_list_lit, 3, .production_id = 15),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_lit, 1),
  [648] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_lit, 1),
  [650] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_map_lit, 3, .production_id = 15),
  [652] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_map_lit, 3, .production_id = 15),
  [654] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquote_splicing_lit, 2, .production_id = 6),
  [656] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquote_splicing_lit, 2, .production_id = 6),
  [658] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ns_map_lit, 3, .production_id = 17),
  [660] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ns_map_lit, 3, .production_id = 17),
  [662] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vec_lit, 1, .production_id = 4),
  [664] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vec_lit, 1, .production_id = 4),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_lit, 1, .production_id = 5),
  [668] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set_lit, 1, .production_id = 5),
  [670] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_str_lit, 1),
  [672] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_str_lit, 1),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 3, .production_id = 19),
  [676] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 3, .production_id = 19),
  [678] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_lit, 2, .production_id = 1),
  [680] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_lit, 2, .production_id = 1),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dis_expr, 2, .production_id = 6),
  [684] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dis_expr, 2, .production_id = 6),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_quoting_lit, 2, .production_id = 6),
  [688] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_quoting_lit, 2, .production_id = 6),
  [690] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 6, .production_id = 35),
  [692] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 6, .production_id = 35),
  [694] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_vec_lit, 2, .production_id = 11),
  [696] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_vec_lit, 2, .production_id = 11),
  [698] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_quoting_lit, 3, .production_id = 14),
  [700] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_quoting_lit, 3, .production_id = 14),
  [702] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_val_lit, 3, .production_id = 14),
  [704] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_val_lit, 3, .production_id = 14),
  [706] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_evaling_lit, 3, .production_id = 14),
  [708] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_evaling_lit, 3, .production_id = 14),
  [710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_derefing_lit, 3, .production_id = 14),
  [712] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_derefing_lit, 3, .production_id = 14),
  [714] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoting_lit, 3, .production_id = 14),
  [716] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoting_lit, 3, .production_id = 14),
  [718] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_syn_quoting_lit, 3, .production_id = 14),
  [720] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_syn_quoting_lit, 3, .production_id = 14),
  [722] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquote_splicing_lit, 3, .production_id = 14),
  [724] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquote_splicing_lit, 3, .production_id = 14),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoting_lit, 3, .production_id = 14),
  [728] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoting_lit, 3, .production_id = 14),
  [730] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoting_lit, 2, .production_id = 6),
  [732] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoting_lit, 2, .production_id = 6),
  [734] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_splicing_read_cond_lit, 2, .production_id = 10),
  [736] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_splicing_read_cond_lit, 2, .production_id = 10),
  [738] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_set_lit, 3, .production_id = 18),
  [740] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_set_lit, 3, .production_id = 18),
  [742] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anon_fn_lit, 3, .production_id = 21),
  [744] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anon_fn_lit, 3, .production_id = 21),
  [746] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_syn_quoting_lit, 2, .production_id = 6),
  [748] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_syn_quoting_lit, 2, .production_id = 6),
  [750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_read_cond_lit, 3, .production_id = 21),
  [752] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_read_cond_lit, 3, .production_id = 21),
  [754] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoting_lit, 2, .production_id = 6),
  [756] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoting_lit, 2, .production_id = 6),
  [758] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_splicing_read_cond_lit, 3, .production_id = 21),
  [760] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_splicing_read_cond_lit, 3, .production_id = 21),
  [762] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_derefing_lit, 2, .production_id = 6),
  [764] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_derefing_lit, 2, .production_id = 6),
  [766] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_quoting_lit, 3, .production_id = 22),
  [768] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_quoting_lit, 3, .production_id = 22),
  [770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_evaling_lit, 2, .production_id = 6),
  [772] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_evaling_lit, 2, .production_id = 6),
  [774] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoting_lit, 3, .production_id = 22),
  [776] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoting_lit, 3, .production_id = 22),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sym_val_lit, 2, .production_id = 6),
  [780] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sym_val_lit, 2, .production_id = 6),
  [782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_syn_quoting_lit, 3, .production_id = 22),
  [784] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_syn_quoting_lit, 3, .production_id = 22),
  [786] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_read_cond_lit, 3, .production_id = 20),
  [788] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_read_cond_lit, 3, .production_id = 20),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_splicing_read_cond_lit, 3, .production_id = 20),
  [792] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_splicing_read_cond_lit, 3, .production_id = 20),
  [794] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_lit, 2, .production_id = 12),
  [796] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set_lit, 2, .production_id = 12),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_derefing_lit, 3, .production_id = 22),
  [800] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_derefing_lit, 3, .production_id = 22),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_read_cond_lit, 2, .production_id = 10),
  [804] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_read_cond_lit, 2, .production_id = 10),
  [806] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquote_splicing_lit, 3, .production_id = 22),
  [808] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquote_splicing_lit, 3, .production_id = 22),
  [810] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anon_fn_lit, 2, .production_id = 10),
  [812] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anon_fn_lit, 2, .production_id = 10),
  [814] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoting_lit, 3, .production_id = 22),
  [816] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoting_lit, 3, .production_id = 22),
  [818] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_regex_lit, 2, .production_id = 9),
  [820] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_regex_lit, 2, .production_id = 9),
  [822] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ns_map_lit, 4, .production_id = 23),
  [824] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ns_map_lit, 4, .production_id = 23),
  [826] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_set_lit, 4, .production_id = 24),
  [828] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_set_lit, 4, .production_id = 24),
  [830] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 25),
  [832] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 25),
  [834] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 26),
  [836] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 26),
  [838] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_vec_lit, 2, .production_id = 7),
  [840] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_vec_lit, 2, .production_id = 7),
  [842] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ns_map_lit, 4, .production_id = 27),
  [844] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ns_map_lit, 4, .production_id = 27),
  [846] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_map_lit, 2, .production_id = 7),
  [848] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_map_lit, 2, .production_id = 7),
  [850] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 34),
  [852] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 34),
  [854] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 28),
  [856] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 4, .production_id = 28),
  [858] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__bare_list_lit, 2, .production_id = 7),
  [860] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__bare_list_lit, 2, .production_id = 7),
  [862] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 33),
  [864] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 33),
  [866] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_read_cond_lit, 4, .production_id = 29),
  [868] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_read_cond_lit, 4, .production_id = 29),
  [870] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_splicing_read_cond_lit, 4, .production_id = 29),
  [872] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_splicing_read_cond_lit, 4, .production_id = 29),
  [874] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_quoting_lit, 4, .production_id = 30),
  [876] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_var_quoting_lit, 4, .production_id = 30),
  [878] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_evaling_lit, 4, .production_id = 30),
  [880] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_evaling_lit, 4, .production_id = 30),
  [882] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_derefing_lit, 4, .production_id = 30),
  [884] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_derefing_lit, 4, .production_id = 30),
  [886] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoting_lit, 4, .production_id = 30),
  [888] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoting_lit, 4, .production_id = 30),
  [890] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_syn_quoting_lit, 4, .production_id = 30),
  [892] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_syn_quoting_lit, 4, .production_id = 30),
  [894] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquote_splicing_lit, 4, .production_id = 30),
  [896] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquote_splicing_lit, 4, .production_id = 30),
  [898] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoting_lit, 4, .production_id = 30),
  [900] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoting_lit, 4, .production_id = 30),
  [902] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 31),
  [904] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tagged_or_ctor_lit, 5, .production_id = 31),
  [906] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ns_map_lit, 5, .production_id = 32),
  [908] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ns_map_lit, 5, .production_id = 32),
  [910] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__bare_list_lit_repeat1, 1, .production_id = 8),
  [912] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__bare_list_lit_repeat1, 1, .production_id = 8),
  [914] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(170),
  [917] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(75),
  [920] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2),
  [922] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_dis_expr_repeat1, 2),
  [924] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [926] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [928] = {.entry = {.count = 1, .reusable = false}}, SHIFT(315),
  [930] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [934] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [944] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [946] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(172),
  [949] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dis_expr_repeat1, 2), SHIFT_REPEAT(40),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [954] = {.entry = {.count = 1, .reusable = false}}, SHIFT(269),
  [956] = {.entry = {.count = 1, .reusable = false}}, SHIFT(311),
  [958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [966] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [970] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [972] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [974] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [982] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [986] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__metadata_lit, 2, .production_id = 2),
  [988] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__metadata_lit, 2, .production_id = 2),
  [990] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__metadata_lit, 2, .production_id = 3),
  [992] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__metadata_lit, 2, .production_id = 3),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [1000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [1004] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__metadata_lit, 1, .production_id = 3),
  [1006] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__metadata_lit, 1, .production_id = 3),
  [1008] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [1010] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__metadata_lit, 1, .production_id = 2),
  [1012] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__metadata_lit, 1, .production_id = 2),
  [1014] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 13),
  [1016] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 13), SHIFT_REPEAT(179),
  [1019] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 13), SHIFT_REPEAT(178),
  [1022] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sym_lit_repeat1, 2, .production_id = 13),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1034] = {.entry = {.count = 1, .reusable = false}}, SHIFT(292),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1044] = {.entry = {.count = 1, .reusable = false}}, SHIFT(302),
  [1046] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_old_meta_lit, 2, .production_id = 6),
  [1048] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_old_meta_lit, 2, .production_id = 6),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1058] = {.entry = {.count = 1, .reusable = false}}, SHIFT(297),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [1062] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_meta_lit, 3, .production_id = 14),
  [1064] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_meta_lit, 3, .production_id = 14),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [1070] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [1072] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_old_meta_lit, 3, .production_id = 14),
  [1074] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_old_meta_lit, 3, .production_id = 14),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [1080] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_meta_lit, 2, .production_id = 6),
  [1082] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_meta_lit, 2, .production_id = 6),
  [1084] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sym_lit_repeat1, 1, .production_id = 1),
  [1086] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sym_lit_repeat1, 1, .production_id = 1),
  [1088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [1090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [1102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [1106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [1126] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_read_cond_lit_repeat1, 2), SHIFT_REPEAT(321),
  [1129] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_read_cond_lit_repeat1, 2),
  [1131] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_clojure(void) {
  static TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = (const uint16_t *)ts_parse_table,
    .small_parse_table = (const uint16_t *)ts_small_parse_table,
    .small_parse_table_map = (const uint32_t *)ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = (const TSFieldMapSlice *)ts_field_map_slices,
    .field_map_entries = (const TSFieldMapEntry *)ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = (const TSSymbol *)ts_alias_sequences,
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
