#include <stdio.h>
#define DREG	0x1	/* Data Register Direct */
#define	AREG	0x2	/* Address Register Direct */
#define	AINDR	0x4	/* Address Register Indirect */
#define	AINC	0x8	/* Address Register Indirect with Postincrement */
#define	ADEC	0x10	/* Address Register Indirect with Predecrement */
#define	Ad16	0x20	/* Address Register Indirect with Displacement */
#define	Ad8Xn	0x40	/* Address Register Indirect with Index */
			/*  (8-Bit Displacement) */
#define	AbdXn	0x80	/* Address Register Indirect with Index */
			/*  (Base Displacement) */
#define	MIPRE	0x100	/* Memory Indirect with Preindexed */
#define	MIPOST	0x200	/* Memory Indirect with Postindexed */
#define	ABSW	0x400	/* Absolute Short */
#define	ABSL	0x800	/* Absolute Long */
#define	IMMED	0x1000	/* Immediate */
#define	PCd16	0x2000	/* Program Counter Indirect with Displacement */
#define	PCd8Xn	0x4000	/* Program Counter Indirect with Index */
			/*  (8-Bit Displacement) */
#define	PCbdXn	0x8000	/* Program Counter Indirect with Index */
			/*  (Base Displacement) */
#define	PCMIPRE	0x10000	/* Program Counter Memory Indirect with Preindexed */
#define	PCMIPOST 0x20000/* Program Counter Memory Indirect with Postindexed */
#define MOVEC_REG	0x40000
#define SPECIAL_1	0x80000
#define SPECIAL_2	0x100000
#define SPECIAL_3	0x200000

struct operand {
    char *string;
    int32_t type;
};

struct operand ops[] = {
/* Dn "Data Register Direct" Dn */
    { "d0",			DREG },
/* An "Address Register Direct" An */
    { "a1",			AREG },
/* An@ "Address Register Indirect" (An) */
    { "a3@",			AINDR },
/* An@+ "Address Register Indirect with Postincrement" (An)+ */
    { "a3@+",			AINC },
/* An@- "Address Register Indirect with Predecrement" -(An) */
    { "a3@-",			ADEC },
/* An@(d16) "Address Register Indirect with Displacement" (d16,An) */
    { "a3@(0x1234:w)",		Ad16 },
/* An@(d8,Xn) "Address Register Indirect with Index (8-Bit Displacement)"
   uses Brief Format Extension Word (d8,An,Xn) */
#ifdef ALL_OPERANDS
    { "a3@(0x12:b,d2:w:1)",	Ad8Xn },
    { "a3@(0x12:b,d2:w:2)",	Ad8Xn },
    { "a3@(0x12:b,d2:w:4)",	Ad8Xn },
    { "a3@(0x12:b,d2:w:8)",	Ad8Xn },
    { "a3@(0x12:b,d2:l:1)",	Ad8Xn },
    { "a3@(0x12:b,d2:l:2)",	Ad8Xn },
    { "a3@(0x12:b,d2:l:4)",	Ad8Xn },
    { "a3@(0x12:b,d2:l:8)",	Ad8Xn },
    { "a3@(0x12:b,a5:w:1)",	Ad8Xn },
    { "a3@(0x12:b,a5:w:2)",	Ad8Xn },
    { "a3@(0x12:b,a5:w:4)",	Ad8Xn },
    { "a3@(0x12:b,a5:w:8)",	Ad8Xn },
    { "a3@(0x12:b,a5:l:1)",	Ad8Xn },
    { "a3@(0x12:b,a5:l:2)",	Ad8Xn },
    { "a3@(0x12:b,a5:l:4)",	Ad8Xn },
#endif /* ALL_OPERANDS */
    { "a3@(0x12:b,a5:l:8)",	Ad8Xn },
/* An@(bd,Xn) "Address Register Indirect with Index (Base Displacement)",
   uses Full Format Extension Word(s) (bd,An,Xn) */
#ifdef ALL_OPERANDS
/* the form of An@(bd,Xn) with bd (base displacement) encoded as a null
   displacement will not be generated by the assembler because it will use
   the form An(d8,Xn).
    { "a3@(0)",			AbdXn },
    { "a3@(0,d2:w:1)",		AbdXn },
    { "a3@(0,d2:w:2)",		AbdXn },
    { "a3@(0,d2:w:4)",		AbdXn },
    { "a3@(0,d2:w:8)",		AbdXn },
    { "a3@(0,d2:l:1)",		AbdXn },
    { "a3@(0,d2:l:2)",		AbdXn },
    { "a3@(0,d2:l:4)",		AbdXn },
    { "a3@(0,d2:l:8)",		AbdXn },
    { "a3@(0,a5:w:1)",		AbdXn },
    { "a3@(0,a5:w:2)",		AbdXn },
    { "a3@(0,a5:w:4)",		AbdXn },
    { "a3@(0,a5:w:8)",		AbdXn },
    { "a3@(0,a5:l:1)",		AbdXn },
    { "a3@(0,a5:l:2)",		AbdXn },
    { "a3@(0,a5:l:4)",		AbdXn },
    { "a3@(0,a5:l:8)",		AbdXn },
*/
    { "a3@(0x1234:w,d2:w:1)",	AbdXn },
    { "a3@(0x1234:w,d2:w:2)",	AbdXn },
    { "a3@(0x1234:w,d2:w:4)",	AbdXn },
    { "a3@(0x1234:w,d2:w:8)",	AbdXn },
    { "a3@(0x1234:w,d2:l:1)",	AbdXn },
    { "a3@(0x1234:w,d2:l:2)",	AbdXn },
    { "a3@(0x1234:w,d2:l:4)",	AbdXn },
    { "a3@(0x1234:w,d2:l:8)",	AbdXn },
    { "a3@(0x1234:w,a5:w:1)",	AbdXn },
    { "a3@(0x1234:w,a5:w:2)",	AbdXn },
    { "a3@(0x1234:w,a5:w:4)",	AbdXn },
    { "a3@(0x1234:w,a5:w:8)",	AbdXn },
    { "a3@(0x1234:w,a5:l:1)",	AbdXn },
    { "a3@(0x1234:w,a5:l:2)",	AbdXn },
    { "a3@(0x1234:w,a5:l:4)",	AbdXn },
    { "a3@(0x1234:w,a5:l:8)",	AbdXn },
    { "a3@(0x1234abcd:l,d2:w:1)",	AbdXn },
    { "a3@(0x1234abcd:l,d2:w:2)",	AbdXn },
    { "a3@(0x1234abcd:l,d2:w:4)",	AbdXn },
    { "a3@(0x1234abcd:l,d2:w:8)",	AbdXn },
    { "a3@(0x1234abcd:l,d2:l:1)",	AbdXn },
    { "a3@(0x1234abcd:l,d2:l:2)",	AbdXn },
    { "a3@(0x1234abcd:l,d2:l:4)",	AbdXn },
    { "a3@(0x1234abcd:l,d2:l:8)",	AbdXn },
    { "a3@(0x1234abcd:l,a5:w:1)",	AbdXn },
    { "a3@(0x1234abcd:l,a5:w:2)",	AbdXn },
    { "a3@(0x1234abcd:l,a5:w:4)",	AbdXn },
    { "a3@(0x1234abcd:l,a5:w:8)",	AbdXn },
    { "a3@(0x1234abcd:l,a5:l:1)",	AbdXn },
    { "a3@(0x1234abcd:l,a5:l:2)",	AbdXn },
    { "a3@(0x1234abcd:l,a5:l:4)",	AbdXn },
#endif /* ALL_OPERANDS */
    { "a3@(0x1234abcd:l,a5:l:8)",	AbdXn },
#ifdef ALL_OPERANDS
    { "@(0)",				AbdXn },
    { "@(0,d2:w:1)",			AbdXn },
    { "@(0,d2:w:2)",			AbdXn },
    { "@(0,d2:w:4)",			AbdXn },
    { "@(0,d2:w:8)",			AbdXn },
    { "@(0,d2:l:1)",			AbdXn },
    { "@(0,d2:l:2)",			AbdXn },
    { "@(0,d2:l:4)",			AbdXn },
    { "@(0,d2:l:8)",			AbdXn },
    { "@(0,a5:w:1)",			AbdXn },
    { "@(0,a5:w:2)",			AbdXn },
    { "@(0,a5:w:4)",			AbdXn },
    { "@(0,a5:w:8)",			AbdXn },
    { "@(0,a5:l:1)",			AbdXn },
    { "@(0,a5:l:2)",			AbdXn },
    { "@(0,a5:l:4)",			AbdXn },
    { "@(0,a5:l:8)",			AbdXn },
    { "@(0x1234:w,d2:w:1)",			AbdXn },
    { "@(0x1234:w,d2:w:2)",			AbdXn },
    { "@(0x1234:w,d2:w:4)",			AbdXn },
    { "@(0x1234:w,d2:w:8)",			AbdXn },
    { "@(0x1234:w,d2:l:1)",			AbdXn },
    { "@(0x1234:w,d2:l:2)",			AbdXn },
    { "@(0x1234:w,d2:l:4)",			AbdXn },
    { "@(0x1234:w,d2:l:8)",			AbdXn },
    { "@(0x1234:w,a5:w:1)",			AbdXn },
    { "@(0x1234:w,a5:w:2)",			AbdXn },
    { "@(0x1234:w,a5:w:4)",			AbdXn },
    { "@(0x1234:w,a5:w:8)",			AbdXn },
    { "@(0x1234:w,a5:l:1)",			AbdXn },
    { "@(0x1234:w,a5:l:2)",			AbdXn },
    { "@(0x1234:w,a5:l:4)",			AbdXn },
    { "@(0x1234:w,a5:l:8)",			AbdXn },
    { "@(0x1234abcd:l,d2:w:1)",			AbdXn },
    { "@(0x1234abcd:l,d2:w:2)",			AbdXn },
    { "@(0x1234abcd:l,d2:w:4)",			AbdXn },
    { "@(0x1234abcd:l,d2:w:8)",			AbdXn },
    { "@(0x1234abcd:l,d2:l:1)",			AbdXn },
    { "@(0x1234abcd:l,d2:l:2)",			AbdXn },
    { "@(0x1234abcd:l,d2:l:4)",			AbdXn },
    { "@(0x1234abcd:l,d2:l:8)",			AbdXn },
    { "@(0x1234abcd:l,a5:w:1)",			AbdXn },
    { "@(0x1234abcd:l,a5:w:2)",			AbdXn },
    { "@(0x1234abcd:l,a5:w:4)",			AbdXn },
    { "@(0x1234abcd:l,a5:w:8)",			AbdXn },
    { "@(0x1234abcd:l,a5:l:1)",			AbdXn },
    { "@(0x1234abcd:l,a5:l:2)",			AbdXn },
    { "@(0x1234abcd:l,a5:l:4)",			AbdXn },
    { "@(0x1234abcd:l,a5:l:8)",			AbdXn },
#endif /* ALL_OPERANDS */
/* An@(bd,Xn)@(od) "Memory Indirect with Preindexed" ([bd,An,Xn],od)
   uses Full Format Extension Word(s) */
#ifdef ALL_OPERANDS
    { "a3@(0)@(0)",	MIPRE },
    { "a3@(0,d2:w:1)@(0)",	MIPRE },
    { "a3@(0,d2:w:2)@(0)",	MIPRE },
    { "a3@(0,d2:w:4)@(0)",	MIPRE },
    { "a3@(0,d2:w:8)@(0)",	MIPRE },
    { "a3@(0,d2:l:1)@(0)",	MIPRE },
    { "a3@(0,d2:l:2)@(0)",	MIPRE },
    { "a3@(0,d2:l:4)@(0)",	MIPRE },
    { "a3@(0,d2:l:8)@(0)",	MIPRE },
    { "a3@(0,a5:w:1)@(0)",	MIPRE },
    { "a3@(0,a5:w:2)@(0)",	MIPRE },
    { "a3@(0,a5:w:4)@(0)",	MIPRE },
    { "a3@(0,a5:w:8)@(0)",	MIPRE },
    { "a3@(0,a5:l:1)@(0)",	MIPRE },
    { "a3@(0,a5:l:2)@(0)",	MIPRE },
    { "a3@(0,a5:l:4)@(0)",	MIPRE },
    { "a3@(0,a5:l:8)@(0)",	MIPRE },
    { "a3@(0x1234:w,d2:w:1)@(0)",	MIPRE },
    { "a3@(0x1234:w,d2:w:2)@(0)",	MIPRE },
    { "a3@(0x1234:w,d2:w:4)@(0)",	MIPRE },
    { "a3@(0x1234:w,d2:w:8)@(0)",	MIPRE },
    { "a3@(0x1234:w,d2:l:1)@(0)",	MIPRE },
    { "a3@(0x1234:w,d2:l:2)@(0)",	MIPRE },
    { "a3@(0x1234:w,d2:l:4)@(0)",	MIPRE },
    { "a3@(0x1234:w,d2:l:8)@(0)",	MIPRE },
    { "a3@(0x1234:w,a5:w:1)@(0)",	MIPRE },
    { "a3@(0x1234:w,a5:w:2)@(0)",	MIPRE },
    { "a3@(0x1234:w,a5:w:4)@(0)",	MIPRE },
    { "a3@(0x1234:w,a5:w:8)@(0)",	MIPRE },
    { "a3@(0x1234:w,a5:l:1)@(0)",	MIPRE },
    { "a3@(0x1234:w,a5:l:2)@(0)",	MIPRE },
    { "a3@(0x1234:w,a5:l:4)@(0)",	MIPRE },
    { "a3@(0x1234:w,a5:l:8)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:w:1)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:w:2)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:w:4)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:w:8)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:l:1)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:l:2)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:l:4)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:l:8)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:w:1)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:w:2)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:w:4)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:w:8)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:l:1)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:l:2)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:l:4)@(0)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:l:8)@(0)",	MIPRE },
    { "@(0)@(0)",	MIPRE },
    { "@(0,d2:w:1)@(0)",	MIPRE },
    { "@(0,d2:w:2)@(0)",	MIPRE },
    { "@(0,d2:w:4)@(0)",	MIPRE },
    { "@(0,d2:w:8)@(0)",	MIPRE },
    { "@(0,d2:l:1)@(0)",	MIPRE },
    { "@(0,d2:l:2)@(0)",	MIPRE },
    { "@(0,d2:l:4)@(0)",	MIPRE },
    { "@(0,d2:l:8)@(0)",	MIPRE },
    { "@(0,a5:w:1)@(0)",	MIPRE },
    { "@(0,a5:w:2)@(0)",	MIPRE },
    { "@(0,a5:w:4)@(0)",	MIPRE },
    { "@(0,a5:w:8)@(0)",	MIPRE },
    { "@(0,a5:l:1)@(0)",	MIPRE },
    { "@(0,a5:l:2)@(0)",	MIPRE },
    { "@(0,a5:l:4)@(0)",	MIPRE },
    { "@(0,a5:l:8)@(0)",	MIPRE },
    { "@(0x1234:w,d2:w:1)@(0)",	MIPRE },
    { "@(0x1234:w,d2:w:2)@(0)",	MIPRE },
    { "@(0x1234:w,d2:w:4)@(0)",	MIPRE },
    { "@(0x1234:w,d2:w:8)@(0)",	MIPRE },
    { "@(0x1234:w,d2:l:1)@(0)",	MIPRE },
    { "@(0x1234:w,d2:l:2)@(0)",	MIPRE },
    { "@(0x1234:w,d2:l:4)@(0)",	MIPRE },
    { "@(0x1234:w,d2:l:8)@(0)",	MIPRE },
    { "@(0x1234:w,a5:w:1)@(0)",	MIPRE },
    { "@(0x1234:w,a5:w:2)@(0)",	MIPRE },
    { "@(0x1234:w,a5:w:4)@(0)",	MIPRE },
    { "@(0x1234:w,a5:w:8)@(0)",	MIPRE },
    { "@(0x1234:w,a5:l:1)@(0)",	MIPRE },
    { "@(0x1234:w,a5:l:2)@(0)",	MIPRE },
    { "@(0x1234:w,a5:l:4)@(0)",	MIPRE },
    { "@(0x1234:w,a5:l:8)@(0)",	MIPRE },
    { "@(0x1234abcd:l,d2:w:1)@(0)",	MIPRE },
    { "@(0x1234abcd:l,d2:w:2)@(0)",	MIPRE },
    { "@(0x1234abcd:l,d2:w:4)@(0)",	MIPRE },
    { "@(0x1234abcd:l,d2:w:8)@(0)",	MIPRE },
    { "@(0x1234abcd:l,d2:l:1)@(0)",	MIPRE },
    { "@(0x1234abcd:l,d2:l:2)@(0)",	MIPRE },
    { "@(0x1234abcd:l,d2:l:4)@(0)",	MIPRE },
    { "@(0x1234abcd:l,d2:l:8)@(0)",	MIPRE },
    { "@(0x1234abcd:l,a5:w:1)@(0)",	MIPRE },
    { "@(0x1234abcd:l,a5:w:2)@(0)",	MIPRE },
    { "@(0x1234abcd:l,a5:w:4)@(0)",	MIPRE },
    { "@(0x1234abcd:l,a5:w:8)@(0)",	MIPRE },
    { "@(0x1234abcd:l,a5:l:1)@(0)",	MIPRE },
    { "@(0x1234abcd:l,a5:l:2)@(0)",	MIPRE },
    { "@(0x1234abcd:l,a5:l:4)@(0)",	MIPRE },
    { "@(0x1234abcd:l,a5:l:8)@(0)",	MIPRE },
    { "a3@(0)@(0xfeed:w)",	MIPRE },
    { "a3@(0,d2:w:1)@(0xfeed:w)",	MIPRE },
    { "a3@(0,d2:w:2)@(0xfeed:w)",	MIPRE },
    { "a3@(0,d2:w:4)@(0xfeed:w)",	MIPRE },
    { "a3@(0,d2:w:8)@(0xfeed:w)",	MIPRE },
    { "a3@(0,d2:l:1)@(0xfeed:w)",	MIPRE },
    { "a3@(0,d2:l:2)@(0xfeed:w)",	MIPRE },
    { "a3@(0,d2:l:4)@(0xfeed:w)",	MIPRE },
    { "a3@(0,d2:l:8)@(0xfeed:w)",	MIPRE },
    { "a3@(0,a5:w:1)@(0xfeed:w)",	MIPRE },
    { "a3@(0,a5:w:2)@(0xfeed:w)",	MIPRE },
    { "a3@(0,a5:w:4)@(0xfeed:w)",	MIPRE },
    { "a3@(0,a5:w:8)@(0xfeed:w)",	MIPRE },
    { "a3@(0,a5:l:1)@(0xfeed:w)",	MIPRE },
    { "a3@(0,a5:l:2)@(0xfeed:w)",	MIPRE },
    { "a3@(0,a5:l:4)@(0xfeed:w)",	MIPRE },
    { "a3@(0,a5:l:8)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,d2:w:1)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,d2:w:2)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,d2:w:4)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,d2:w:8)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,d2:l:1)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,d2:l:2)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,d2:l:4)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,d2:l:8)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,a5:w:1)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,a5:w:2)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,a5:w:4)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,a5:w:8)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,a5:l:1)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,a5:l:2)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,a5:l:4)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234:w,a5:l:8)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:w:1)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:w:2)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:w:4)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:w:8)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:l:1)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:l:2)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:l:4)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:l:8)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:w:1)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:w:2)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:w:4)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:w:8)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:l:1)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:l:2)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:l:4)@(0xfeed:w)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:l:8)@(0xfeed:w)",	MIPRE },
    { "@(0)@(0xfeed:w)",	MIPRE },
    { "@(0,d2:w:1)@(0xfeed:w)",	MIPRE },
    { "@(0,d2:w:2)@(0xfeed:w)",	MIPRE },
    { "@(0,d2:w:4)@(0xfeed:w)",	MIPRE },
    { "@(0,d2:w:8)@(0xfeed:w)",	MIPRE },
    { "@(0,d2:l:1)@(0xfeed:w)",	MIPRE },
    { "@(0,d2:l:2)@(0xfeed:w)",	MIPRE },
    { "@(0,d2:l:4)@(0xfeed:w)",	MIPRE },
    { "@(0,d2:l:8)@(0xfeed:w)",	MIPRE },
    { "@(0,a5:w:1)@(0xfeed:w)",	MIPRE },
    { "@(0,a5:w:2)@(0xfeed:w)",	MIPRE },
    { "@(0,a5:w:4)@(0xfeed:w)",	MIPRE },
    { "@(0,a5:w:8)@(0xfeed:w)",	MIPRE },
    { "@(0,a5:l:1)@(0xfeed:w)",	MIPRE },
    { "@(0,a5:l:2)@(0xfeed:w)",	MIPRE },
    { "@(0,a5:l:4)@(0xfeed:w)",	MIPRE },
    { "@(0,a5:l:8)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,d2:w:1)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,d2:w:2)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,d2:w:4)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,d2:w:8)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,d2:l:1)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,d2:l:2)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,d2:l:4)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,d2:l:8)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,a5:w:1)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,a5:w:2)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,a5:w:4)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,a5:w:8)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,a5:l:1)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,a5:l:2)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,a5:l:4)@(0xfeed:w)",	MIPRE },
    { "@(0x1234:w,a5:l:8)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,d2:w:1)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,d2:w:2)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,d2:w:4)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,d2:w:8)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,d2:l:1)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,d2:l:2)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,d2:l:4)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,d2:l:8)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,a5:w:1)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,a5:w:2)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,a5:w:4)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,a5:w:8)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,a5:l:1)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,a5:l:2)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,a5:l:4)@(0xfeed:w)",	MIPRE },
    { "@(0x1234abcd:l,a5:l:8)@(0xfeed:w)",	MIPRE },
    { "a3@(0)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,d2:w:1)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,d2:w:2)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,d2:w:4)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,d2:w:8)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,d2:l:1)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,d2:l:2)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,d2:l:4)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,d2:l:8)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,a5:w:1)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,a5:w:2)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,a5:w:4)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,a5:w:8)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,a5:l:1)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,a5:l:2)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,a5:l:4)@(0xfeedface:l)",	MIPRE },
    { "a3@(0,a5:l:8)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,d2:w:1)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,d2:w:2)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,d2:w:4)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,d2:w:8)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,d2:l:1)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,d2:l:2)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,d2:l:4)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,d2:l:8)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,a5:w:1)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,a5:w:2)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,a5:w:4)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,a5:w:8)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,a5:l:1)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,a5:l:2)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,a5:l:4)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234:w,a5:l:8)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:w:1)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:w:2)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:w:4)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:w:8)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:l:1)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:l:2)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:l:4)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,d2:l:8)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:w:1)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:w:2)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:w:4)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:w:8)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:l:1)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:l:2)@(0xfeedface:l)",	MIPRE },
    { "a3@(0x1234abcd:l,a5:l:4)@(0xfeedface:l)",	MIPRE },
#endif /* ALL_OPERANDS */
    { "a3@(0x1234abcd:l,a5:l:8)@(0xfeedface:l)",	MIPRE },
#ifdef ALL_OPERANDS
    { "@(0)@(0xfeedface:l)",	MIPRE },
    { "@(0,d2:w:1)@(0xfeedface:l)",	MIPRE },
    { "@(0,d2:w:2)@(0xfeedface:l)",	MIPRE },
    { "@(0,d2:w:4)@(0xfeedface:l)",	MIPRE },
    { "@(0,d2:w:8)@(0xfeedface:l)",	MIPRE },
    { "@(0,d2:l:1)@(0xfeedface:l)",	MIPRE },
    { "@(0,d2:l:2)@(0xfeedface:l)",	MIPRE },
    { "@(0,d2:l:4)@(0xfeedface:l)",	MIPRE },
    { "@(0,d2:l:8)@(0xfeedface:l)",	MIPRE },
    { "@(0,a5:w:1)@(0xfeedface:l)",	MIPRE },
    { "@(0,a5:w:2)@(0xfeedface:l)",	MIPRE },
    { "@(0,a5:w:4)@(0xfeedface:l)",	MIPRE },
    { "@(0,a5:w:8)@(0xfeedface:l)",	MIPRE },
    { "@(0,a5:l:1)@(0xfeedface:l)",	MIPRE },
    { "@(0,a5:l:2)@(0xfeedface:l)",	MIPRE },
    { "@(0,a5:l:4)@(0xfeedface:l)",	MIPRE },
    { "@(0,a5:l:8)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,d2:w:1)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,d2:w:2)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,d2:w:4)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,d2:w:8)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,d2:l:1)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,d2:l:2)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,d2:l:4)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,d2:l:8)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,a5:w:1)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,a5:w:2)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,a5:w:4)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,a5:w:8)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,a5:l:1)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,a5:l:2)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,a5:l:4)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234:w,a5:l:8)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,d2:w:1)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,d2:w:2)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,d2:w:4)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,d2:w:8)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,d2:l:1)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,d2:l:2)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,d2:l:4)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,d2:l:8)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,a5:w:1)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,a5:w:2)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,a5:w:4)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,a5:w:8)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,a5:l:1)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,a5:l:2)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,a5:l:4)@(0xfeedface:l)",	MIPRE },
    { "@(0x1234abcd:l,a5:l:8)@(0xfeedface:l)",	MIPRE },
#endif /* ALL_OPERANDS */
/* An@(bd)@(od,Xn) "Memory Indirect with Postindexed" ([bd,An],Xn,od)
   uses Full Format Extension Word(s) */
#ifdef ALL_OPERANDS
    { "a3@(0)@(0)",	MIPOST },
    { "a3@(0)@(0,d2:w:1)",	MIPOST },
    { "a3@(0)@(0,d2:w:2)",	MIPOST },
    { "a3@(0)@(0,d2:w:4)",	MIPOST },
    { "a3@(0)@(0,d2:w:8)",	MIPOST },
    { "a3@(0)@(0,d2:l:1)",	MIPOST },
    { "a3@(0)@(0,d2:l:2)",	MIPOST },
    { "a3@(0)@(0,d2:l:4)",	MIPOST },
    { "a3@(0)@(0,d2:l:8)",	MIPOST },
    { "a3@(0)@(0,a5:w:1)",	MIPOST },
    { "a3@(0)@(0,a5:w:2)",	MIPOST },
    { "a3@(0)@(0,a5:w:4)",	MIPOST },
    { "a3@(0)@(0,a5:w:8)",	MIPOST },
    { "a3@(0)@(0,a5:l:1)",	MIPOST },
    { "a3@(0)@(0,a5:l:2)",	MIPOST },
    { "a3@(0)@(0,a5:l:4)",	MIPOST },
    { "a3@(0)@(0,a5:l:8)",	MIPOST },
    { "a3@(0x1234:w)@(0,d2:w:1)",	MIPOST },
    { "a3@(0x1234:w)@(0,d2:w:2)",	MIPOST },
    { "a3@(0x1234:w)@(0,d2:w:4)",	MIPOST },
    { "a3@(0x1234:w)@(0,d2:w:8)",	MIPOST },
    { "a3@(0x1234:w)@(0,d2:l:1)",	MIPOST },
    { "a3@(0x1234:w)@(0,d2:l:2)",	MIPOST },
    { "a3@(0x1234:w)@(0,d2:l:4)",	MIPOST },
    { "a3@(0x1234:w)@(0,d2:l:8)",	MIPOST },
    { "a3@(0x1234:w)@(0,a5:w:1)",	MIPOST },
    { "a3@(0x1234:w)@(0,a5:w:2)",	MIPOST },
    { "a3@(0x1234:w)@(0,a5:w:4)",	MIPOST },
    { "a3@(0x1234:w)@(0,a5:w:8)",	MIPOST },
    { "a3@(0x1234:w)@(0,a5:l:1)",	MIPOST },
    { "a3@(0x1234:w)@(0,a5:l:2)",	MIPOST },
    { "a3@(0x1234:w)@(0,a5:l:4)",	MIPOST },
    { "a3@(0x1234:w)@(0,a5:l:8)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,d2:w:1)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,d2:w:2)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,d2:w:4)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,d2:w:8)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,d2:l:1)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,d2:l:2)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,d2:l:4)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,d2:l:8)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,a5:w:1)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,a5:w:2)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,a5:w:4)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,a5:w:8)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,a5:l:1)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,a5:l:2)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,a5:l:4)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0,a5:l:8)",	MIPOST },
    { "@(0)@(0)",	MIPOST },
    { "@(0)@(0,d2:w:1)",	MIPOST },
    { "@(0)@(0,d2:w:2)",	MIPOST },
    { "@(0)@(0,d2:w:4)",	MIPOST },
    { "@(0)@(0,d2:w:8)",	MIPOST },
    { "@(0)@(0,d2:l:1)",	MIPOST },
    { "@(0)@(0,d2:l:2)",	MIPOST },
    { "@(0)@(0,d2:l:4)",	MIPOST },
    { "@(0)@(0,d2:l:8)",	MIPOST },
    { "@(0)@(0,a5:w:1)",	MIPOST },
    { "@(0)@(0,a5:w:2)",	MIPOST },
    { "@(0)@(0,a5:w:4)",	MIPOST },
    { "@(0)@(0,a5:w:8)",	MIPOST },
    { "@(0)@(0,a5:l:1)",	MIPOST },
    { "@(0)@(0,a5:l:2)",	MIPOST },
    { "@(0)@(0,a5:l:4)",	MIPOST },
    { "@(0)@(0,a5:l:8)",	MIPOST },
    { "@(0x1234:w)@(0,d2:w:1)",	MIPOST },
    { "@(0x1234:w)@(0,d2:w:2)",	MIPOST },
    { "@(0x1234:w)@(0,d2:w:4)",	MIPOST },
    { "@(0x1234:w)@(0,d2:w:8)",	MIPOST },
    { "@(0x1234:w)@(0,d2:l:1)",	MIPOST },
    { "@(0x1234:w)@(0,d2:l:2)",	MIPOST },
    { "@(0x1234:w)@(0,d2:l:4)",	MIPOST },
    { "@(0x1234:w)@(0,d2:l:8)",	MIPOST },
    { "@(0x1234:w)@(0,a5:w:1)",	MIPOST },
    { "@(0x1234:w)@(0,a5:w:2)",	MIPOST },
    { "@(0x1234:w)@(0,a5:w:4)",	MIPOST },
    { "@(0x1234:w)@(0,a5:w:8)",	MIPOST },
    { "@(0x1234:w)@(0,a5:l:1)",	MIPOST },
    { "@(0x1234:w)@(0,a5:l:2)",	MIPOST },
    { "@(0x1234:w)@(0,a5:l:4)",	MIPOST },
    { "@(0x1234:w)@(0,a5:l:8)",	MIPOST },
    { "@(0x1234abcd:l)@(0,d2:w:1)",	MIPOST },
    { "@(0x1234abcd:l)@(0,d2:w:2)",	MIPOST },
    { "@(0x1234abcd:l)@(0,d2:w:4)",	MIPOST },
    { "@(0x1234abcd:l)@(0,d2:w:8)",	MIPOST },
    { "@(0x1234abcd:l)@(0,d2:l:1)",	MIPOST },
    { "@(0x1234abcd:l)@(0,d2:l:2)",	MIPOST },
    { "@(0x1234abcd:l)@(0,d2:l:4)",	MIPOST },
    { "@(0x1234abcd:l)@(0,d2:l:8)",	MIPOST },
    { "@(0x1234abcd:l)@(0,a5:w:1)",	MIPOST },
    { "@(0x1234abcd:l)@(0,a5:w:2)",	MIPOST },
    { "@(0x1234abcd:l)@(0,a5:w:4)",	MIPOST },
    { "@(0x1234abcd:l)@(0,a5:w:8)",	MIPOST },
    { "@(0x1234abcd:l)@(0,a5:l:1)",	MIPOST },
    { "@(0x1234abcd:l)@(0,a5:l:2)",	MIPOST },
    { "@(0x1234abcd:l)@(0,a5:l:4)",	MIPOST },
    { "@(0x1234abcd:l)@(0,a5:l:8)",	MIPOST },
    { "a3@(0)@(0xfeed:w)",	MIPOST },
    { "a3@(0)@(0xfeed:w,d2:w:1)",	MIPOST },
    { "a3@(0)@(0xfeed:w,d2:w:2)",	MIPOST },
    { "a3@(0)@(0xfeed:w,d2:w:4)",	MIPOST },
    { "a3@(0)@(0xfeed:w,d2:w:8)",	MIPOST },
    { "a3@(0)@(0xfeed:w,d2:l:1)",	MIPOST },
    { "a3@(0)@(0xfeed:w,d2:l:2)",	MIPOST },
    { "a3@(0)@(0xfeed:w,d2:l:4)",	MIPOST },
    { "a3@(0)@(0xfeed:w,d2:l:8)",	MIPOST },
    { "a3@(0)@(0xfeed:w,a5:w:1)",	MIPOST },
    { "a3@(0)@(0xfeed:w,a5:w:2)",	MIPOST },
    { "a3@(0)@(0xfeed:w,a5:w:4)",	MIPOST },
    { "a3@(0)@(0xfeed:w,a5:w:8)",	MIPOST },
    { "a3@(0)@(0xfeed:w,a5:l:1)",	MIPOST },
    { "a3@(0)@(0xfeed:w,a5:l:2)",	MIPOST },
    { "a3@(0)@(0xfeed:w,a5:l:4)",	MIPOST },
    { "a3@(0)@(0xfeed:w,a5:l:8)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,d2:w:1)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,d2:w:2)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,d2:w:4)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,d2:w:8)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,d2:l:1)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,d2:l:2)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,d2:l:4)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,d2:l:8)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,a5:w:1)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,a5:w:2)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,a5:w:4)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,a5:w:8)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,a5:l:1)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,a5:l:2)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,a5:l:4)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeed:w,a5:l:8)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,d2:w:1)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,d2:w:2)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,d2:w:4)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,d2:w:8)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,d2:l:1)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,d2:l:2)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,d2:l:4)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,d2:l:8)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,a5:w:1)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,a5:w:2)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,a5:w:4)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,a5:w:8)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,a5:l:1)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,a5:l:2)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,a5:l:4)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeed:w,a5:l:8)",	MIPOST },
    { "@(0)@(0xfeed:w)",	MIPOST },
    { "@(0)@(0xfeed:w,d2:w:1)",	MIPOST },
    { "@(0)@(0xfeed:w,d2:w:2)",	MIPOST },
    { "@(0)@(0xfeed:w,d2:w:4)",	MIPOST },
    { "@(0)@(0xfeed:w,d2:w:8)",	MIPOST },
    { "@(0)@(0xfeed:w,d2:l:1)",	MIPOST },
    { "@(0)@(0xfeed:w,d2:l:2)",	MIPOST },
    { "@(0)@(0xfeed:w,d2:l:4)",	MIPOST },
    { "@(0)@(0xfeed:w,d2:l:8)",	MIPOST },
    { "@(0)@(0xfeed:w,a5:w:1)",	MIPOST },
    { "@(0)@(0xfeed:w,a5:w:2)",	MIPOST },
    { "@(0)@(0xfeed:w,a5:w:4)",	MIPOST },
    { "@(0)@(0xfeed:w,a5:w:8)",	MIPOST },
    { "@(0)@(0xfeed:w,a5:l:1)",	MIPOST },
    { "@(0)@(0xfeed:w,a5:l:2)",	MIPOST },
    { "@(0)@(0xfeed:w,a5:l:4)",	MIPOST },
    { "@(0)@(0xfeed:w,a5:l:8)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,d2:w:1)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,d2:w:2)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,d2:w:4)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,d2:w:8)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,d2:l:1)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,d2:l:2)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,d2:l:4)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,d2:l:8)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,a5:w:1)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,a5:w:2)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,a5:w:4)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,a5:w:8)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,a5:l:1)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,a5:l:2)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,a5:l:4)",	MIPOST },
    { "@(0x1234:w)@(0xfeed:w,a5:l:8)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,d2:w:1)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,d2:w:2)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,d2:w:4)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,d2:w:8)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,d2:l:1)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,d2:l:2)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,d2:l:4)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,d2:l:8)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,a5:w:1)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,a5:w:2)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,a5:w:4)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,a5:w:8)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,a5:l:1)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,a5:l:2)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,a5:l:4)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeed:w,a5:l:8)",	MIPOST },
    { "a3@(0)@(0xfeedface:l)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,d2:w:1)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,d2:w:2)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,d2:w:4)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,d2:w:8)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,d2:l:1)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,d2:l:2)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,d2:l:4)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,d2:l:8)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,a5:w:1)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,a5:w:2)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,a5:w:4)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,a5:w:8)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,a5:l:1)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,a5:l:2)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,a5:l:4)",	MIPOST },
    { "a3@(0)@(0xfeedface:l,a5:l:8)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,d2:w:1)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,d2:w:2)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,d2:w:4)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,d2:w:8)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,d2:l:1)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,d2:l:2)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,d2:l:4)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,d2:l:8)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,a5:w:1)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,a5:w:2)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,a5:w:4)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,a5:w:8)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,a5:l:1)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,a5:l:2)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,a5:l:4)",	MIPOST },
    { "a3@(0x1234:w)@(0xfeedface:l,a5:l:8)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,d2:w:1)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,d2:w:2)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,d2:w:4)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,d2:w:8)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,d2:l:1)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,d2:l:2)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,d2:l:4)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,d2:l:8)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,a5:w:1)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,a5:w:2)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,a5:w:4)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,a5:w:8)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,a5:l:1)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,a5:l:2)",	MIPOST },
    { "a3@(0x1234abcd:l)@(0xfeedface:l,a5:l:4)",	MIPOST },
#endif /* ALL_OPERANDS */
    { "a3@(0x1234abcd:l)@(0xfeedface:l,a5:l:8)",	MIPOST },
#ifdef ALL_OPERANDS
    { "@(0)@(0xfeedface:l)",	MIPOST },
    { "@(0)@(0xfeedface:l,d2:w:1)",	MIPOST },
    { "@(0)@(0xfeedface:l,d2:w:2)",	MIPOST },
    { "@(0)@(0xfeedface:l,d2:w:4)",	MIPOST },
    { "@(0)@(0xfeedface:l,d2:w:8)",	MIPOST },
    { "@(0)@(0xfeedface:l,d2:l:1)",	MIPOST },
    { "@(0)@(0xfeedface:l,d2:l:2)",	MIPOST },
    { "@(0)@(0xfeedface:l,d2:l:4)",	MIPOST },
    { "@(0)@(0xfeedface:l,d2:l:8)",	MIPOST },
    { "@(0)@(0xfeedface:l,a5:w:1)",	MIPOST },
    { "@(0)@(0xfeedface:l,a5:w:2)",	MIPOST },
    { "@(0)@(0xfeedface:l,a5:w:4)",	MIPOST },
    { "@(0)@(0xfeedface:l,a5:w:8)",	MIPOST },
    { "@(0)@(0xfeedface:l,a5:l:1)",	MIPOST },
    { "@(0)@(0xfeedface:l,a5:l:2)",	MIPOST },
    { "@(0)@(0xfeedface:l,a5:l:4)",	MIPOST },
    { "@(0)@(0xfeedface:l,a5:l:8)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,d2:w:1)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,d2:w:2)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,d2:w:4)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,d2:w:8)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,d2:l:1)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,d2:l:2)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,d2:l:4)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,d2:l:8)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,a5:w:1)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,a5:w:2)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,a5:w:4)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,a5:w:8)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,a5:l:1)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,a5:l:2)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,a5:l:4)",	MIPOST },
    { "@(0x1234:w)@(0xfeedface:l,a5:l:8)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,d2:w:1)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,d2:w:2)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,d2:w:4)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,d2:w:8)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,d2:l:1)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,d2:l:2)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,d2:l:4)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,d2:l:8)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,a5:w:1)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,a5:w:2)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,a5:w:4)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,a5:w:8)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,a5:l:1)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,a5:l:2)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,a5:l:4)",	MIPOST },
    { "@(0x1234abcd:l)@(0xfeedface:l,a5:l:8)",	MIPOST },
#endif /* ALL_OPERANDS */

/* xxx:w "Absolute Short" (xxx).W */
    { "0x1bad:w",	ABSW },
/* xxx:l "Absolute Long" (xxx).L */
    { "0xbad1add2:l",	ABSL },
/* #data "Immediate" #<data> */
    { "#0x3",		IMMED },

/* pc@(d16) "Program Counter Indirect with Displacement" (d16,PC)
    { "pc@(0x1234)",	PCd16 },
/* pc@(d8,Xn) "Program Counter Indirect with Index (8-Bit Displacement)"
   uses Brief Format Extension Word (d8,PC,Xn) */
#ifdef ALL_OPERANDS
    { "pc@(0x12:b,d2:w:1)",	PCd8Xn },
    { "pc@(0x12:b,d2:w:2)",	PCd8Xn },
    { "pc@(0x12:b,d2:w:4)",	PCd8Xn },
    { "pc@(0x12:b,d2:w:8)",	PCd8Xn },
    { "pc@(0x12:b,d2:l:1)",	PCd8Xn },
    { "pc@(0x12:b,d2:l:2)",	PCd8Xn },
    { "pc@(0x12:b,d2:l:4)",	PCd8Xn },
    { "pc@(0x12:b,d2:l:8)",	PCd8Xn },
    { "pc@(0x12:b,a5:w:1)",	PCd8Xn },
    { "pc@(0x12:b,a5:w:2)",	PCd8Xn },
    { "pc@(0x12:b,a5:w:4)",	PCd8Xn },
    { "pc@(0x12:b,a5:w:8)",	PCd8Xn },
    { "pc@(0x12:b,a5:l:1)",	PCd8Xn },
    { "pc@(0x12:b,a5:l:2)",	PCd8Xn },
    { "pc@(0x12:b,a5:l:4)",	PCd8Xn },
#endif /* ALL_OPERANDS */
    { "pc@(0x12:b,a5:l:8)",	PCd8Xn },

/* pc@(bd,Xn) "Program Counter Indirect with Index (Base Displacement)"
   uses Full Format Extension Word(s) (bd,PC,Xn) */
#ifdef ALL_OPERANDS
/* the form of pc@(bd,Xn) with bd (base displacement) encoded as a null
   displacement will not be generated by the assembler because it will use
   the form pc(d8,Xn).
    { "pc@(0)",			PCbdXn },
    { "pc@(0,d2:w:1)",		PCbdXn },
    { "pc@(0,d2:w:2)",		PCbdXn },
    { "pc@(0,d2:w:4)",		PCbdXn },
    { "pc@(0,d2:w:8)",		PCbdXn },
    { "pc@(0,d2:l:1)",		PCbdXn },
    { "pc@(0,d2:l:2)",		PCbdXn },
    { "pc@(0,d2:l:4)",		PCbdXn },
    { "pc@(0,d2:l:8)",		PCbdXn },
    { "pc@(0,a5:w:1)",		PCbdXn },
    { "pc@(0,a5:w:2)",		PCbdXn },
    { "pc@(0,a5:w:4)",		PCbdXn },
    { "pc@(0,a5:w:8)",		PCbdXn },
    { "pc@(0,a5:l:1)",		PCbdXn },
    { "pc@(0,a5:l:2)",		PCbdXn },
    { "pc@(0,a5:l:4)",		PCbdXn },
    { "pc@(0,a5:l:8)",		PCbdXn },
*/
    { "pc@(0x1234:w,d2:w:1)",	PCbdXn },
    { "pc@(0x1234:w,d2:w:2)",	PCbdXn },
    { "pc@(0x1234:w,d2:w:4)",	PCbdXn },
    { "pc@(0x1234:w,d2:w:8)",	PCbdXn },
    { "pc@(0x1234:w,d2:l:1)",	PCbdXn },
    { "pc@(0x1234:w,d2:l:2)",	PCbdXn },
    { "pc@(0x1234:w,d2:l:4)",	PCbdXn },
    { "pc@(0x1234:w,d2:l:8)",	PCbdXn },
    { "pc@(0x1234:w,a5:w:1)",	PCbdXn },
    { "pc@(0x1234:w,a5:w:2)",	PCbdXn },
    { "pc@(0x1234:w,a5:w:4)",	PCbdXn },
    { "pc@(0x1234:w,a5:w:8)",	PCbdXn },
    { "pc@(0x1234:w,a5:l:1)",	PCbdXn },
    { "pc@(0x1234:w,a5:l:2)",	PCbdXn },
    { "pc@(0x1234:w,a5:l:4)",	PCbdXn },
    { "pc@(0x1234:w,a5:l:8)",	PCbdXn },
    { "pc@(0x1234abcd:l,d2:w:1)",	PCbdXn },
    { "pc@(0x1234abcd:l,d2:w:2)",	PCbdXn },
    { "pc@(0x1234abcd:l,d2:w:4)",	PCbdXn },
    { "pc@(0x1234abcd:l,d2:w:8)",	PCbdXn },
    { "pc@(0x1234abcd:l,d2:l:1)",	PCbdXn },
    { "pc@(0x1234abcd:l,d2:l:2)",	PCbdXn },
    { "pc@(0x1234abcd:l,d2:l:4)",	PCbdXn },
    { "pc@(0x1234abcd:l,d2:l:8)",	PCbdXn },
    { "pc@(0x1234abcd:l,a5:w:1)",	PCbdXn },
    { "pc@(0x1234abcd:l,a5:w:2)",	PCbdXn },
    { "pc@(0x1234abcd:l,a5:w:4)",	PCbdXn },
    { "pc@(0x1234abcd:l,a5:w:8)",	PCbdXn },
    { "pc@(0x1234abcd:l,a5:l:1)",	PCbdXn },
    { "pc@(0x1234abcd:l,a5:l:2)",	PCbdXn },
    { "pc@(0x1234abcd:l,a5:l:4)",	PCbdXn },
#endif /* ALL_OPERANDS */
    { "pc@(0x1234abcd:l,a5:l:8)",	PCbdXn },
#ifdef ALL_OPERANDS
    { "zpc@(0)",				PCbdXn },
    { "zpc@(0,d2:w:1)",			PCbdXn },
    { "zpc@(0,d2:w:2)",			PCbdXn },
    { "zpc@(0,d2:w:4)",			PCbdXn },
    { "zpc@(0,d2:w:8)",			PCbdXn },
    { "zpc@(0,d2:l:1)",			PCbdXn },
    { "zpc@(0,d2:l:2)",			PCbdXn },
    { "zpc@(0,d2:l:4)",			PCbdXn },
    { "zpc@(0,d2:l:8)",			PCbdXn },
    { "zpc@(0,a5:w:1)",			PCbdXn },
    { "zpc@(0,a5:w:2)",			PCbdXn },
    { "zpc@(0,a5:w:4)",			PCbdXn },
    { "zpc@(0,a5:w:8)",			PCbdXn },
    { "zpc@(0,a5:l:1)",			PCbdXn },
    { "zpc@(0,a5:l:2)",			PCbdXn },
    { "zpc@(0,a5:l:4)",			PCbdXn },
    { "zpc@(0,a5:l:8)",			PCbdXn },
    { "zpc@(0x1234:w,d2:w:1)",			PCbdXn },
    { "zpc@(0x1234:w,d2:w:2)",			PCbdXn },
    { "zpc@(0x1234:w,d2:w:4)",			PCbdXn },
    { "zpc@(0x1234:w,d2:w:8)",			PCbdXn },
    { "zpc@(0x1234:w,d2:l:1)",			PCbdXn },
    { "zpc@(0x1234:w,d2:l:2)",			PCbdXn },
    { "zpc@(0x1234:w,d2:l:4)",			PCbdXn },
    { "zpc@(0x1234:w,d2:l:8)",			PCbdXn },
    { "zpc@(0x1234:w,a5:w:1)",			PCbdXn },
    { "zpc@(0x1234:w,a5:w:2)",			PCbdXn },
    { "zpc@(0x1234:w,a5:w:4)",			PCbdXn },
    { "zpc@(0x1234:w,a5:w:8)",			PCbdXn },
    { "zpc@(0x1234:w,a5:l:1)",			PCbdXn },
    { "zpc@(0x1234:w,a5:l:2)",			PCbdXn },
    { "zpc@(0x1234:w,a5:l:4)",			PCbdXn },
    { "zpc@(0x1234:w,a5:l:8)",			PCbdXn },
    { "zpc@(0x1234abcd:l,d2:w:1)",			PCbdXn },
    { "zpc@(0x1234abcd:l,d2:w:2)",			PCbdXn },
    { "zpc@(0x1234abcd:l,d2:w:4)",			PCbdXn },
    { "zpc@(0x1234abcd:l,d2:w:8)",			PCbdXn },
    { "zpc@(0x1234abcd:l,d2:l:1)",			PCbdXn },
    { "zpc@(0x1234abcd:l,d2:l:2)",			PCbdXn },
    { "zpc@(0x1234abcd:l,d2:l:4)",			PCbdXn },
    { "zpc@(0x1234abcd:l,d2:l:8)",			PCbdXn },
    { "zpc@(0x1234abcd:l,a5:w:1)",			PCbdXn },
    { "zpc@(0x1234abcd:l,a5:w:2)",			PCbdXn },
    { "zpc@(0x1234abcd:l,a5:w:4)",			PCbdXn },
    { "zpc@(0x1234abcd:l,a5:w:8)",			PCbdXn },
    { "zpc@(0x1234abcd:l,a5:l:1)",			PCbdXn },
    { "zpc@(0x1234abcd:l,a5:l:2)",			PCbdXn },
    { "zpc@(0x1234abcd:l,a5:l:4)",			PCbdXn },
#endif /* ALL_OPERANDS */
    { "zpc@(0x1234abcd:l,a5:l:8)",			PCbdXn },
/* pc@(bd,Xn)@(od) "Program Counter Memory Indirect with Preindexed"
   uses Full Format Extension Word(s) ([bd,PC,Xn],od) */
#ifdef ALL_OPERANDS
    { "pc@(0)@(0)",	PCMIPRE },
    { "pc@(0,d2:w:1)@(0)",	PCMIPRE },
    { "pc@(0,d2:w:2)@(0)",	PCMIPRE },
    { "pc@(0,d2:w:4)@(0)",	PCMIPRE },
    { "pc@(0,d2:w:8)@(0)",	PCMIPRE },
    { "pc@(0,d2:l:1)@(0)",	PCMIPRE },
    { "pc@(0,d2:l:2)@(0)",	PCMIPRE },
    { "pc@(0,d2:l:4)@(0)",	PCMIPRE },
    { "pc@(0,d2:l:8)@(0)",	PCMIPRE },
    { "pc@(0,a5:w:1)@(0)",	PCMIPRE },
    { "pc@(0,a5:w:2)@(0)",	PCMIPRE },
    { "pc@(0,a5:w:4)@(0)",	PCMIPRE },
    { "pc@(0,a5:w:8)@(0)",	PCMIPRE },
    { "pc@(0,a5:l:1)@(0)",	PCMIPRE },
    { "pc@(0,a5:l:2)@(0)",	PCMIPRE },
    { "pc@(0,a5:l:4)@(0)",	PCMIPRE },
    { "pc@(0,a5:l:8)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,d2:w:1)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,d2:w:2)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,d2:w:4)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,d2:w:8)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,d2:l:1)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,d2:l:2)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,d2:l:4)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,d2:l:8)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,a5:w:1)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,a5:w:2)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,a5:w:4)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,a5:w:8)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,a5:l:1)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,a5:l:2)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,a5:l:4)@(0)",	PCMIPRE },
    { "pc@(0x1234:w,a5:l:8)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:w:1)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:w:2)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:w:4)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:w:8)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:l:1)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:l:2)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:l:4)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:l:8)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:w:1)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:w:2)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:w:4)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:w:8)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:l:1)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:l:2)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:l:4)@(0)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:l:8)@(0)",	PCMIPRE },
    { "zpc@(0)@(0)",	PCMIPRE },
    { "zpc@(0,d2:w:1)@(0)",	PCMIPRE },
    { "zpc@(0,d2:w:2)@(0)",	PCMIPRE },
    { "zpc@(0,d2:w:4)@(0)",	PCMIPRE },
    { "zpc@(0,d2:w:8)@(0)",	PCMIPRE },
    { "zpc@(0,d2:l:1)@(0)",	PCMIPRE },
    { "zpc@(0,d2:l:2)@(0)",	PCMIPRE },
    { "zpc@(0,d2:l:4)@(0)",	PCMIPRE },
    { "zpc@(0,d2:l:8)@(0)",	PCMIPRE },
    { "zpc@(0,a5:w:1)@(0)",	PCMIPRE },
    { "zpc@(0,a5:w:2)@(0)",	PCMIPRE },
    { "zpc@(0,a5:w:4)@(0)",	PCMIPRE },
    { "zpc@(0,a5:w:8)@(0)",	PCMIPRE },
    { "zpc@(0,a5:l:1)@(0)",	PCMIPRE },
    { "zpc@(0,a5:l:2)@(0)",	PCMIPRE },
    { "zpc@(0,a5:l:4)@(0)",	PCMIPRE },
    { "zpc@(0,a5:l:8)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:w:1)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:w:2)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:w:4)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:w:8)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:l:1)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:l:2)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:l:4)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:l:8)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:w:1)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:w:2)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:w:4)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:w:8)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:l:1)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:l:2)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:l:4)@(0)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:l:8)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:w:1)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:w:2)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:w:4)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:w:8)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:l:1)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:l:2)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:l:4)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:l:8)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:w:1)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:w:2)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:w:4)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:w:8)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:l:1)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:l:2)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:l:4)@(0)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:l:8)@(0)",	PCMIPRE },
    { "pc@(0)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,d2:w:1)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,d2:w:2)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,d2:w:4)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,d2:w:8)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,d2:l:1)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,d2:l:2)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,d2:l:4)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,d2:l:8)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,a5:w:1)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,a5:w:2)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,a5:w:4)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,a5:w:8)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,a5:l:1)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,a5:l:2)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,a5:l:4)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0,a5:l:8)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,d2:w:1)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,d2:w:2)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,d2:w:4)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,d2:w:8)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,d2:l:1)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,d2:l:2)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,d2:l:4)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,d2:l:8)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,a5:w:1)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,a5:w:2)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,a5:w:4)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,a5:w:8)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,a5:l:1)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,a5:l:2)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,a5:l:4)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234:w,a5:l:8)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:w:1)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:w:2)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:w:4)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:w:8)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:l:1)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:l:2)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:l:4)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:l:8)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:w:1)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:w:2)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:w:4)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:w:8)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:l:1)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:l:2)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:l:4)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:l:8)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,d2:w:1)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,d2:w:2)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,d2:w:4)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,d2:w:8)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,d2:l:1)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,d2:l:2)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,d2:l:4)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,d2:l:8)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,a5:w:1)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,a5:w:2)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,a5:w:4)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,a5:w:8)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,a5:l:1)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,a5:l:2)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,a5:l:4)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0,a5:l:8)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:w:1)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:w:2)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:w:4)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:w:8)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:l:1)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:l:2)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:l:4)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:l:8)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:w:1)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:w:2)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:w:4)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:w:8)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:l:1)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:l:2)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:l:4)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:l:8)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:w:1)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:w:2)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:w:4)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:w:8)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:l:1)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:l:2)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:l:4)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:l:8)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:w:1)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:w:2)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:w:4)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:w:8)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:l:1)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:l:2)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:l:4)@(0xfeed:w)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:l:8)@(0xfeed:w)",	PCMIPRE },
    { "pc@(0)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,d2:w:1)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,d2:w:2)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,d2:w:4)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,d2:w:8)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,d2:l:1)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,d2:l:2)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,d2:l:4)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,d2:l:8)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,a5:w:1)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,a5:w:2)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,a5:w:4)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,a5:w:8)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,a5:l:1)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,a5:l:2)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,a5:l:4)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0,a5:l:8)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,d2:w:1)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,d2:w:2)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,d2:w:4)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,d2:w:8)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,d2:l:1)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,d2:l:2)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,d2:l:4)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,d2:l:8)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,a5:w:1)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,a5:w:2)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,a5:w:4)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,a5:w:8)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,a5:l:1)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,a5:l:2)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,a5:l:4)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234:w,a5:l:8)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:w:1)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:w:2)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:w:4)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:w:8)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:l:1)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:l:2)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:l:4)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,d2:l:8)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:w:1)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:w:2)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:w:4)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:w:8)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:l:1)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:l:2)@(0xfeedface:l)",	PCMIPRE },
    { "pc@(0x1234abcd:l,a5:l:4)@(0xfeedface:l)",	PCMIPRE },
#endif /* ALL_OPERANDS */
    { "pc@(0x1234abcd:l,a5:l:8)@(0xfeedface:l)",	PCMIPRE },
#ifdef ALL_OPERANDS
    { "zpc@(0)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,d2:w:1)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,d2:w:2)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,d2:w:4)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,d2:w:8)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,d2:l:1)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,d2:l:2)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,d2:l:4)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,d2:l:8)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,a5:w:1)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,a5:w:2)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,a5:w:4)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,a5:w:8)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,a5:l:1)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,a5:l:2)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,a5:l:4)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0,a5:l:8)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:w:1)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:w:2)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:w:4)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:w:8)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:l:1)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:l:2)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:l:4)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,d2:l:8)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:w:1)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:w:2)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:w:4)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:w:8)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:l:1)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:l:2)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:l:4)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234:w,a5:l:8)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:w:1)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:w:2)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:w:4)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:w:8)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:l:1)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:l:2)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:l:4)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,d2:l:8)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:w:1)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:w:2)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:w:4)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:w:8)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:l:1)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:l:2)@(0xfeedface:l)",	PCMIPRE },
    { "zpc@(0x1234abcd:l,a5:l:4)@(0xfeedface:l)",	PCMIPRE },
#endif /* ALL_OPERANDS */
    { "zpc@(0x1234abcd:l,a5:l:8)@(0xfeedface:l)",	PCMIPRE },
/* pc@(bd)@(od,Xn) "Program Counter Memory Indirect with Postindexed"
   uses Full Format Extension Word(s) ([bd,PC],Xn,od) */
#ifdef ALL_OPERANDS
    { "pc@(0)@(0)",	PCMIPOST },
    { "pc@(0)@(0,d2:w:1)",	PCMIPOST },
    { "pc@(0)@(0,d2:w:2)",	PCMIPOST },
    { "pc@(0)@(0,d2:w:4)",	PCMIPOST },
    { "pc@(0)@(0,d2:w:8)",	PCMIPOST },
    { "pc@(0)@(0,d2:l:1)",	PCMIPOST },
    { "pc@(0)@(0,d2:l:2)",	PCMIPOST },
    { "pc@(0)@(0,d2:l:4)",	PCMIPOST },
    { "pc@(0)@(0,d2:l:8)",	PCMIPOST },
    { "pc@(0)@(0,a5:w:1)",	PCMIPOST },
    { "pc@(0)@(0,a5:w:2)",	PCMIPOST },
    { "pc@(0)@(0,a5:w:4)",	PCMIPOST },
    { "pc@(0)@(0,a5:w:8)",	PCMIPOST },
    { "pc@(0)@(0,a5:l:1)",	PCMIPOST },
    { "pc@(0)@(0,a5:l:2)",	PCMIPOST },
    { "pc@(0)@(0,a5:l:4)",	PCMIPOST },
    { "pc@(0)@(0,a5:l:8)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,d2:w:1)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,d2:w:2)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,d2:w:4)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,d2:w:8)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,d2:l:1)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,d2:l:2)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,d2:l:4)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,d2:l:8)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,a5:w:1)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,a5:w:2)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,a5:w:4)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,a5:w:8)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,a5:l:1)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,a5:l:2)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,a5:l:4)",	PCMIPOST },
    { "pc@(0x1234:w)@(0,a5:l:8)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,d2:w:1)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,d2:w:2)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,d2:w:4)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,d2:w:8)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,d2:l:1)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,d2:l:2)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,d2:l:4)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,d2:l:8)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,a5:w:1)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,a5:w:2)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,a5:w:4)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,a5:w:8)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,a5:l:1)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,a5:l:2)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,a5:l:4)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0,a5:l:8)",	PCMIPOST },
    { "zpc@(0)@(0)",	PCMIPOST },
    { "zpc@(0)@(0,d2:w:1)",	PCMIPOST },
    { "zpc@(0)@(0,d2:w:2)",	PCMIPOST },
    { "zpc@(0)@(0,d2:w:4)",	PCMIPOST },
    { "zpc@(0)@(0,d2:w:8)",	PCMIPOST },
    { "zpc@(0)@(0,d2:l:1)",	PCMIPOST },
    { "zpc@(0)@(0,d2:l:2)",	PCMIPOST },
    { "zpc@(0)@(0,d2:l:4)",	PCMIPOST },
    { "zpc@(0)@(0,d2:l:8)",	PCMIPOST },
    { "zpc@(0)@(0,a5:w:1)",	PCMIPOST },
    { "zpc@(0)@(0,a5:w:2)",	PCMIPOST },
    { "zpc@(0)@(0,a5:w:4)",	PCMIPOST },
    { "zpc@(0)@(0,a5:w:8)",	PCMIPOST },
    { "zpc@(0)@(0,a5:l:1)",	PCMIPOST },
    { "zpc@(0)@(0,a5:l:2)",	PCMIPOST },
    { "zpc@(0)@(0,a5:l:4)",	PCMIPOST },
    { "zpc@(0)@(0,a5:l:8)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,d2:w:1)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,d2:w:2)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,d2:w:4)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,d2:w:8)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,d2:l:1)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,d2:l:2)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,d2:l:4)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,d2:l:8)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,a5:w:1)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,a5:w:2)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,a5:w:4)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,a5:w:8)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,a5:l:1)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,a5:l:2)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,a5:l:4)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0,a5:l:8)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,d2:w:1)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,d2:w:2)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,d2:w:4)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,d2:w:8)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,d2:l:1)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,d2:l:2)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,d2:l:4)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,d2:l:8)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,a5:w:1)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,a5:w:2)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,a5:w:4)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,a5:w:8)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,a5:l:1)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,a5:l:2)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,a5:l:4)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0,a5:l:8)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,d2:w:1)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,d2:w:2)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,d2:w:4)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,d2:w:8)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,d2:l:1)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,d2:l:2)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,d2:l:4)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,d2:l:8)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,a5:w:1)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,a5:w:2)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,a5:w:4)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,a5:w:8)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,a5:l:1)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,a5:l:2)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,a5:l:4)",	PCMIPOST },
    { "pc@(0)@(0xfeed:w,a5:l:8)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,d2:w:1)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,d2:w:2)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,d2:w:4)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,d2:w:8)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,d2:l:1)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,d2:l:2)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,d2:l:4)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,d2:l:8)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,a5:w:1)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,a5:w:2)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,a5:w:4)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,a5:w:8)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,a5:l:1)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,a5:l:2)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,a5:l:4)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeed:w,a5:l:8)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,d2:w:1)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,d2:w:2)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,d2:w:4)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,d2:w:8)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,d2:l:1)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,d2:l:2)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,d2:l:4)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,d2:l:8)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,a5:w:1)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,a5:w:2)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,a5:w:4)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,a5:w:8)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,a5:l:1)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,a5:l:2)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,a5:l:4)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeed:w,a5:l:8)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,d2:w:1)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,d2:w:2)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,d2:w:4)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,d2:w:8)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,d2:l:1)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,d2:l:2)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,d2:l:4)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,d2:l:8)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,a5:w:1)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,a5:w:2)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,a5:w:4)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,a5:w:8)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,a5:l:1)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,a5:l:2)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,a5:l:4)",	PCMIPOST },
    { "zpc@(0)@(0xfeed:w,a5:l:8)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,d2:w:1)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,d2:w:2)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,d2:w:4)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,d2:w:8)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,d2:l:1)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,d2:l:2)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,d2:l:4)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,d2:l:8)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,a5:w:1)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,a5:w:2)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,a5:w:4)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,a5:w:8)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,a5:l:1)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,a5:l:2)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,a5:l:4)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeed:w,a5:l:8)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,d2:w:1)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,d2:w:2)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,d2:w:4)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,d2:w:8)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,d2:l:1)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,d2:l:2)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,d2:l:4)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,d2:l:8)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,a5:w:1)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,a5:w:2)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,a5:w:4)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,a5:w:8)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,a5:l:1)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,a5:l:2)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,a5:l:4)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeed:w,a5:l:8)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,d2:w:1)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,d2:w:2)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,d2:w:4)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,d2:w:8)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,d2:l:1)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,d2:l:2)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,d2:l:4)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,d2:l:8)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,a5:w:1)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,a5:w:2)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,a5:w:4)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,a5:w:8)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,a5:l:1)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,a5:l:2)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,a5:l:4)",	PCMIPOST },
    { "pc@(0)@(0xfeedface:l,a5:l:8)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,d2:w:1)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,d2:w:2)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,d2:w:4)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,d2:w:8)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,d2:l:1)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,d2:l:2)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,d2:l:4)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,d2:l:8)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,a5:w:1)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,a5:w:2)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,a5:w:4)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,a5:w:8)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,a5:l:1)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,a5:l:2)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,a5:l:4)",	PCMIPOST },
    { "pc@(0x1234:w)@(0xfeedface:l,a5:l:8)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,d2:w:1)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,d2:w:2)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,d2:w:4)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,d2:w:8)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,d2:l:1)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,d2:l:2)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,d2:l:4)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,d2:l:8)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,a5:w:1)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,a5:w:2)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,a5:w:4)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,a5:w:8)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,a5:l:1)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,a5:l:2)",	PCMIPOST },
    { "pc@(0x1234abcd:l)@(0xfeedface:l,a5:l:4)",	PCMIPOST },
#endif /* ALL_OPERANDS */
    { "pc@(0x1234abcd:l)@(0xfeedface:l,a5:l:8)",	PCMIPOST },
#ifdef ALL_OPERANDS
    { "zpc@(0)@(0xfeedface:l)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,d2:w:1)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,d2:w:2)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,d2:w:4)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,d2:w:8)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,d2:l:1)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,d2:l:2)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,d2:l:4)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,d2:l:8)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,a5:w:1)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,a5:w:2)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,a5:w:4)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,a5:w:8)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,a5:l:1)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,a5:l:2)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,a5:l:4)",	PCMIPOST },
    { "zpc@(0)@(0xfeedface:l,a5:l:8)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,d2:w:1)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,d2:w:2)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,d2:w:4)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,d2:w:8)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,d2:l:1)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,d2:l:2)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,d2:l:4)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,d2:l:8)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,a5:w:1)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,a5:w:2)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,a5:w:4)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,a5:w:8)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,a5:l:1)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,a5:l:2)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,a5:l:4)",	PCMIPOST },
    { "zpc@(0x1234:w)@(0xfeedface:l,a5:l:8)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,d2:w:1)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,d2:w:2)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,d2:w:4)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,d2:w:8)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,d2:l:1)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,d2:l:2)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,d2:l:4)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,d2:l:8)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,a5:w:1)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,a5:w:2)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,a5:w:4)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,a5:w:8)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,a5:l:1)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,a5:l:2)",	PCMIPOST },
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,a5:l:4)",	PCMIPOST },
#endif /* ALL_OPERANDS */
    { "zpc@(0x1234abcd:l)@(0xfeedface:l,a5:l:8)",	PCMIPOST },

/* These are used by the movec instruction */
    { "sfc",	MOVEC_REG },
    { "dfc",	MOVEC_REG },
    { "cacr",	MOVEC_REG },
    { "usp",	MOVEC_REG },
    { "vbr",	MOVEC_REG },
    { "caar",	MOVEC_REG },
    { "msp",	MOVEC_REG },
    { "isp",	MOVEC_REG },
    { "tc",	MOVEC_REG },
    { "itt0",	MOVEC_REG },
    { "itt1",	MOVEC_REG },
    { "dtt0",	MOVEC_REG },
    { "dtt1",	MOVEC_REG },
    { "mmusr",	MOVEC_REG },
    { "urp",	MOVEC_REG },
    { "srp",	MOVEC_REG },
/* These are used by special case operand types */
    { "special 1",	SPECIAL_1 },
    { "special 2",	SPECIAL_2 },
    { "special 3",	SPECIAL_3 },

    { 0, 0 }
};

/*
bs = An, PC, ZPC or nothing (not present)
bdsize = null (0), word, long displacement
Xn = An, Dn or nothing (not present) (followed by :scale = 1 (assumed), 2, 4, 8)

IS = 0 (index register not suppressed, present)
"bs@(bd:bdsize,Xn)",		"No Memory Indirection"
"bs@(bd:bdsize,Xn)@",		"Indirect Preindexed with Null Displacement"
"bs@(bd:bdsize,Xn)@(od:w)",	"Indirect Preindexed with Word Displacement"
"bs@(bd:bdsize,Xn)@(od:l)",	"Indirect Preindexed with Long Displacement"
"bs@(bd:bdsize)@(Xn)",		"Indirect Postindexed with Null Displacement"
"bs@(bd:bdsize)@(od:w,Xn)",	"Indirect Postindexed with Word Displacement"
"bs@(bd:bdsize)@(od:l,Xn)",	"Indirect Postindexed with Long Displacement"

IS = 1 (index register suppressed, not present)
"bs@(bd:bdsize)",		"No Memory Indirection"
"bs@(bd:bdsize)@",		"Memory Indirect with Null Displacement"
"bs@(bd:bdsize)@(od:w)",	"Memory Indirect with Word Displacement"
"bs@(bd:bdsize)@(od:l)",	"Memory Indirect with Long Displacement"
*/

#if 1

#include "m68k-opcode.h"

#else
struct m68k_opcode
{
  char *name;
  uint32_t opcode;
  uint32_t  match;
  char *args;
  char *cpus;
};

#define one(x) ((x) << 16)
struct m68k_opcode m68k_opcodes[] =
{
{"abcd",	one(0140400),		one(0170770),		"DsDd"},
{"addal",	one(0150700),		one(0170700),		"*lAd"},
};

int numopcodes=sizeof(m68k_opcodes)/sizeof(m68k_opcodes[0]);
#endif

int32_t types[128]; /* initialized to zero */

static void print_op(
    struct operand *op,
    char *arg,
    char end_char);

void
main(
int argc,
char *argv[],
char *envp[])
{
    struct m68k_opcode *opcode;
    char *args;
    struct operand *op1, *op2, *op3, *op4, *op5, *op6;

/* Kinds of operands: */
   	/* D  data register only.  Stored as 3 bits. */
	types['D'] = DREG;
	/* A  address register only.  Stored as 3 bits. */
	types['A'] = AREG;
	/* R  either kind of register.  Stored as 4 bits. */
	types['R'] = DREG | AREG;
	/* F  floating point coprocessor register only.   Stored as 3 bits. */
	types['F'] = SPECIAL_1;
   	/* O  an offset (or width): immediate data 0-31 or data register.
	   Stored as 6 bits in special format for BF... insns. */
	types['O'] = SPECIAL_1 | DREG;
	/* +  autoincrement only.  Stored as 3 bits (number of the address
	   register). */
	types['+'] = AINC;
	/* -  autodecrement only.  Stored as 3 bits (number of the address
	   register). */
	types['-'] = ADEC;
	/* Q  quick immediate data.  Stored as 3 bits.  This matches an
	   immediate operand only when value is in range 1 .. 8. */
	types['Q'] = SPECIAL_1;
	/* M  moveq immediate data.  Stored as 8 bits.  This matches an
	   immediate operand only when value is in range -128..127 */
	types['M'] = SPECIAL_1;
	/* T  trap vector immediate data.  Stored as 4 bits. */
	types['T'] = SPECIAL_1;
	/* k  K-factor for fmove.p instruction.   Stored as a 7-bit constant or
	   a three bit register offset, depending on the field type. */
	types['k'] = SPECIAL_1 | SPECIAL_2;
	/* #  immediate data.  Stored in special places (b, w or l)
	   which say how many bits to store. */
	types['#'] = SPECIAL_1;
	/* ^  immediate data for floating point instructions.   Special places
	   are offset by 2 bytes from '#'... */
	types['^'] = SPECIAL_1;
	/* B  pc-relative address, converted to an offset
	   that is treated as immediate data. */
	types['B'] = SPECIAL_1;
	/* d  displacement and register.  Stores the register as 3 bits
	   and stores the displacement in the entire second word. */
	types['d'] = SPECIAL_1;
   	/* C  the CCR.  No need to store it; this is just for filtering
	   validity. */
	types['C'] = SPECIAL_1;
	/* S  the SR.  No need to store, just as with CCR.
	types['S'] = SPECIAL_1;
	/* U  the USP.  No need to store, just as with CCR.
	types['U'] = SPECIAL_1;
	/* I  Coprocessor ID.   Not printed if 1.   The Coprocessor ID is
	   always extracted from the 'd' field of word one, which means that an
	   extended coprocessor opcode can be skipped using the 'i' place, if
	   needed. */
	types['I'] = SPECIAL_1;
	/* s  System Control register for the floating point coprocessor. */
	types['s'] = SPECIAL_1 | SPECIAL_2 | SPECIAL_3;
	/* S  List of system control registers for floating point coprocessor.*/
	types['S'] = SPECIAL_1;
	/* J  Misc register for movec instruction, stored in 'j' format. */
	types['J'] = MOVEC_REG;
	/* L  Register list of the type d0-d7/a0-a7 etc.  Can also hold
	   fp0-fp7, as well. */
	types['L'] = SPECIAL_1;
	/* l  Register list like L, but with all the bits reversed.
	   Used for going the other way. . . */
	types['l'] = SPECIAL_1;
	/* 0  Address register indirect only */
	types['0'] = AINDR;

   	/* *  all (modes 0-6,7.*) */
	types['*'] = DREG | AREG | AINDR | AINC | ADEC | Ad16 | Ad8Xn | AbdXn |
		     MIPRE | MIPOST | ABSW | ABSL | IMMED | PCd16 | PCd8Xn |
		     PCbdXn | PCMIPRE | PCMIPOST;
	/* ~  alterable memory (modes 2-6,7.0,7.1)(not 0,1,7.~) */
	types['~'] = AINDR | AINC | ADEC | Ad16 | Ad8Xn | AbdXn | MIPRE |
		     MIPOST | ABSW | ABSL;
	/* %  alterable (modes 0-6,7.0,7.1)(not 7.~) */
	types['%'] = DREG | AREG | AINDR | AINC | ADEC | Ad16 | Ad8Xn | AbdXn |
		     MIPRE | MIPOST | ABSW | ABSL;
	/* ;  data (modes 0,2-6,7.*)(not 1) */
	types[';'] = DREG | AINDR | AINC | ADEC | Ad16 | Ad8Xn | AbdXn |
		     MIPRE | MIPOST | ABSW | ABSL | IMMED | PCd16 | PCd8Xn |
		     PCbdXn | PCMIPRE | PCMIPOST;
	/* @  data, but not immediate (modes 0,2-6,7.? ? ?)(not 1,7.4) */
	types['@'] = DREG | AINDR | AINC | ADEC | Ad16 | Ad8Xn | AbdXn |
		     MIPRE | MIPOST | ABSW | ABSL | PCd16 | PCd8Xn |
		     PCbdXn | PCMIPRE | PCMIPOST;
	/* !  control (modes 2,5,6,7.*-)(not 0,1,3,4,7.4) */
	types['!'] = AINDR | Ad16 | Ad8Xn | AbdXn | MIPRE | MIPOST | ABSW |
		     ABSL | PCd16 | PCd8Xn | PCbdXn | PCMIPRE | PCMIPOST;
	/* &  alterable control	(modes 2,5,6,7.0,7.1)(not 0,1,7.? ? ?) */
	types['&'] = AINDR | Ad16 | Ad8Xn | AbdXn | MIPRE | MIPOST | ABSW |
		     ABSL;
	/* $  alterable data (modes 0,2-6,7.0,7.1)(not 1,7.~) */
	types['$'] = DREG | AINDR | AINC | ADEC | Ad16 | Ad8Xn | AbdXn |
		     MIPRE | MIPOST | ABSW | ABSL;
	/* ?  alterable control, or data register (modes 0,2,5,6,7.0,7.1)		      (not 1,3,4,7.~) */
	types['?'] = DREG | AINDR | Ad16 | Ad8Xn | AbdXn |
		     MIPRE | MIPOST | ABSW | ABSL;
	/* /  control, or data register	(modes 0,2,5,6,7.0,7.1,7.2,7.3)
	      (not 1,3,4,7.4) */
	types['/'] = DREG | AINDR | Ad16 | Ad8Xn | AbdXn | MIPRE | MIPOST |
		     ABSW | ABSL | PCd16 | PCd8Xn | PCbdXn | PCMIPRE | PCMIPOST;

	/* f  function code register (sfc or dfc) */
	types['f'] = SPECIAL_1 | SPECIAL_2;
	/* a  030 mmu registers srp, crp or tc */
	types['a'] = SPECIAL_1 | SPECIAL_2 | SPECIAL_3;
	/* b  030 mmu register mmusr */
	types['b'] = SPECIAL_1;
	/* c  040 cache indicators ic, dc or bc */
	types['c'] = SPECIAL_1 | SPECIAL_2 | SPECIAL_3;
	/* e  030 mmu registers tt0 or tt1 */
	types['e'] = SPECIAL_1 | SPECIAL_2;

	for(opcode = (struct m68k_opcode *)m68k_opcodes;
	    opcode != endop;
	    opcode++){
	    args = opcode->args;

	    if(args[0] == '\0'){
		printf("\t%s\n", opcode->name);
		continue;
	    }
	    for(op1 = ops; op1->type; op1++){
		if((types[(int)args[0]] & op1->type) == 0)
		    continue;
		if(args[2] == '\0'){
		    printf("\t%s\t", opcode->name);
		    print_op(op1, &(args[0]), '\n');
		    continue;
		}
		for(op2 = ops; op2->type; op2++){
		    if((types[(int)args[2]] & op2->type) == 0)
			continue;
		    if(args[4] == '\0'){
			printf("\t%s\t", opcode->name);
			print_op(op1, &(args[0]), ',');
			print_op(op2, &(args[2]), '\n');
			continue;
		    }
		    for(op3 = ops; op3->type; op3++){
			if((types[(int)args[4]] & op3->type) == 0)
			    continue;
			if(args[6] == '\0'){
			    printf("\t%s\t", opcode->name);
			    print_op(op1, &(args[0]), ',');
			    print_op(op2, &(args[2]), ',');
			    print_op(op3, &(args[4]), '\n');
			    continue;
			}
			for(op4 = ops; op4->type; op4++){
			    if((types[(int)args[6]] & op4->type) == 0)
				continue;
			    if(args[8] == '\0'){
				printf("\t%s\t", opcode->name);
				print_op(op1, &(args[0]), ',');
				print_op(op2, &(args[2]), ',');
				print_op(op3, &(args[4]), ',');
				print_op(op4, &(args[6]), '\n');
				continue;
			    }
			    for(op5 = ops; op5->type; op5++){
				if((types[(int)args[8]] & op5->type) == 0)
				    continue;
				if(args[10] == '\0'){
				    printf("\t%s\t", opcode->name);
				    print_op(op1, &(args[0]), ',');
				    print_op(op2, &(args[2]), ',');
				    print_op(op3, &(args[4]), ',');
				    print_op(op4, &(args[6]), ',');
				    print_op(op5, &(args[8]), '\n');
				    continue;
				}
				for(op6 = ops; op6->type; op6++){
				    if((types[(int)args[10]] & op6->type) == 0)
					continue;
				    if(args[12] == '\0'){
					printf("\t%s\t", opcode->name);
					print_op(op1, &(args[0]), ',');
					print_op(op2, &(args[2]), ',');
					print_op(op3, &(args[4]), ',');
					print_op(op4, &(args[6]), ',');
					print_op(op5, &(args[8]), ',');
					print_op(op6, &(args[10]), '\n');
					continue;
				    }
				    printf("# more than 6 operands %s %s\n",
					   opcode->name, args);
				    printf(".abort\n");
				    exit(1);
				}
			    }
			}
		    }
		}
	    }
	}
}

static
void
print_op(
struct operand *op,
char *arg,
char end_char)
{
	switch(*arg){
	case 'F':
	/* F  floating point coprocessor register only.   Stored as 3 bits. */
	    printf("fp7");
	    break;

	case 'O':
   	/* O  an offset (or width): immediate data 0-31 or data register.
	   Stored as 6 bits in special format for BF... insns. */
	    if(op->type == DREG)
		printf("%s", op->string);
	    else
		printf("#0x13");
	    break;

	case 'Q':
	/* Q  quick immediate data.  Stored as 3 bits.  This matches an
	   immediate operand only when value is in range 1 .. 8. */
	    printf("#0x7");
	    break;
	
	case 'M':
	/* M  moveq immediate data.  Stored as 8 bits.  This matches an
	   immediate operand only when value is in range -128..127 */
	    printf("#0x7e");
	    break;
	   
	case 'T':
	/* T  trap vector immediate data.  Stored as 4 bits. */
	    printf("#0xe");
	    break;

	case 'k':
	/* k  K-factor for fmove.p instruction.   Stored as a 7-bit constant or
	   a three bit register offset, depending on the field type. */
	    if(op->type == SPECIAL_1)
		printf("{d4}");
	    else
		printf("{#0x3f}");
	    break;

	case '#':
	/* #  immediate data.  Stored in special places (b, w or l)
	   which say how many bits to store. */
	    if(arg[1] == 'b')
		printf("#0x81");
	    else if(arg[1] == 'w' || arg[1] == 'z')
		printf("#0x8001");
	    else if(arg[1] == 'l')
		printf("#0x80000001");
	    /* Used with the fmovecr (7 bits) */
	    else if(arg[1] == 'C')
		printf("#0x7f");
	    /* Used with the fmovemx (8 bits) */
	    else if(arg[1] == '3')
		printf("#0xff");
	    /* Used with the fmoveml (3 bits) */
	    else if(arg[1] == '8')
		printf("#0x3");
	    /* Used with the movec (12 bits) */
	    else if(arg[1] == 'j')
		printf("#0x801"); /* vbr register # */
	    else
		printf("#???");
	    break;

	case '^':
	/* ^  immediate data for floating point instructions.   Special places
	   are offset by 2 bytes from '#'... */
	    printf("#0x3");
	    break;

	case 'B':
	/* B  pc-relative address, converted to an offset
	   that is treated as immediate data. */
	    if(arg[1] == 'w')
		printf("0x7ace");
	    else
		printf("0x1badface");
	    break;

	case 'd':
	/* d  displacement and register.  Stores the register as 3 bits
	   and stores the displacement in the entire second word. */
	/* This is used for the movep instruction "movep Dx,(d,Ay) where
	   the displacement d is 16 bits */
	    printf("(0x4321,a6)");
	    break;

	case 'C':
   	/* C  the CCR.  No need to store it; this is just for filtering
	   validity. */
	    printf("ccr");
	    break;
	
	case 'S':
	/* S  the SR.  No need to store, just as with CCR. */
	    printf("sr");
	    break;

	case 'U':
	/* U  the USP.  No need to store, just as with CCR. */
	    printf("usp");
	    break;

	case 'I':
	/* I  Coprocessor ID.   Not printed if 1.   The Coprocessor ID is
	   always extracted from the 'd' field of word one, which means that an
	   extended coprocessor opcode can be skipped using the 'i' place, if
	   needed. */
	    break;
	
	case 's':
	/* s  System Control register for the floating point coprocessor. */
	    if(op->type == SPECIAL_1)
		printf("fpi");
	    else if(op->type == SPECIAL_2)
		printf("fpc");
	    else
		printf("fps");
	    break;

#if 0
	case 'S':
	/* S  List of system control registers for floating point coprocessor.*/
	    printf("fpc/fps/fpi");
	    break;
#endif /* 0 */

	case 'J':
	/* J  Misc register for movec instruction, stored in 'j' format. */
	    printf("%s", op->string);
	    break;

	case 'f':
	/* f  function code register (sfc or dfc) */
	    if(op->type == SPECIAL_1)
		printf("sfc");
	    else
		printf("dfc");
	    break;

	case 'a':
	/* a  030 mmu registers srp, crp or tc */
	    if(op->type == SPECIAL_1)
		printf("srp");
	    else if(op->type == SPECIAL_2)
		printf("crp");
	    else
		printf("tc");
	    break;

	case 'b':
	/* b  030 mmu register mmusr */
	    printf("mmusr");
	    break;

	case 'c':
	/* c  040 cache indicators ic, dc or bc */
	    if(op->type == SPECIAL_1)
		printf("ic");
	    else if(op->type == SPECIAL_2)
		printf("dc");
	    else
		printf("bc");
	    break;

	case 'e':
	/* e  030 mmu registers tt0 or tt1 */
	    if(op->type == SPECIAL_1)
		printf("tt0");
	    else
		printf("tt1");
	    break;

	case 'L':
	case 'l':
	/* L  Register list of the type d0-d7/a0-a7 etc.  Can also hold
	   fp0-fp7, as well. */
	/* l  Register list like L, but with all the bits reversed.
	   Used for going the other way. . . */
	    if(arg[1] == 'w')
		printf("a0/a1/a2/a3/a4/a5/a6/sp/d0/d1/d2/d3/d4/d5/d6/d7");
	    else if(arg[1] == '3')
		printf("fp0/fp1/fp2/fp3/fp4/fp5/fp6/fp7");
	    else if(arg[1] == '8')
		printf("fpc/fps/fpi");
	    else
		printf("???%c", arg[0]);
	    break;

	default:
	    printf("%s", op->string);
	    break;
	}
	if((arg[2] != 'k' && arg[0] != 'I') ||
	   (arg[0] == 'I' && arg[2] == '\0'))
	    printf("%c", end_char);
}
