/*
*  qm_colorpicker.cpp
*  QUIMUP window to select custom colors
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/


#include "qm_colorpicker.h"

qm_colorPicker::qm_colorPicker(QWidget *parent, qm_Config *conf)
{
    setParent(parent);
    config = conf;

    setWindowIcon(QPixmap(":/qmp_main_icon.png"));
    setWindowTitle(tr("Custom colors") );

    sl_H_fg_title = new QSlider(Qt::Horizontal, this);
    sl_H_fg_title->setRange(0, 255);
    sl_H_fg_title->setSingleStep(1);
    sl_H_fg_title->setPageStep(10);

    sl_S_fg_title = new QSlider(Qt::Horizontal, this);
    sl_S_fg_title->setRange(0, 255);
    sl_S_fg_title->setSingleStep(1);
    sl_S_fg_title->setPageStep(10);

    sl_V_fg_title = new QSlider(Qt::Horizontal, this);
    sl_V_fg_title->setRange(0, 255);
    sl_V_fg_title->setSingleStep(1);
    sl_V_fg_title->setPageStep(10);

    sl_H_bg_title = new QSlider(Qt::Horizontal, this);
    sl_H_bg_title->setRange(0, 255);
    sl_H_bg_title->setSingleStep(1);
    sl_H_bg_title->setPageStep(10);

    sl_S_bg_title = new QSlider(Qt::Horizontal, this);
    sl_S_bg_title->setRange(0, 255);
    sl_S_bg_title->setSingleStep(1);
    sl_S_bg_title->setPageStep(10);

    sl_V_bg_title = new QSlider(Qt::Horizontal, this);
    sl_V_bg_title->setRange(0, 255);
    sl_V_bg_title->setSingleStep(1);
    sl_V_bg_title->setPageStep(10);

    lb_color_title = new QLabel;
    lb_color_title->setFixedHeight(56);
    lb_color_title->setFrameShape(QFrame::StyledPanel);
    lb_color_title->setFrameShadow(QFrame::Sunken);
    lb_color_title->setAlignment(Qt::AlignCenter);
    lb_color_title->setTextFormat(Qt::RichText);
    lb_color_title->setMinimumSize(QSize(240, 36));
    lb_color_title->setAutoFillBackground(true);
    lb_color_title->setText("<b>" + tr("Artist : Title") + "</b>");

    sl_H_fg_album = new QSlider(Qt::Horizontal, this);
    sl_H_fg_album->setRange(0, 255);
    sl_H_fg_album->setSingleStep(1);
    sl_H_fg_album->setPageStep(10);

    sl_S_fg_album = new QSlider(Qt::Horizontal, this);
    sl_S_fg_album->setRange(0, 255);
    sl_S_fg_album->setSingleStep(1);
    sl_S_fg_album->setPageStep(10);

    sl_V_fg_album = new QSlider(Qt::Horizontal, this);
    sl_V_fg_album->setRange(0, 255);
    sl_V_fg_album->setSingleStep(1);
    sl_V_fg_album->setPageStep(10);

    sl_H_bg_album = new QSlider(Qt::Horizontal, this);
    sl_H_bg_album->setRange(0, 255);
    sl_H_bg_album->setSingleStep(1);
    sl_H_bg_album->setPageStep(10);

    sl_S_bg_album = new QSlider(Qt::Horizontal, this);
    sl_S_bg_album->setRange(0, 255);
    sl_S_bg_album->setSingleStep(1);
    sl_S_bg_album->setPageStep(10);

    sl_V_bg_album = new QSlider(Qt::Horizontal, this);
    sl_V_bg_album->setRange(0, 255);
    sl_V_bg_album->setSingleStep(1);
    sl_V_bg_album->setPageStep(10);

    lb_color_album = new QLabel;
    lb_color_album->setFixedHeight(56);
    lb_color_album->setFrameShape(QFrame::StyledPanel);
    lb_color_album->setFrameShadow(QFrame::Sunken);
    lb_color_album->setAlignment(Qt::AlignCenter);
    lb_color_album->setTextFormat(Qt::RichText);
    lb_color_album->setMinimumSize(QSize(240, 36));
    lb_color_album->setAutoFillBackground(true);
    lb_color_album->setText(tr("album & year"));

    bt_ok = new QPushButton(tr("OK"), this);
    bt_cancel = new QPushButton(tr("Cancel"), this);

    QWidget *main_widget = new QWidget();
    setCentralWidget(main_widget);

    QVBoxLayout *top_bottom = new QVBoxLayout(main_widget);
    QHBoxLayout *left_right = new QHBoxLayout();
    top_bottom->addLayout(left_right);

    // LEFT : title
    QVBoxLayout *layout_title = new QVBoxLayout();
    left_right->addLayout(layout_title);

    QGridLayout *gb_HSV_fg_title = new QGridLayout();
    gb_HSV_fg_title->addWidget(new QLabel(tr("Text"), this), 0, 1);
    gb_HSV_fg_title->addWidget(new QLabel("H", this), 1, 0);
    gb_HSV_fg_title->addWidget(new QLabel("S", this), 2, 0);
    gb_HSV_fg_title->addWidget(new QLabel("V", this), 3, 0);

    gb_HSV_fg_title->addWidget(sl_H_fg_title, 1, 1);
    gb_HSV_fg_title->addWidget(sl_S_fg_title, 2, 1);
    gb_HSV_fg_title->addWidget(sl_V_fg_title, 3 ,1);

    layout_title->addLayout(gb_HSV_fg_title);

    QGridLayout *gb_HSV_bg_title = new QGridLayout();
    gb_HSV_bg_title->addWidget(new QLabel(tr("Background"), this), 0, 1);
    gb_HSV_bg_title->addWidget(new QLabel("H", this), 1, 0);
    gb_HSV_bg_title->addWidget(new QLabel("S", this), 2, 0);
    gb_HSV_bg_title->addWidget(new QLabel("V", this), 3, 0);

    gb_HSV_bg_title->addWidget(sl_H_bg_title, 1, 1);
    gb_HSV_bg_title->addWidget(sl_S_bg_title, 2, 1);
    gb_HSV_bg_title->addWidget(sl_V_bg_title, 3 ,1);



    layout_title->addLayout(gb_HSV_bg_title);
    layout_title->addWidget(new QLabel(tr("Preview")));
    layout_title->addWidget(lb_color_title);

    // RIGHT : album
    QVBoxLayout *layout_album = new QVBoxLayout();
    left_right->addLayout(layout_album);

    QGridLayout *gb_HSV_fg_album = new QGridLayout();
    gb_HSV_fg_album->addWidget(new QLabel(tr("Text"), this), 0, 1);
    gb_HSV_fg_album->addWidget(new QLabel("H", this), 1, 0);
    gb_HSV_fg_album->addWidget(new QLabel("S", this), 2, 0);
    gb_HSV_fg_album->addWidget(new QLabel("V", this), 3, 0);

    gb_HSV_fg_album->addWidget(sl_H_fg_album, 1, 1);
    gb_HSV_fg_album->addWidget(sl_S_fg_album, 2, 1);
    gb_HSV_fg_album->addWidget(sl_V_fg_album, 3 ,1);

    layout_album->addLayout(gb_HSV_fg_album);

    QGridLayout *gb_HSV_bg_album = new QGridLayout();
    gb_HSV_bg_album->addWidget(new QLabel(tr("Background"), this), 0, 1);
    gb_HSV_bg_album->addWidget(new QLabel("H", this), 1, 0);
    gb_HSV_bg_album->addWidget(new QLabel("S", this), 2, 0);
    gb_HSV_bg_album->addWidget(new QLabel("V", this), 3, 0);

    gb_HSV_bg_album->addWidget(sl_H_bg_album, 1, 1);
    gb_HSV_bg_album->addWidget(sl_S_bg_album, 2, 1);
    gb_HSV_bg_album->addWidget(sl_V_bg_album, 3 ,1);

    layout_album->addLayout(gb_HSV_bg_album);
    layout_album->addWidget(new QLabel(tr("Preview")));
    layout_album->addWidget(lb_color_album);

    QHBoxLayout *ok_cancel_Layout = new QHBoxLayout();
    ok_cancel_Layout->setAlignment(Qt::AlignRight);
    ok_cancel_Layout->setContentsMargins(10,10,10,10);
    ok_cancel_Layout->setSpacing(10);
    ok_cancel_Layout->addWidget(bt_ok);
    ok_cancel_Layout->addWidget(bt_cancel);

    top_bottom->addLayout(ok_cancel_Layout);

    connect( sl_H_fg_title, SIGNAL(valueChanged(int)), SLOT(set_fg_title()) );
    connect( sl_S_fg_title, SIGNAL(valueChanged(int)), SLOT(set_fg_title()) );
    connect( sl_V_fg_title, SIGNAL(valueChanged(int)), SLOT(set_fg_title()) );

    connect( sl_H_bg_title, SIGNAL(valueChanged(int)), SLOT(set_bg_title()) );
    connect( sl_S_bg_title, SIGNAL(valueChanged(int)), SLOT(set_bg_title()) );
    connect( sl_V_bg_title, SIGNAL(valueChanged(int)), SLOT(set_bg_title()) );

    connect( sl_H_fg_album, SIGNAL(valueChanged(int)), SLOT(set_fg_album()) );
    connect( sl_S_fg_album, SIGNAL(valueChanged(int)), SLOT(set_fg_album()) );
    connect( sl_V_fg_album, SIGNAL(valueChanged(int)), SLOT(set_fg_album()) );

    connect( sl_H_bg_album, SIGNAL(valueChanged(int)), SLOT(set_bg_album()) );
    connect( sl_S_bg_album, SIGNAL(valueChanged(int)), SLOT(set_bg_album()) );
    connect( sl_V_bg_album, SIGNAL(valueChanged(int)), SLOT(set_bg_album()) );

    connect( bt_cancel, SIGNAL(clicked()), this, SLOT(on_cancel()) );
    connect( bt_ok, SIGNAL(clicked()), this, SLOT(on_ok()) );

    set_colors();
}


void qm_colorPicker::on_cancel()
{
    this->hide();
}


void qm_colorPicker::on_ok()
{
    config->color_cus_fg_title = color_fg_title.name();
    config->color_cus_bg_title = color_bg_title.name();
    config->color_cus_fg_album = color_fg_album.name();
    config->color_cus_bg_album = color_bg_album.name();
    emit signal_newcolors();
    this->hide();
}


void qm_colorPicker::set_colors()
{
    sl_H_fg_title->setValue(QColor(config->color_cus_fg_title).hue());
    sl_S_fg_title->setValue(QColor(config->color_cus_fg_title).saturation());
    sl_V_fg_title->setValue(QColor(config->color_cus_fg_title).value());
    sl_H_bg_title->setValue(QColor(config->color_cus_bg_title).hue());
    sl_S_bg_title->setValue(QColor(config->color_cus_bg_title).saturation());
    sl_V_bg_title->setValue(QColor(config->color_cus_bg_title).value());

    sl_H_fg_album->setValue(QColor(config->color_cus_fg_album).hue());
    sl_S_fg_album->setValue(QColor(config->color_cus_fg_album).saturation());
    sl_V_fg_album->setValue(QColor(config->color_cus_fg_album).value());
    sl_H_bg_album->setValue(QColor(config->color_cus_bg_album).hue());
    sl_S_bg_album->setValue(QColor(config->color_cus_bg_album).saturation());
    sl_V_bg_album->setValue(QColor(config->color_cus_bg_album).value());
}


void qm_colorPicker::set_fg_title()
{
    // h,s,v > 0 to work around a setHsv bug
    QPalette pal (lb_color_title->palette());
    int h = sl_H_fg_title->value();
    if (h == 0) h = 1;
    int s = sl_S_fg_title->value();
    if (s == 0) s = 1;
    int v = sl_V_fg_title->value();
    if (v == 0) v = 1;
    color_fg_title.setHsv(h, s, v);
    pal.setColor(QPalette::WindowText, color_fg_title);
    lb_color_title->setPalette(pal);
}


void qm_colorPicker::set_bg_title()
{
    // h,s,v > 0 to work around a setHsv bug
    QPalette pal (lb_color_title->palette());
    int h = sl_H_bg_title->value();
    if (h == 0) h = 1;
    int s = sl_S_bg_title->value();
    if (s == 0) s = 1;
    int v = sl_V_bg_title->value();
    if (v == 0) v = 1;
    color_bg_title.setHsv(h, s, v);
    pal.setColor(QPalette::Window, color_bg_title);
    lb_color_title->setPalette(pal);
}


void qm_colorPicker::set_fg_album()
{
    // h,s,v > 0 to work around a setHsv bug
    QPalette pal (lb_color_album->palette());
    int h = sl_H_fg_album->value();
    if (h == 0) h = 1;
    int s = sl_S_fg_album->value();
    if (s == 0) s = 1;
    int v = sl_V_fg_album->value();
    if (v == 0) v = 1;
    color_fg_album.setHsv(h, s, v);
    pal.setColor(QPalette::WindowText, color_fg_album);
    lb_color_album->setPalette(pal);
}


void qm_colorPicker::set_bg_album()
{
    // h,s,v > 0 to work around a setHsv bug
    QPalette pal (lb_color_album->palette());
    int h = sl_H_bg_album->value();
    if (h == 0) h = 1;
    int s = sl_S_bg_album->value();
    if (s == 0) s = 1;
    int v = sl_V_bg_album->value();
    if (v == 0) v = 1;
    color_bg_album.setHsv(h, s, v);
    pal.setColor(QPalette::Window, color_bg_album);
    lb_color_album->setPalette(pal);
}


qm_colorPicker::~qm_colorPicker()
{}
