/*
*  qm_clicklabel.h
*  QUIMUP clickabel class
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#ifndef QM_CLICKLABEL
#define QM_CLICKLABEL

#include <QLabel>
#include <qevent.h> // note: <QEvent> equals qcoreevent.h

class qm_clickLabel : public QLabel
{
    Q_OBJECT

public:
    qm_clickLabel( QWidget *parent = nullptr);
    virtual ~qm_clickLabel();

signals:
    void clicked();
    void clicked(QMouseEvent *);
    void scrolled(int);
    void doubleclicked();

protected:
    void mouseReleaseEvent(QMouseEvent *);
    void keyReleaseEvent(QKeyEvent *);
    void wheelEvent(QWheelEvent *);
    void mouseDoubleClickEvent(QMouseEvent *);
};

#endif // QM_CLICKLABEL
