/*
*  qm_clicklabel.cpp
*  QUIMUP clickabel class
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#include "qm_clicklabel.h"
#include <qevent.h> // note: <QEvent> equals qcoreevent.h


qm_clickLabel::qm_clickLabel (QWidget *parent)
{
    setParent(parent);
}


qm_clickLabel::~qm_clickLabel()
{}


void qm_clickLabel::mouseReleaseEvent (QMouseEvent *event)
{
    if(event->button() == Qt::LeftButton )
    {
        emit clicked();
        emit clicked(event);
    }
}


void qm_clickLabel::wheelEvent ( QWheelEvent *event)
{
    QPoint numSteps = (event->angleDelta() / 8) / 15;

    emit scrolled(numSteps.rx());
}


void qm_clickLabel::keyReleaseEvent (QKeyEvent *event)
{
    if(event->key() == Qt::Key_Return || event->key() == Qt::Key_Enter)
    {
        emit clicked();
    }
}


void qm_clickLabel::mouseDoubleClickEvent(QMouseEvent *event)
{
    emit doubleclicked();
    event->ignore();
}
