﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/apigatewayv2/model/ReimportApiResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::ApiGatewayV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ReimportApiResult::ReimportApiResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ReimportApiResult& ReimportApiResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("apiEndpoint")) {
    m_apiEndpoint = jsonValue.GetString("apiEndpoint");
    m_apiEndpointHasBeenSet = true;
  }
  if (jsonValue.ValueExists("apiGatewayManaged")) {
    m_apiGatewayManaged = jsonValue.GetBool("apiGatewayManaged");
    m_apiGatewayManagedHasBeenSet = true;
  }
  if (jsonValue.ValueExists("apiId")) {
    m_apiId = jsonValue.GetString("apiId");
    m_apiIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("apiKeySelectionExpression")) {
    m_apiKeySelectionExpression = jsonValue.GetString("apiKeySelectionExpression");
    m_apiKeySelectionExpressionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("corsConfiguration")) {
    m_corsConfiguration = jsonValue.GetObject("corsConfiguration");
    m_corsConfigurationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("createdDate")) {
    m_createdDate = jsonValue.GetString("createdDate");
    m_createdDateHasBeenSet = true;
  }
  if (jsonValue.ValueExists("description")) {
    m_description = jsonValue.GetString("description");
    m_descriptionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("disableSchemaValidation")) {
    m_disableSchemaValidation = jsonValue.GetBool("disableSchemaValidation");
    m_disableSchemaValidationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("disableExecuteApiEndpoint")) {
    m_disableExecuteApiEndpoint = jsonValue.GetBool("disableExecuteApiEndpoint");
    m_disableExecuteApiEndpointHasBeenSet = true;
  }
  if (jsonValue.ValueExists("importInfo")) {
    Aws::Utils::Array<JsonView> importInfoJsonList = jsonValue.GetArray("importInfo");
    for (unsigned importInfoIndex = 0; importInfoIndex < importInfoJsonList.GetLength(); ++importInfoIndex) {
      m_importInfo.push_back(importInfoJsonList[importInfoIndex].AsString());
    }
    m_importInfoHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ipAddressType")) {
    m_ipAddressType = IpAddressTypeMapper::GetIpAddressTypeForName(jsonValue.GetString("ipAddressType"));
    m_ipAddressTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("name")) {
    m_name = jsonValue.GetString("name");
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("protocolType")) {
    m_protocolType = ProtocolTypeMapper::GetProtocolTypeForName(jsonValue.GetString("protocolType"));
    m_protocolTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("routeSelectionExpression")) {
    m_routeSelectionExpression = jsonValue.GetString("routeSelectionExpression");
    m_routeSelectionExpressionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("tags")) {
    Aws::Map<Aws::String, JsonView> tagsJsonMap = jsonValue.GetObject("tags").GetAllObjects();
    for (auto& tagsItem : tagsJsonMap) {
      m_tags[tagsItem.first] = tagsItem.second.AsString();
    }
    m_tagsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("version")) {
    m_version = jsonValue.GetString("version");
    m_versionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("warnings")) {
    Aws::Utils::Array<JsonView> warningsJsonList = jsonValue.GetArray("warnings");
    for (unsigned warningsIndex = 0; warningsIndex < warningsJsonList.GetLength(); ++warningsIndex) {
      m_warnings.push_back(warningsJsonList[warningsIndex].AsString());
    }
    m_warningsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
