/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.pms.util.UriRetrieverCallback;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class UriRetriever {
    private static final String HTTP_HEADER_CONTENT_LENGTH = "Content-Length";
    private static final int BUFFER_SIZE = 1024;
    private HttpClient client = new HttpClient();

    public byte[] get(String uri) throws IOException {
        GetMethod method = new GetMethod(uri);
        try {
            int statusCode = this.client.executeMethod(method);
            if (statusCode != 200) {
                throw new IOException("HTTP response not OK");
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        catch (HttpException e) {
            throw new IOException("Unable to download by HTTP" + e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
    }

    public byte[] getWithCallback(String uri, UriRetrieverCallback callback) throws IOException {
        HttpMethod getMethod = null;
        try {
            byte[] data;
            getMethod = this.startGetRequest(uri, callback);
            int totalBytes = this.getContentSize(uri, getMethod);
            byte[] byArray = data = UriRetriever.pullData(uri, getMethod, callback, totalBytes);
            return byArray;
        }
        catch (HttpException e) {
            throw new IOException("Unable to download via HTTP: " + uri + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new IOException("Unable to download via HTTP: " + uri + ": " + e.getMessage());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    private HttpMethod startGetRequest(String uri, UriRetrieverCallback callback) throws HttpException, IOException {
        int statusCode = -1;
        GetMethod method = new GetMethod(uri);
        this.configureMethod(method);
        statusCode = this.client.executeMethod(method);
        if (statusCode != 200) {
            throw new IOException("HTTP result code was not OK");
        }
        return method;
    }

    private void configureMethod(HttpMethod method) {
        method.setRequestHeader("User-Agent", "PMS");
        method.setFollowRedirects(true);
    }

    private static byte[] pullData(String uri, HttpMethod method, UriRetrieverCallback callback, int totalBytes) throws IOException {
        int bytesWritten = 0;
        InputStream input = method.getResponseBodyAsStream();
        ByteArrayOutputStream output = new ByteArrayOutputStream(totalBytes);
        byte[] buffer = new byte[1024];
        int count = -1;
        while ((count = input.read(buffer)) != -1) {
            output.write(buffer, 0, count);
            UriRetriever.invokeCallback(uri, callback, totalBytes, bytesWritten += count);
        }
        output.flush();
        output.close();
        return output.toByteArray();
    }

    private static void invokeCallback(String uri, UriRetrieverCallback callback, int totalBytes, int bytesWritten) throws IOException {
        try {
            callback.progressMade(uri, bytesWritten, totalBytes);
        }
        catch (UriRetrieverCallback.CancelDownloadException e) {
            throw new IOException("Download was cancelled");
        }
    }

    private int getContentSize(String uri, HttpMethod method) {
        Header header = method.getResponseHeader(HTTP_HEADER_CONTENT_LENGTH);
        if (header != null) {
            String value = "" + header.getValue();
            int totalBytes = -1;
            try {
                totalBytes = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return 0;
            }
            return totalBytes;
        }
        return 0;
    }
}

