/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import net.pms.network.HTTPResource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverUtil
extends HTTPResource {
    private static final Logger logger = LoggerFactory.getLogger(CoverUtil.class);
    public static final int AUDIO_DISCOGS = 0;
    public static final int AUDIO_AMAZON = 1;
    private static CoverUtil instance;
    private HashMap<String, byte[]> covers = new HashMap();

    public static synchronized CoverUtil get() {
        if (instance == null) {
            instance = new CoverUtil();
        }
        return instance;
    }

    private CoverUtil() {
    }

    public synchronized byte[] getThumbnailFromArtistAlbum(int backend, String ... info) throws IOException {
        if (info.length >= 2 && StringUtils.isNotBlank(info[0]) && StringUtils.isNotBlank(info[1])) {
            String url;
            byte[] data;
            String artist = URLEncoder.encode(info[0], "UTF-8");
            String album = URLEncoder.encode(info[1], "UTF-8");
            if (this.covers.get(artist + album) != null) {
                byte[] data2 = this.covers.get(artist + album);
                if (data2.length == 0) {
                    return null;
                }
                return data2;
            }
            if (backend == 0) {
                String url2 = "http://www.discogs.com/advanced_search?artist=" + artist + "&release_title=" + album + "&btn=Search+Releases";
                byte[] data3 = CoverUtil.downloadAndSendBinary(url2);
                if (data3 != null) {
                    try {
                        String html = new String(data3, "UTF-8");
                        int firstItem = html.indexOf("<li style=\"background:");
                        if (firstItem > -1) {
                            String detailUrl = html.substring(html.indexOf("<a href=\"/", firstItem) + 10, html.indexOf("\"><em>", firstItem));
                            data3 = CoverUtil.downloadAndSendBinary("http://www.discogs.com/" + detailUrl);
                            html = new String(data3, "UTF-8");
                            firstItem = html.indexOf("<a href=\"/viewimages?");
                            if (firstItem > -1) {
                                String imageUrl = html.substring(html.indexOf("<img src=\"", firstItem) + 10, html.indexOf("\" border", firstItem));
                                data3 = CoverUtil.downloadAndSendBinary(imageUrl);
                                if (data3 != null) {
                                    this.covers.put(artist + album, data3);
                                } else {
                                    this.covers.put(artist + album, new byte[0]);
                                }
                                return data3;
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.error("Error while retrieving cover for " + artist + album, e);
                    }
                }
            } else if (backend == 1 && (data = CoverUtil.downloadAndSendBinary(url = "http://www.amazon.com/gp/search/ref=sr_adv_m_pop/?search-alias=popular&unfiltered=1&field-keywords=&field-artist=" + artist + "&field-title=" + album + "&field-label=&field-binding=&sort=relevancerank&Adv-Srch-Music-Album-Submit.x=35&Adv-Srch-Music-Album-Submit.y=13")) != null) {
                try {
                    String html = new String(data, "UTF-8");
                    int firstItem = html.indexOf("class=\"imageColumn\"");
                    if (firstItem > -1) {
                        int imageUrlPos = html.indexOf("src=\"", firstItem) + 5;
                        String imageUrl = html.substring(imageUrlPos, html.indexOf("\" class", imageUrlPos));
                        data = CoverUtil.downloadAndSendBinary(imageUrl);
                        if (data != null) {
                            this.covers.put(artist + album, data);
                        } else {
                            this.covers.put(artist + album, new byte[0]);
                        }
                        return data;
                    }
                }
                catch (IOException e) {
                    logger.error("Error while retrieving cover for " + artist + album, e);
                }
            }
            this.covers.put(artist + album, new byte[0]);
        }
        return null;
    }
}

