/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AVCHeader {
    private static final Logger logger = LoggerFactory.getLogger(AVCHeader.class);
    private byte[] buffer;
    private int currentBit;
    private int profile;
    private int level;
    private int ref_frames;
    private boolean parseFailed = false;

    public AVCHeader(byte[] buffer) {
        this.buffer = buffer;
        this.currentBit = 0;
    }

    public void parse() {
        this.profile = this.getValue(8);
        this.skipBit(8);
        this.level = this.getValue(8);
        if (this.profile == 100 || this.profile == 110 || this.profile == 122 || this.profile == -112) {
            if (this.getExpGolombCode() == 3) {
                this.getExpGolombCode();
            }
            this.getExpGolombCode();
            this.getExpGolombCode();
            this.getBit();
            if (this.getBit() == 1) {
                for (int i = 0; i < 8; ++i) {
                    int seqScalingListPresentFlag = this.getBit();
                    if (seqScalingListPresentFlag != 1) continue;
                    int lastScale = 8;
                    int nextScale = 8;
                    int scalingListSize = i < 6 ? 16 : 64;
                    for (int pos = 0; pos < scalingListSize; ++pos) {
                        if (nextScale != 0) {
                            int deltaScale = this.getExpGolombCode();
                            nextScale = (lastScale + deltaScale + 256) % 256;
                        }
                        lastScale = nextScale;
                    }
                }
            }
            this.getExpGolombCode();
            int picOrderCntType = this.getExpGolombCode();
            if (picOrderCntType == 0) {
                this.getExpGolombCode();
            } else if (picOrderCntType == 1) {
                this.getBit();
                this.getExpGolombCode();
                this.getExpGolombCode();
                int n = this.getExpGolombCode();
                for (int i = 0; i < n; ++i) {
                    this.getExpGolombCode();
                }
            }
            this.ref_frames = this.getExpGolombCode();
        }
    }

    private int getBit() {
        int pos = this.currentBit / 8;
        int modulo = this.currentBit % 8;
        ++this.currentBit;
        if (this.buffer != null && pos < this.buffer.length) {
            return (this.buffer[pos] & 1 << 7 - modulo) >> 7 - modulo;
        }
        if (!this.parseFailed) {
            logger.error("Cannot parse AVC header, buffer length is " + this.buffer.length);
            this.parseFailed = true;
        }
        return 0;
    }

    private void skipBit(int number) {
        this.currentBit += number;
    }

    private int getValue(int length) {
        int total = 0;
        for (int i = 0; i < length; ++i) {
            total += this.getBit() << length - i - 1;
        }
        return total;
    }

    private int getExpGolombCode() {
        int bits = 0;
        while (this.getBit() == 0 && !this.parseFailed) {
            ++bits;
        }
        if (bits > 0 && !this.parseFailed) {
            return (1 << bits) - 1 + this.getValue(bits);
        }
        return 0;
    }

    public int getProfile() {
        return this.profile;
    }

    public int getLevel() {
        return this.level;
    }

    public int getRef_frames() {
        return this.ref_frames;
    }
}

