/*
 * Decompiled with CFR 0.152.
 */
package net.pms.newgui.update;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import net.pms.update.AutoUpdater;

public class AutoUpdateDialog
extends JDialog
implements Observer {
    private static final long serialVersionUID = 3809427933990495309L;
    private final AutoUpdater autoUpdater;
    private JLabel stateLabel = new JLabel();
    private JButton okButton = new DownloadButton();
    private JButton cancelButton = new CancelButton();
    private JProgressBar downloadProgressBar = new JProgressBar();
    private static AutoUpdateDialog instance;

    public static synchronized void showIfNecessary(Window parent, AutoUpdater autoUpdater) {
        if (autoUpdater.isUpdateAvailable()) {
            if (instance == null) {
                instance = new AutoUpdateDialog(parent, autoUpdater);
            }
            instance.setVisible(true);
        }
    }

    AutoUpdateDialog(Window parent, AutoUpdater autoUpdater) {
        super(parent, "PS3 Media Server Auto Update");
        this.autoUpdater = autoUpdater;
        autoUpdater.addObserver(this);
        this.initComponents();
        this.setResizable(false);
        this.setMinimumSize(new Dimension(0, 120));
        this.setLocationRelativeTo(parent);
        this.setDefaultCloseOperation(0);
        this.update();
    }

    @Override
    public void update(Observable source, Object data) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Work is probably happening on event thread.  Bad.");
        }
        this.update();
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoUpdateDialog.this.updateOnGuiThread();
            }
        });
    }

    private void updateOnGuiThread() {
        AutoUpdater.State state = this.autoUpdater.getState();
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Must be on event thread");
        }
        this.stateLabel.setText(this.getStateText());
        this.okButton.setEnabled(state == AutoUpdater.State.UPDATE_AVAILABLE);
        this.cancelButton.setEnabled(state == AutoUpdater.State.DOWNLOAD_IN_PROGRESS || state == AutoUpdater.State.UPDATE_AVAILABLE);
        this.updateCancelButton(state);
        if (state == AutoUpdater.State.DOWNLOAD_IN_PROGRESS) {
            this.downloadProgressBar.setEnabled(true);
            this.downloadProgressBar.setValue(this.autoUpdater.getBytesDownloaded());
            this.downloadProgressBar.setMaximum(this.autoUpdater.getTotalBytes());
        } else {
            this.downloadProgressBar.setEnabled(false);
            this.downloadProgressBar.setValue(0);
            this.downloadProgressBar.setMaximum(Integer.MAX_VALUE);
        }
    }

    private void updateCancelButton(AutoUpdater.State state) {
        switch (state) {
            case UPDATE_AVAILABLE: {
                this.cancelButton.setText("Not Now");
                this.cancelButton.setEnabled(true);
                this.cancelButton.setVisible(true);
                break;
            }
            case DOWNLOAD_IN_PROGRESS: {
                this.cancelButton.setText("Cancel");
                this.cancelButton.setEnabled(true);
                this.cancelButton.setVisible(true);
                break;
            }
            case ERROR: {
                this.cancelButton.setText("Close");
                this.cancelButton.setEnabled(true);
                this.cancelButton.setVisible(true);
                break;
            }
            default: {
                this.cancelButton.setEnabled(false);
                this.cancelButton.setVisible(false);
            }
        }
    }

    private String getStateText() {
        switch (this.autoUpdater.getState()) {
            case NOTHING_KNOWN: {
                return "Check for updates not started";
            }
            case DOWNLOAD_FINISHED: {
                return "Download finished";
            }
            case DOWNLOAD_IN_PROGRESS: {
                return "Download in progress";
            }
            case ERROR: {
                return this.getErrorStateText();
            }
            case NO_UPDATE_AVAILABLE: {
                return "No update available";
            }
            case POLLING_SERVER: {
                return "Connecting to server";
            }
            case UPDATE_AVAILABLE: {
                return "An update is available";
            }
        }
        return "Unknown state";
    }

    private String getErrorStateText() {
        if (this.autoUpdater == null) {
            return "No auto updater";
        }
        Throwable exception = this.autoUpdater.getErrorStateCause();
        if (exception == null) {
            return "Error";
        }
        String message = exception.getMessage();
        if (message == null) {
            return "Error";
        }
        return message;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.okButton, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 100, -2)).addComponent(this.stateLabel).addComponent(this.downloadProgressBar, -1, 446, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.stateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadProgressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private class CancelButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 4762020878159496713L;

        CancelButton() {
            super("Not Now");
            this.setEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            switch (AutoUpdateDialog.this.autoUpdater.getState()) {
                case UPDATE_AVAILABLE: 
                case ERROR: {
                    AutoUpdateDialog.this.setVisible(false);
                    break;
                }
                case DOWNLOAD_IN_PROGRESS: {
                    AutoUpdateDialog.this.autoUpdater.cancelDownload();
                    break;
                }
            }
        }
    }

    private class DownloadButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 4762020878159496712L;

        DownloadButton() {
            super("Download");
            this.setEnabled(false);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AutoUpdateDialog.this.autoUpdater.getUpdateFromNetwork();
            if (!AutoUpdateDialog.this.autoUpdater.isDownloadCancelled()) {
                AutoUpdateDialog.this.autoUpdater.runUpdateAndExit();
            }
        }
    }
}

