/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.pms.PMS;
import net.pms.encoders.AviDemuxerInputStream;
import net.pms.io.BufferedOutputFile;
import net.pms.io.OutputBufferConsumer;
import net.pms.io.OutputConsumer;
import net.pms.io.OutputParams;
import net.pms.io.OutputTextConsumer;
import net.pms.io.OutputTextLogger;
import net.pms.io.ProcessWrapper;
import net.pms.util.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessWrapperImpl
extends Thread
implements ProcessWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ProcessWrapperImpl.class);
    private static final String FONTCONFIG_PATH = "FONTCONFIG_PATH";
    private String cmdLine;
    private Process process;
    private OutputConsumer stdoutConsumer;
    private OutputConsumer stderrConsumer;
    private OutputParams params;
    private boolean destroyed;
    private String[] cmdArray;
    private boolean nullable;
    private ArrayList<ProcessWrapper> attachedProcesses;
    private BufferedOutputFile bo = null;
    private boolean keepStdout;
    private boolean keepStderr;
    private static int processCounter = 0;
    private boolean success;

    @Override
    public String toString() {
        return super.getName();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ProcessWrapperImpl(String[] cmdArray, OutputParams params) {
        this(cmdArray, params, false, false);
    }

    public ProcessWrapperImpl(String[] cmdArray, OutputParams params, boolean keepOutput) {
        this(cmdArray, params, keepOutput, keepOutput);
    }

    public ProcessWrapperImpl(String[] cmdArray, OutputParams params, boolean keepStdout, boolean keepStderr) {
        String threadName = cmdArray[0];
        if (threadName.indexOf("/") >= 0) {
            threadName = threadName.substring(threadName.lastIndexOf("/") + 1);
        }
        if (threadName.indexOf("\\") >= 0) {
            threadName = threadName.substring(threadName.lastIndexOf("\\") + 1);
        }
        this.setName(threadName + "-" + this.getProcessCounter());
        File exec = new File(cmdArray[0]);
        if (exec.isFile()) {
            cmdArray[0] = exec.getAbsolutePath();
        }
        this.cmdArray = cmdArray;
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < cmdArray.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            if (cmdArray[i] != null && cmdArray[i].indexOf(" ") >= 0) {
                sb.append("\"" + cmdArray[i] + "\"");
                continue;
            }
            sb.append(cmdArray[i]);
        }
        this.cmdLine = sb.toString();
        this.params = params;
        this.keepStdout = keepStdout;
        this.keepStderr = keepStderr;
        this.attachedProcesses = new ArrayList();
    }

    private synchronized int getProcessCounter() {
        return processCounter++;
    }

    public void attachProcess(ProcessWrapper process) {
        this.attachedProcesses.add(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ProcessBuilder pb = new ProcessBuilder(this.cmdArray);
        try {
            Integer pid;
            logger.debug("Starting " + this.cmdLine);
            if (this.params.workDir != null && this.params.workDir.isDirectory()) {
                pb.directory(this.params.workDir);
            }
            Map<String, String> environment = pb.environment();
            if (this.params.env != null && !this.params.env.isEmpty()) {
                String PATH;
                String sysPathKey;
                String string = sysPathKey = Platform.isWindows() ? "Path" : "PATH";
                String string2 = this.params.env.containsKey("PATH") ? this.params.env.get("PATH") : (this.params.env.containsKey("path") ? this.params.env.get("path") : (PATH = this.params.env.containsKey("Path") ? this.params.env.get("Path") : null));
                if (PATH != null) {
                    PATH = PATH + File.pathSeparator + environment.get(sysPathKey);
                }
                environment.putAll(this.params.env);
                if (PATH != null) {
                    environment.put(sysPathKey, PATH);
                }
            }
            if (Platform.isMac() && !environment.containsKey(FONTCONFIG_PATH)) {
                String pmsWorkingDirectory = new File("").getAbsolutePath();
                String fontconfigFontsPath = pmsWorkingDirectory + "/fonts";
                logger.trace("Setting FONTCONFIG_PATH to \"" + fontconfigFontsPath + "\"");
                environment.put(FONTCONFIG_PATH, fontconfigFontsPath);
            }
            this.process = pb.start();
            PMS.get().currentProcesses.add(this.process);
            this.stderrConsumer = this.keepStderr ? new OutputTextConsumer(this.process.getErrorStream(), true) : new OutputTextLogger(this.process.getErrorStream());
            this.stderrConsumer.start();
            this.stdoutConsumer = null;
            if (this.params.input_pipes[0] != null) {
                logger.debug("Reading pipe: " + this.params.input_pipes[0].getInputPipe());
                this.bo = this.params.input_pipes[0].getDirectBuffer();
                if (this.bo == null || this.params.losslessaudio || this.params.lossyaudio || this.params.no_videoencode) {
                    InputStream is = this.params.input_pipes[0].getInputStream();
                    if (this.params.avidemux) {
                        is = new AviDemuxerInputStream(is, this.params, this.attachedProcesses);
                    }
                    this.stdoutConsumer = new OutputBufferConsumer(is, this.params);
                    this.bo = this.stdoutConsumer.getBuffer();
                }
                this.bo.attachThread(this);
                new OutputTextLogger(this.process.getInputStream()).start();
            } else if (this.params.log) {
                this.stdoutConsumer = this.keepStdout ? new OutputTextConsumer(this.process.getInputStream(), true) : new OutputTextLogger(this.process.getInputStream());
            } else {
                this.stdoutConsumer = new OutputBufferConsumer(this.process.getInputStream(), this.params);
                this.bo = this.stdoutConsumer.getBuffer();
                this.bo.attachThread(this);
            }
            if (this.stdoutConsumer != null) {
                this.stdoutConsumer.start();
            }
            if (this.params.stdin != null) {
                this.params.stdin.push(this.process.getOutputStream());
            }
            if ((pid = ProcessUtil.getProcessID(this.process)) != null) {
                logger.debug("Unix process ID ({}): {}", (Object)this.cmdArray[0], (Object)pid);
            }
            ProcessUtil.waitFor(this.process);
            try {
                if (this.stderrConsumer != null) {
                    this.stderrConsumer.join(1000L);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                if (this.stdoutConsumer != null) {
                    this.stdoutConsumer.join(1000L);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        catch (Exception e) {
            logger.error("Error initializing process: ", e);
            this.stopProcess();
        }
        finally {
            try {
                if (this.bo != null) {
                    this.bo.close();
                }
            }
            catch (IOException ioe) {
                logger.debug("Error closing buffered output file", (Object)ioe.getMessage());
            }
            if (!this.destroyed && !this.params.noexitcheck) {
                try {
                    this.success = true;
                    if (this.process != null && this.process.exitValue() != 0) {
                        logger.info("Process {} has a return code of {}! Maybe an error occurred... check the log file", (Object)this.cmdArray[0], (Object)this.process.exitValue());
                        this.success = false;
                    }
                }
                catch (IllegalThreadStateException itse) {
                    logger.error("Error reading process exit value", itse);
                }
            }
            if (this.attachedProcesses != null) {
                for (ProcessWrapper pw : this.attachedProcesses) {
                    if (pw == null) continue;
                    pw.stopProcess();
                }
            }
            PMS.get().currentProcesses.remove(this.process);
        }
    }

    @Override
    public void runInNewThread() {
        this.start();
    }

    public void runInSameThread() {
        this.run();
    }

    @Override
    public InputStream getInputStream(long seek) throws IOException {
        if (this.bo != null) {
            return this.bo.getInputStream(seek);
        }
        if (this.stdoutConsumer != null && this.stdoutConsumer.getBuffer() != null) {
            return this.stdoutConsumer.getBuffer().getInputStream(seek);
        }
        return null;
    }

    public List<String> getOtherResults() {
        if (this.stdoutConsumer == null) {
            return null;
        }
        try {
            this.stdoutConsumer.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.stdoutConsumer.getResults();
    }

    @Override
    public List<String> getResults() {
        try {
            this.stderrConsumer.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.stderrConsumer.getResults();
    }

    @Override
    public synchronized void stopProcess() {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.process != null) {
                Integer pid = ProcessUtil.getProcessID(this.process);
                if (pid != null) {
                    logger.debug("Stopping Unix process " + pid + ": " + this);
                } else {
                    logger.debug("Stopping process: " + this);
                }
                ProcessUtil.destroy(this.process);
            }
            if (this.attachedProcesses != null) {
                for (ProcessWrapper pw : this.attachedProcesses) {
                    if (pw == null) continue;
                    pw.stopProcess();
                }
            }
            if (this.stdoutConsumer != null && this.stdoutConsumer.getBuffer() != null) {
                this.stdoutConsumer.getBuffer().reset();
            }
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isReadyToStop() {
        return this.nullable;
    }

    @Override
    public void setReadyToStop(boolean nullable) {
        if (nullable != this.nullable) {
            logger.trace("Ready to Stop: " + nullable);
        }
        this.nullable = nullable;
    }
}

