/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAResource;
import net.pms.encoders.MEncoderVideo;
import net.pms.encoders.PlayerPurpose;
import net.pms.formats.Format;
import net.pms.util.PlayerUtil;

public class MEncoderAviSynth
extends MEncoderVideo {
    private JTextArea textArea;
    private JCheckBox convertfps;
    public static final String ID = "avsmencoder";

    public MEncoderAviSynth(PmsConfiguration configuration) {
        super(configuration);
    }

    @Override
    public JComponent config() {
        FormLayout layout = new FormLayout("left:pref, 0:grow", "p, 3dlu, p, 3dlu, p, 3dlu,  0:grow");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.EMPTY_BORDER);
        builder.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        JComponent cmp = builder.addSeparator(Messages.getString("MEncoderAviSynth.2"), cc.xyw(2, 1, 1));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        this.convertfps = new JCheckBox(Messages.getString("MEncoderAviSynth.3"));
        this.convertfps.setContentAreaFilled(false);
        if (PMS.getConfiguration().getAvisynthConvertFps()) {
            this.convertfps.setSelected(true);
        }
        this.convertfps.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PMS.getConfiguration().setAvisynthConvertFps(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.convertfps, cc.xy(2, 3));
        String clip = PMS.getConfiguration().getAvisynthScript();
        if (clip == null) {
            clip = "";
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(clip, "\u0001");
        int i = 0;
        while (st.hasMoreTokens()) {
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(st.nextToken());
            ++i;
        }
        this.textArea = new JTextArea(sb.toString());
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                StringBuilder sb = new StringBuilder();
                StringTokenizer st = new StringTokenizer(MEncoderAviSynth.this.textArea.getText(), "\n");
                int i = 0;
                while (st.hasMoreTokens()) {
                    if (i > 0) {
                        sb.append("\u0001");
                    }
                    sb.append(st.nextToken());
                    ++i;
                }
                PMS.getConfiguration().setAvisynthScript(sb.toString());
            }
        });
        JScrollPane pane = new JScrollPane(this.textArea, 20, 30);
        pane.setPreferredSize(new Dimension(500, 350));
        builder.add((Component)pane, cc.xy(2, 5));
        return builder.getPanel();
    }

    @Override
    public PlayerPurpose getPurpose() {
        return PlayerPurpose.VIDEO_FILE_PLAYER;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean avisynth() {
        return true;
    }

    @Override
    public String name() {
        return "AviSynth/MEncoder";
    }

    @Override
    public boolean isCompatible(DLNAResource resource) {
        return PlayerUtil.isVideo(resource, Format.Identifier.MKV) || PlayerUtil.isVideo(resource, Format.Identifier.MPG);
    }
}

