/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.encoders.FFmpegAudio;
import net.pms.encoders.FFmpegProtocols;
import net.pms.encoders.PlayerPurpose;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.util.PlayerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegWebAudio
extends FFmpegAudio {
    private static final Logger logger = LoggerFactory.getLogger(FFmpegWebAudio.class);
    private final PmsConfiguration configuration;
    private final FFmpegProtocols protocols;
    public static final String ID = "ffmpegwebaudio";

    public FFmpegWebAudio(PmsConfiguration configuration) {
        super(configuration);
        this.configuration = configuration;
        this.protocols = this.getProtocols();
    }

    @Deprecated
    public FFmpegWebAudio(PmsConfiguration configuration, FFmpegProtocols protocols) {
        this(configuration);
    }

    @Override
    public JComponent config() {
        return null;
    }

    @Override
    public PlayerPurpose getPurpose() {
        return PlayerPurpose.AUDIO_WEB_STREAM_PLAYER;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean isTimeSeekable() {
        return false;
    }

    @Override
    public String name() {
        return "FFmpeg Web Audio";
    }

    @Override
    public ProcessWrapper launchTranscode(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) throws IOException {
        String filename = this.protocols.getFilename(dlna.getSystemName());
        params.maxBufferSize = this.configuration.getMaxAudioBuffer();
        params.waitbeforestart = 6000;
        params.manageFastStart();
        int nThreads = this.configuration.getNumberOfCpuCores();
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.executable());
        cmdList.addAll(this.getGlobalOptions(logger));
        cmdList.add("-threads");
        cmdList.add("" + nThreads);
        cmdList.add("-i");
        cmdList.add(filename);
        cmdList.add("-threads");
        cmdList.add("" + nThreads);
        cmdList.addAll(this.getAudioTranscodeOptions(dlna, media, params));
        cmdList.add("pipe:");
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        cmdArray = this.finalizeTranscoderArgs(filename, dlna, media, params, cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        pw.runInNewThread();
        return pw;
    }

    @Override
    public boolean isCompatible(DLNAResource dlna) {
        if (!PlayerUtil.isWebAudio(dlna)) {
            return false;
        }
        String protocol = dlna.getFormat().getMatchedExtension();
        return this.protocols.isSupportedProtocol(protocol);
    }
}

