/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import net.pms.Messages;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.encoders.FFmpegVideo;
import net.pms.encoders.PlayerPurpose;
import net.pms.formats.Format;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.util.PlayerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegAudio
extends FFmpegVideo {
    public static final String ID = "ffmpegaudio";
    private final PmsConfiguration configuration;
    private Logger logger = LoggerFactory.getLogger(FFmpegAudio.class);
    @Deprecated
    JCheckBox noresample;

    public FFmpegAudio(PmsConfiguration configuration) {
        super(configuration);
        this.configuration = configuration;
    }

    @Override
    public JComponent config() {
        FormLayout layout = new FormLayout("left:pref, 0:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, 0:grow");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.EMPTY_BORDER);
        builder.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        JComponent cmp = builder.addSeparator("Audio settings", cc.xyw(2, 1, 1));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        this.noresample = new JCheckBox(Messages.getString("TrTab2.22"));
        this.noresample.setContentAreaFilled(false);
        this.noresample.setSelected(this.configuration.isAudioResample());
        this.noresample.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FFmpegAudio.this.configuration.setAudioResample(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.noresample, cc.xy(2, 3));
        return builder.getPanel();
    }

    @Override
    public PlayerPurpose getPurpose() {
        return PlayerPurpose.AUDIO_FILE_PLAYER;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean isTimeSeekable() {
        return true;
    }

    @Override
    public boolean avisynth() {
        return false;
    }

    @Override
    public String name() {
        return "FFmpeg Audio";
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    @Deprecated
    public String[] args() {
        return new String[]{"-f", "s16be", "-ar", "48000"};
    }

    @Override
    public String mimeType() {
        return "audio/transcode";
    }

    protected List<String> getAudioTranscodeOptions(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) {
        ArrayList<String> options = new ArrayList<String>();
        if (params.mediaRenderer.isTranscodeToMP3()) {
            options.add("-f");
            options.add("mp3");
            options.add("-ab");
            options.add("320000");
        } else if (params.mediaRenderer.isTranscodeToWAV()) {
            options.add("-f");
            options.add("wav");
        } else {
            options.add("-f");
            options.add("s16be");
        }
        if (this.configuration.isAudioResample()) {
            if (params.mediaRenderer.isTranscodeAudioTo441()) {
                options.add("-ar");
                options.add("44100");
            } else {
                options.add("-ar");
                options.add("48000");
            }
        }
        return options;
    }

    @Override
    public ProcessWrapper launchTranscode(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) throws IOException {
        String filename = dlna.getSystemName();
        params.maxBufferSize = this.configuration.getMaxAudioBuffer();
        params.waitbeforestart = 2000;
        params.manageFastStart();
        int nThreads = this.configuration.getNumberOfCpuCores();
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.executable());
        cmdList.addAll(this.getGlobalOptions(this.logger));
        if (params.timeseek > 0.0) {
            cmdList.add("-ss");
            cmdList.add("" + params.timeseek);
        }
        cmdList.add("-threads");
        cmdList.add("" + nThreads);
        cmdList.add("-i");
        cmdList.add(filename);
        cmdList.add("-threads");
        cmdList.add("" + nThreads);
        if (params.timeend > 0.0) {
            cmdList.add("-t");
            cmdList.add("" + params.timeend);
        }
        cmdList.addAll(this.getAudioTranscodeOptions(dlna, media, params));
        cmdList.add("pipe:");
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        cmdArray = this.finalizeTranscoderArgs(filename, dlna, media, params, cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        pw.runInNewThread();
        return pw;
    }

    @Override
    public boolean isCompatible(DLNAResource resource) {
        return PlayerUtil.isAudio(resource, Format.Identifier.FLAC) || PlayerUtil.isAudio(resource, Format.Identifier.M4A) || PlayerUtil.isAudio(resource, Format.Identifier.OGG) || PlayerUtil.isAudio(resource, Format.Identifier.WAV);
    }
}

